/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client;

import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.Log;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.WindowsServiceControlError;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.WindowsServiceControlException;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.WindowsServiceControlOperation;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.WindowsServiceState;
import com.mathworks.toolbox.distcomp.remote.util.StreamRedirector;
import com.mathworks.util.PlatformInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class WindowsServiceControl {
    private static final int WAIT_FOR_STATE_SLEEP_TIME_MILLIS = 500;
    private static final String SC_EXE = "sc.exe";
    private static final String FAILED = "FAILED";
    private static final String SC_FAILED_2_CANNOT_FIND_FILE = "FAILED 2";
    private static final String SC_FAILED_3_INVALID_BINPATH = "FAILED 3";
    private static final String SC_FAILED_5_ACCESS_DENIED = "FAILED 5";
    private static final String SC_FAILED_1053_DID_NOT_RESPOND_IN_TIMELY_FASHION = "FAILED 1053";
    private static final String SC_FAILED_1060_SERVICE_NOT_INSTALLED = "FAILED 1060";
    private static final String SC_FAILED_1072_MARKED_FOR_DELETION = "FAILED 1072";
    private static final String SC_FAILED_1326_UNKNOWN_USER = "FAILED 1326";
    private static final String SC_FAILED_1073_SERVICE_ALREADY_INSTALLED = "FAILED 1073";
    private static final String SC_FAILED_1722_CANNOT_CONTACT_SERVER = "FAILED 1722";
    private static final String SC_FAILED_1727_RPC_CALL_FAILED = "FAILED 1727";
    private final String fServer;

    public WindowsServiceControl(String string) {
        assert (PlatformInfo.isWindows()) : "WindowsServiceControl can only be used on Windows";
        this.fServer = string.equals("localhost") ? "" : "\\\\" + string;
    }

    public WindowsServiceControl() {
        assert (PlatformInfo.isWindows()) : "WindowsServiceControl can only be used on Windows";
        this.fServer = "";
    }

    public WindowsServiceState query(String string) throws WindowsServiceControlException {
        String string2;
        try {
            string2 = this.runServiceControlCommand(WindowsServiceControlOperation.QUERY, string);
        }
        catch (IOException iOException) {
            throw new WindowsServiceControlException("Failed to query service state", iOException);
        }
        WindowsServiceState windowsServiceState = WindowsServiceState.fromScQueryOutput(string2);
        if (windowsServiceState == WindowsServiceState.UNKNOWN) {
            Log.LOGGER.severe("'sc.exe query' command output: " + string2);
            throw this.diagnoseFailedServiceQuery(string2);
        }
        return windowsServiceState;
    }

    public void install(String string, String string2) throws WindowsServiceControlException {
        String string3;
        if (string2 == null) {
            throw new NullPointerException("binPath must not be null.");
        }
        if ("".equals(string2)) {
            throw new IllegalArgumentException("binPath must not be empty.");
        }
        try {
            string3 = this.runServiceControlCommand(WindowsServiceControlOperation.INSTALL, string, "binPath=", string2);
        }
        catch (IOException iOException) {
            throw new WindowsServiceControlException("Failed to create service", iOException);
        }
        if (string3.contains(FAILED)) {
            Log.LOGGER.severe("'sc.exe create' command output: " + string3);
            throw this.disgnoseFailedServiceCreation(string3);
        }
    }

    public void start(String string) throws WindowsServiceControlException {
        WindowsServiceState windowsServiceState;
        String string2;
        try {
            string2 = this.runServiceControlCommand(WindowsServiceControlOperation.START, string);
        }
        catch (IOException iOException) {
            throw new WindowsServiceControlException("Failed to start service", iOException);
        }
        if (string2.contains(FAILED)) {
            Log.LOGGER.severe("'sc.exe start' command output: " + string2);
            throw this.diagnoseFailedServiceStart(string2);
        }
        try {
            windowsServiceState = this.waitForNotState(string, WindowsServiceState.START_PENDING);
        }
        catch (InterruptedException interruptedException) {
            throw new WindowsServiceControlException("Interrupted while waiting for service to start", interruptedException);
        }
        if (windowsServiceState != WindowsServiceState.RUNNING) {
            throw new WindowsServiceControlException("Service failed to become RUNNING.");
        }
    }

    public void stop(String string) throws WindowsServiceControlException {
        WindowsServiceState windowsServiceState;
        String string2;
        try {
            string2 = this.runServiceControlCommand(WindowsServiceControlOperation.STOP, string);
        }
        catch (IOException iOException) {
            throw new WindowsServiceControlException("Failed to stop service", iOException);
        }
        if (string2.contains(FAILED)) {
            Log.LOGGER.severe("'sc.exe stop' command output: " + string2);
            throw this.diagnoseFailedServiceStop(string2);
        }
        try {
            windowsServiceState = this.waitForNotState(string, WindowsServiceState.STOP_PENDING);
        }
        catch (InterruptedException interruptedException) {
            throw new WindowsServiceControlException("Interrupted while waiting for service to stop", interruptedException);
        }
        if (windowsServiceState != WindowsServiceState.STOPPED) {
            throw new WindowsServiceControlException("Service failed to stop");
        }
    }

    public void uninstall(String string) throws WindowsServiceControlException {
        String string2;
        try {
            string2 = this.runServiceControlCommand(WindowsServiceControlOperation.UNINSTALL, string);
        }
        catch (IOException iOException) {
            throw new WindowsServiceControlException("Failed to uninstall service", iOException);
        }
        if (string2.contains(FAILED)) {
            Log.LOGGER.severe("'sc.exe delete' command output: " + string2);
            throw this.diagnoseFailedServiceDeletion(string2);
        }
    }

    private String runServiceControlCommand(WindowsServiceControlOperation windowsServiceControlOperation, String ... stringArray) throws IOException {
        List<String> list = this.createServiceControlCommand(windowsServiceControlOperation, stringArray);
        Log.LOGGER.finest("About to start " + list);
        ProcessBuilder processBuilder = new ProcessBuilder(list);
        processBuilder.redirectErrorStream(true);
        return this.runAndCaptureOutput(processBuilder);
    }

    private String runAndCaptureOutput(ProcessBuilder processBuilder) throws IOException {
        Process process = processBuilder.start();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamRedirector streamRedirector = StreamRedirector.getInstance();
        InputStream inputStream = process.getInputStream();
        StreamRedirector.RedirectionPair redirectionPair = streamRedirector.addRedirect(inputStream, byteArrayOutputStream);
        while (true) {
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        streamRedirector.removeRedirect(redirectionPair);
        return byteArrayOutputStream.toString();
    }

    private List<String> createServiceControlCommand(WindowsServiceControlOperation windowsServiceControlOperation, String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(SC_EXE, this.fServer));
        arrayList.add(windowsServiceControlOperation.getScCommandString());
        arrayList.addAll(Arrays.asList(stringArray));
        return arrayList;
    }

    public WindowsServiceState waitForState(String string, WindowsServiceState windowsServiceState, long l) throws WindowsServiceControlException, InterruptedException {
        long l2 = System.currentTimeMillis() + l;
        WindowsServiceState windowsServiceState2 = this.query(string);
        while (windowsServiceState2 != windowsServiceState && System.currentTimeMillis() < l2) {
            Thread.sleep(500L);
            windowsServiceState2 = this.query(string);
        }
        return windowsServiceState2;
    }

    private WindowsServiceState waitForNotState(String string, WindowsServiceState windowsServiceState) throws WindowsServiceControlException, InterruptedException {
        WindowsServiceState windowsServiceState2 = this.query(string);
        while (windowsServiceState2 == windowsServiceState) {
            Thread.sleep(500L);
            windowsServiceState2 = this.query(string);
        }
        return windowsServiceState2;
    }

    private WindowsServiceControlException diagnoseFailedServiceQuery(String string) {
        WindowsServiceControlException windowsServiceControlException = this.diagnoseCommonFailures(string);
        if (windowsServiceControlException == null) {
            windowsServiceControlException = new WindowsServiceControlException(WindowsServiceControlError.UNKNOWN, string);
        }
        return windowsServiceControlException;
    }

    private WindowsServiceControlException disgnoseFailedServiceCreation(String string) {
        WindowsServiceControlException windowsServiceControlException = this.diagnoseCommonFailures(string);
        if (windowsServiceControlException == null) {
            windowsServiceControlException = string.contains(SC_FAILED_1073_SERVICE_ALREADY_INSTALLED) ? new WindowsServiceControlException(WindowsServiceControlError.SERVICE_ALREADY_INSTALLED, string) : new WindowsServiceControlException(WindowsServiceControlError.UNKNOWN, string);
        }
        return windowsServiceControlException;
    }

    private WindowsServiceControlException diagnoseFailedServiceStart(String string) {
        WindowsServiceControlException windowsServiceControlException = this.diagnoseCommonFailures(string);
        if (windowsServiceControlException == null) {
            windowsServiceControlException = string.contains(SC_FAILED_3_INVALID_BINPATH) ? new WindowsServiceControlException(WindowsServiceControlError.INVALID_BINPATH, string) : (string.contains(SC_FAILED_1060_SERVICE_NOT_INSTALLED) ? new WindowsServiceControlException(WindowsServiceControlError.SERVICE_NOT_INSTALLED, string) : (string.contains(SC_FAILED_2_CANNOT_FIND_FILE) ? new WindowsServiceControlException(WindowsServiceControlError.CANNOT_FIND_FILE, string) : (string.contains(SC_FAILED_1326_UNKNOWN_USER) ? new WindowsServiceControlException(WindowsServiceControlError.UNKNOWN_USER_OR_BAD_PASSWORD, string) : (string.contains(SC_FAILED_1053_DID_NOT_RESPOND_IN_TIMELY_FASHION) ? new WindowsServiceControlException(WindowsServiceControlError.DID_NOT_RESPOND_IN_TIMELY_FASHION, string) : new WindowsServiceControlException(WindowsServiceControlError.UNKNOWN, string)))));
        }
        return windowsServiceControlException;
    }

    private WindowsServiceControlException diagnoseFailedServiceStop(String string) {
        WindowsServiceControlException windowsServiceControlException = this.diagnoseCommonFailures(string);
        if (windowsServiceControlException == null) {
            windowsServiceControlException = string.contains(SC_FAILED_1060_SERVICE_NOT_INSTALLED) ? new WindowsServiceControlException(WindowsServiceControlError.SERVICE_NOT_INSTALLED, string) : new WindowsServiceControlException(WindowsServiceControlError.UNKNOWN, string);
        }
        return windowsServiceControlException;
    }

    private WindowsServiceControlException diagnoseFailedServiceDeletion(String string) {
        WindowsServiceControlException windowsServiceControlException = this.diagnoseCommonFailures(string);
        if (windowsServiceControlException == null) {
            windowsServiceControlException = string.contains(SC_FAILED_1060_SERVICE_NOT_INSTALLED) ? new WindowsServiceControlException(WindowsServiceControlError.SERVICE_NOT_INSTALLED, string) : new WindowsServiceControlException(WindowsServiceControlError.UNKNOWN, string);
        }
        return windowsServiceControlException;
    }

    private WindowsServiceControlException diagnoseCommonFailures(String string) {
        if (string.contains(SC_FAILED_1722_CANNOT_CONTACT_SERVER)) {
            WindowsServiceControlError windowsServiceControlError = WindowsServiceControlError.FAILED_TO_CONTACT_SERVER;
            return new WindowsServiceControlException(windowsServiceControlError, string);
        }
        if (string.contains(SC_FAILED_5_ACCESS_DENIED)) {
            WindowsServiceControlError windowsServiceControlError = WindowsServiceControlError.PERMISSION_DENIED;
            return new WindowsServiceControlException(windowsServiceControlError, string);
        }
        if (string.contains(SC_FAILED_1727_RPC_CALL_FAILED)) {
            WindowsServiceControlError windowsServiceControlError = WindowsServiceControlError.RPC_CALL_FAILED;
            return new WindowsServiceControlException(windowsServiceControlError, string);
        }
        if (string.contains(SC_FAILED_1072_MARKED_FOR_DELETION)) {
            WindowsServiceControlError windowsServiceControlError = WindowsServiceControlError.MARKED_FOR_DELETION;
            return new WindowsServiceControlException(windowsServiceControlError, string);
        }
        return null;
    }
}

