/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control.serviceinfo;

import com.mathworks.toolbox.distcomp.control.serviceinfo.CheckpointDir;
import com.mathworks.toolbox.distcomp.control.serviceinfo.InvalidCheckpointDirException;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceInfo;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;

public class CheckpointDirInfo {
    public static List<ServiceInfo> getStoppedServicesList(String string) {
        assert (string != null) : "The hostname must not be null";
        Vector<CheckpointDir> vector = new Vector<CheckpointDir>();
        for (Comparable<File> comparable : CheckpointDirInfo.getServiceFiles()) {
            try {
                vector.add(new CheckpointDir(comparable.getPath()));
            }
            catch (InvalidCheckpointDirException invalidCheckpointDirException) {
                // empty catch block
            }
        }
        Vector vector2 = new Vector();
        for (CheckpointDir checkpointDir : vector) {
            Comparable<File> comparable;
            comparable = checkpointDir.createServiceInfo(string);
            if (vector2.contains(comparable)) {
                vector2.remove(comparable);
                continue;
            }
            vector2.add(comparable);
        }
        Collections.sort(vector2);
        return vector2;
    }

    public static int getFirstAvailableNumber(String string) {
        int n;
        int n2;
        SortedSet<Integer> sortedSet = CheckpointDirInfo.getNumbersOfNamesContaining(string);
        Iterator iterator = sortedSet.iterator();
        for (n2 = 1; iterator.hasNext() && n2 == (n = ((Integer)iterator.next()).intValue()); ++n2) {
        }
        return n2;
    }

    public static int getLastAssignedNumber(String string) {
        SortedSet<Integer> sortedSet = CheckpointDirInfo.getNumbersOfNamesContaining(string);
        return sortedSet.size() == 0 ? 0 : sortedSet.last();
    }

    private static SortedSet<Integer> getNumbersOfNamesContaining(String string) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (File file : CheckpointDirInfo.getServiceFiles()) {
            String string2 = file.getName();
            if (string2.indexOf(string) < 0) continue;
            treeSet.add(CheckpointDirInfo.extractServiceNumber(string, string2));
        }
        return treeSet;
    }

    private static int extractServiceNumber(String string, String string2) {
        try {
            int n = string2.indexOf(string) + string.length();
            int n2 = string2.indexOf("_", n);
            return Integer.parseInt(string2.substring(n, n2));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private static File[] getServiceFiles() {
        File file = new File(System.getProperty("com.mathworks.toolbox.distcomp.checkpointdir"));
        return file.listFiles();
    }
}

