/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.distcompobjects;

import com.mathworks.toolbox.distcomp.distcompobjects.Distcomp;
import com.mathworks.toolbox.distcomp.util.Version;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;

public abstract class DistcompProxy
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int VERSION_NUM_ON_ORIGIN = 16;
    private String VERSION_STRING_ON_ORIGIN = Version.VERSION_STRING;
    private byte[] fSerializedProxy;

    protected DistcompProxy(Distcomp distcomp) throws SerializeProxyException {
        this.setSerializedProxy(distcomp);
    }

    protected Object getSerializedProxy() throws DeserializeProxyException {
        Object var1_1 = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(this.fSerializedProxy));
            var1_1 = ((MarshalledObject)objectInputStream.readObject()).get();
            objectInputStream.close();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DeserializeProxyException((Throwable)classNotFoundException);
        }
        catch (IOException iOException) {
            throw new DeserializeProxyException((Throwable)iOException);
        }
        return var1_1;
    }

    protected void setSerializedProxy(Object object) throws SerializeProxyException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(new MarshalledObject<Object>(object));
            objectOutputStream.close();
            this.fSerializedProxy = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new SerializeProxyException((Throwable)iOException);
        }
    }

    public boolean checkVersion() {
        return 16 == this.VERSION_NUM_ON_ORIGIN;
    }

    public String getVersionString() {
        return this.VERSION_STRING_ON_ORIGIN;
    }

    public int getVersionNumber() {
        return this.VERSION_NUM_ON_ORIGIN;
    }

    public class DeserializeProxyException
    extends RemoteException {
        public DeserializeProxyException() {
            super("Unable to deserialize proxy to remote object from byte array");
        }

        public DeserializeProxyException(Throwable throwable) {
            super("Unable to deserialize proxy to remote object from byte array", throwable);
        }
    }

    public class SerializeProxyException
    extends RemoteException {
        public SerializeProxyException() {
            super("Unable to serialize proxy to remote object to byte array");
        }

        public SerializeProxyException(Throwable throwable) {
            super("Unable to serialize proxy to remote object to byte array", throwable);
        }
    }
}

