/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.distcompobjects;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;

abstract class EntityProxy {
    private static PipedInputStream sIn;
    private static PipedOutputStream sOut;
    private static MessageDigest sDigest;
    private static int sDigestLength;
    protected Uuid fUuid;

    protected EntityProxy(String string) {
        try {
            sIn = new PipedInputStream();
            sOut = new PipedOutputStream(sIn);
            sDigest = MessageDigest.getInstance("MD5");
            sDigestLength = sDigest.getDigestLength();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        this.fUuid = this.computeUuid(string);
    }

    public Object getID() {
        return this.fUuid;
    }

    protected Uuid computeUuid(String string) {
        byte[] byArray = sDigest.digest(string.getBytes());
        sDigest.reset();
        try {
            sOut.write(byArray, 0, sDigestLength);
            return UuidFactory.read((InputStream)sIn);
        }
        catch (IOException iOException) {
            return UuidFactory.create((long)0L, (long)0L);
        }
    }

    public int hashCode() {
        return this.fUuid.hashCode();
    }
}

