/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.jobmanager.permissions;

import com.mathworks.toolbox.distcomp.distcompobjects.Identifiable;
import com.mathworks.toolbox.distcomp.jobmanager.permissions.Permission;
import com.mathworks.toolbox.distcomp.jobmanager.permissions.PermissionChecker;
import com.mathworks.toolbox.distcomp.jobmanager.permissions.PermissionStore;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jini.id.Uuid;

public class ClientPermissionStore
implements PermissionStore,
PermissionChecker {
    private final Map<UUID, Set<Permission>> fClientPermissionsMap = new HashMap<UUID, Set<Permission>>();
    private final Lock fLock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPermission(Identifiable identifiable, Permission permission) {
        UUID uUID = ClientPermissionStore.convertID(identifiable.getID());
        this.fLock.lock();
        try {
            if (this.fClientPermissionsMap.containsKey(uUID)) {
                Set<Permission> set = this.fClientPermissionsMap.get(uUID);
                set.add(permission);
            } else {
                HashSet<Permission> hashSet = new HashSet<Permission>();
                hashSet.add(permission);
                this.fClientPermissionsMap.put(uUID, hashSet);
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePermission(Identifiable identifiable, Permission permission) {
        UUID uUID = ClientPermissionStore.convertID(identifiable.getID());
        this.fLock.lock();
        try {
            if (this.fClientPermissionsMap.containsKey(uUID)) {
                Set<Permission> set = this.fClientPermissionsMap.get(uUID);
                set.remove(permission);
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllPermissions(Identifiable identifiable) {
        this.fLock.lock();
        try {
            this.fClientPermissionsMap.remove(ClientPermissionStore.convertID(identifiable.getID()));
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkPermissions(Identifiable identifiable, Permission permission) {
        this.fLock.lock();
        try {
            Set<Permission> set = this.fClientPermissionsMap.get(ClientPermissionStore.convertID(identifiable.getID()));
            boolean bl = set != null && set.contains(permission);
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    private static UUID convertID(Uuid uuid) {
        return new UUID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }
}

