/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.parallelui;

import java.text.ParseException;
import java.util.Iterator;

public class IntSet
implements Iterable<Integer> {
    private int[] fMemberRanges;
    private int fRangeCount;
    private int fMemberCount;
    private static final int CAPACITY_INCREMENT = 10;

    public IntSet() {
    }

    public IntSet(int n) {
        this.fMemberRanges = new int[2];
        this.fMemberRanges[0] = this.fMemberRanges[1] = n;
        this.fRangeCount = 1;
        this.fMemberCount = 1;
    }

    public IntSet(int n, int n2) {
        this.fMemberRanges = new int[2];
        this.fMemberRanges[0] = n;
        this.fMemberRanges[1] = n2;
        this.fRangeCount = 1;
        this.fMemberCount = n2 - n + 1;
    }

    public IntSet(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.add(nArray[i]);
        }
    }

    public IntSet(IntSet intSet) {
        if (intSet.fMemberRanges != null) {
            this.fMemberRanges = new int[2 * intSet.fRangeCount];
            System.arraycopy(intSet.fMemberRanges, 0, this.fMemberRanges, 0, this.fMemberRanges.length);
        }
        this.fRangeCount = intSet.fRangeCount;
        this.fMemberCount = intSet.fMemberCount;
    }

    public IntSet(String string) throws ParseException {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = 1;
        int n4 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            boolean bl2 = Character.isDigit(c);
            if (bl2) {
                n = 10 * n + Character.digit(c, 10);
                ++n2;
            }
            if (c == ' ' || c == ',' || c == ':' || c == '-' || i == string.length() - 1) {
                if (n2 > 0) {
                    if (!bl) {
                        if (n4 > 0 && n == this.fMemberRanges[n4 - 1] + 1) {
                            this.fMemberRanges[n4 - 1] = n * n3;
                            ++this.fMemberCount;
                        } else {
                            this.ensureCapacity(n4 / 2 + 1);
                            this.fMemberRanges[n4++] = n * n3;
                            if (c == ':' || c == '-') {
                                bl = true;
                            } else {
                                this.fMemberRanges[n4++] = n * n3;
                                ++this.fMemberCount;
                            }
                        }
                    } else {
                        this.fMemberCount += n - this.fMemberRanges[n4 - 1] + 1;
                        this.fMemberRanges[n4++] = n;
                        bl = false;
                    }
                    n = 0;
                    n2 = 0;
                    n3 = 1;
                } else if (c == '-') {
                    n3 = -1;
                }
            } else if (!bl2) {
                throw new ParseException(string, i);
            }
            this.fRangeCount = n4 / 2;
        }
    }

    public void add(int n) {
        if (this.fMemberRanges == null) {
            this.fMemberRanges = new int[2];
            this.fMemberRanges[0] = this.fMemberRanges[1] = n;
            this.fRangeCount = 1;
            this.fMemberCount = 1;
        } else {
            int n2;
            boolean bl = false;
            for (n2 = 0; n2 < 2 * this.fRangeCount && !bl; n2 += 2) {
                int n3;
                if (n == this.fMemberRanges[n2] - 1) {
                    int n4 = n2;
                    this.fMemberRanges[n4] = this.fMemberRanges[n4] - 1;
                    ++this.fMemberCount;
                    bl = true;
                    continue;
                }
                if (n < this.fMemberRanges[n2]) {
                    this.ensureCapacity(this.fRangeCount + 1);
                    for (n3 = 2 * this.fRangeCount - 1; n3 >= n2; --n3) {
                        this.fMemberRanges[n3 + 2] = this.fMemberRanges[n3];
                    }
                    int n5 = n;
                    this.fMemberRanges[n2 + 1] = n5;
                    this.fMemberRanges[n2] = n5;
                    ++this.fRangeCount;
                    ++this.fMemberCount;
                    bl = true;
                    continue;
                }
                if (n == this.fMemberRanges[n2 + 1] + 1) {
                    int n6 = n2 + 1;
                    this.fMemberRanges[n6] = this.fMemberRanges[n6] + 1;
                    ++this.fMemberCount;
                    bl = true;
                    n3 = n2 + 2;
                    if (n3 >= 2 * this.fRangeCount || n != this.fMemberRanges[n3] - 1) continue;
                    this.fMemberRanges[n2 + 1] = this.fMemberRanges[n3 + 1];
                    --this.fRangeCount;
                    for (int i = n3; i < 2 * this.fRangeCount; ++i) {
                        this.fMemberRanges[i] = this.fMemberRanges[i + 2];
                    }
                    continue;
                }
                if (n > this.fMemberRanges[n2 + 1]) continue;
                bl = true;
            }
            if (!bl) {
                this.ensureCapacity(this.fRangeCount + 1);
                n2 = 2 * this.fRangeCount;
                int n7 = n;
                this.fMemberRanges[n2 + 1] = n7;
                this.fMemberRanges[n2] = n7;
                ++this.fRangeCount;
                ++this.fMemberCount;
            }
        }
    }

    public void addAll(IntSet intSet) {
        for (int i = 0; i < 2 * intSet.fRangeCount; i += 2) {
            for (int j = intSet.fMemberRanges[i]; j <= intSet.fMemberRanges[i + 1]; ++j) {
                this.add(j);
            }
        }
    }

    public void clear() {
        this.fRangeCount = 0;
        this.fMemberCount = 0;
    }

    public boolean contains(int n) {
        for (int i = 0; i < 2 * this.fRangeCount && n >= this.fMemberRanges[i]; i += 2) {
            if (n > this.fMemberRanges[i + 1]) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(IntSet intSet) {
        for (int i = 0; i < 2 * intSet.fRangeCount; i += 2) {
            for (int j = intSet.fMemberRanges[i]; j <= intSet.fMemberRanges[i + 1]; ++j) {
                if (this.contains(j)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean containsAny(IntSet intSet) {
        for (int i = 0; i < 2 * intSet.fRangeCount; i += 2) {
            for (int j = intSet.fMemberRanges[i]; j <= intSet.fMemberRanges[i + 1]; ++j) {
                if (!this.contains(j)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IntSet)) {
            return false;
        }
        IntSet intSet = (IntSet)object;
        if (this.fRangeCount != intSet.fRangeCount || this.fMemberCount != intSet.fMemberCount) {
            return false;
        }
        for (int i = 0; i < 2 * this.fRangeCount; ++i) {
            if (this.fMemberRanges[i] == intSet.fMemberRanges[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 23;
        for (int i = 0; i < 2 * this.fRangeCount; ++i) {
            n = 37 * n + this.fMemberRanges[i];
        }
        return n;
    }

    public IntSetIterator iterator() {
        return new IntSetIterator();
    }

    public int first() {
        return this.fMemberRanges[0];
    }

    public int last() {
        return this.fMemberRanges[2 * this.fRangeCount - 1];
    }

    public boolean isEmpty() {
        return this.fMemberCount == 0;
    }

    public void remove(int n) {
        for (int i = 0; i < 2 * this.fRangeCount && n >= this.fMemberRanges[i]; i += 2) {
            if (n > this.fMemberRanges[i + 1]) continue;
            this.removeImpl(i, n - this.fMemberRanges[i]);
        }
    }

    public void removeAll(IntSet intSet) {
        for (int i = 0; i < 2 * intSet.fRangeCount; i += 2) {
            for (int j = intSet.fMemberRanges[i]; j <= intSet.fMemberRanges[i + 1]; ++j) {
                this.remove(j);
            }
        }
    }

    public void retainAll(IntSet intSet) {
        IntSetIterator intSetIterator = new IntSetIterator();
        while (intSetIterator.hasNext()) {
            int n = intSetIterator.nextInt();
            if (intSet.contains(n)) continue;
            intSetIterator.remove();
        }
    }

    public int size() {
        return this.fMemberCount;
    }

    public int[] toArray() {
        return this.toArray(new int[this.fMemberCount]);
    }

    public int[] toArray(int[] nArray) {
        int n = 0;
        for (int i = 0; i < 2 * this.fRangeCount && n < nArray.length; i += 2) {
            int n2 = this.fMemberRanges[i];
            while (n2 <= this.fMemberRanges[i + 1] && n < nArray.length) {
                nArray[n] = n2++;
                ++n;
            }
        }
        return nArray;
    }

    public Object[] toArray(Object[] objectArray) {
        int n = 0;
        for (int i = 0; i < 2 * this.fRangeCount && n < objectArray.length; i += 2) {
            for (int j = this.fMemberRanges[i]; j <= this.fMemberRanges[i + 1] && n < objectArray.length; ++j, ++n) {
                objectArray[n] = new String(Integer.toString(j));
            }
        }
        return objectArray;
    }

    public String toString() {
        if (this.size() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(4 * this.fRangeCount);
        for (int i = 0; i < 2 * this.fRangeCount; i += 2) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.fMemberRanges[i]);
            if (this.fMemberRanges[i] >= this.fMemberRanges[i + 1]) continue;
            stringBuffer.append(':');
            stringBuffer.append(this.fMemberRanges[i + 1]);
        }
        return stringBuffer.toString();
    }

    private void ensureCapacity(int n) {
        int n2;
        int n3 = n2 = this.fMemberRanges == null ? 0 : this.fMemberRanges.length;
        if (2 * n > n2) {
            int[] nArray = new int[Math.max(2 * n, n2 + 10)];
            if (this.fMemberRanges != null) {
                System.arraycopy(this.fMemberRanges, 0, nArray, 0, 2 * this.fRangeCount);
            }
            this.fMemberRanges = nArray;
        }
    }

    private void removeImpl(int n, int n2) {
        if (this.fMemberRanges[n] == this.fMemberRanges[n + 1]) {
            for (int i = n; i < 2 * this.fRangeCount - 2; ++i) {
                this.fMemberRanges[i] = this.fMemberRanges[i + 2];
            }
            --this.fRangeCount;
            --this.fMemberCount;
        } else if (n2 == 0) {
            int n3 = n;
            this.fMemberRanges[n3] = this.fMemberRanges[n3] + 1;
            --this.fMemberCount;
        } else if (this.fMemberRanges[n] + n2 == this.fMemberRanges[n + 1]) {
            int n4 = n + 1;
            this.fMemberRanges[n4] = this.fMemberRanges[n4] - 1;
            --this.fMemberCount;
        } else {
            int n5 = this.fMemberRanges[n] + n2;
            this.ensureCapacity(this.fRangeCount + 1);
            for (int i = 2 * this.fRangeCount - 1; i > n; --i) {
                this.fMemberRanges[i + 2] = this.fMemberRanges[i];
            }
            this.fMemberRanges[n + 1] = n5 - 1;
            this.fMemberRanges[n + 2] = n5 + 1;
            ++this.fRangeCount;
            --this.fMemberCount;
        }
    }

    public class IntSetIterator
    implements Iterator<Integer> {
        int iRangeIndex;
        int iMemberOffset;

        private IntSetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.iRangeIndex < 2 * IntSet.this.fRangeCount;
        }

        @Override
        public Integer next() {
            return new Integer(this.nextInt());
        }

        public int nextInt() {
            int n = IntSet.this.fMemberRanges[this.iRangeIndex] + this.iMemberOffset;
            if (n < IntSet.this.fMemberRanges[this.iRangeIndex + 1]) {
                ++this.iMemberOffset;
            } else {
                this.iRangeIndex += 2;
                this.iMemberOffset = 0;
            }
            return n;
        }

        @Override
        public void remove() {
            int n;
            int n2;
            if (this.iMemberOffset == 0) {
                n2 = this.iRangeIndex - 2;
                n = IntSet.this.fMemberRanges[n2 + 1] - IntSet.this.fMemberRanges[n2];
            } else {
                n2 = this.iRangeIndex;
                n = this.iMemberOffset - 1;
            }
            if (IntSet.this.fMemberRanges[n2] == IntSet.this.fMemberRanges[n2 + 1]) {
                this.iRangeIndex = n2;
            } else if (n == 0) {
                this.iMemberOffset = 0;
            } else if (this.iRangeIndex == n2) {
                this.iRangeIndex += 2;
                this.iMemberOffset = 0;
            }
            IntSet.this.removeImpl(n2, n);
        }
    }
}

