/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.Dispatcher;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.Message;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

class DispatchInvoker {
    private Dispatcher<? extends Message> fDispatcher;
    private Method fDispatchMethod;
    private Class<?> fMessageClass;

    public Dispatcher<? extends Message> getDispatcher() {
        return this.fDispatcher;
    }

    public Method getDispatchMethod() {
        return this.fDispatchMethod;
    }

    public Class getMessageClass() {
        return this.fMessageClass;
    }

    public boolean isInvokableObject(Class clazz) {
        return this.fMessageClass.isAssignableFrom(clazz);
    }

    public void invoke(Message message, Instance instance) {
        try {
            this.fDispatchMethod.invoke(this.fDispatcher, message, instance);
        }
        catch (IllegalAccessException illegalAccessException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unable to invoke dispatcher " + this.fDispatcher.getClass().getName() + " on message " + message.getClass().getName(), illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unable to invoke dispatcher " + this.fDispatcher.getClass().getName() + " on message " + message.getClass().getName(), illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unable to invoke dispatcher " + this.fDispatcher.getClass().getName() + " on message " + message.getClass().getName(), invocationTargetException);
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Non-Runtime Exception received: ", invocationTargetException);
        }
    }

    private DispatchInvoker(Dispatcher<? extends Message> dispatcher, Class clazz) {
        block2: {
            this.fDispatcher = dispatcher;
            this.fMessageClass = clazz;
            try {
                this.fDispatchMethod = dispatcher.getClass().getMethod("dispatch", this.fMessageClass, Instance.class);
                this.fDispatchMethod.setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"Unable to find the dispatch method of a Dispatcher");
            }
        }
    }

    static DispatchInvoker create(Dispatcher<? extends Message> dispatcher) {
        LinkedList<Class> linkedList = DispatchInvoker.findAllMessageClasses(dispatcher);
        assert (linkedList.size() != 0) : "No Dispatch Interface found";
        assert (linkedList.size() == 1) : "Found " + linkedList.size() + " Dispatch interfaces expecting only 1";
        return new DispatchInvoker(dispatcher, linkedList.getFirst());
    }

    private static LinkedList<Class> findAllMessageClasses(Dispatcher<? extends Message> dispatcher) {
        LinkedList<Class> linkedList = new LinkedList<Class>();
        List<Class> list = DispatchInvoker.getAllClasses(dispatcher.getClass());
        list.addAll(DispatchInvoker.getAllInterfaces(list));
        List<Type> list2 = DispatchInvoker.getAllGenericInterfaces(list);
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "Generic interface types on " + dispatcher + " are " + list2);
        for (Type type : list2) {
            if (!(type instanceof ParameterizedType)) continue;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "aParamType is " + parameterizedType);
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "aParamType.getActualTypeArguments() [0] is " + parameterizedType.getActualTypeArguments()[0]);
            if (!Dispatcher.class.isAssignableFrom((Class)parameterizedType.getRawType()) || !(parameterizedType.getActualTypeArguments()[0] instanceof Class)) continue;
            linkedList.add((Class)parameterizedType.getActualTypeArguments()[0]);
        }
        return linkedList;
    }

    private static List<Class> getAllClasses(Class clazz) {
        LinkedList<Class> linkedList = new LinkedList<Class>();
        while (clazz != null) {
            linkedList.add(clazz);
            clazz = clazz.getSuperclass();
        }
        return linkedList;
    }

    private static List<Class> getAllInterfaces(List<Class> list) {
        LinkedList<Class> linkedList = new LinkedList<Class>();
        for (Class clazz : list) {
            List<Class> list2 = Arrays.asList(clazz.getInterfaces());
            List<Class> list3 = DispatchInvoker.getAllInterfaces(list2);
            linkedList.addAll(list2);
            linkedList.addAll(list3);
        }
        return linkedList;
    }

    private static List<Type> getAllGenericInterfaces(List<Class> list) {
        LinkedList<Type> linkedList = new LinkedList<Type>();
        for (Class clazz : list) {
            linkedList.addAll(Arrays.asList(clazz.getGenericInterfaces()));
        }
        return linkedList;
    }
}

