/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.ClosableSessionConnections;
import com.mathworks.toolbox.distcomp.pmode.InitiateLabShutdown;
import com.mathworks.toolbox.distcomp.pmode.LabFinishSessionWithMonitoring;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.SessionConstants;
import com.mathworks.toolbox.distcomp.pmode.SessionShutdownEvent;
import com.mathworks.toolbox.distcomp.pmode.ShutdownACKFromLab;
import com.mathworks.toolbox.distcomp.pmode.shared.ErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.OutputGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.SessionService;
import com.mathworks.toolbox.distcomp.pmode.shared.Shutdown;
import com.mathworks.toolbox.distcomp.pmode.shared.ShutdownHandler;
import com.mathworks.toolbox.distcomp.util.i18n.BundleKey;
import com.mathworks.toolbox.distcomp.util.i18n.HasI18nMatlabErrorId;
import com.mathworks.toolbox.distcomp.util.i18n.I18NMatlabMessage;
import com.mathworks.toolbox.distcomp.util.i18n.MessageGenerator;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;

public class LabShutdownHandlerImpl
implements ShutdownHandler {
    private final OutputGroup fOutGroup;
    private final ErrorHandler fErrorHandler;
    private final AtomicBoolean fHasShutdownSequenceStarted = new AtomicBoolean(false);
    private final ClosableSessionConnections fClosableConnections;
    private final AtomicBoolean fRemoteStartupComplete;
    private final Thread fStartupWatchdogThread;
    private LabFinishSessionWithMonitoring fFinishWithMonitoring;

    static LabShutdownHandlerImpl create(SessionService sessionService, OutputGroup outputGroup, ClosableSessionConnections closableSessionConnections) {
        LabShutdownHandlerImpl labShutdownHandlerImpl = new LabShutdownHandlerImpl(sessionService, outputGroup, closableSessionConnections);
        labShutdownHandlerImpl.init();
        return labShutdownHandlerImpl;
    }

    private LabShutdownHandlerImpl(SessionService sessionService, OutputGroup outputGroup, ClosableSessionConnections closableSessionConnections) {
        this.fOutGroup = outputGroup;
        this.fClosableConnections = closableSessionConnections;
        this.fErrorHandler = sessionService.getErrorHandler();
        this.fRemoteStartupComplete = new AtomicBoolean(false);
        this.fStartupWatchdogThread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(SessionConstants.sLAB_CONNECT_TIMEOUT);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!LabShutdownHandlerImpl.this.fRemoteStartupComplete.get()) {
                    PackageInfo.LOGGER.log(DistcompLevel.ONE, "Startup failed ... shutting down.");
                    LabShutdownError labShutdownError = new LabShutdownError(LabShutdownHandlerI18NText.StartupFailed, new Object[0]);
                    LabShutdownHandlerImpl.this.forceShutdown(labShutdownError);
                } else {
                    PackageInfo.LOGGER.log(DistcompLevel.THREE, "Startup was successful.");
                }
            }
        };
    }

    @Override
    public void sessionStartupComplete() {
        this.fRemoteStartupComplete.set(true);
        this.fStartupWatchdogThread.interrupt();
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "Cancelled shutdown.");
    }

    private void init() {
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "Starting the startup checker thread.");
        this.fStartupWatchdogThread.start();
    }

    @Override
    public boolean normalShutdown() {
        assert (false) : "ShutdownHandlerImpl.normalShutdown called on a lab.";
        return false;
    }

    @Override
    public void forceShutdown(I18NMatlabMessage i18NMatlabMessage) {
        if (this.fHasShutdownSequenceStarted.getAndSet(true)) {
            return;
        }
        PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Initiating a forced shutdown.");
        this.fErrorHandler.deactivate();
        this.labShutdown(new SessionShutdownEvent(this, SessionShutdownEvent.ShutdownState.ERROR, i18NMatlabMessage));
    }

    @Override
    public void dispatch(Shutdown shutdown, Instance instance) {
        if (shutdown instanceof InitiateLabShutdown) {
            if (this.fHasShutdownSequenceStarted.getAndSet(true)) {
                return;
            }
            this.fErrorHandler.deactivate();
            this.sendACKToClient(instance);
            this.labShutdown(new SessionShutdownEvent(this, SessionShutdownEvent.ShutdownState.NORMAL));
        } else assert (false) : "Received an unexpected class " + shutdown.getClass().getName();
    }

    @Override
    public boolean hasShutdownBegun() {
        return this.fHasShutdownSequenceStarted.get();
    }

    private void labShutdown(SessionShutdownEvent sessionShutdownEvent) {
        block5: {
            block4: {
                try {
                    this.fStartupWatchdogThread.interrupt();
                }
                catch (Throwable throwable) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError((Object)("Caught a Throwable when interrupting the startup checker thread: " + throwable.getClass().getName()));
                }
            }
            PackageInfo.LOGGER.log(DistcompLevel.THREE, "Closing IO and stopping executors.");
            try {
                this.fClosableConnections.run(sessionShutdownEvent);
            }
            catch (Throwable throwable) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError((Object)("Caught a Throwable when calling Runnable to close IO and stop executors." + throwable.getClass().getName()));
            }
        }
        this.fFinishWithMonitoring = LabFinishSessionWithMonitoring.create();
    }

    private void sendACKToClient(Instance instance) {
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "Lab sending ACK to client.");
        try {
            this.fOutGroup.sendTo(instance, new ShutdownACKFromLab());
            try {
                Thread.sleep(SessionConstants.sLAB_WAIT_BEFORE_CLOSING_IO);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Could not send a shutdown request to the labs.", throwable);
        }
    }

    private static final class LabShutdownError
    implements I18NMatlabMessage,
    Serializable {
        private final LabShutdownHandlerI18NText fErrorText;
        private final Object[] fMessageArguments;

        LabShutdownError(LabShutdownHandlerI18NText labShutdownHandlerI18NText, Object ... objectArray) {
            this.fErrorText = labShutdownHandlerI18NText;
            this.fMessageArguments = objectArray;
        }

        @Override
        public String getLocalizedMessage() {
            return this.fErrorText.createLocalizedMessage(this.fMessageArguments);
        }

        @Override
        public String getMessage() {
            return this.fErrorText.createMessage(this.fMessageArguments);
        }

        @Override
        public String getMatlabErrorId() {
            return this.fErrorText.getMatlabErrorId();
        }
    }

    public static enum LabShutdownHandlerI18NText implements HasI18nMatlabErrorId,
    Serializable
    {
        StartupFailed;

        private static final String RESOURCE_BASE_NAME = "com.mathworks.toolbox.distcomp.pmode.resources.RES_pmode";
        private static final String RESOURCE_BUNDLE_KEY_PREFIX = "distcomp.pmode.";
        private static final String MATLAB_ERROR_ID_PREFIX = "distcomp:pmode:";

        @Override
        public String getMatlabErrorId() {
            return MATLAB_ERROR_ID_PREFIX + this.toString();
        }

        @Override
        public String getResourceBundleName() {
            return RESOURCE_BASE_NAME;
        }

        @Override
        public String getBundleKey() {
            return RESOURCE_BUNDLE_KEY_PREFIX + this.toString();
        }

        @Override
        public String createMessage(Object ... objectArray) {
            return MessageGenerator.createMessage((BundleKey)this, false, objectArray);
        }

        @Override
        public String createLocalizedMessage(Object ... objectArray) {
            return MessageGenerator.createLocalizedMessage(this, false, objectArray);
        }
    }
}

