/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.jmi.MatlabMCR;
import com.mathworks.toolbox.distcomp.pmode.MDispatchableCommand;
import com.mathworks.toolbox.distcomp.pmode.PathNotificationCommandResult;
import com.mathworks.toolbox.distcomp.pmode.Session;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnGroup;
import com.mathworks.toolbox.distcomp.util.MatlabRefStore;
import java.util.Arrays;
import java.util.Vector;

public class PathNotificationCommand
extends MDispatchableCommand {
    private PathNotificationType fNotificationType;
    private Vector<String> fArguments = new Vector();

    public PathNotificationCommand(PathNotificationType pathNotificationType, String string) {
        this.fNotificationType = pathNotificationType;
        this.fArguments.add(string);
    }

    public PathNotificationCommand(PathNotificationType pathNotificationType, String[] stringArray) {
        this.fNotificationType = pathNotificationType;
        this.fArguments.addAll(Arrays.asList(stringArray));
    }

    public PathNotificationCommand(PathNotificationType pathNotificationType, String[] stringArray, String string) {
        assert (pathNotificationType == PathNotificationType.ADDPATH) : "Where field only applicable to ADDPATH";
        this.fNotificationType = pathNotificationType;
        this.fArguments.addAll(Arrays.asList(stringArray));
        this.fArguments.add(string);
    }

    @Override
    public void dispatch(ReturnGroup returnGroup, Instance instance, Session session) {
        PathNotificationCommandResult pathNotificationCommandResult = new PathNotificationCommandResult(this.getSequenceNumber());
        returnGroup.returnTo(this.getSourceProcess(), pathNotificationCommandResult);
        if (this.fArguments == null || this.fArguments.size() == 0) {
            return;
        }
        MatlabMCR matlabMCR = MatlabRefStore.getMatlabRef();
        Object[] objectArray = this.fArguments.toArray();
        switch (this.fNotificationType) {
            case ADDPATH: {
                matlabMCR.fevalNoOutput("addpath", objectArray);
                break;
            }
            case RMPATH: {
                matlabMCR.fevalNoOutput("rmpath", objectArray);
                break;
            }
            case CD: {
                matlabMCR.fevalNoOutput("cd", objectArray);
            }
        }
    }

    static enum PathNotificationType {
        ADDPATH,
        RMPATH,
        CD;

    }
}

