/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.MatlabMCRFactory;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.Session;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

public class SessionFactory {
    public static final AtomicBoolean sAllowedToStart = new AtomicBoolean(true);
    private static Session sCurrentSession = null;
    private static MatlabMCR sCurrentSessionsMCR = null;
    private static Connection[] sConnections = null;
    private static final Object sLockObject = new Object();

    public static Session getCurrentSession() {
        return SessionFactory.getCurrentSessionForCurrentMCR();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Session getCurrentSessionForCurrentMCR() {
        MatlabMCR matlabMCR = SessionFactory.getCurrentMCR();
        Object object = sLockObject;
        synchronized (object) {
            if (matlabMCR.equals(sCurrentSessionsMCR)) {
                return sCurrentSession;
            }
            return null;
        }
    }

    private static MatlabMCR getCurrentMCR() {
        if (NativeMatlab.nativeIsMatlabThread()) {
            return MatlabMCRFactory.getForCurrentMCR();
        }
        throw new IllegalThreadStateException("Current matlabpool session can only be accessed from the MATLAB main thread.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean destroyClientSession() {
        Object object = sLockObject;
        synchronized (object) {
            boolean bl = false;
            Session session = SessionFactory.getCurrentSessionForCurrentMCR();
            if (session != null) {
                PackageInfo.LOGGER.log(DistcompLevel.THREE, "Destroying the current client session object.");
                bl = session.normalShutdown();
                sCurrentSessionsMCR = null;
                sCurrentSession = null;
            }
            SessionFactory.closeConnections();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyLabSession() {
        Object object = sLockObject;
        synchronized (object) {
            Session session = SessionFactory.getCurrentSessionForCurrentMCR();
            if (session != null) {
                PackageInfo.LOGGER.log(DistcompLevel.THREE, "Destroying the current lab session object.");
                sCurrentSessionsMCR = null;
                sCurrentSession = null;
            }
            SessionFactory.closeConnections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createClientSession(Connection connection) throws IOException {
        assert (connection != null) : "Connection to labs should not be null.";
        Object object = sLockObject;
        synchronized (object) {
            SessionFactory.createClientSession(new Connection[]{connection});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createClientSession(Connection[] connectionArray) throws IOException {
        assert (connectionArray != null) : "Array of Connection to labs should not be null.";
        assert (connectionArray.length > 0) : "Array of Connection to labs should not empty.";
        for (int i = 0; i < connectionArray.length; ++i) {
            assert (connectionArray[i] != null) : "Received a null Connection to lab " + i + ".";
        }
        Object object = sLockObject;
        synchronized (object) {
            Session session = SessionFactory.getCurrentSessionForCurrentMCR();
            if (session != null) {
                throw new IllegalStateException("Only one matlabpool may be open at a time.");
            }
            sCurrentSessionsMCR = SessionFactory.getCurrentMCR();
            sConnections = connectionArray;
            sCurrentSession = Session.create(connectionArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createLabSession(Connection connection, int n) throws IOException {
        assert (connection != null) : "Connection to client should not be null.";
        assert (n > 0) : "Labindex should be > 0.";
        Object object = sLockObject;
        synchronized (object) {
            Session session = SessionFactory.getCurrentSessionForCurrentMCR();
            if (session != null) {
                throw new IllegalStateException("Only one matlabpool may be open at a time.");
            }
            sCurrentSessionsMCR = SessionFactory.getCurrentMCR();
            sConnections = new Connection[]{connection};
            sCurrentSession = Session.create(connection, n);
        }
    }

    private static void closeConnections() {
        if (sConnections != null) {
            for (Connection connection : sConnections) {
                try {
                    connection.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        sConnections = null;
    }
}

