/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.pmode.FevalResult;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.MessageObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class SingleRemoteEvaluationObserver
implements MessageObserver {
    private FevalResult fResult = null;
    private CountDownLatch fLatch = new CountDownLatch(1);
    private AtomicBoolean fDisposed = new AtomicBoolean(false);
    private boolean fFreed = false;

    @Override
    public final synchronized void completed(ReturnMessage returnMessage, Instance instance) {
        if (returnMessage instanceof FevalResult) {
            this.fResult = (FevalResult)returnMessage;
            this.fLatch.countDown();
            this.disposeResultIfReceivedAndDisposed();
        }
    }

    private synchronized void disposeResultIfReceivedAndDisposed() {
        if (this.await(0L, TimeUnit.SECONDS) && this.fDisposed.get()) {
            assert (this.fResult != null) : "Didn't have result to dispose";
            if (!this.fFreed) {
                this.fResult.dispose();
                this.fFreed = true;
            }
        }
    }

    public final void dispose() {
        this.fDisposed.set(true);
        this.disposeResultIfReceivedAndDisposed();
    }

    public final boolean await(long l, TimeUnit timeUnit) {
        try {
            return this.fLatch.await(l, timeUnit);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    public final synchronized FevalResult getResult() {
        assert (this.fResult != null) : "Null result!";
        return this.fResult;
    }
}

