/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.io;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.io.MatlabPoolAcceptor;
import com.mathworks.toolbox.distcomp.pmode.io.MatlabPoolBrokeredAcceptor;
import com.mathworks.toolbox.distcomp.pmode.io.MatlabPoolBrokeredConnector;
import com.mathworks.toolbox.distcomp.pmode.io.MatlabPoolConnector;
import com.mathworks.toolbox.distcomp.pmode.io.MatlabPoolPeerInstance;
import com.mathworks.toolbox.distcomp.pmode.io.MatlabPoolServerSocketAcceptor;
import com.mathworks.toolbox.distcomp.pmode.io.MatlabPoolSocketConnector;
import com.mathworks.toolbox.distcomp.pmode.io.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokerClientInfo;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokeredAcceptInfo;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokeredAcceptorSSLSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokeredSocketConnectInfo;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerMessagingException;
import com.mathworks.toolbox.distcomp.pmode.shared.AcceptInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.AcceptorPlainSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.shared.AcceptorSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.HandShake;
import com.mathworks.toolbox.distcomp.pmode.shared.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketAcceptInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketConnectInfo;
import java.util.UUID;

public final class ConnectionManager {
    private static Throwable sThrowable = null;

    private ConnectionManager() {
    }

    public static Connector buildLabConnManager(int n, int n2, String string, ConnectInfo connectInfo) throws PeerMessagingException {
        sThrowable = null;
        try {
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "buildLabConnManager clientConnectInfo is " + connectInfo);
            UUID uUID = connectInfo.getGroupUUID();
            UUID uUID2 = UUID.randomUUID();
            MatlabPoolPeerInstance matlabPoolPeerInstance = new MatlabPoolPeerInstance(uUID, uUID2, ProcessInstance.getLabInstance(n), n2);
            MatlabPoolConnector matlabPoolConnector = connectInfo instanceof BrokeredSocketConnectInfo ? new MatlabPoolBrokeredConnector(matlabPoolPeerInstance, string, connectInfo.getGroupUUID()) : new MatlabPoolSocketConnector(matlabPoolPeerInstance);
            Connector connector = new Connector(matlabPoolConnector);
            connector.registerClientConnectInfo(connectInfo);
            return connector;
        }
        catch (PeerMessagingException peerMessagingException) {
            ConnectionManager.handleTrappedThrowable(peerMessagingException);
            throw peerMessagingException;
        }
        catch (RuntimeException runtimeException) {
            ConnectionManager.handleTrappedThrowable(runtimeException);
            throw runtimeException;
        }
    }

    public static Acceptor buildClientConnManager(String string, MatlabPoolPeerInstance matlabPoolPeerInstance, AcceptInfo acceptInfo) throws PeerMessagingException, InterruptedException {
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "buildClientConnManager acceptInfo is " + acceptInfo);
        sThrowable = null;
        try {
            MatlabPoolAcceptor matlabPoolAcceptor;
            if (acceptInfo instanceof BrokeredAcceptInfo) {
                BrokeredAcceptInfo brokeredAcceptInfo = (BrokeredAcceptInfo)acceptInfo;
                matlabPoolAcceptor = new MatlabPoolBrokeredAcceptor(matlabPoolPeerInstance, brokeredAcceptInfo);
            } else if (acceptInfo instanceof ServerSocketAcceptInfo) {
                ServerSocketAcceptInfo serverSocketAcceptInfo = (ServerSocketAcceptInfo)acceptInfo;
                matlabPoolAcceptor = new MatlabPoolServerSocketAcceptor(string, matlabPoolPeerInstance, serverSocketAcceptInfo);
            } else {
                throw new IllegalArgumentException("acceptInfo is a " + acceptInfo.getClass() + ", not a BrokeredAcceptInfo or a ServerSocketAcceptInfo");
            }
            return new Acceptor(matlabPoolAcceptor);
        }
        catch (PeerMessagingException peerMessagingException) {
            ConnectionManager.handleTrappedThrowable(peerMessagingException);
            throw peerMessagingException;
        }
        catch (InterruptedException interruptedException) {
            ConnectionManager.handleTrappedThrowable(interruptedException);
            throw interruptedException;
        }
        catch (RuntimeException runtimeException) {
            ConnectionManager.handleTrappedThrowable(runtimeException);
            throw runtimeException;
        }
    }

    public static MatlabPoolPeerInstance createClientPeerInstance() {
        UUID uUID = UUID.randomUUID();
        UUID uUID2 = UUID.randomUUID();
        return new MatlabPoolPeerInstance(uUID, uUID2, ProcessInstance.getClientInstance(), -1);
    }

    public static AcceptInfo createAcceptInfo(MatlabPoolPeerInstance matlabPoolPeerInstance, int n, int n2, int n3, ServerSocketConnectInfo serverSocketConnectInfo, ServerSocketAcceptInfo serverSocketAcceptInfo, boolean bl, long l, long l2) {
        AcceptorSecurityDescription acceptorSecurityDescription = bl ? BrokeredAcceptorSSLSecurityDescription.createAcceptorSSLSecurityDescription(matlabPoolPeerInstance.getGroupUuid(), "MATLABPOOL-") : new AcceptorPlainSecurityDescription();
        if (serverSocketConnectInfo != null) {
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "buildClientConnManager brokerServerSocketConnectInfo is " + serverSocketConnectInfo);
            ServerSocketAcceptInfo serverSocketAcceptInfo2 = serverSocketAcceptInfo.createFromTemplate(matlabPoolPeerInstance.getGroupUuid(), acceptorSecurityDescription, l2);
            BrokerClientInfo brokerClientInfo = new BrokerClientInfo(serverSocketConnectInfo, l, l2);
            return new BrokeredAcceptInfo(matlabPoolPeerInstance.getGroupUuid(), brokerClientInfo, l, l2, serverSocketAcceptInfo2);
        }
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "buildClientConnManager using new code path");
        AcceptorPlainSecurityDescription acceptorPlainSecurityDescription = new AcceptorPlainSecurityDescription();
        return new ServerSocketAcceptInfo(matlabPoolPeerInstance.getGroupUuid(), n, n2, 0, 1, n3, acceptorPlainSecurityDescription, l2);
    }

    public static AcceptInfo createAcceptInfo(MatlabPoolPeerInstance matlabPoolPeerInstance, int n, int n2, int n3, boolean bl, long l) {
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "buildClientConnManager using new code path");
        AcceptorPlainSecurityDescription acceptorPlainSecurityDescription = new AcceptorPlainSecurityDescription();
        return new ServerSocketAcceptInfo(matlabPoolPeerInstance.getGroupUuid(), n, n2, 0, 1, n3, acceptorPlainSecurityDescription, l);
    }

    private static void handleTrappedThrowable(Throwable throwable) {
        sThrowable = throwable;
        PackageInfo.LOGGER.log(DistcompLevel.TWO, "Trapped Throwable before returning to Matlab.", throwable);
    }

    public static boolean hasTrappedThrowable() {
        return sThrowable != null;
    }

    public static boolean hasTrappedHandshakeException() {
        if (ConnectionManager.hasTrappedThrowable()) {
            return sThrowable instanceof HandShake.HandShakeException;
        }
        return false;
    }

    public static Throwable getTrappedThrowable() {
        return sThrowable;
    }

    public static final class ConnectionAndNumberOfLabs {
        private final Connection fConnection;
        private final int fNumberOfLabs;

        ConnectionAndNumberOfLabs(Connection connection, int n) {
            this.fConnection = connection;
            this.fNumberOfLabs = n;
        }

        public Connection getConnection() {
            return this.fConnection;
        }

        public int getNumberOfLabs() {
            return this.fNumberOfLabs;
        }
    }

    public static final class Connector {
        private final MatlabPoolConnector fMatlabPoolConnector;

        private Connector(MatlabPoolConnector matlabPoolConnector) {
            this.fMatlabPoolConnector = matlabPoolConnector;
        }

        private ProcessInstance registerClientConnectInfo(ConnectInfo connectInfo) {
            return this.fMatlabPoolConnector.registerClientConnectInfo(connectInfo);
        }

        public Connection activelyConnectTo(ProcessInstance processInstance) throws PeerMessagingException, InterruptedException {
            sThrowable = null;
            try {
                PackageInfo.LOGGER.log(DistcompLevel.SIX, "activelyConnectTo(" + processInstance + ")");
                Connection connection = this.fMatlabPoolConnector.activelyConnectTo(processInstance);
                PackageInfo.LOGGER.log(DistcompLevel.SIX, "activelyConnectTo will return " + connection);
                return connection;
            }
            catch (PeerMessagingException peerMessagingException) {
                ConnectionManager.handleTrappedThrowable(peerMessagingException);
                throw peerMessagingException;
            }
            catch (RuntimeException runtimeException) {
                ConnectionManager.handleTrappedThrowable(runtimeException);
                throw runtimeException;
            }
        }

        public void close() {
            this.fMatlabPoolConnector.close();
        }

        public String toString() {
            return "Connector{fMatlabPoolConnector=" + this.fMatlabPoolConnector + '}';
        }
    }

    public static final class Acceptor {
        private final MatlabPoolAcceptor fMatlabPoolAcceptor;

        private Acceptor(MatlabPoolAcceptor matlabPoolAcceptor) {
            this.fMatlabPoolAcceptor = matlabPoolAcceptor;
        }

        public ConnectInfo getInfoToConnect() {
            return this.fMatlabPoolAcceptor.getInfoToConnect();
        }

        public ConnectionAndNumberOfLabs activelyAccept() {
            return this.fMatlabPoolAcceptor.activelyAccept();
        }

        public void close() {
            this.fMatlabPoolAcceptor.close();
        }

        public String toString() {
            return "Acceptor{fMatlabPoolAcceptor=" + this.fMatlabPoolAcceptor + '}';
        }
    }
}

