/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.io;

import com.mathworks.toolbox.distcomp.pmode.io.BufAccessibleByteArrayOutputStream;
import com.mathworks.toolbox.distcomp.pmode.io.BufferType;
import com.mathworks.toolbox.distcomp.pmode.shared.PmodeSerializable;
import com.mathworks.toolbox.distcomp.util.ByteBufferHandle;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

final class SerializationHelpers {
    static ByteBufferHandle serializeToByteBuffer(PmodeSerializable pmodeSerializable, BufferType bufferType) throws IOException {
        ByteBufferHandle byteBufferHandle;
        BufAccessibleByteArrayOutputStream bufAccessibleByteArrayOutputStream = new BufAccessibleByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufAccessibleByteArrayOutputStream);
        objectOutputStream.writeObject(pmodeSerializable);
        objectOutputStream.close();
        if (bufferType == BufferType.DIRECT) {
            byteBufferHandle = ByteBufferHandle.allocateDirect(bufAccessibleByteArrayOutputStream.size());
            byteBufferHandle.get().put(bufAccessibleByteArrayOutputStream.getBuf());
        } else {
            byteBufferHandle = ByteBufferHandle.wrap(bufAccessibleByteArrayOutputStream.getBuf());
        }
        byteBufferHandle.get().position(0).limit(byteBufferHandle.get().capacity());
        return byteBufferHandle;
    }

    static PmodeSerializable deserializeFromByteBuffer(ByteBufferHandle byteBufferHandle) throws IOException, ClassNotFoundException {
        Object object;
        ByteArrayInputStream byteArrayInputStream;
        if (byteBufferHandle.get().hasArray()) {
            byteArrayInputStream = new ByteArrayInputStream(byteBufferHandle.get().array());
        } else {
            object = new byte[byteBufferHandle.get().capacity()];
            byteBufferHandle.get().get((byte[])object);
            byteArrayInputStream = new ByteArrayInputStream((byte[])object);
        }
        object = new ObjectInputStream(byteArrayInputStream);
        PmodeSerializable pmodeSerializable = (PmodeSerializable)((ObjectInputStream)object).readObject();
        byteBufferHandle.free();
        return pmodeSerializable;
    }

    private SerializationHelpers() {
    }
}

