/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.peermessaging;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.io.IoConstants;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerMessagingException;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectionFactory;
import com.mathworks.toolbox.distcomp.pmode.shared.HandShake;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketAcceptInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketConnectInfo;
import com.mathworks.toolbox.distcomp.util.i18n.BundleKey;
import com.mathworks.toolbox.distcomp.util.i18n.HasI18nMatlabErrorId;
import com.mathworks.toolbox.distcomp.util.i18n.MessageGenerator;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public abstract class AbstractPeerAcceptor {
    private final ServerSocketChannel fServerSocketChannel;
    private final Instance fLocalPeerInstance;
    private final ServerSocketAcceptInfo fAcceptInfo;
    private final ServerSocketConnectInfo fInfoToConnect;
    private final ConnectionFactory fConnectionFactory;

    AbstractPeerAcceptor(String string, Instance instance, ServerSocketAcceptInfo serverSocketAcceptInfo) throws InitializeServerSocketChannelException {
        if (null == string || "".equals(string)) {
            String string2 = this.getClass().getSimpleName() + ": hostname must be defined, but hostname is '" + string + "'";
            PackageInfo.LOGGER.log(DistcompLevel.TWO, string2);
            throw new IllegalArgumentException(string2);
        }
        this.fLocalPeerInstance = instance;
        this.fAcceptInfo = serverSocketAcceptInfo;
        this.fConnectionFactory = serverSocketAcceptInfo.getAcceptorSecurityDescription().createConnectionFactoryForAcceptor();
        try {
            this.fServerSocketChannel = ServerSocketChannel.open();
        }
        catch (IOException iOException) {
            throw new CouldNotOpenServerSocketChannelException(string, instance, iOException);
        }
        try {
            int[] nArray = IoConstants.sSOCKET_PERFORMANCE_PREFS;
            this.fServerSocketChannel.socket().setPerformancePreferences(nArray[0], nArray[1], nArray[2]);
            try {
                this.fServerSocketChannel.configureBlocking(false);
            }
            catch (IOException iOException) {
                throw new CouldNotConfigureNonblockingServerSocketChannelException(string, instance, iOException);
            }
            InetAddress inetAddress = null;
            boolean bl = false;
            IOException iOException = null;
            int n = Integer.MIN_VALUE;
            int n2 = serverSocketAcceptInfo.getMinPort() + serverSocketAcceptInfo.getPortOffset();
            while (!bl && n2 <= serverSocketAcceptInfo.getMaxPort()) {
                InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n2);
                PackageInfo.LOGGER.log(DistcompLevel.SIX, "AbstractPeerAcceptor for " + this.fLocalPeerInstance + " to be bound to " + inetSocketAddress + " with backlog " + this.fAcceptInfo.getBacklog());
                try {
                    this.fServerSocketChannel.socket().bind(inetSocketAddress, this.fAcceptInfo.getBacklog());
                    bl = true;
                }
                catch (BindException bindException) {
                    PackageInfo.LOGGER.log(DistcompLevel.SIX, "AbstractPeerAcceptor for " + this.fLocalPeerInstance + " failed to bind to " + inetSocketAddress, bindException);
                    n2 += serverSocketAcceptInfo.getPortStep();
                }
                catch (IOException iOException2) {
                    PackageInfo.LOGGER.log(DistcompLevel.THREE, "AbstractPeerAcceptor for " + this.fLocalPeerInstance + " failed to bind to " + inetSocketAddress, iOException2);
                    n2 += serverSocketAcceptInfo.getPortStep();
                    if (iOException != null) continue;
                    iOException = iOException2;
                    n = n2;
                }
            }
            if (!bl) {
                if (iOException != null) {
                    throw new CouldNotBindServerSocketChannelGeneralException(string, instance, n, iOException);
                }
                if (serverSocketAcceptInfo.getMinPort() + serverSocketAcceptInfo.getPortOffset() == serverSocketAcceptInfo.getMaxPort()) {
                    throw new CouldNotBindServerSocketChannelToOnePortException(string, instance, serverSocketAcceptInfo);
                }
                throw new CouldNotBindServerSocketChannelToPortsException(string, instance, serverSocketAcceptInfo);
            }
            int n3 = this.fServerSocketChannel.socket().getLocalPort();
            this.fInfoToConnect = new ServerSocketConnectInfo(string, n3, serverSocketAcceptInfo.getGroupUUID(), serverSocketAcceptInfo.getAcceptorSecurityDescription().createConnectorSecurityDescription(), serverSocketAcceptInfo.getHandShakeTimeout());
            PackageInfo.LOGGER.log(DistcompLevel.THREE, "AbstractPeerAcceptor for " + this.fLocalPeerInstance + " constructed using " + this.fInfoToConnect.getSocketAddress());
        }
        catch (InitializeServerSocketChannelException initializeServerSocketChannelException) {
            AbstractPeerAcceptor.safeCloseServerSocketChannel(this.fServerSocketChannel);
            throw initializeServerSocketChannelException;
        }
        catch (RuntimeException runtimeException) {
            AbstractPeerAcceptor.safeCloseServerSocketChannel(this.fServerSocketChannel);
            throw runtimeException;
        }
    }

    public ServerSocketConnectInfo getInfoToConnect() {
        PackageInfo.LOGGER.log(DistcompLevel.ONE, "getInfoToConnect() will return " + this.fInfoToConnect);
        return this.fInfoToConnect;
    }

    public void close() {
        AbstractPeerAcceptor.safeCloseServerSocketChannel(this.fServerSocketChannel);
    }

    private static void safeCloseServerSocketChannel(ServerSocketChannel serverSocketChannel) {
        try {
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "Closing " + serverSocketChannel);
            serverSocketChannel.close();
        }
        catch (IOException iOException) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "IOException closing server socket channel", iOException);
        }
    }

    protected Instance getLocalPeerInstance() {
        return this.fLocalPeerInstance;
    }

    protected ServerSocketChannel getServerSocketChannel() {
        return this.fServerSocketChannel;
    }

    protected Connection createConnection(SocketChannel socketChannel) throws HandShake.HandShakeException, CouldNotConfigureSocketChannelException {
        PackageInfo.LOGGER.log(DistcompLevel.SIX, this.fLocalPeerInstance.toString() + " " + socketChannel + " about to be configured.");
        try {
            socketChannel.socket().setTcpNoDelay(false);
            socketChannel.configureBlocking(true);
        }
        catch (IOException iOException) {
            throw new CouldNotConfigureSocketChannelException(socketChannel, iOException);
        }
        PackageInfo.LOGGER.log(DistcompLevel.SIX, this.fLocalPeerInstance.toString() + " " + socketChannel + " configured.");
        return this.fConnectionFactory.createConnection(socketChannel, this.fLocalPeerInstance, this.fAcceptInfo, false);
    }

    public static enum AbstractPeerAcceptorErrorCode implements HasI18nMatlabErrorId
    {
        CouldNotOpenServerSocketChannel,
        CouldNotConfigureNonblockingServerSocketChannel,
        CouldNotBindServerSocketChannelToPorts,
        CouldNotBindServerSocketChannelToOnePort,
        CouldNotBindServerSocketChannelGeneralException,
        CouldNotCreateAsyncSelectorException,
        CouldNotConfigureSocketChannelException,
        CouldNotAcceptException,
        ActivelyAcceptInterruptedException;

        private static final String RESOURCE_BASE_NAME = "com.mathworks.toolbox.distcomp.pmode.peermessaging.resources.RES_peermessaging";
        private static final String RESOURCE_BUNDLE_KEY_PREFIX = "parallel.peermessaging.";
        private static final String MATLAB_ERROR_ID_PREFIX = "parallel:peermessaging:";

        @Override
        public String getMatlabErrorId() {
            return MATLAB_ERROR_ID_PREFIX + this.toString();
        }

        @Override
        public String getResourceBundleName() {
            return RESOURCE_BASE_NAME;
        }

        @Override
        public String getBundleKey() {
            return RESOURCE_BUNDLE_KEY_PREFIX + this.toString();
        }

        @Override
        public String createMessage(Object ... objectArray) {
            return MessageGenerator.createMessage((BundleKey)this, true, objectArray);
        }

        @Override
        public String createLocalizedMessage(Object ... objectArray) {
            return MessageGenerator.createLocalizedMessage(this, true, objectArray);
        }
    }

    public static final class CouldNotBindServerSocketChannelGeneralException
    extends InitializeServerSocketChannelException {
        private final int fProblemPort;

        private CouldNotBindServerSocketChannelGeneralException(String string, Instance instance, int n, IOException iOException) {
            super(AbstractPeerAcceptorErrorCode.CouldNotBindServerSocketChannelGeneralException, string, instance, iOException);
            this.fProblemPort = n;
        }

        @Override
        protected Object[] getMessageArguments() {
            return new Object[]{this.getLocalHostname(), this.getLocalPeerInstance(), this.fProblemPort, this.getCause().getLocalizedMessage()};
        }
    }

    public static final class CouldNotBindServerSocketChannelToOnePortException
    extends InitializeServerSocketChannelException {
        private final ServerSocketAcceptInfo fAcceptInfo;

        private CouldNotBindServerSocketChannelToOnePortException(String string, Instance instance, ServerSocketAcceptInfo serverSocketAcceptInfo) {
            super(AbstractPeerAcceptorErrorCode.CouldNotBindServerSocketChannelToOnePort, string, instance);
            this.fAcceptInfo = serverSocketAcceptInfo;
        }

        @Override
        protected Object[] getMessageArguments() {
            return new Object[]{this.getLocalHostname(), this.getLocalPeerInstance(), this.fAcceptInfo.getMinPort() + this.fAcceptInfo.getPortOffset()};
        }
    }

    public static final class CouldNotBindServerSocketChannelToPortsException
    extends InitializeServerSocketChannelException {
        private final ServerSocketAcceptInfo fAcceptInfo;

        private CouldNotBindServerSocketChannelToPortsException(String string, Instance instance, ServerSocketAcceptInfo serverSocketAcceptInfo) {
            super(AbstractPeerAcceptorErrorCode.CouldNotBindServerSocketChannelToPorts, string, instance);
            this.fAcceptInfo = serverSocketAcceptInfo;
        }

        @Override
        protected Object[] getMessageArguments() {
            return new Object[]{this.getLocalHostname(), this.getLocalPeerInstance(), this.fAcceptInfo.getMinPort() + this.fAcceptInfo.getPortOffset(), this.fAcceptInfo.getMaxPort(), this.fAcceptInfo.getPortStep()};
        }
    }

    public static final class CouldNotConfigureNonblockingServerSocketChannelException
    extends InitializeServerSocketChannelException {
        private CouldNotConfigureNonblockingServerSocketChannelException(String string, Instance instance, IOException iOException) {
            super(AbstractPeerAcceptorErrorCode.CouldNotConfigureNonblockingServerSocketChannel, string, instance, iOException);
        }

        @Override
        protected Object[] getMessageArguments() {
            return new Object[]{this.getLocalHostname(), this.getLocalPeerInstance()};
        }
    }

    public static final class CouldNotOpenServerSocketChannelException
    extends InitializeServerSocketChannelException {
        private CouldNotOpenServerSocketChannelException(String string, Instance instance, IOException iOException) {
            super(AbstractPeerAcceptorErrorCode.CouldNotOpenServerSocketChannel, string, instance, iOException);
        }

        @Override
        protected Object[] getMessageArguments() {
            return new Object[]{this.getLocalHostname(), this.getLocalPeerInstance()};
        }
    }

    public static abstract class InitializeServerSocketChannelException
    extends PeerMessagingException {
        private final String fLocalHostname;
        private final Instance fLocalPeerInstance;

        InitializeServerSocketChannelException(AbstractPeerAcceptorErrorCode abstractPeerAcceptorErrorCode, String string, Instance instance, IOException iOException) {
            super(abstractPeerAcceptorErrorCode, iOException);
            this.fLocalHostname = string;
            this.fLocalPeerInstance = instance;
        }

        private InitializeServerSocketChannelException(AbstractPeerAcceptorErrorCode abstractPeerAcceptorErrorCode, String string, Instance instance) {
            super(abstractPeerAcceptorErrorCode);
            this.fLocalHostname = string;
            this.fLocalPeerInstance = instance;
        }

        public String getLocalHostname() {
            return this.fLocalHostname;
        }

        public Instance getLocalPeerInstance() {
            return this.fLocalPeerInstance;
        }
    }

    public static final class CouldNotConfigureSocketChannelException
    extends PeerMessagingException {
        private final InetSocketAddress fRemoteSocketAddress;
        private final InetSocketAddress fLocalSocketAddress;

        private CouldNotConfigureSocketChannelException(SocketChannel socketChannel, IOException iOException) {
            super(AbstractPeerAcceptorErrorCode.CouldNotConfigureSocketChannelException, iOException);
            this.fLocalSocketAddress = (InetSocketAddress)socketChannel.socket().getLocalSocketAddress();
            this.fRemoteSocketAddress = (InetSocketAddress)socketChannel.socket().getRemoteSocketAddress();
        }

        @Override
        protected Object[] getMessageArguments() {
            return new Object[]{this.fRemoteSocketAddress, this.fLocalSocketAddress, this.getCause().getLocalizedMessage()};
        }
    }
}

