/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.transfer;

import com.mathworks.jmi.Matlab;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.shared.LabsCompletionObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.LabsResponseVector;
import com.mathworks.toolbox.distcomp.pmode.shared.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.transfer.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.transfer.TransferError;
import com.mathworks.toolbox.distcomp.pmode.transfer.TransferMonitor;

class TransferLabsCompletionObserver
implements LabsCompletionObserver {
    TransferMonitor fMonitor;
    long fTransferSeqNumber;
    ProcessInstance fSrcID;
    String fCmdWinOutput;
    LabsResponseVector fResponses;
    boolean fWasInterrupted;
    boolean fFailed;

    public TransferLabsCompletionObserver(long l, ProcessInstance processInstance, int n, TransferMonitor transferMonitor) {
        this.fTransferSeqNumber = l;
        this.fSrcID = processInstance;
        this.fMonitor = transferMonitor;
        this.fResponses = new LabsResponseVector(n);
        this.fCmdWinOutput = "";
    }

    @Override
    public synchronized void handleOutput(String string, ProcessInstance processInstance) {
        if (processInstance.equals(this.fSrcID) && string != null) {
            this.fCmdWinOutput = this.fCmdWinOutput + string;
        }
    }

    @Override
    public synchronized void handleExecStatus(int n, ProcessInstance processInstance) {
        this.fResponses.receivedResponse(processInstance);
        switch (Matlab.getExecutionStatus((int)n)) {
            case 0: {
                break;
            }
            case 4: {
                this.fWasInterrupted = true;
                break;
            }
            default: {
                this.fFailed = true;
            }
        }
        if (this.fResponses.hasAllResponses()) {
            this.completed();
        }
    }

    private void completed() {
        if (this.fWasInterrupted) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Labs were interrupted during the transfer.");
            this.fMonitor.setOutsideLocalMError(TransferError.getLabsInterruptedError(this.fTransferSeqNumber));
        } else if (this.fFailed) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Labs completed transfer command earlier than expected.");
            this.fMonitor.setOutsideLocalMError(TransferError.getLabsUnexpectedError(this.fTransferSeqNumber, this.fSrcID, this.fCmdWinOutput));
        } else {
            this.fMonitor.setRemoteFinished();
        }
    }
}

