/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.spi.plugin;

import com.jcraft.jsch.ChannelDirectTCPIP;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.ForwardTunnelCommand;
import com.mathworks.toolbox.distcomp.remote.FulfillmentException;
import com.mathworks.toolbox.distcomp.remote.Logger;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ProtocolDispatchException;
import com.mathworks.toolbox.distcomp.remote.ProtocolFulfillmentException;
import com.mathworks.toolbox.distcomp.remote.RequestedPortException;
import com.mathworks.toolbox.distcomp.remote.TunnelFuture;
import com.mathworks.toolbox.distcomp.remote.spi.LeaseMonitor;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchLeasableSession;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchSessionLeaseSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

public final class JSchForwardTunnelFuture
implements TunnelFuture,
Runnable {
    private final Lock fLock = new ReentrantLock();
    private final Condition fCompleted = this.fLock.newCondition();
    private boolean fHasCompleted = false;
    private final Condition fConnected = this.fLock.newCondition();
    private boolean fHasConnected = false;
    private boolean fHasBeenCancelled = false;
    private FulfillmentException fCauseOfProblem = null;
    private final ForwardTunnelCommand fCommand;
    private final LeaseMonitor<JSchLeasableSession> fSessionMonitor;
    private final String fRemoteBindAddress;
    private final int fRemotePort;
    private final String fLogIDString;
    private final ServerSocket fServerSocket;
    private static final int SERVER_SOCKET_TIMEOUT = 100;

    static JSchForwardTunnelFuture createJSchForwardTunnelFuture(ForwardTunnelCommand forwardTunnelCommand, String string, ParameterMap parameterMap) throws DispatchException {
        String string2 = string + " " + forwardTunnelCommand + ": ";
        boolean bl = false;
        LeaseMonitor<JSchLeasableSession> leaseMonitor = null;
        try {
            leaseMonitor = JSchSessionLeaseSource.createForTunnelFuture(string, parameterMap);
            JSchForwardTunnelFuture jSchForwardTunnelFuture = new JSchForwardTunnelFuture(forwardTunnelCommand, leaseMonitor, parameterMap, string2);
            JSchForwardTunnelFuture.startThread(jSchForwardTunnelFuture, string2);
            bl = true;
            Logger.LOGGER.fine(string2 + ": started");
            JSchForwardTunnelFuture jSchForwardTunnelFuture2 = jSchForwardTunnelFuture;
            return jSchForwardTunnelFuture2;
        }
        catch (JSchException jSchException) {
            throw new ProtocolDispatchException(string2 + ": Could not create session", (Throwable)jSchException);
        }
        catch (IOException iOException) {
            throw new ProtocolDispatchException(string2 + ": Could not create server socket", (Throwable)iOException);
        }
        finally {
            if (!bl && leaseMonitor != null) {
                leaseMonitor.disconnectWithNoRelease();
            }
        }
    }

    private JSchForwardTunnelFuture(ForwardTunnelCommand forwardTunnelCommand, LeaseMonitor<JSchLeasableSession> leaseMonitor, ParameterMap parameterMap, String string) throws JSchException, DispatchException, IOException {
        this.fCommand = forwardTunnelCommand;
        this.fSessionMonitor = leaseMonitor;
        this.fLogIDString = string;
        String string2 = forwardTunnelCommand.getLocalHostBindAddress();
        int n = forwardTunnelCommand.getLocalHostPort();
        this.fRemoteBindAddress = forwardTunnelCommand.getRemoteHostBindAddress();
        this.fRemotePort = forwardTunnelCommand.getRemoteHostPort();
        InetAddress inetAddress = InetAddress.getByName(string2);
        this.fServerSocket = new ServerSocket(n, 0, inetAddress);
        this.fServerSocket.setSoTimeout(100);
        int n2 = this.fServerSocket.getLocalPort();
        if (n != n2) {
            throw new RequestedPortException(string, n, n2);
        }
    }

    private static void startThread(JSchForwardTunnelFuture jSchForwardTunnelFuture, String string) {
        Thread thread = new Thread((Runnable)jSchForwardTunnelFuture, string);
        thread.start();
        jSchForwardTunnelFuture.awaitConnected();
        Logger.LOGGER.finest(string + ": thread started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        this.fLock.lock();
        try {
            this.fHasBeenCancelled = true;
            this.fHasCompleted = false;
            this.fCompleted.signalAll();
            Logger.LOGGER.fine(this.fLogIDString + ": cancelled");
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRunning() {
        this.fLock.lock();
        try {
            boolean bl = !this.fHasCompleted;
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitEnd() throws InterruptedException, FulfillmentException {
        this.fLock.lockInterruptibly();
        try {
            if (!this.fHasCompleted) {
                Logger.LOGGER.finest(this.fLogIDString + ": awaitEnd await started");
                this.fCompleted.await();
                Logger.LOGGER.finest(this.fLogIDString + ": awaitEnd await done");
            }
            if (this.fCauseOfProblem != null) {
                throw this.fCauseOfProblem;
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean awaitConnected() {
        this.fLock.lockInterruptibly();
        try {
            if (!this.fHasConnected) {
                Logger.LOGGER.finest(this.fLogIDString + ": awaitConnected await started");
                this.fConnected.await();
                Logger.LOGGER.finest(this.fLogIDString + ": awaitConnected await completed");
            }
            boolean bl = true;
            this.fLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.fLock.unlock();
                throw throwable;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            try {
                try {
                    this.signalConnected();
                    this.loopAcceptTimeout();
                }
                catch (IOException iOException) {
                    this.handleException(iOException);
                }
                catch (JSchException jSchException) {
                    this.handleException((Exception)((Object)jSchException));
                }
                finally {
                    this.closeServerSocket();
                }
            }
            finally {
                this.fSessionMonitor.disconnectWithNoRelease();
            }
        }
        finally {
            this.signalCompleted();
        }
    }

    private void closeServerSocket() {
        try {
            this.fServerSocket.close();
        }
        catch (IOException iOException) {
            Logger.LOGGER.log(Level.WARNING, this.fLogIDString + ": problem while closing", iOException);
        }
    }

    private void loopAcceptTimeout() throws JSchException, IOException {
        while (!this.hasBeenCancelled() && this.fSessionMonitor.isConnected()) {
            try {
                this.acceptAndCreateChannel();
            }
            catch (SocketTimeoutException socketTimeoutException) {}
        }
    }

    private void acceptAndCreateChannel() throws IOException, JSchException {
        Socket socket = this.fServerSocket.accept();
        if (!this.hasBeenCancelled()) {
            socket.setTcpNoDelay(true);
            ChannelDirectTCPIP channelDirectTCPIP = this.createChannel(socket);
            channelDirectTCPIP.connect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalConnected() {
        Logger.LOGGER.fine(this.fLogIDString + ": connected");
        this.fLock.lock();
        try {
            this.fHasConnected = true;
            this.fConnected.signalAll();
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalCompleted() {
        this.fLock.lock();
        try {
            this.fHasCompleted = true;
            this.fConnected.signalAll();
            this.fCompleted.signalAll();
        }
        finally {
            this.fLock.unlock();
        }
    }

    private ChannelDirectTCPIP createChannel(Socket socket) throws IOException, JSchException {
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        Session session = this.fSessionMonitor.getLeasedConnection().getSession();
        ChannelDirectTCPIP channelDirectTCPIP = (ChannelDirectTCPIP)session.openChannel("direct-tcpip");
        channelDirectTCPIP.setInputStream(inputStream);
        channelDirectTCPIP.setOutputStream(outputStream);
        channelDirectTCPIP.setHost(this.fRemoteBindAddress);
        channelDirectTCPIP.setPort(this.fRemotePort);
        channelDirectTCPIP.setOrgIPAddress(socket.getInetAddress().getHostAddress());
        channelDirectTCPIP.setOrgPort(socket.getPort());
        return channelDirectTCPIP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasBeenCancelled() {
        this.fLock.lock();
        try {
            boolean bl = this.fHasBeenCancelled;
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleException(Exception exception) {
        exception.printStackTrace();
        Logger.LOGGER.log(Level.WARNING, this.fLogIDString + ": ", exception);
        this.fLock.lock();
        try {
            this.fCauseOfProblem = new ProtocolFulfillmentException(exception);
        }
        finally {
            this.fLock.unlock();
        }
    }
}

