/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.spi.plugin;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.mathworks.toolbox.distcomp.remote.FulfillmentException;
import com.mathworks.toolbox.distcomp.remote.Logger;
import com.mathworks.toolbox.distcomp.remote.ProtocolFulfillmentException;
import com.mathworks.toolbox.distcomp.remote.spi.Lease;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchLeasableSession;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

final class JSchFutureHelper {
    private final Lock fLock = new ReentrantLock();
    private final Condition fCompleted = this.fLock.newCondition();
    private boolean fHasCompleted = false;
    private final Condition fConnected = this.fLock.newCondition();
    private boolean fHasConnected = false;
    private boolean fHasBeenCancelled = false;
    private final Lease<JSchLeasableSession> fChannelLease;
    private Channel fChannel;
    private final String fLogIDString;
    private FulfillmentException fCauseOfProblem = null;

    static void startThread(Runnable runnable, String string) {
        Thread thread = new Thread(runnable, string);
        thread.start();
        Logger.LOGGER.finest(string + ": thread started");
    }

    JSchFutureHelper(Lease<JSchLeasableSession> lease, Channel channel, String string) {
        this.fLogIDString = string;
        this.fChannelLease = lease;
        this.fChannel = channel;
    }

    String getLogIDString() {
        return this.fLogIDString;
    }

    String getHostname() {
        return this.fChannelLease.getLeaseMonitor().getHostname();
    }

    Session getSession() {
        return this.fChannelLease.getLeasedConnection().getSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Channel getChannel() {
        this.fLock.lock();
        try {
            Channel channel = this.fChannel;
            return channel;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OutputStream getOutputStream() throws IOException {
        this.fLock.lock();
        try {
            OutputStream outputStream = this.fChannel.getOutputStream();
            return outputStream;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream getInputStream() throws IOException {
        this.fLock.lock();
        try {
            InputStream inputStream = this.fChannel.getInputStream();
            return inputStream;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel() {
        this.fLock.lock();
        try {
            this.fHasBeenCancelled = true;
            this.fHasCompleted = true;
            this.fCompleted.signalAll();
        }
        finally {
            this.fLock.unlock();
        }
        Logger.LOGGER.finer(this.fLogIDString + ": cancelled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isRunning() {
        this.fLock.lock();
        try {
            boolean bl = !this.fHasCompleted;
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void awaitEnd() throws InterruptedException, FulfillmentException {
        this.fLock.lockInterruptibly();
        try {
            if (!this.fHasCompleted) {
                Logger.LOGGER.finest(this.fLogIDString + ": waitFor await started");
                this.fCompleted.await();
                Logger.LOGGER.finest(this.fLogIDString + ": waitFor await done");
            }
            if (this.fCauseOfProblem != null) {
                throw this.fCauseOfProblem;
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    public boolean isExitStatusOfRemoteCommand() {
        return true;
    }

    public int getExitStatus() throws InterruptedException, FulfillmentException {
        this.awaitEnd();
        return this.fChannel.getExitStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean delayUntilConnected() {
        this.fLock.lockInterruptibly();
        try {
            if (!this.fHasConnected) {
                this.fConnected.await();
            }
            boolean bl = true;
            this.fLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.fLock.unlock();
                throw throwable;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForChannelToClose() throws InterruptedException {
        boolean bl = false;
        while (!bl) {
            this.fLock.lock();
            try {
                bl = this.fChannel.isClosed();
            }
            finally {
                this.fLock.unlock();
            }
            if (bl) continue;
            Thread.sleep(100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasBeenCancelled() {
        this.fLock.lock();
        try {
            boolean bl = this.fHasBeenCancelled;
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replaceCommandAndChannel(Channel channel) throws JSchException {
        this.fLock.lock();
        try {
            if (!this.fHasCompleted && !this.fHasBeenCancelled) {
                boolean bl = this.fHasConnected;
                this.disconnectFromChannel();
                this.fChannel = channel;
                if (bl) {
                    this.connectToChannel();
                }
                Logger.LOGGER.fine(this.fLogIDString + ": channel replaced.");
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectToChannel() throws JSchException {
        this.fLock.lock();
        try {
            this.fChannel.connect();
            this.fHasConnected = true;
            Logger.LOGGER.fine(this.fLogIDString + ": channel connected");
            this.fConnected.signalAll();
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleException(Exception exception) {
        Logger.LOGGER.log(Level.WARNING, this.fLogIDString + ": ", exception);
        this.fLock.lock();
        try {
            this.fCauseOfProblem = exception instanceof FulfillmentException ? (FulfillmentException)exception : new ProtocolFulfillmentException(exception);
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnectFromChannel() {
        this.fLock.lock();
        try {
            this.fChannel.disconnect();
            Logger.LOGGER.fine(this.fLogIDString + ": channel disconnected");
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseLease() {
        this.fLock.lock();
        try {
            this.fChannelLease.release();
            Logger.LOGGER.fine(this.fLogIDString + ": lease released");
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void signalCompleted() {
        this.fLock.lock();
        try {
            this.fHasCompleted = true;
            this.fConnected.signalAll();
            this.fCompleted.signalAll();
        }
        finally {
            this.fLock.unlock();
        }
        Logger.LOGGER.finer(this.fLogIDString + ": signalCompleted");
    }
}

