/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.spi.plugin;

import com.mathworks.toolbox.distcomp.remote.Command;
import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.Environment;
import com.mathworks.toolbox.distcomp.remote.Future;
import com.mathworks.toolbox.distcomp.remote.InvalidValueException;
import com.mathworks.toolbox.distcomp.remote.LocalProcessFailedException;
import com.mathworks.toolbox.distcomp.remote.Logger;
import com.mathworks.toolbox.distcomp.remote.Parameter;
import com.mathworks.toolbox.distcomp.remote.ParameterImpl;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ParameterNotAllowedException;
import com.mathworks.toolbox.distcomp.remote.ParameterSet;
import com.mathworks.toolbox.distcomp.remote.ProtocolDispatchException;
import com.mathworks.toolbox.distcomp.remote.RequiredParameterMissingException;
import com.mathworks.toolbox.distcomp.remote.ShellCommand;
import com.mathworks.toolbox.distcomp.remote.spi.ShellCommandSender;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.ProcessShellFuture;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.ShellParameter;
import com.mathworks.toolbox.distcomp.remote.util.NetworkInfo;
import com.mathworks.toolbox.distcomp.remote.util.PathUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public final class LocalShellSender
implements ShellCommandSender {
    private static final String PROTOCOL_NAME = "local-shell";
    private static final String PROTOCOL_TYPE = "local-shell";
    public static final ParameterSet LOCAL_PARAMETER_SET = new ParameterSet(LocalParameter.COMMAND, LocalParameter.FLAG, LocalParameter.DIRECTORY, ShellParameter.LOCAL_ENVIRONMENT);

    @Override
    public ParameterSet getParameterSet() {
        return LOCAL_PARAMETER_SET;
    }

    @Override
    public String getProtocolName() {
        return "local-shell";
    }

    @Override
    public String getProtocolType() {
        return "local-shell";
    }

    @Override
    public Class<? extends Command> getCommandClass() {
        return ShellCommand.class;
    }

    public ProcessShellFuture sendAndRun(ShellCommand shellCommand, ParameterMap parameterMap) throws ProtocolDispatchException, RequiredParameterMissingException, ParameterNotAllowedException, LocalProcessFailedException, InvalidValueException {
        Serializable serializable;
        List<String> list;
        String string;
        parameterMap.checkParameters(LOCAL_PARAMETER_SET);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = parameterMap.get(LocalParameter.COMMAND);
        if (string2 != null) {
            arrayList.add(string2);
        }
        if ((string = parameterMap.get(LocalParameter.FLAG)) != null) {
            arrayList.add(string);
        }
        if ((list = shellCommand.getCommand()).isEmpty()) {
            throw new ProtocolDispatchException("Command is empty");
        }
        arrayList.addAll(list);
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
        if (parameterMap.containsKey(LocalParameter.DIRECTORY)) {
            serializable = parameterMap.getOrSuggest(LocalParameter.DIRECTORY);
            processBuilder.directory((File)serializable);
            Logger.LOGGER.finest("LocalShellSender executing in " + serializable);
        }
        if ((serializable = parameterMap.get(ShellParameter.LOCAL_ENVIRONMENT)) != null) {
            if (((Environment)serializable).clearBeforeSetting()) {
                processBuilder.environment().clear();
            }
            for (String charSequence : ((Environment)serializable).keySet()) {
                processBuilder.environment().put(charSequence, ((Environment)serializable).get(charSequence));
            }
        }
        try {
            Process process = processBuilder.start();
            StringBuilder stringBuilder = new StringBuilder();
            for (String string3 : arrayList) {
                stringBuilder.append(string3);
                stringBuilder.append(" ");
            }
            ProcessShellFuture processShellFuture = new ProcessShellFuture(process, true, stringBuilder.toString(), "LocalShellSender");
            Logger.LOGGER.fine("LocalShellSender " + stringBuilder.toString() + " started");
            return processShellFuture;
        }
        catch (IOException iOException) {
            throw new LocalProcessFailedException("Could not start", iOException, arrayList);
        }
    }

    @Override
    public ProcessShellFuture sendAndRun(ShellCommand shellCommand, String string, ParameterMap parameterMap) throws ProtocolDispatchException, RequiredParameterMissingException, ParameterNotAllowedException, LocalProcessFailedException, InvalidValueException {
        this.checkHostname(string);
        return this.sendAndRun(shellCommand, parameterMap);
    }

    @Override
    public Future execute(Command command, String string, ParameterMap parameterMap) throws DispatchException {
        return this.sendAndRun((ShellCommand)command, string, parameterMap);
    }

    private void checkHostname(String string) throws ProtocolDispatchException {
        try {
            if (!LocalShellSender.privateIsLocalhost(string)) {
                throw new ProtocolDispatchException(string + " is not a loopback address and does not match any network device on this machine.");
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new ProtocolDispatchException("While checking if " + string + " is local.", (Throwable)unknownHostException);
        }
        catch (SocketException socketException) {
            throw new ProtocolDispatchException("While checking if " + string + " is local.", (Throwable)socketException);
        }
    }

    public static boolean isLocalhost(String string) throws SocketException {
        try {
            return LocalShellSender.privateIsLocalhost(string);
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    private static boolean privateIsLocalhost(String string) throws UnknownHostException, SocketException {
        return NetworkInfo.isHostnameLocal(string);
    }

    public static class LocalParameter<V>
    extends ParameterImpl<V> {
        public static final Parameter<String> COMMAND = PathUtils.Platform.getLocal().getPlatformType().isWindows() ? new LocalParameter<String>(Key.COMMAND, false, false, String.class, "cmd") : new LocalParameter<String>(Key.COMMAND, false, false, String.class, "sh");
        public static final Parameter<String> FLAG = PathUtils.Platform.getLocal().getPlatformType().isWindows() ? new LocalParameter<String>(Key.FLAG, false, false, String.class, "/c") : new LocalParameter<String>(Key.FLAG, false, false, String.class, "-c");
        public static final Parameter<File> DIRECTORY = new LocalParameter<File>((Parameter.PersistentKey)Key.DIRECTORY, false, false, File.class);

        private LocalParameter(Parameter.PersistentKey persistentKey, boolean bl, boolean bl2, Class<V> clazz, V v) {
            super(persistentKey, bl, bl2, clazz, v);
        }

        private LocalParameter(Parameter.PersistentKey persistentKey, boolean bl, boolean bl2, Class<V> clazz) {
            super(persistentKey, bl, bl2, clazz);
        }

        @Override
        protected String getSimpleName() {
            return LocalParameter.class.getSimpleName();
        }

        private static enum Key implements Parameter.PersistentKey
        {
            COMMAND,
            FLAG,
            DIRECTORY;

        }
    }
}

