/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.service;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.service.ExportConfigInfo;
import com.mathworks.toolbox.distcomp.service.Exporter;
import com.mathworks.toolbox.distcomp.service.PackageInfo;
import com.mathworks.toolbox.distcomp.service.RMISocketFactoryProvider;
import com.mathworks.toolbox.distcomp.util.concurrent.ReentrantLock;
import java.rmi.Remote;
import java.rmi.server.ExportException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.security.Security;
import java.util.concurrent.locks.Lock;

public abstract class DistcompExporter
implements Exporter {
    private static final Lock EXPORT_PORT_LOCK;
    protected static final int EXPORT_PORT_NOT_SET = -1;
    private final int fMinPort;
    private final int fMaxPort;
    private final RMISocketFactoryProvider fProvider;

    protected DistcompExporter(int n, int n2, RMISocketFactoryProvider rMISocketFactoryProvider) {
        this.fMinPort = n;
        this.fMaxPort = n2;
        this.fProvider = rMISocketFactoryProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Remote export(Remote remote) throws ExportException {
        Remote remote2;
        EXPORT_PORT_LOCK.lock();
        try {
            int n = this.getExportPort();
            if (n == -1) {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Exporting " + remote.getClass() + " on free port");
                remote2 = this.exportOnFreePort(remote);
            } else {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Exporting " + remote.getClass() + " on export port " + n);
                remote2 = this.exportOnPortAndRegister(remote, n, this.getRMIServerSocketFactory(), this.getRMIClientSocketFactory());
            }
        }
        finally {
            EXPORT_PORT_LOCK.unlock();
        }
        return remote2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unexport(boolean bl) {
        EXPORT_PORT_LOCK.lock();
        try {
            boolean bl2 = this.unexportImpl(bl);
            if (bl2) {
                this.unregisterExportPort();
            }
            boolean bl3 = bl2;
            return bl3;
        }
        finally {
            EXPORT_PORT_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getExportPort() {
        EXPORT_PORT_LOCK.lock();
        try {
            int n = ExportConfigInfo.getPort(this.fProvider, -1);
            return n;
        }
        finally {
            EXPORT_PORT_LOCK.unlock();
        }
    }

    @Override
    public boolean isExportSecure() {
        return this.fProvider.isSecure();
    }

    protected abstract Remote exportOnPort(Remote var1, int var2, RMIClientSocketFactory var3, RMIServerSocketFactory var4) throws ExportException;

    protected abstract boolean unexportImpl(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerExportPort(int n) {
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "DistcompExporter has successfully exported on " + n);
        EXPORT_PORT_LOCK.lock();
        try {
            ExportConfigInfo.register(this.fProvider, n);
        }
        finally {
            EXPORT_PORT_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterExportPort() {
        EXPORT_PORT_LOCK.lock();
        try {
            ExportConfigInfo.unregister(this.fProvider);
        }
        finally {
            EXPORT_PORT_LOCK.unlock();
        }
    }

    private Remote exportOnFreePort(Remote remote) throws ExportException {
        RMIServerSocketFactory rMIServerSocketFactory = this.getRMIServerSocketFactory();
        RMIClientSocketFactory rMIClientSocketFactory = this.getRMIClientSocketFactory();
        Remote remote2 = null;
        for (int i = this.fMinPort; i <= this.fMaxPort; ++i) {
            try {
                remote2 = this.exportOnPortAndRegister(remote, i, rMIServerSocketFactory, rMIClientSocketFactory);
                break;
            }
            catch (ExportException exportException) {
                if (i != this.fMaxPort) continue;
                throw new ExportException(this.getFailedToExportMessage(), exportException);
            }
        }
        return remote2;
    }

    private Remote exportOnPortAndRegister(Remote remote, int n, RMIServerSocketFactory rMIServerSocketFactory, RMIClientSocketFactory rMIClientSocketFactory) throws ExportException {
        Remote remote2 = this.exportOnPort(remote, n, rMIClientSocketFactory, rMIServerSocketFactory);
        this.registerExportPort(n);
        return remote2;
    }

    private String getFailedToExportMessage() {
        String string = "Failed to find a free port between %d and %d to export the object on.";
        String string2 = "Failed to export object on port %d.";
        if (this.fMinPort == this.fMaxPort) {
            return String.format(string2, this.fMinPort);
        }
        return String.format(string, this.fMinPort, this.fMaxPort);
    }

    private RMIClientSocketFactory getRMIClientSocketFactory() {
        return this.fProvider.getClientSocketFactory();
    }

    private RMIServerSocketFactory getRMIServerSocketFactory() {
        return this.fProvider.getServerSocketFactory();
    }

    static {
        if (Security.getProvider("Apple") != null) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Removing Apple security provider");
            Security.removeProvider("Apple");
        }
        EXPORT_PORT_LOCK = new ReentrantLock();
    }
}

