/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.service;

import com.mathworks.toolbox.distcomp.distcompobjects.DistcompException;
import com.mathworks.toolbox.distcomp.jobmanager.CachedJobManagerProxy;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerLocal;
import com.mathworks.toolbox.distcomp.mjs.peerlookupservice.PeerLookupAccessor;
import com.mathworks.toolbox.distcomp.service.MulticastServiceNotFoundException;
import com.mathworks.toolbox.distcomp.service.UnicastServiceNotFoundException;
import com.mathworks.toolbox.distcomp.service.UnresolvableLookupURLException;
import com.mathworks.toolbox.distcomp.util.Accessor;
import com.mathworks.toolbox.distcomp.util.AccessorException;
import com.mathworks.toolbox.distcomp.util.MulticastAccessor;
import com.mathworks.toolbox.distcomp.util.UnicastAccessor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public final class ServiceAccessor {
    private static AtomicReference<AccessorException> sStashedException = new AtomicReference();

    public static AccessorException getStashedException() {
        return sStashedException.get();
    }

    private static void resetStashedException() {
        sStashedException.set(null);
    }

    private static void stashFirstException(AccessorException accessorException) {
        sStashedException.compareAndSet(null, accessorException);
    }

    private ServiceAccessor() {
    }

    public static JobManagerLocal[] getJobManagers(String string, String string2) throws DistcompException, AccessorException {
        ServiceAccessor.resetStashedException();
        try {
            LookupServiceAccessorFactory lookupServiceAccessorFactory = new LookupServiceAccessorFactory(string);
            List<JobManagerLocal> list = CachedJobManagerProxy.create(string, string2, lookupServiceAccessorFactory);
            return list.toArray(new JobManagerLocal[list.size()]);
        }
        catch (AccessorException accessorException) {
            ServiceAccessor.stashFirstException(accessorException);
            throw accessorException;
        }
    }

    public static Object[] getMLWorkers(String string, String string2) throws DistcompException, AccessorException {
        ServiceAccessor.resetStashedException();
        try {
            Accessor accessor = new LookupServiceAccessorFactory(string).getAccessor();
            return accessor.getMLWorkers(string2);
        }
        catch (AccessorException accessorException) {
            ServiceAccessor.stashFirstException(accessorException);
            throw accessorException;
        }
    }

    private static class LookupServiceAccessorFactory
    implements AccessorFactory {
        private final String fUrl;

        private LookupServiceAccessorFactory(String string) {
            this.fUrl = string;
        }

        @Override
        public Accessor getAccessor() throws DistcompException, AccessorException {
            Accessor accessor = this.fUrl == null || this.fUrl.isEmpty() ? this.createMulticastAccessor() : (PeerLookupAccessor.isPeerLookupUrl(this.fUrl) ? this.createPeerLookupAccessor() : this.createUnicastAccessor());
            return accessor;
        }

        private Accessor createMulticastAccessor() throws DistcompException, AccessorException {
            MulticastAccessor multicastAccessor = new MulticastAccessor();
            if (!multicastAccessor.lookupServiceFound()) {
                throw new MulticastServiceNotFoundException();
            }
            return multicastAccessor;
        }

        private Accessor createPeerLookupAccessor() throws AccessorException {
            return new PeerLookupAccessor(this.fUrl);
        }

        private Accessor createUnicastAccessor() throws DistcompException, AccessorException {
            UnicastAccessor unicastAccessor = new UnicastAccessor(this.fUrl);
            if (!unicastAccessor.lookupServiceFound()) {
                throw LookupServiceAccessorFactory.createUnicastLookupServiceNotFoundException(this.fUrl);
            }
            return unicastAccessor;
        }

        private static AccessorException createUnicastLookupServiceNotFoundException(String string) {
            String string2 = string.replaceFirst(":[0-9]*$", "");
            try {
                InetAddress inetAddress = InetAddress.getByName(string2);
                String string3 = inetAddress.getHostAddress();
                String string4 = inetAddress.getCanonicalHostName();
                return new UnicastServiceNotFoundException(string, string2, string4, string3);
            }
            catch (UnknownHostException unknownHostException) {
                return new UnresolvableLookupURLException(string, string2, unknownHostException);
            }
        }
    }

    public static interface AccessorFactory {
        public Accessor getAccessor() throws DistcompException, AccessorException;
    }
}

