/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public final class ClickAwayFocusListener
implements FocusListener {
    private final JComponent fComponent;
    private final Runnable fCallback;
    private final AWTEventListener fListener;
    private boolean fCallbackCalled = false;

    public ClickAwayFocusListener(JComponent jComponent, Runnable runnable) {
        this.fComponent = jComponent;
        this.fCallback = runnable;
        this.fListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent aWTEvent) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                Point point = mouseEvent.getPoint();
                if (!aWTEvent.getSource().equals(ClickAwayFocusListener.this.fComponent)) {
                    point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), ClickAwayFocusListener.this.fComponent);
                }
                if ((mouseEvent.getID() == 500 || mouseEvent.getID() == 502) && ClickAwayFocusListener.this.fComponent.isFocusOwner() && !ClickAwayFocusListener.this.fComponent.contains(point)) {
                    ClickAwayFocusListener.this.doFocusLost();
                }
            }
        };
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.fCallbackCalled = false;
        Toolkit.getDefaultToolkit().addAWTEventListener(this.fListener, 16L);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.doFocusLost();
    }

    private void doFocusLost() {
        if (!this.fCallbackCalled) {
            this.fCallback.run();
            this.fCallbackCalled = true;
        }
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.fListener);
    }
}

