/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.profile;

import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.client.Client;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.distcomp.ui.BrowserLauncher;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuideEmptyPanel;
import com.mathworks.toolbox.distcomp.ui.profile.ActionProvider;
import com.mathworks.toolbox.distcomp.ui.profile.model.ProfileManager;
import com.mathworks.toolbox.distcomp.ui.profile.model.PropertyInfoProvider;
import com.mathworks.toolbox.distcomp.ui.resources.icons.ParallelIcon;
import com.mathworks.toolstrip.DefaultToolstrip;
import com.mathworks.toolstrip.DefaultToolstripTab;
import com.mathworks.toolstrip.Toolstrip;
import com.mathworks.toolstrip.components.ButtonOrientation;
import com.mathworks.toolstrip.components.PopupListener;
import com.mathworks.toolstrip.components.TSButton;
import com.mathworks.toolstrip.components.TSDropDownButton;
import com.mathworks.toolstrip.components.TSSplitButton;
import com.mathworks.toolstrip.components.popups.ListActionEvent;
import com.mathworks.toolstrip.components.popups.ListActionListener;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.ListStyle;
import com.mathworks.toolstrip.components.popups.PopupList;
import com.mathworks.toolstrip.plaf.TSLookAndFeel;
import com.mathworks.toolstrip.sections.ToolstripSections;
import com.mathworks.widgets.Dialogs;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;

public final class ProfileToolstripPanel
extends StyleGuideEmptyPanel {
    private ProfileManager fProfileManager;
    private ActionProvider fActionProvider;
    private DefaultToolstrip fToolstrip;
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_profile");
    private static final String MATHWORKS_SECTION = "MathWorks";
    private static final String THIRD_PARTY_SECTION = "ThirdParty";
    private static final String PRODUCT_URL_STRING = "http://www.mathworks.com/products/distriben";
    private static final String DISTCONFIG_URL_STRING = "http://www.mathworks.com/distconfig";
    public static final String WARN_MDCS_REQUIRED = "PCT_MDCSRequired";
    private static final String LOCAL_TYPE = "Local";
    private static final String DISCOVER_TRAILING_SPACE = "                       ";

    public ProfileToolstripPanel(ProfileManager profileManager, ActionProvider actionProvider) {
        this.fActionProvider = actionProvider;
        this.fProfileManager = profileManager;
        this.createToolstrip();
        JComponent jComponent = this.fToolstrip.getComponent();
        this.setMinimumSize(jComponent.getPreferredSize());
        this.addLine(jComponent, 8);
        this.fToolstrip.getComponent().setName("ProfileToolstrip");
    }

    private void createToolstrip() {
        DefaultToolstripTab defaultToolstripTab = new DefaultToolstripTab("profiles", sRes.getString("ProfileManager.Toolstrip.ProfileTab"));
        TSButton tSButton = this.createNewButton();
        TSButton tSButton2 = this.createImportButton();
        TSButton tSButton3 = this.createExportButton();
        TSButton tSButton4 = this.createValidateButton();
        TSButton tSButton5 = this.createEditButton();
        TSButton tSButton6 = this.createRenameButton();
        TSButton tSButton7 = this.createDuplicateButton();
        TSButton tSButton8 = this.createDeleteButton();
        TSButton tSButton9 = this.createSetDefaultButton();
        TSButton tSButton10 = this.createDiscoverClustersButton();
        defaultToolstripTab.getModel().add((Client)ToolstripSections.newSectionBuilder((String)"create", (String)sRes.getString("ProfileManager.Toolstrip.CreateSection")).add((JComponent)tSButton).separator().add((JComponent)tSButton10).separator().add((JComponent)tSButton2).build());
        defaultToolstripTab.getModel().add((Client)ToolstripSections.newSectionBuilder((String)"manage", (String)sRes.getString("ProfileManager.Toolstrip.ManageSection")).add((JComponent)tSButton5).separator().add((JComponent)tSButton7).add((JComponent)tSButton8).separator().add((JComponent)tSButton6).add((JComponent)tSButton9).separator().add((JComponent)tSButton3).build());
        defaultToolstripTab.getModel().add((Client)ToolstripSections.newSectionBuilder((String)"validate", (String)sRes.getString("ProfileManager.Toolstrip.ValidateSection")).add((JComponent)tSButton4).build());
        TSButton tSButton11 = ProfileToolstripPanel.createHelpButton();
        defaultToolstripTab.getModel().add((Client)ToolstripSections.newSectionBuilder((String)"help", (String)sRes.getString("ProfileManager.Toolstrip.HelpSection")).add((JComponent)tSButton11).build());
        this.fToolstrip = new DefaultToolstrip();
        this.fToolstrip.setAttribute((Attribute)Toolstrip.COLLAPSABLE, (Object)false);
        this.fToolstrip.setAttribute((Attribute)Toolstrip.NO_TABS, (Object)true);
        this.fToolstrip.getModel().add((Client)defaultToolstripTab);
        this.fToolstrip.setCurrentTab(defaultToolstripTab.getName());
        tSButton.setName("NewButton");
        tSButton2.setName("ImportButton");
        tSButton3.setName("ExportButton");
        tSButton7.setName("DuplicateButton");
        tSButton8.setName("DeleteButton");
        tSButton6.setName("RenameButton");
        tSButton4.setName("ValidateButton");
        tSButton9.setName("SetDefaultButton");
        tSButton11.setName("HelpButton");
        tSButton5.setName("EditButton");
        tSButton10.setName("DiscoverClustersButton");
    }

    private static TSButton createHelpButton() {
        TSButton tSButton = new TSButton((Action)ActionProvider.createHelpAction());
        tSButton.setOrientation(ButtonOrientation.VERTICAL);
        return tSButton;
    }

    private TSButton createExportButton() {
        TSSplitButton tSSplitButton = new TSSplitButton((Action)this.fActionProvider.createExportAction((Component)((Object)this)));
        tSSplitButton.setOrientation(ButtonOrientation.VERTICAL);
        tSSplitButton.setIcon(ParallelIcon.EXPORT.getIcon());
        final JComponent jComponent = this.createExportMenu();
        tSSplitButton.setPopupListener(new PopupListener(){

            public void onPopupEvent(JComponent jComponent2, PopupListener.PopupCallback popupCallback) {
                popupCallback.show(jComponent);
            }
        });
        return tSSplitButton;
    }

    private JComponent createExportMenu() {
        final MJAbstractAction mJAbstractAction = this.fActionProvider.createExportAction((Component)((Object)this));
        final MJAbstractAction mJAbstractAction2 = this.fActionProvider.createExportAllAction((JComponent)((Object)this));
        DefaultListModel<ListItem> defaultListModel = new DefaultListModel<ListItem>();
        final ListItem listItem = ListItem.newItem((String)mJAbstractAction.getName(), (String)mJAbstractAction.getName());
        final ListItem listItem2 = ListItem.newItem((String)mJAbstractAction2.getName(), (String)mJAbstractAction2.getName());
        defaultListModel.addElement(listItem);
        defaultListModel.addElement(listItem2);
        PopupList popupList = new PopupList(defaultListModel);
        popupList.addListActionListener(new ListActionListener(){

            public void listItemSelected(ListActionEvent listActionEvent) {
                if (listActionEvent.getListItem().equals((Object)listItem)) {
                    mJAbstractAction.actionPerformed(null);
                } else if (listActionEvent.getListItem().equals((Object)listItem2)) {
                    mJAbstractAction2.actionPerformed(null);
                } else assert (false) : "Unknown item";
            }
        });
        popupList.setListStyle(ListStyle.TEXT_ONLY);
        popupList.setName("ExportPopupList");
        return popupList;
    }

    private TSButton createSetDefaultButton() {
        TSButton tSButton = new TSButton((Action)this.fActionProvider.createSetDefaultProfile());
        tSButton.setIcon(ParallelIcon.SET_DEFAULT_PROFILE.getIcon());
        return tSButton;
    }

    private TSButton createDeleteButton() {
        TSButton tSButton = new TSButton((Action)this.fActionProvider.getDeleteAction());
        tSButton.setIcon(ParallelIcon.DELETE.getIcon());
        return tSButton;
    }

    private TSButton createRenameButton() {
        TSButton tSButton = new TSButton((Action)this.fActionProvider.createRename());
        tSButton.setIcon(ParallelIcon.RENAME.getIcon());
        return tSButton;
    }

    private TSButton createDuplicateButton() {
        TSButton tSButton = new TSButton((Action)this.fActionProvider.getDuplicateAction());
        tSButton.setIcon(ParallelIcon.DUPLICATE.getIcon());
        return tSButton;
    }

    private TSButton createValidateButton() {
        TSButton tSButton = new TSButton((Action)this.fActionProvider.createValidate());
        tSButton.setOrientation(ButtonOrientation.VERTICAL);
        tSButton.setIcon(ParallelIcon.VALIDATE_PROFILE.getIcon());
        return tSButton;
    }

    private TSButton createImportButton() {
        TSButton tSButton = new TSButton((Action)this.fActionProvider.createImport((Component)((Object)this)));
        tSButton.setOrientation(ButtonOrientation.VERTICAL);
        tSButton.setIcon(ParallelIcon.IMPORT.getIcon());
        return tSButton;
    }

    private TSButton createNewButton() {
        TSDropDownButton tSDropDownButton = new TSDropDownButton(sRes.getString("ProfileManager.Toolstrip.AddAction"), ParallelIcon.NEW.getIcon());
        tSDropDownButton.setOrientation(ButtonOrientation.VERTICAL);
        tSDropDownButton.setPopupListener(new PopupListener(){

            public void onPopupEvent(JComponent jComponent, PopupListener.PopupCallback popupCallback) {
                JComponent jComponent2 = ProfileToolstripPanel.this.createPopupMenuForSimpleView();
                popupCallback.show(jComponent2);
            }
        });
        return tSDropDownButton;
    }

    private TSButton createEditButton() {
        TSButton tSButton = new TSButton((Action)this.fActionProvider.createEdit());
        tSButton.setIcon(ParallelIcon.EDIT.getIcon());
        tSButton.setOrientation(ButtonOrientation.VERTICAL);
        return tSButton;
    }

    private TSButton createDiscoverClustersButton() {
        TSButton tSButton = new TSButton((Action)this.fActionProvider.createDiscoverCluster());
        tSButton.setIcon(ParallelIcon.DISCOVER_CLUSTER.getIcon());
        tSButton.setOrientation(ButtonOrientation.VERTICAL);
        tSButton.setToolTipText(sRes.getString("DiscoverCluster.Title"));
        return tSButton;
    }

    private JComponent createPopupMenuForSimpleView() {
        DefaultListModel<ListItem> defaultListModel = new DefaultListModel<ListItem>();
        final ListItem listItem = ListItem.newItem((String)"DiscoverClusters", (String)sRes.getString("DiscoverCluster.Title"), (String)(sRes.getString("DiscoverCluster.Description") + DISCOVER_TRAILING_SPACE), null);
        listItem.setAttribute((Attribute)ListItem.STYLE, (Object)ListStyle.ICON_TEXT_DESCRIPTION);
        defaultListModel.addElement(listItem);
        ListItem listItem2 = ListItem.newItem((String)"ImportProfiles", (String)sRes.getString("ProfileManager.Toolstrip.ImportAction"), (String)sRes.getString("ProfileManager.Toolstrip.ImportAction.Description"), null);
        listItem2.setAttribute((Attribute)ListItem.STYLE, (Object)ListStyle.SINGLE_LINE_DESCRIPTION);
        defaultListModel.addElement(listItem2);
        PopupList popupList = this.createNewProfileSubMenu();
        ListItem listItem3 = ListItem.newSubList((String)"ManualCreateProfile", (String)sRes.getString("ProfileManager.Toolstrip.CustomSubMenu"), null, (PopupList)popupList);
        listItem3.getAttributes().setAttribute((Attribute)ListItem.DESCRIPTION, (Object)sRes.getString("ProfileManager.Toolstrip.CustomSubMenu.Description"));
        listItem3.setAttribute((Attribute)ListItem.STYLE, (Object)ListStyle.SINGLE_LINE_DESCRIPTION);
        defaultListModel.addElement(listItem3);
        MJAbstractAction mJAbstractAction = this.fActionProvider.createDiscoverCluster();
        MJAbstractAction mJAbstractAction2 = this.fActionProvider.createImport((Component)((Object)this));
        PopupList popupList2 = new PopupList(defaultListModel);
        popupList2.addListActionListener(new ListActionListener((AbstractAction)mJAbstractAction, listItem2, (AbstractAction)mJAbstractAction2){
            final /* synthetic */ AbstractAction val$discoverClusterAction;
            final /* synthetic */ ListItem val$importProfileItem;
            final /* synthetic */ AbstractAction val$importProfileAction;
            {
                this.val$discoverClusterAction = abstractAction;
                this.val$importProfileItem = listItem2;
                this.val$importProfileAction = abstractAction2;
            }

            public void listItemSelected(ListActionEvent listActionEvent) {
                if (listActionEvent.getListItem().equals((Object)listItem)) {
                    this.val$discoverClusterAction.actionPerformed(null);
                } else if (listActionEvent.getListItem().equals((Object)this.val$importProfileItem)) {
                    this.val$importProfileAction.actionPerformed(null);
                }
            }
        });
        popupList2.setName("NewPopupList");
        return popupList2;
    }

    private PopupList createNewProfileSubMenu() {
        String string;
        String string2;
        DefaultListModel<ListItem> defaultListModel = new DefaultListModel<ListItem>();
        ListItem listItem = ListItem.newHeader((String)sRes.getString("ProfileManager.Toolstrip.MathWorksProfileSection"));
        defaultListModel.addElement(listItem);
        List<String> list = PropertyInfoProvider.getInstance().getSchedulerTypes();
        for (String object2 : list) {
            String string3 = sRes.getString(object2 + ".Section");
            string2 = sRes.getString(object2 + ".Title");
            string = sRes.getString(object2 + ".Description");
            boolean bl = Boolean.valueOf(sRes.getString(object2 + ".Hidden"));
            if (!string3.equals(MATHWORKS_SECTION) || bl) continue;
            ListItem bl2 = string.isEmpty() ? ListItem.newItem((String)object2, (String)string2) : ListItem.newItem((String)object2, (String)string2, (String)string, null);
            bl2.getAttributes().setAttribute((Attribute)ListItem.STYLE, (Object)ListStyle.SINGLE_LINE_DESCRIPTION);
            defaultListModel.addElement(bl2);
        }
        ListItem listItem3 = ListItem.newHeader((String)sRes.getString("ProfileManager.Toolstrip.ThirdPartyProfileSection"));
        defaultListModel.addElement(listItem3);
        for (String string3 : list) {
            string2 = sRes.getString(string3 + ".Section");
            string = sRes.getString(string3 + ".Title");
            String string4 = sRes.getString(string3 + ".Description");
            boolean bl = Boolean.valueOf(sRes.getString(string3 + ".Hidden"));
            if (!string2.equals(THIRD_PARTY_SECTION) || bl) continue;
            ListItem listItem2 = string4.isEmpty() ? ListItem.newItem((String)string3, (String)string) : ListItem.newItem((String)string3, (String)string, (String)string4, null);
            listItem2.getAttributes().setAttribute((Attribute)ListItem.STYLE, (Object)ListStyle.TEXT_ONLY);
            defaultListModel.addElement(listItem2);
        }
        PopupList popupList = new PopupList(defaultListModel);
        popupList.addListActionListener(new ListActionListener(){

            public void listItemSelected(ListActionEvent listActionEvent) {
                final String string = listActionEvent.getListItem().getName();
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ProfileToolstripPanel.this.showMDCSRequiredDialog(string);
                        ProfileToolstripPanel.this.fProfileManager.addProfile(string);
                    }
                });
            }
        });
        popupList.setName("CustomProfilePopupList");
        return popupList;
    }

    private void showMDCSRequiredDialog(String string) {
        if (string.equals(LOCAL_TYPE)) {
            return;
        }
        String string2 = MessageFormat.format(sRes.getString("ProfileManager.Toolstrip.NeedMDCSInstalled.Message"), PRODUCT_URL_STRING, DISTCONFIG_URL_STRING);
        HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel(string2, new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                try {
                    BrowserLauncher.launchURL(null, new URL(string));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        });
        Dialogs.showOptionalMessageDialog((Component)this.getParent(), (Object)hyperlinkTextLabel.getComponent(), (String)sRes.getString("ProfileManager.Toolstrip.NeedMDCSInstalled.Title"), (int)2, (String)WARN_MDCS_REQUIRED, (boolean)true);
    }

    static {
        TSLookAndFeel.install();
    }
}

