/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import com.mathworks.toolbox.distcomp.auth.credentials.consumer.ConsumerCreationException;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.CredentialConsumer;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.CredentialConsumerConfig;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.CredentialConsumerFactory;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.GraphicalCredentialConsumer;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.NoCredentialsEnteredException;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.TextualCredentialConsumer;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.AuthModelResourceMessenger;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.AuthorizationModel;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.AuthorizationModelFactory;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.InputCreator;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.InputField;
import com.mathworks.toolbox.distcomp.util.ResourceBundleUtilities;
import java.io.Console;
import java.io.OutputStream;
import javax.swing.JFrame;

final class AdminCredentialConsumerFactory
extends CredentialConsumerFactory {
    private final boolean fGraphical;
    private final JFrame fParent;

    AdminCredentialConsumerFactory(boolean bl, JFrame jFrame) {
        this.fGraphical = bl;
        this.fParent = jFrame;
    }

    @Override
    public AdminCredentialConsumerFactory copy() {
        return new AdminCredentialConsumerFactory(this.fGraphical, this.fParent);
    }

    @Override
    public CredentialConsumer create(CredentialConsumerConfig credentialConsumerConfig) throws ConsumerCreationException {
        AdminAuthorizationModelFactory adminAuthorizationModelFactory = new AdminAuthorizationModelFactory(credentialConsumerConfig);
        return this.fGraphical ? new GraphicalCredentialConsumer(this.fParent, credentialConsumerConfig, adminAuthorizationModelFactory) : new TextualCredentialConsumer(new ShellPrompt(), credentialConsumerConfig, adminAuthorizationModelFactory);
    }

    @Override
    public boolean getGraphical() {
        return this.fGraphical;
    }

    @Override
    public void setGraphical(boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isInteractive() {
        return true;
    }

    @Override
    public void setInteractive(boolean bl) {
        throw new UnsupportedOperationException();
    }

    private static class AdminAuthorizationModelFactory
    extends AuthorizationModelFactory {
        private static final ResourceBundleUtilities.ResourceBundleMessenger ADD_ADMIN_USER_NEW_PASSWORD = new LocalMessenger("AddAdminUser.NEW_PASSWORD", new Object[0]);
        private static final ResourceBundleUtilities.ResourceBundleMessenger ADD_ADMIN_USER_CONFIRM_NEW = new LocalMessenger("AddAdminUser.CONFIRM_NEW", new Object[0]);
        private static final String KEY_ADD_ADMIN_USER_BLURB = "AddAdminUser.BLURB";

        AdminAuthorizationModelFactory(CredentialConsumerConfig credentialConsumerConfig) {
            super(credentialConsumerConfig);
        }

        @Override
        public AuthorizationModel createModel(AuthorizationModelFactory.ModelSpec modelSpec) {
            String string = KEY_ADD_ADMIN_USER_BLURB;
            InputCreator[] inputCreatorArray = new InputCreator[]{new InputCreator(InputField.NEW_PASSWORD, ADD_ADMIN_USER_NEW_PASSWORD), new InputCreator(InputField.CONFIRM_NEW, ADD_ADMIN_USER_CONFIRM_NEW)};
            return new AuthorizationModel(this, new LocalMessenger(KEY_ADD_ADMIN_USER_BLURB, this.getTargetUsername(), this.getConfig().getJobManagerName(), this.getConfig().getJobManagerHostname()), this.getConfig().getAllowClientPasswordCache(), inputCreatorArray);
        }

        private static final class LocalMessenger
        extends AuthModelResourceMessenger {
            public LocalMessenger(Object object, Object ... objectArray) {
                super(object, objectArray);
            }
        }
    }

    private static class ShellPrompt
    implements TextualCredentialConsumer.Prompt {
        private ShellPrompt() {
        }

        @Override
        public OutputStream getOutputStream() {
            return System.out;
        }

        @Override
        public OutputStream getErrorStream() {
            return System.err;
        }

        @Override
        public char[] prompt(String string, boolean bl) throws NoCredentialsEnteredException {
            Console console = System.console();
            if (console == null) {
                throw new NoCredentialsEnteredException(null, (Throwable)new NullPointerException("System.console is not available."));
            }
            if (bl) {
                return console.readPassword(string, new Object[0]);
            }
            return console.readLine(string, new Object[0]).toCharArray();
        }
    }
}

