/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import com.mathworks.toolbox.distcomp.util.Executor;
import java.util.concurrent.Semaphore;

public class LimitedQueueExecutor
implements Executor {
    private final Executor fExecutor;
    private final Semaphore fExecutePermission;

    public LimitedQueueExecutor(Executor executor, int n) {
        assert (executor != null) : "Executor must not be null.";
        assert (n > 0) : "Max number of pending/running must be > 0.";
        this.fExecutor = executor;
        this.fExecutePermission = new Semaphore(n, true);
    }

    @Override
    public void execute(final Runnable runnable) throws Executor.ExecutorDestroyedException {
        assert (runnable != null) : "Runnables should not be null.";
        this.fExecutePermission.acquireUninterruptibly();
        try {
            this.fExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        runnable.run();
                    }
                    finally {
                        LimitedQueueExecutor.this.fExecutePermission.release();
                    }
                }
            });
        }
        catch (Executor.ExecutorDestroyedException executorDestroyedException) {
            this.fExecutePermission.release();
            throw executorDestroyedException;
        }
    }

    @Override
    public void destroy() {
        this.fExecutor.destroy();
    }
}

