/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.wsclients.entitlements;

import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.mlwebservices.WSEndPoints;
import com.mathworks.mlwebservices.ws_client_core.DefaultMathWorksWebServiceClientConfigurator;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.wsclients.ClientErrorException;
import com.mathworks.toolbox.distcomp.wsclients.Log;
import com.mathworks.toolbox.distcomp.wsclients.ServiceErrorPassThroughException;
import com.mathworks.toolbox.distcomp.wsclients.WSAuthenticationFailureException;
import com.mathworks.toolbox.distcomp.wsclients.WSProxyAuthenticationRequiredException;
import com.mathworks.toolbox.distcomp.wsclients.WSServiceNotFoundException;
import com.mathworks.toolbox.distcomp.wsclients.WSServiceUnavailableException;
import com.mathworks.toolbox.distcomp.wsclients.WSUnknownHostException;
import com.mathworks.toolbox.distcomp.wsclients.WebServiceException;
import com.mathworks.webservices.client.core.MathWorksClientException;
import com.mathworks.webservices.client.core.MathWorksServiceException;
import com.mathworks.webservices.client.core.MathWorksWebServiceClient;
import com.mathworks.webservices.client.core.ProxyAuthenticationRequiredException;
import com.mathworks.webservices.client.core.ServiceNotFoundException;
import com.mathworks.webservices.client.core.ServiceUnavailableException;
import com.mathworks.webservices.mls.MathWorksLicenseServerClient;
import com.mathworks.webservices.mls.MathWorksLicenseServerClientImpl;
import com.mathworks.webservices.mls.model.DescribeEntitlementsRequest;
import com.mathworks.webservices.mls.model.DescribeEntitlementsResponse;
import com.mathworks.webservices.mls.model.Entitlement;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Locale;

public class MDCSEntitlementRetriever {
    private final MathWorksLicenseServerClient fClient;
    private static final String CLIENT_STRING_PREFIX = "MDPCT";
    private static WebServiceException sStashedException = null;
    private static String sEndPoint = WSEndPoints.getMWLicServerEndPoint();

    public MDCSEntitlementRetriever() {
        DefaultMathWorksWebServiceClientConfigurator defaultMathWorksWebServiceClientConfigurator = new DefaultMathWorksWebServiceClientConfigurator(sEndPoint);
        MathWorksLicenseServerClientImpl mathWorksLicenseServerClientImpl = new MathWorksLicenseServerClientImpl();
        defaultMathWorksWebServiceClientConfigurator.configureClient((MathWorksWebServiceClient)mathWorksLicenseServerClientImpl);
        this.fClient = mathWorksLicenseServerClientImpl;
    }

    public MDCSEntitlementRetriever(MathWorksLicenseServerClient mathWorksLicenseServerClient) {
        this.fClient = mathWorksLicenseServerClient;
    }

    public Entitlement[] getEntitlements(String string) throws WebServiceException {
        try {
            MDCSEntitlementRetriever.clearStashedException();
            String string2 = InstutilResourceKeys.RELEASE.getString(new Object[0]);
            ArrayList<String> arrayList = new ArrayList<String>(1);
            arrayList.add("DW");
            DescribeEntitlementsRequest describeEntitlementsRequest = new DescribeEntitlementsRequest();
            describeEntitlementsRequest.setToken(string);
            describeEntitlementsRequest.setRelease(string2);
            describeEntitlementsRequest.setCoreProducts(arrayList);
            describeEntitlementsRequest.setLocale(Locale.US.toString());
            describeEntitlementsRequest.setClientString("MDPCT-" + string2);
            DescribeEntitlementsResponse describeEntitlementsResponse = this.fClient.describeEntitlements(describeEntitlementsRequest);
            return describeEntitlementsResponse.getEntitlements().toArray(new Entitlement[describeEntitlementsResponse.getEntitlements().size()]);
        }
        catch (ServiceUnavailableException serviceUnavailableException) {
            WSServiceUnavailableException wSServiceUnavailableException = new WSServiceUnavailableException(serviceUnavailableException);
            MDCSEntitlementRetriever.stashFirstException(wSServiceUnavailableException);
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to retrieve entitlements from web services because it was unavailable", serviceUnavailableException);
            throw wSServiceUnavailableException;
        }
        catch (MathWorksServiceException mathWorksServiceException) {
            int n = mathWorksServiceException.getStatusCode();
            if (n == 401) {
                WSAuthenticationFailureException wSAuthenticationFailureException = new WSAuthenticationFailureException(mathWorksServiceException);
                String string3 = String.format("Failed to retrieve entitlements from web services due to an authentication failure.Status code %d, Error code: %s", mathWorksServiceException.getStatusCode(), mathWorksServiceException.getErrorCode());
                Log.LOGGER.log(DistcompLevel.TWO, string3, mathWorksServiceException);
                MDCSEntitlementRetriever.stashFirstException(wSAuthenticationFailureException);
                throw wSAuthenticationFailureException;
            }
            String string4 = String.format("Failed to retrieve entitlements from web services. Status code: %d, Error code: %s", mathWorksServiceException.getStatusCode(), mathWorksServiceException.getErrorCode());
            Log.LOGGER.log(DistcompLevel.ONE, string4, mathWorksServiceException);
            ServiceErrorPassThroughException serviceErrorPassThroughException = new ServiceErrorPassThroughException(mathWorksServiceException);
            MDCSEntitlementRetriever.stashFirstException(serviceErrorPassThroughException);
            throw serviceErrorPassThroughException;
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            WSServiceNotFoundException wSServiceNotFoundException = new WSServiceNotFoundException(serviceNotFoundException);
            MDCSEntitlementRetriever.stashFirstException(wSServiceNotFoundException);
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to retrieve entitlements from web services because the web service could not be found.", serviceNotFoundException);
            throw wSServiceNotFoundException;
        }
        catch (ProxyAuthenticationRequiredException proxyAuthenticationRequiredException) {
            WSProxyAuthenticationRequiredException wSProxyAuthenticationRequiredException = new WSProxyAuthenticationRequiredException(proxyAuthenticationRequiredException);
            MDCSEntitlementRetriever.stashFirstException(wSProxyAuthenticationRequiredException);
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to retrieve entitlements from web services because of a proxy authentication failure", proxyAuthenticationRequiredException);
            throw wSProxyAuthenticationRequiredException;
        }
        catch (MathWorksClientException mathWorksClientException) {
            if (mathWorksClientException.getCause() instanceof UnknownHostException) {
                UnknownHostException unknownHostException = (UnknownHostException)mathWorksClientException.getCause();
                WSUnknownHostException wSUnknownHostException = new WSUnknownHostException(mathWorksClientException, unknownHostException.getMessage());
                MDCSEntitlementRetriever.stashFirstException(wSUnknownHostException);
                Log.LOGGER.log(DistcompLevel.ONE, "Unable to connect to MathWorks web services.", mathWorksClientException);
                throw wSUnknownHostException;
            }
            ClientErrorException clientErrorException = new ClientErrorException(mathWorksClientException);
            MDCSEntitlementRetriever.stashFirstException(clientErrorException);
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to retrieve entitlements from web services because of a client error.", mathWorksClientException);
            throw clientErrorException;
        }
    }

    private static void stashFirstException(WebServiceException webServiceException) {
        sStashedException = webServiceException;
    }

    private static void clearStashedException() {
        sStashedException = null;
    }

    public static WebServiceException getStashedException() {
        return sStashedException;
    }
}

