/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.ssl;

import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.jeri.Endpoint;
import net.jini.jeri.connection.OutboundRequestHandle;
import net.jini.jeri.ssl.SslEndpointImpl;
import net.jini.jeri.ssl.Utilities;

class CallContext
extends Utilities
implements OutboundRequestHandle {
    final Endpoint endpoint;
    final SslEndpointImpl endpointImpl;
    final Subject clientSubject;
    final boolean clientAuthRequired;
    final Set clientPrincipals;
    final Set serverPrincipals;
    final String[] cipherSuites;
    final boolean integrityRequired;
    final boolean integrityPreferred;
    final long connectionTime;

    static CallContext coerce(OutboundRequestHandle outboundRequestHandle, Endpoint endpoint) {
        if (outboundRequestHandle == null) {
            throw new NullPointerException("Handle cannot be null");
        }
        if (!(outboundRequestHandle instanceof CallContext)) {
            throw new IllegalArgumentException("Handle must be of type CallContext: " + outboundRequestHandle);
        }
        CallContext callContext = (CallContext)outboundRequestHandle;
        if (!endpoint.equals(callContext.endpoint)) {
            throw new IllegalArgumentException("Handle has wrong endpoint -- was " + callContext.endpoint + ", should be " + endpoint);
        }
        return callContext;
    }

    CallContext(Endpoint endpoint, SslEndpointImpl sslEndpointImpl, Subject subject, boolean bl, Set set, Set set2, List list, boolean bl2, boolean bl3, long l) {
        this.endpoint = endpoint;
        this.endpointImpl = sslEndpointImpl;
        this.clientSubject = subject;
        this.clientAuthRequired = bl;
        this.clientPrincipals = set;
        this.serverPrincipals = set2;
        this.cipherSuites = list.toArray(new String[list.size()]);
        this.integrityRequired = bl2;
        this.integrityPreferred = bl3;
        this.connectionTime = l;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("CallContext[");
        stringBuffer.append("\n  ").append(this.endpoint);
        stringBuffer.append("\n  clientSubject=");
        if (this.clientSubject == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append("Subject@");
            stringBuffer.append(Integer.toHexString(System.identityHashCode(this.clientSubject)));
        }
        stringBuffer.append("\n  clientAuthRequired=").append(this.clientAuthRequired);
        stringBuffer.append("\n  clientPrincipals=").append(this.clientPrincipals);
        stringBuffer.append("\n  serverPrincipals=").append(this.serverPrincipals);
        stringBuffer.append("\n  cipherSuites=").append(CallContext.toString(this.cipherSuites));
        if (this.integrityRequired) {
            stringBuffer.append("\n  integrity=required");
        } else if (this.integrityPreferred) {
            stringBuffer.append("\n  integrity=preferred");
        }
        if (this.connectionTime != Long.MAX_VALUE) {
            stringBuffer.append("\n  connectionTime=").append(this.connectionTime);
        }
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }

    InvocationConstraints getUnfulfilledConstraints() {
        if (this.integrityRequired) {
            return INTEGRITY_REQUIRED;
        }
        if (this.integrityPreferred) {
            return INTEGRITY_PREFERRED;
        }
        return InvocationConstraints.EMPTY;
    }
}

