/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.system;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;

public abstract class CommandLine {
    public static String parseString(String string, String string2) {
        return string != null ? string : string2;
    }

    public static int parseInt(String string, int n) throws NumberFormatException {
        if (string == null) {
            return n;
        }
        if (string.startsWith("0x")) {
            return Integer.parseInt(string.substring(2), 16);
        }
        if (string.startsWith("#")) {
            return Integer.parseInt(string.substring(1), 16);
        }
        if (string.startsWith("0")) {
            return Integer.parseInt(string.substring(1), 8);
        }
        return Integer.parseInt(string);
    }

    public static long parseLong(String string, long l) throws NumberFormatException {
        if (string == null) {
            return l;
        }
        if (string.startsWith("0x")) {
            return Long.parseLong(string.substring(2), 16);
        }
        if (string.startsWith("#")) {
            return Long.parseLong(string.substring(1), 16);
        }
        if (string.startsWith("0")) {
            return Long.parseLong(string.substring(1), 8);
        }
        return Long.parseLong(string);
    }

    public static double parseDouble(String string, double d) throws NumberFormatException {
        if (string == null) {
            return d;
        }
        return new Double(string);
    }

    public static Writer parseWriter(String string, Writer writer) throws IOException {
        if (string == null) {
            return writer;
        }
        if (string.equals("-")) {
            return new OutputStreamWriter(System.out);
        }
        return new FileWriter(string);
    }

    public static Writer parseWriter(String string, String string2) throws IOException {
        if (string == null) {
            string = string2;
        }
        if (string.equals("-")) {
            return new OutputStreamWriter(System.out);
        }
        return new FileWriter(string);
    }

    public static Reader parseReader(String string, Reader reader) throws IOException {
        if (string == null) {
            return reader;
        }
        if (string.equals("-")) {
            return new InputStreamReader(System.in);
        }
        return new FileReader(string);
    }

    public static Reader parseReader(String string, String string2) throws IOException {
        if (string == null) {
            string = string2;
        }
        if (string.equals("-")) {
            return new InputStreamReader(System.in);
        }
        return new FileReader(string);
    }

    public static OutputStream parseOutputStream(String string, OutputStream outputStream) throws IOException {
        if (string == null) {
            return outputStream;
        }
        if (string.equals("-")) {
            return System.out;
        }
        return new FileOutputStream(string);
    }

    public static OutputStream parseOutputStream(String string, String string2) throws IOException {
        if (string == null) {
            string = string2;
        }
        if (string.equals("-")) {
            return System.out;
        }
        return new FileOutputStream(string);
    }

    public static InputStream parseInputStream(String string, InputStream inputStream) throws IOException {
        if (string == null) {
            return inputStream;
        }
        if (string.equals("-")) {
            return System.in;
        }
        return new FileInputStream(string);
    }

    public static InputStream parseInputStream(String string, String string2) throws IOException {
        if (string == null) {
            string = string2;
        }
        if (string.equals("-")) {
            return System.in;
        }
        return new FileInputStream(string);
    }

    public static RandomAccessFile parseRandomAccessFile(String string, RandomAccessFile randomAccessFile, String string2) throws IOException {
        if (string == null) {
            return randomAccessFile;
        }
        return new RandomAccessFile(string, string2);
    }

    public static RandomAccessFile parseRandomAccessFile(String string, String string2, String string3) throws IOException {
        if (string == null) {
            string = string2;
        }
        return new RandomAccessFile(string, string3);
    }

    public static class HelpOnlyException
    extends Exception {
        static final long serialVersionUID = -8973201446772368025L;

        public HelpOnlyException() {
            super("User only asked for help");
        }
    }

    public static class BadInvocationException
    extends Exception {
        static final long serialVersionUID = 4503820475450471907L;

        public BadInvocationException(Object object) {
            super("Argument required for '" + object + "'");
        }

        public BadInvocationException(String string) {
            super(string);
        }
    }

    public static class ProgrammingException
    extends RuntimeException {
        static final long serialVersionUID = 2401745757311140184L;

        public ProgrammingException(String string) {
            super(string);
        }
    }
}

