/*
 * Decompiled with CFR 0.152.
 */
package ice.dom.html;

import ice.dom.html.DefaultHTMLElement;
import ice.dom.html.TableCellElement;
import ice.dom.html.VectorCollection;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DNode;
import ice.storm.DynEnv;
import ice.storm.DynamicObject;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLTableCellElement;
import org.w3c.dom.html.HTMLTableElement;
import org.w3c.dom.html.HTMLTableRowElement;
import org.w3c.dom.html.HTMLTableSectionElement;

public class TableRowElement
extends DefaultHTMLElement
implements HTMLTableRowElement {
    public TableRowElement(DDocument dDocument, int n) {
        super(dDocument, n);
    }

    public int getRowIndex() {
        TableRowElement tableRowElement = this;
        while (tableRowElement.getNameId() != 79 && tableRowElement != null) {
            tableRowElement = (DNode)tableRowElement.getParentNode();
        }
        if (tableRowElement != null) {
            HTMLCollection hTMLCollection = ((HTMLTableElement)((Object)tableRowElement)).getRows();
            int n = 0;
            while (n < hTMLCollection.getLength()) {
                if (hTMLCollection.item(n) == this) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public int getSectionRowIndex() {
        Node node = this.getParentNode();
        if (node instanceof HTMLTableSectionElement) {
            HTMLCollection hTMLCollection = ((HTMLTableSectionElement)node).getRows();
            int n = 0;
            while (n < hTMLCollection.getLength()) {
                if (hTMLCollection.item(n) == this) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public HTMLCollection getCells() {
        Vector<Node> vector = new Vector<Node>();
        NodeList nodeList = this.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof HTMLTableCellElement) {
                vector.addElement(node);
            }
            ++n;
        }
        return new VectorCollection(vector);
    }

    public HTMLElement insertCell(int n) {
        HTMLCollection hTMLCollection = this.getCells();
        if (n < 0 || n > hTMLCollection.getLength()) {
            return null;
        }
        TableCellElement tableCellElement = new TableCellElement(((DNode)this).doc, 81);
        this.insertBefore(tableCellElement, hTMLCollection.item(n));
        return tableCellElement;
    }

    public void deleteCell(int n) {
        HTMLCollection hTMLCollection = this.getCells();
        if (n < 0 || n >= hTMLCollection.getLength()) {
            return;
        }
        Node node = hTMLCollection.item(n);
        node.getParentNode().removeChild(node);
    }

    public Object getDynamicValue(String string, DynEnv dynEnv) {
        int n = TableRowElement.deleteCell(string);
        if (n < 0) {
            return dynEnv.wrapMethod((DynamicObject)this, string);
        }
        if (n > 0) {
            return this.OEAB(n, dynEnv);
        }
        return super.getDynamicValue(string, dynEnv);
    }

    public int setDynamicValue(String string, Object object, DynEnv dynEnv) {
        int n = TableRowElement.deleteCell(string);
        if (n < 0) {
            return 2;
        }
        if (n > 0) {
            return this.addElement(n, object, dynEnv);
        }
        return super.setDynamicValue(string, object, dynEnv);
    }

    public Object execDynamicMethod(String string, Object[] objectArray, DynEnv dynEnv) {
        int n = TableRowElement.deleteCell(string);
        if (n < 0) {
            return this.charAt(n, objectArray, dynEnv);
        }
        return super.execDynamicMethod(string, objectArray, dynEnv);
    }

    private Object OEAB(int n, DynEnv dynEnv) {
        switch (n) {
            case 1: {
                return this.getCells();
            }
            case 2: {
                return dynEnv.wrapInt(this.getRowIndex());
            }
            case 3: {
                return dynEnv.wrapInt(this.getSectionRowIndex());
            }
        }
        return null;
    }

    private int addElement(int n, Object object, DynEnv dynEnv) {
        if (n == 1) {
            return 2;
        }
        if (n == 2) {
            return 2;
        }
        if (n == 3) {
            return 2;
        }
        return 2;
    }

    private Object charAt(int n, Object[] objectArray, DynEnv dynEnv) {
        switch (n) {
            case -1: {
                this.deleteCell(dynEnv.toInt(objectArray, 0));
                break;
            }
            case -2: {
                return this.insertCell(dynEnv.toInt(objectArray, 0));
            }
        }
        return dynEnv.wrapVoid();
    }

    private static int deleteCell(String string) {
        int n = 0;
        String string2 = null;
        switch (string.length()) {
            case 5: {
                string2 = "cells";
                n = 1;
                break;
            }
            case 8: {
                string2 = "rowIndex";
                n = 2;
                break;
            }
            case 10: {
                char c = string.charAt(0);
                if (c == 'd') {
                    string2 = "deleteCell";
                    n = -1;
                    break;
                }
                if (c != 'i') break;
                string2 = "insertCell";
                n = -2;
                break;
            }
            case 15: {
                string2 = "sectionRowIndex";
                n = 3;
            }
        }
        if (string2 != null && (string2 == string || string2.equals(string))) {
            return n;
        }
        return 0;
    }
}

