/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.source;

import com.mathworks.comparisons.collection.ComparisonCollection;
import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.comparisons.source.ComparisonSourcePropertyInfo;
import com.mathworks.comparisons.source.info.CSPInfoIncludeRelativeFrom;
import com.mathworks.comparisons.source.info.CSPInfoIncludeSubFolders;
import com.mathworks.comparisons.source.property.CSPropertyAbsoluteName;
import com.mathworks.comparisons.source.property.CSPropertyComparisonCollection;
import com.mathworks.comparisons.source.property.CSPropertyName;
import com.mathworks.comparisons.source.property.CSPropertyShortTitle;
import com.mathworks.comparisons.source.property.CSPropertySize;
import com.mathworks.comparisons.source.property.CSPropertyTitle;

public class ComparisonSourceUtilities {
    private ComparisonSourceUtilities() {
    }

    public static String getName(ComparisonSource comparisonSource) {
        CSPropertyName cSPropertyName = CSPropertyName.getInstance();
        assert (comparisonSource.hasProperty(cSPropertyName));
        return (String)comparisonSource.getPropertyValue(cSPropertyName, new ComparisonSourcePropertyInfo[0]);
    }

    public static String getAbsoluteName(ComparisonSource comparisonSource) {
        CSPropertyAbsoluteName cSPropertyAbsoluteName = CSPropertyAbsoluteName.getInstance();
        if (comparisonSource.hasProperty(cSPropertyAbsoluteName)) {
            return (String)comparisonSource.getPropertyValue(cSPropertyAbsoluteName, new ComparisonSourcePropertyInfo[0]);
        }
        return ComparisonSourceUtilities.getName(comparisonSource);
    }

    public static boolean isFolder(ComparisonSource comparisonSource) {
        CSPropertyComparisonCollection cSPropertyComparisonCollection = CSPropertyComparisonCollection.getInstance();
        return comparisonSource.hasProperty(cSPropertyComparisonCollection);
    }

    public static long getSize(ComparisonSource comparisonSource) {
        CSPropertySize cSPropertySize = CSPropertySize.getInstance();
        Long l = 0L;
        if (comparisonSource.hasProperty(cSPropertySize)) {
            l = (Long)comparisonSource.getPropertyValue(cSPropertySize, new ComparisonSourcePropertyInfo[0]);
        }
        return l;
    }

    public static String getSuitableTitle(ComparisonSource comparisonSource) {
        CSPropertyName cSPropertyName = CSPropertyName.getInstance();
        CSPropertyTitle cSPropertyTitle = CSPropertyTitle.getInstance();
        String string = null;
        if (comparisonSource.hasProperty(cSPropertyTitle)) {
            string = (String)comparisonSource.getPropertyValue(cSPropertyTitle, new ComparisonSourcePropertyInfo[0]);
        } else if (comparisonSource.hasProperty(cSPropertyName)) {
            string = (String)comparisonSource.getPropertyValue(cSPropertyName, new ComparisonSourcePropertyInfo[0]);
        }
        return string;
    }

    public static String getSuitableShortTitle(ComparisonSource comparisonSource) {
        CSPropertyShortTitle cSPropertyShortTitle = CSPropertyShortTitle.getInstance();
        String string = null;
        if (comparisonSource.hasProperty(cSPropertyShortTitle)) {
            string = (String)comparisonSource.getPropertyValue(cSPropertyShortTitle, new ComparisonSourcePropertyInfo[0]);
        }
        return string;
    }

    public static ComparisonCollection getCollection(ComparisonSource comparisonSource, boolean bl, String string) {
        CSPropertyComparisonCollection cSPropertyComparisonCollection = CSPropertyComparisonCollection.getInstance();
        CSPInfoIncludeSubFolders cSPInfoIncludeSubFolders = new CSPInfoIncludeSubFolders(bl);
        CSPInfoIncludeRelativeFrom cSPInfoIncludeRelativeFrom = new CSPInfoIncludeRelativeFrom(string);
        ComparisonCollection comparisonCollection = (ComparisonCollection)comparisonSource.getPropertyValue(cSPropertyComparisonCollection, new ComparisonSourcePropertyInfo[]{cSPInfoIncludeSubFolders, cSPInfoIncludeRelativeFrom});
        return comparisonCollection;
    }
}

