/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.source.impl;

import com.mathworks.comparisons.collection.ComparisonCollection;
import com.mathworks.comparisons.collection.ComparisonCollectionFactory;
import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.comparisons.source.ComparisonSourceProperty;
import com.mathworks.comparisons.source.ComparisonSourcePropertyInfo;
import com.mathworks.comparisons.source.impl.ComparisonSourceImpl;
import com.mathworks.comparisons.source.info.CSPInfoIncludeRelativeFrom;
import com.mathworks.comparisons.source.info.CSPInfoIncludeSubFolders;
import com.mathworks.comparisons.source.property.CSPropertyName;
import com.mathworks.comparisons.source.property.CSPropertyReadableLocation;
import com.mathworks.comparisons.source.type.CSTypeCollectionFile;
import com.mathworks.comparisons.source.type.CSTypeFile;
import com.mathworks.comparisons.util.ResourceManager;
import java.io.File;

public final class FileSourceCollection
extends ComparisonSourceImpl {
    private final Class<? extends ComparisonCollection> mCollectionClass;
    private final ComparisonSource mFileSource;

    public FileSourceCollection(ComparisonSource comparisonSource, Class<? extends ComparisonCollection> clazz) throws IllegalArgumentException {
        this.checkArgument(comparisonSource);
        this.mFileSource = comparisonSource;
        this.setType(new CSTypeCollectionFile());
        this.mCollectionClass = clazz;
    }

    @Override
    public Object getPropertyValue(ComparisonSourceProperty comparisonSourceProperty, ComparisonSourcePropertyInfo ... comparisonSourcePropertyInfoArray) {
        this.hasPropertyOrThrow(comparisonSourceProperty);
        Object object = this.mFileSource.hasProperty(comparisonSourceProperty) ? this.mFileSource.getPropertyValue(comparisonSourceProperty, comparisonSourcePropertyInfoArray) : this.mPropertyGetter.get(this, comparisonSourceProperty, comparisonSourcePropertyInfoArray);
        return object;
    }

    public Class<? extends ComparisonCollection> getCollectionClass() {
        return this.mCollectionClass;
    }

    @Override
    public void refresh() {
        this.mFileSource.refresh();
    }

    @Override
    public synchronized void dispose() {
        this.mFileSource.dispose();
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    private ComparisonCollection getComparisonCollection(CSPInfoIncludeSubFolders cSPInfoIncludeSubFolders, CSPInfoIncludeRelativeFrom cSPInfoIncludeRelativeFrom) {
        CSPropertyName cSPropertyName = CSPropertyName.getInstance();
        CSPropertyReadableLocation cSPropertyReadableLocation = CSPropertyReadableLocation.getInstance();
        assert (this.mFileSource.hasProperty(cSPropertyName) && this.mFileSource.hasProperty(cSPropertyReadableLocation));
        assert (cSPropertyName.isValueType(String.class));
        assert (cSPropertyReadableLocation.isValueType(File.class));
        String string = (String)this.mFileSource.getPropertyValue(cSPropertyName, new ComparisonSourcePropertyInfo[0]);
        File file = (File)this.mFileSource.getPropertyValue(cSPropertyReadableLocation, new ComparisonSourcePropertyInfo[0]);
        return ComparisonCollectionFactory.createFromFile(this.mCollectionClass, string, file, cSPInfoIncludeSubFolders, cSPInfoIncludeRelativeFrom);
    }

    private void checkArgument(ComparisonSource comparisonSource) throws IllegalArgumentException {
        CSTypeFile cSTypeFile = new CSTypeFile();
        if (!comparisonSource.hasProperties(cSTypeFile.getProperties()) || !cSTypeFile.hasProperties(comparisonSource.getProperties())) {
            String string;
            CSPropertyName cSPropertyName = CSPropertyName.getInstance();
            if (comparisonSource.hasProperty(cSPropertyName) && cSPropertyName.getValueType().equals(String.class)) {
                String string2 = (String)comparisonSource.getPropertyValue(cSPropertyName, new ComparisonSourcePropertyInfo[0]);
                string = ResourceManager.format("exception.notrecognizingallproperties", string2, CSTypeFile.class.getName());
            } else {
                string = ResourceManager.format("exception.notrecognizingallproperties", "Anonymous ComparisonSource", CSTypeFile.class.getName());
            }
            throw new IllegalArgumentException(string);
        }
    }
}

