/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.util;

import java.util.EnumSet;
import java.util.Set;

public class DebugUtils {
    private static Set<DebugSetting> sDebugSettings = EnumSet.noneOf(DebugSetting.class);

    public static boolean hasDebugSetting(DebugSetting debugSetting) {
        return sDebugSettings.contains((Object)debugSetting);
    }

    public static void addDebugSetting(DebugSetting debugSetting) {
        sDebugSettings.add(debugSetting);
    }

    public static void removeDebugSetting(DebugSetting debugSetting) {
        sDebugSettings.remove((Object)debugSetting);
    }

    public static void setUseIce(boolean bl) {
        if (!bl && DebugUtils.hasDebugSetting(DebugSetting.ALWAYS_USE_ICE)) {
            DebugUtils.removeDebugSetting(DebugSetting.ALWAYS_USE_ICE);
        } else if (bl) {
            DebugUtils.addDebugSetting(DebugSetting.ALWAYS_USE_ICE);
        }
    }

    public static void setAllowViewSource(boolean bl) {
        if (!bl && DebugUtils.hasDebugSetting(DebugSetting.ALLOW_VIEW_SOURCE)) {
            DebugUtils.removeDebugSetting(DebugSetting.ALLOW_VIEW_SOURCE);
        } else if (bl) {
            DebugUtils.addDebugSetting(DebugSetting.ALLOW_VIEW_SOURCE);
        }
    }

    public static enum DebugSetting {
        ALWAYS_USE_ICE,
        ALLOW_VIEW_SOURCE;

    }
}

