/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.util.Arrays;
import java.util.Collections;
import org.openide.util.Lookup;
import org.openide.util.lookup.ExcludingLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.MetaInfServicesLookup;
import org.openide.util.lookup.SimpleLookup;
import org.openide.util.lookup.SimpleProxyLookup;

public class Lookups {
    private Lookups() {
    }

    public static Lookup singleton(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return new SimpleLookup(Collections.singleton(object));
    }

    public static Lookup fixed(Object[] objectArray) {
        if (objectArray == null) {
            throw new NullPointerException();
        }
        return new SimpleLookup(Arrays.asList(objectArray));
    }

    public static Lookup fixed(Object[] objectArray, InstanceContent.Convertor convertor) {
        if (objectArray == null) {
            throw new NullPointerException();
        }
        if (convertor == null) {
            throw new NullPointerException();
        }
        return new SimpleLookup(Arrays.asList(objectArray), convertor);
    }

    public static Lookup proxy(Lookup.Provider provider) {
        return new SimpleProxyLookup(provider);
    }

    public static Lookup metaInfServices(ClassLoader classLoader) {
        return new MetaInfServicesLookup(classLoader);
    }

    public static Lookup exclude(Lookup lookup, Class[] classArray) {
        return new ExcludingLookup(lookup, classArray);
    }

    public static Lookup.Item lookupItem(Object object, String string) {
        return new LookupItem(object, string);
    }

    private static class LookupItem
    extends Lookup.Item {
        private String id;
        private Object instance;

        public LookupItem(Object object) {
            this(object, null);
        }

        public LookupItem(Object object, String string) {
            this.id = string;
            this.instance = object;
        }

        @Override
        public String getDisplayName() {
            return this.getId();
        }

        @Override
        public String getId() {
            return this.id == null ? this.instance.toString() : this.id;
        }

        @Override
        public Object getInstance() {
            return this.instance;
        }

        @Override
        public Class getType() {
            return this.instance.getClass();
        }

        public boolean equals(Object object) {
            if (object instanceof LookupItem) {
                return this.instance == ((LookupItem)object).getInstance();
            }
            return false;
        }

        public int hashCode() {
            return this.instance.hashCode();
        }
    }
}

