/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlab.api.explorer;

import com.mathworks.util.PlatformInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;

public class FileLocation
implements Comparable<FileLocation> {
    private final String fPath;
    private String[] fTokens;
    private volatile Integer fHashCode;
    public static final FileLocation ROOT = new FileLocation(PlatformInfo.isWindows() ? "" : "/");
    private static final String UNC_ROOT = "\\\\";
    private static String nameExtension;

    public FileLocation(File file) {
        this(file.getAbsolutePath());
    }

    public FileLocation(String string) {
        if (FileLocation.isUrlString(string)) {
            this.fPath = string.trim();
        } else {
            String string2 = string;
            if (!PlatformInfo.isUnix()) {
                string2 = string.replace('/', File.separatorChar);
            }
            if (!PlatformInfo.isUnix() || !string2.equals("/")) {
                string2 = FileLocation.trimTrailingSeparators(string2);
            }
            if (!PlatformInfo.isWindows() && string2.startsWith("~")) {
                string2 = System.getProperty("user.home") + string2.substring(1);
            }
            this.fPath = !PlatformInfo.isWindows() && string2.length() > 0 && !string2.startsWith(File.separator) ? File.separator + string2 : (PlatformInfo.isWindows() && string2.startsWith("\\") && !string2.startsWith(UNC_ROOT) ? string2.substring(1) : (PlatformInfo.isWindows() && string2.length() == 2 && string2.charAt(1) == ':' ? string2 + File.separator : string2));
        }
    }

    private FileLocation(String[] stringArray, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = n;
        while (n3 - n < n2) {
            stringBuilder.append(stringArray[n3]);
            if (!stringArray[n3].equals(File.separator) && n3 - n < n2 - 1) {
                stringBuilder.append(File.separatorChar);
            }
            ++n3;
        }
        this.fPath = PlatformInfo.isWindows() && stringBuilder.length() == 2 && stringBuilder.charAt(1) == ':' ? stringBuilder + File.separator : stringBuilder.toString();
    }

    public FileLocation(FileLocation fileLocation, String string) {
        this(fileLocation.equals(ROOT) ? string : FileLocation.trimTrailingSeparators(fileLocation.fPath) + File.separator + FileLocation.trimLeadingSeparators(string));
    }

    public FileLocation getParent() {
        if (this.fPath.length() == 0 || PlatformInfo.isUnix() && this.fPath.equals("/") || this.isUrl()) {
            return null;
        }
        String[] stringArray = this.getTokens();
        if (stringArray.length == 1) {
            return PlatformInfo.isWindows() && !this.isUrl() ? ROOT : null;
        }
        return new FileLocation(stringArray, 0, stringArray.length - 1);
    }

    public String getName() {
        String[] stringArray = this.getTokens();
        return stringArray.length == 0 ? "" : stringArray[stringArray.length - 1];
    }

    public boolean hasToken(int n, String string) {
        String[] stringArray = this.getTokens();
        return n >= 0 && n < stringArray.length && FileLocation.platformEquals(stringArray[n], string);
    }

    public String getNameBeforeDot() {
        String string = this.getName();
        int n = string.lastIndexOf(46);
        return n >= 0 ? string.substring(0, n) : string;
    }

    public String getExtension() {
        String string = this.getName();
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n > 0 && n < string.length() - 1) {
            return string.substring(n + 1);
        }
        return null;
    }

    public boolean checkExtension(String ... stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            nameExtension = stringArray[i];
            if (!nameExtension.startsWith(".")) {
                nameExtension = "." + stringArray[i];
            }
            if (this.getName() == null || !this.getName().toLowerCase().endsWith(nameExtension)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPrefix(FileLocation fileLocation) {
        return fileLocation.equals(ROOT) || FileLocation.platformStartsWith(this.fPath, fileLocation.fPath) && (this.fPath.length() == fileLocation.fPath.length() || this.fPath.length() > fileLocation.fPath.length() && this.fPath.charAt(fileLocation.fPath.endsWith(File.separator) ? fileLocation.fPath.length() - 1 : fileLocation.fPath.length()) == File.separatorChar);
    }

    public boolean isDirectChildOf(FileLocation fileLocation) {
        if (!this.hasPrefix(fileLocation) || this.equals(fileLocation)) {
            return false;
        }
        String[] stringArray = this.stripPrefix(fileLocation).getTokens();
        return stringArray.length == 1 && FileLocation.platformEquals(stringArray[0], this.getName()) || stringArray.length == 2 && stringArray[0].equals(File.separator) && FileLocation.platformEquals(stringArray[1], this.getName());
    }

    private static boolean platformEquals(String string, String string2) {
        return PlatformInfo.isWindows() ? string.equalsIgnoreCase(string2) : string.equals(string2);
    }

    private static boolean platformStartsWith(String string, String string2) {
        return string.startsWith(string2) || PlatformInfo.isWindows() && string.toUpperCase(Locale.getDefault()).startsWith(string2.toUpperCase(Locale.getDefault()));
    }

    public FileLocation stripPrefix(FileLocation fileLocation) {
        if (!this.hasPrefix(fileLocation)) {
            throw new IllegalArgumentException("This path does not have the prefix " + fileLocation);
        }
        return new FileLocation(this.fPath.substring(fileLocation.fPath.length()));
    }

    private synchronized String[] getTokens() {
        if (this.fTokens != null) {
            return this.fTokens;
        }
        if (this.isUrl()) {
            int n = this.fPath.indexOf("://") + 3;
            int n2 = this.fPath.indexOf(47, n + 3);
            if (n2 == -1) {
                n2 = this.fPath.length();
            }
            String string = this.fPath.substring(0, n2);
            StringTokenizer stringTokenizer = new StringTokenizer(this.fPath.substring(string.length()), "/");
            this.fTokens = new String[1 + stringTokenizer.countTokens()];
            this.fTokens[0] = string;
            for (int i = 1; i < this.fTokens.length; ++i) {
                this.fTokens[i] = stringTokenizer.nextToken();
            }
            return this.fTokens;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.fPath, File.separator);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!PlatformInfo.isWindows()) {
            arrayList.add(File.separator);
        }
        boolean bl = PlatformInfo.isWindows() && this.fPath.startsWith(UNC_ROOT);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (n == 0 && bl) {
                string = UNC_ROOT + string;
            }
            if (n == 1 && bl) {
                arrayList.set(0, (String)arrayList.get(0) + File.separator + string);
            } else {
                arrayList.add(string);
            }
            ++n;
        }
        this.fTokens = arrayList.toArray(new String[arrayList.size()]);
        return this.fTokens;
    }

    public String toString() {
        return this.fPath;
    }

    private static String trimLeadingSeparators(String string) {
        while (string.startsWith("/") || string.startsWith("\\")) {
            string = string.substring(1);
        }
        return string;
    }

    private static String trimTrailingSeparators(String string) {
        while (string.endsWith("/") || string.endsWith("\\")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public int hashCode() {
        if (this.fHashCode == null) {
            this.fHashCode = new File(this.fPath).hashCode();
        }
        return this.fHashCode;
    }

    public boolean equals(Object object) {
        if (PlatformInfo.isUnix() && this.fPath.length() == 0 && ((FileLocation)object).fPath.equals("/")) {
            return true;
        }
        return object instanceof FileLocation && new File(this.fPath).equals(new File(((FileLocation)object).fPath));
    }

    @Override
    public int compareTo(FileLocation fileLocation) {
        if (this.equals(fileLocation)) {
            return 0;
        }
        return new File(this.fPath).compareTo(new File(fileLocation.fPath));
    }

    public File toFile() {
        return new File(this.toString());
    }

    public boolean isUrl() {
        return FileLocation.isUrlString(this.fPath);
    }

    public static boolean isUrlString(String string) {
        int n = string.indexOf("://");
        int n2 = string.indexOf(47);
        int n3 = string.indexOf(92);
        return n > 0 && n2 > n && (n3 < 0 || n3 > n);
    }

    public static boolean isPathString(String string) {
        return PlatformInfo.isWindows() && (string.startsWith(UNC_ROOT) || string.length() >= 2 && Character.isLetter(string.charAt(0)) && string.charAt(1) == ':') || !PlatformInfo.isWindows() && string.startsWith(File.separator);
    }
}

