/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo.log;

import com.sun.jini.logging.Levels;
import com.sun.jini.mahalo.log.InvalidatedLogException;
import com.sun.jini.mahalo.log.Log;
import com.sun.jini.mahalo.log.LogException;
import com.sun.jini.mahalo.log.LogRecord;
import com.sun.jini.mahalo.log.LogRecovery;
import com.sun.jini.mahalo.log.MultiLogManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimpleLogFile
implements Log {
    private long cookie;
    private ObjectOutputStream out;
    private FileOutputStream outfile;
    private String name;
    private MultiLogManager.LogRemovalManager logMgr;
    private boolean valid = true;
    private boolean readonly = false;
    private static final Logger persistenceLogger = Logger.getLogger("com.sun.jini.mahalo.persistence");
    private static final Logger operationsLogger = Logger.getLogger("com.sun.jini.mahalo.operations");
    private static final Logger initLogger = Logger.getLogger("com.sun.jini.mahalo.init");

    public SimpleLogFile(String string, MultiLogManager.LogRemovalManager logRemovalManager) {
        this.init(string, 0L, logRemovalManager);
        this.readonly = true;
    }

    public SimpleLogFile(String string, long l, MultiLogManager.LogRemovalManager logRemovalManager) {
        this.init(string, l, logRemovalManager);
    }

    private void init(String string, long l, MultiLogManager.LogRemovalManager logRemovalManager) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(SimpleLogFile.class.getName(), "init", new Object[]{string, new Long(l), logRemovalManager});
        }
        if (string == null) {
            throw new IllegalArgumentException("SimpleLogFile: null name");
        }
        if (logRemovalManager == null) {
            throw new IllegalArgumentException("SimpleLogFile: null log manager");
        }
        this.name = string;
        this.cookie = l;
        this.logMgr = logRemovalManager;
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(SimpleLogFile.class.getName(), "init");
        }
    }

    public long cookie() {
        return this.cookie;
    }

    public synchronized void write(LogRecord logRecord) throws LogException {
        block15: {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.entering(SimpleLogFile.class.getName(), "write", logRecord);
            }
            try {
                if (!this.valid) {
                    throw new InvalidatedLogException("Cannot write to to invalidated log");
                }
                if (this.readonly) {
                    throw new LogException("Unable to write to read only log");
                }
                if (this.out == null) {
                    boolean bl = true;
                    File file = new File(this.name);
                    this.outfile = new FileOutputStream(this.name, bl);
                    this.out = new HeaderlessObjectOutputStream(new BufferedOutputStream(this.outfile));
                    if (file.length() == 0L) {
                        this.out.writeLong(this.cookie);
                    }
                    this.out.reset();
                }
                this.out.writeObject(logRecord);
                this.out.flush();
                this.outfile.getFD().sync();
                if (persistenceLogger.isLoggable(Level.FINEST)) {
                    persistenceLogger.log(Level.FINEST, "Wrote: {0}", logRecord);
                }
            }
            catch (InvalidClassException invalidClassException) {
                if (persistenceLogger.isLoggable(Level.WARNING)) {
                    persistenceLogger.log(Level.WARNING, "Problem persisting LogRecord", invalidClassException);
                }
            }
            catch (NotSerializableException notSerializableException) {
                if (persistenceLogger.isLoggable(Level.WARNING)) {
                    persistenceLogger.log(Level.WARNING, "Problem persisting LogRecord", notSerializableException);
                }
            }
            catch (IOException iOException) {
                if (persistenceLogger.isLoggable(Level.WARNING)) {
                    persistenceLogger.log(Level.WARNING, "Problem persisting LogRecord", iOException);
                }
            }
            catch (SecurityException securityException) {
                if (!persistenceLogger.isLoggable(Level.WARNING)) break block15;
                persistenceLogger.log(Level.WARNING, "Problem persisting LogRecord", securityException);
            }
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(SimpleLogFile.class.getName(), "write", logRecord);
        }
    }

    public synchronized void invalidate() throws LogException {
        block11: {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.entering(MultiLogManager.class.getName(), "invalidate");
            }
            if (persistenceLogger.isLoggable(Level.FINEST)) {
                persistenceLogger.log(Level.FINEST, "Invalidating log for cookie: {0}", new Long(this.cookie));
            }
            if (this.valid) {
                this.valid = false;
                this.logMgr.release(this.cookie);
            }
            try {
                if (this.out != null) {
                    this.out.close();
                }
            }
            catch (IOException iOException) {
                if (!persistenceLogger.isLoggable(Levels.HANDLED)) break block11;
                persistenceLogger.log(Levels.HANDLED, "Problem closing log file", iOException);
            }
        }
        try {
            File file = new File(this.name);
            if (!file.delete() && persistenceLogger.isLoggable(Levels.HANDLED)) {
                persistenceLogger.log(Levels.HANDLED, "Could not delete log file");
            }
        }
        catch (SecurityException securityException) {
            if (persistenceLogger.isLoggable(Level.FINEST)) {
                persistenceLogger.log(Level.FINEST, "SecurityException on log deletion", securityException);
            }
            throw new LogException("SimpleLogFile: invalidate: cannot delete log file.");
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(MultiLogManager.class.getName(), "invalidate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void recover(LogRecovery logRecovery) throws LogException {
        block31: {
            ObjectInputStream objectInputStream;
            block30: {
                block29: {
                    boolean bl;
                    ArrayList<LogRecord> arrayList;
                    block28: {
                        if (operationsLogger.isLoggable(Level.FINER)) {
                            operationsLogger.entering(MultiLogManager.class.getName(), "recover", logRecovery);
                        }
                        if (!this.valid) {
                            throw new InvalidatedLogException("Cannot recover from invalidated log");
                        }
                        if (logRecovery == null) {
                            throw new IllegalArgumentException("Cannot have a <null> client argument.");
                        }
                        objectInputStream = null;
                        arrayList = new ArrayList<LogRecord>();
                        if (persistenceLogger.isLoggable(Level.FINEST)) {
                            persistenceLogger.log(Level.FINEST, "Recovering from: {0}", this.name);
                        }
                        objectInputStream = new HeaderlessObjectInputStream(new BufferedInputStream(new FileInputStream(this.name)));
                        this.cookie = objectInputStream.readLong();
                        LogRecord logRecord = null;
                        boolean bl2 = false;
                        bl = true;
                        try {
                            while (!bl2) {
                                logRecord = (LogRecord)objectInputStream.readObject();
                                if (logRecord != null) {
                                    arrayList.add(logRecord);
                                    continue;
                                }
                                bl = false;
                                bl2 = true;
                                if (!persistenceLogger.isLoggable(Levels.HANDLED)) continue;
                                persistenceLogger.log(Levels.HANDLED, "Log for cookie {0} contained a null record object", new Long(this.cookie));
                            }
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            bl = false;
                            if (persistenceLogger.isLoggable(Level.WARNING)) {
                                persistenceLogger.log(Level.WARNING, "Problem recovering log file", classNotFoundException);
                            }
                        }
                        catch (ClassCastException classCastException) {
                            bl = false;
                            if (persistenceLogger.isLoggable(Level.WARNING)) {
                                persistenceLogger.log(Level.WARNING, "Problem recovering log file", classCastException);
                            }
                        }
                        catch (EOFException eOFException) {
                        }
                        catch (IOException iOException) {
                            bl = false;
                            if (!persistenceLogger.isLoggable(Level.WARNING)) break block28;
                            persistenceLogger.log(Level.WARNING, "Problem recovering log file", iOException);
                        }
                    }
                    if (bl) {
                        for (int i = 0; i < arrayList.size(); ++i) {
                            logRecovery.recover(this.cookie, (LogRecord)arrayList.get(i));
                        }
                        break block29;
                    }
                    if (!persistenceLogger.isLoggable(Level.WARNING)) break block29;
                    persistenceLogger.log(Level.WARNING, "Skipping log recovery for", this.name);
                }
                Object var9_14 = null;
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    if (!persistenceLogger.isLoggable(Levels.HANDLED)) break block30;
                    persistenceLogger.log(Levels.HANDLED, "Problem closing recovered log file", iOException);
                }
            }
            this.readonly = false;
            {
                break block31;
                catch (IOException iOException) {
                    block32: {
                        if (persistenceLogger.isLoggable(Level.WARNING)) {
                            persistenceLogger.log(Level.WARNING, "Problem recovering log file", iOException);
                        }
                        Object var9_15 = null;
                        try {
                            if (objectInputStream != null) {
                                objectInputStream.close();
                            }
                        }
                        catch (IOException iOException2) {
                            if (!persistenceLogger.isLoggable(Levels.HANDLED)) break block32;
                            persistenceLogger.log(Levels.HANDLED, "Problem closing recovered log file", iOException2);
                        }
                    }
                    this.readonly = false;
                }
            }
            catch (Throwable throwable) {
                block33: {
                    Object var9_16 = null;
                    try {
                        if (objectInputStream != null) {
                            objectInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        if (!persistenceLogger.isLoggable(Levels.HANDLED)) break block33;
                        persistenceLogger.log(Levels.HANDLED, "Problem closing recovered log file", iOException);
                    }
                }
                this.readonly = false;
                throw throwable;
            }
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(MultiLogManager.class.getName(), "recover");
        }
    }

    private static class HeaderlessObjectOutputStream
    extends ObjectOutputStream {
        public HeaderlessObjectOutputStream(OutputStream outputStream) throws IOException {
            super(outputStream);
        }

        protected void writeStreamHeader() throws IOException {
        }
    }

    private static class HeaderlessObjectInputStream
    extends ObjectInputStream {
        public HeaderlessObjectInputStream(InputStream inputStream) throws IOException {
            super(inputStream);
        }

        protected void readStreamHeader() throws IOException {
        }
    }
}

