/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.NetworkDataLink;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;

class Connect
extends Thread {
    private static final int BUFLEN = 16535;
    private Socket client;
    private DataInputStream dataInputStream;
    private InputStreamReader inputStreamReader;
    private DataOutputStream dataOutputStream;
    private byte[] buf = new byte[16535];
    protected boolean connectionIsOk = true;

    public Connect(Socket socket) {
        this.client = socket;
        try {
            this.client.setSendBufferSize(NetworkDataLink.OSBUFFERSIZE);
            this.client.setReceiveBufferSize(NetworkDataLink.OSBUFFERSIZE);
            InputStream inputStream = this.client.getInputStream();
            this.dataInputStream = new DataInputStream(inputStream);
            if (this.dataInputStream == null) {
                throw new IOException();
            }
            this.inputStreamReader = new InputStreamReader(inputStream);
            if (this.inputStreamReader == null) {
                throw new IOException();
            }
            this.dataOutputStream = new DataOutputStream(this.client.getOutputStream());
            if (this.dataOutputStream == null) {
                throw new IOException();
            }
        }
        catch (IOException iOException) {
            try {
                this.client.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            this.connectionIsOk = false;
            return;
        }
        this.start();
    }

    @Override
    public void run() {
        try {
            int n = 0;
            while (this.inputStreamReader.ready() || this.connectionIsOk) {
                n = this.dataInputStream.read(this.buf, 0, 16535);
                if (n == -1) {
                    this.connectionIsOk = false;
                    continue;
                }
                this.dataOutputStream.write(this.buf, 0, n);
            }
            this.closeClient();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isOK() {
        return this.connectionIsOk;
    }

    public void shutDownServer() {
        this.connectionIsOk = false;
        try {
            if (this.dataInputStream != null) {
                this.dataInputStream.close();
                this.dataInputStream = null;
            }
            if (this.dataOutputStream != null) {
                this.dataOutputStream.close();
                this.dataOutputStream = null;
            }
            this.closeClient();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void closeClient() {
        try {
            this.client.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

