/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.Gpib;
import com.mathworks.toolbox.instrument.ICProp;
import com.mathworks.toolbox.instrument.Poller;
import com.mathworks.toolbox.instrument.VISA;
import com.mathworks.toolbox.instrument.events.ICEvent;
import com.mathworks.toolbox.instrument.util.DefaultICProp;
import com.mathworks.toolbox.instrument.util.Displays;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.util.Timer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;

public class GpibVisa
extends Gpib
implements ActionListener {
    private static final int EOIMODE = 100;
    private static final int EOSMODE = 101;
    private static final int EOSCHAR = 102;
    private static final int TIMEOUT = 104;
    protected static final int SUCCESS = 0;
    protected static final String[] HWINFO_FIELDS = new String[]{"adaptordllname", "adaptordllversion", "adaptorname", "vendordllname", "vendordriverdescription", "vendordriverversion"};
    protected String alias = "";
    protected String rsrcName = "";
    protected VISA visa;
    protected String visaName;
    protected boolean useAlias;
    protected int defaultRM;
    protected Object[] info = new Object[6];
    private int readId = 0;
    private int writeId = 0;
    private int oldTransferStatus = 0;
    private boolean objectPolls = false;
    protected static final Object[] comVals = new Object[]{new Double(8.0)};
    protected static final Object[] SadVals = new Object[]{new Double(0.0), new Double(30.0)};
    static ICProp[] objectICProps = new ICProp[]{new ICProp("Alias", "string", "none", "", "", "always", 1, 0), new ICProp("BoardIndex", "double", "none", "", "", "whileopen", 1, 0), new ICProp("ByteOrder", "string", "enum", byteOVals, "littleEndian", "never", 0, 0), new ICProp("BytesAvailableFcnMode", "string", "enum", dModeVals, "eosCharCode", "whileOpen", 0, 0), new ICProp("CompareBits", "double", "bounded", comVals, new Integer(8), "never", 1, 2), new ICProp("EOIMode", "string", "enum", boolVals, "on", "never", 1, 0), new ICProp("EOSCharCode", "ASCII Value", "ASCII Value", AsciiVals, "LF", "never", 1, 0), new ICProp("EOSMode", "string", "enum", EOSMVals, "none", "never", 1, 0), new ICProp("PrimaryAddress", "double", "bounded", PadVals, "", "whileOpen", 1, 0), new ICProp("RsrcName", "string", "none", "", "", "always", 1, 0), new ICProp("SecondaryAddress", "double", "bounded", SadVals, new Integer(0), "whileOpen", 1, 0), new ICProp("Type", "string", "none", "", "visa-gpib", "always", 0, 0)};

    public GpibVisa() {
        this.deleteInstrumentObject(this);
    }

    public GpibVisa(String string, String string2, String string3, String string4) throws TMException {
        if (!IS_TOOLBOX_INSTALLED) {
            GpibVisa.displayError("Undefined function or variable 'visa'.");
        }
        try {
            this.rsrcName = this.visaName = string3;
            try {
                this.parseName(this.visaName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.alias = string4;
            this.useAlias = !this.alias.equals("");
            this.info[0] = string + FILESEP + string2;
            this.info[1] = GpibVisa.jarVersion();
            this.info[2] = this.getVendorName(string2);
            this.visa = VISA.createVisaObject((String)this.info[2], (String)this.info[0]);
            this.name = this.secondaryAddress == 0 ? "VISA-GPIB" + this.boardIndex + "-" + this.primaryAddress : "VISA-GPIB" + this.boardIndex + "-" + this.primaryAddress + "-" + this.secondaryAddress;
            this.type = "visa-gpib";
            this.displayName = "VISA-GPIB";
            this.objectProps = DefaultICProp.addObjectProps(objectICProps);
            this.objectPolls = this.visa.VerifyAsyncVISARead();
        }
        catch (Exception exception) {
            this.deleteInstrumentObject(this);
            throw new TMException(exception.getMessage());
        }
    }

    public String getInspectorToolbarObjectName() {
        return "VISA-GPIB";
    }

    public void setAlias(String string) throws TMException {
        GpibVisa.displayError(this.createReadOnlyPropertyError("Alias"));
    }

    public String getAlias() {
        return this.alias;
    }

    @Override
    public void setBoardIndex(int n) throws TMException {
        if (this.useAlias) {
            GpibVisa.displayError("BoardIndex cannot be set for a VISA object that has an alias.");
        }
        super.setBoardIndex(n);
    }

    @Override
    public void setPrimaryAddress(int n) throws TMException {
        if (this.useAlias) {
            GpibVisa.displayError("PrimaryAddress cannot be set for a VISA object that has an alias.");
        }
        super.setPrimaryAddress(n);
    }

    public void setRsrcName(String string) throws TMException {
        GpibVisa.displayError(this.createReadOnlyPropertyError("RsrcName"));
    }

    public String getRsrcName() {
        return this.rsrcName;
    }

    @Override
    public void setSecondaryAddress(int n) throws TMException {
        if (this.useAlias) {
            GpibVisa.displayError("SecondaryAddress cannot be set for a VISA object that has an alias.");
        }
        super.setSecondaryAddress(n);
    }

    @Override
    protected void nameStandardFormat() {
        this.nameStandardFormat = this.name.equals("VISA-GPIB" + this.boardIndex + "-" + this.primaryAddress) || this.name.equals("VISA-GPIB" + this.boardIndex + "-" + this.primaryAddress + "-" + this.secondaryAddress);
    }

    @Override
    protected void updateNameProperties() {
        this.rsrcName = "GPIB" + this.boardIndex + "::" + this.primaryAddress + "::" + this.secondaryAddress + "::INSTR";
        if (this.nameStandardFormat) {
            if (this.secondaryAddress == 0) {
                this.setName("VISA-GPIB" + this.boardIndex + "-" + this.primaryAddress);
            } else {
                this.setName("VISA-GPIB" + this.boardIndex + "-" + this.primaryAddress + "-" + this.secondaryAddress);
            }
        }
    }

    @Override
    protected void setHardwareCompareBits(int n) {
    }

    @Override
    protected final int[] getValidCompareBits() {
        int[] nArray = new int[]{8, 8};
        return nArray;
    }

    @Override
    protected void setHardwareEOIMode(boolean bl) throws TMException {
        this.visa.setProperty(this.handle, 100, this.bool2int(bl));
    }

    @Override
    protected void setHardwareEOSChar(int n) throws TMException {
        this.visa.setHardwareEOSChar(this.handle, 102, n, this.eosMode);
    }

    @Override
    protected void setHardwareEOSMode(int n) throws TMException {
        this.visa.setHardwareEOSMode(this.handle, 101, n, this.eosCharCode);
    }

    @Override
    protected int[] getValidSecondaryAddress() {
        int[] nArray = new int[]{0, 30};
        return nArray;
    }

    @Override
    protected void setHardwareTimeout(double d) throws TMException {
        this.visa.setHardwareTimeout(this.handle, d, 104);
    }

    @Override
    protected double getHardwareTimeout() {
        int n = this.visa.Get(this.handle, 104);
        return (double)n / 1000.0;
    }

    private void parseName(String string) {
        int n = string.indexOf("::");
        if (n == -1) {
            return;
        }
        this.boardIndex = n == 4 ? 0 : this.str2num(string.substring(4, n));
        if (this.boardIndex < 0) {
            return;
        }
        String string2 = string.substring(n + 2, string.length());
        if ((n = string2.indexOf("::")) == -1) {
            return;
        }
        this.primaryAddress = this.str2num(string2.substring(0, n));
        if (!this.verifySetRange(this.primaryAddress, 0, 30)) {
            return;
        }
        if ((n = (string2 = string2.substring(n + 2, string2.length())).indexOf("::")) == -1) {
            this.secondaryAddress = 0;
        } else {
            this.secondaryAddress = this.str2num(string2.substring(0, n));
            string2 = string2.substring(n + 2, string2.length());
        }
        if (!this.verifySetRange(this.secondaryAddress, 0, 30)) {
            return;
        }
        if (!string2.toUpperCase().equals("INSTR")) {
            return;
        }
        this.rsrcName = "GPIB" + this.boardIndex + "::" + this.primaryAddress + "::" + this.secondaryAddress + "::INSTR";
    }

    @Override
    public String[] getBrowserInfo() {
        String[] stringArray = new String[]{"GPIB board vendor:", (String)this.info[2], "GPIB board index:", String.valueOf(this.boardIndex), "Primary address:", String.valueOf(this.primaryAddress)};
        return stringArray;
    }

    @Override
    public String getBrowserString() {
        return "primary address " + this.primaryAddress + " (" + (String)this.info[2] + " board " + this.boardIndex + ")";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.eventTime = Calendar.getInstance();
        if (this.timerFcn != ACTION) {
            this.executeEvent(6, "Timer", this.eventTime, new ICEvent("Timer", GpibVisa.constructClockVector(this.eventTime)));
        }
    }

    @Override
    protected void createTimer() {
        this.timer = new Timer((int)(this.timerPeriod * 1000.0), (ActionListener)this, 1, 5, "GpibVisaTimer");
        this.timer.start();
        this.wasTimerStarted = true;
    }

    @Override
    protected boolean isInUse() {
        for (int i = 0; i < allInstrumentObjects.size(); ++i) {
            Object e = allInstrumentObjects.elementAt(i);
            if (!(e instanceof GpibVisa)) continue;
            GpibVisa gpibVisa = (GpibVisa)e;
            if (gpibVisa.boardIndex != this.boardIndex || gpibVisa.primaryAddress != this.primaryAddress || gpibVisa.secondaryAddress != this.secondaryAddress || gpibVisa.status != 1) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void openHardware() throws TMException {
        int[] nArray;
        if (this.isInUse()) {
            GpibVisa.displayError("The specified configuration: " + this.rsrcName + " is not available.  " + LINESEP + "Use INSTRHWINFO for a list of available configurations. Use INSTRFIND to " + LINESEP + "determine if other instrument objects are connected to the requested instrument.");
        }
        String string = this.rsrcName;
        if (this.secondaryAddress == 0) {
            string = "GPIB" + this.boardIndex + "::" + this.primaryAddress + "::INSTR";
        }
        if ((nArray = this.visa.Create(this, string)) != null) {
            this.handle = nArray[0];
            this.defaultRM = nArray[1];
        } else {
            GpibVisa.displayError("Could not open VISA object. Use INSTRHWINFO for a list of available configurations.");
        }
        Object[] objectArray = this.visa.GetAliasInfo(this.visaName);
        if (objectArray != null) {
            this.parseName((String)objectArray[1]);
        }
    }

    @Override
    protected void closeHardware() throws TMException {
        int n;
        if (this.objectPolls) {
            Poller.removeInstrument(this);
        }
        if (this.wasTimerStarted) {
            this.timer.hold();
        }
        if ((n = this.visa.Close(this.handle, this.defaultRM)) < 0) {
            GpibVisa.displayError("VISA: " + this.visa.TranslateErrorCode(this.handle, n));
        }
    }

    @Override
    protected void disposeMLArrayRefs() {
        this.superDisposeMLArrayRef();
        if (this.timer != null) {
            this.timer.removeActionListener((ActionListener)this);
        }
    }

    @Override
    public final Object[] constructorargs() {
        String string = (String)this.info[0];
        int n = string.lastIndexOf(FILESEP);
        Object[] objectArray = new Object[]{string.substring(0, n), string.substring(n + 1), this.rsrcName, this.alias};
        return objectArray;
    }

    @Override
    public final String getConstructor() {
        return "visa('" + this.info[2] + "', '" + this.rsrcName + "');";
    }

    @Override
    public String getConstructorDescription() {
        return "Vendor - " + this.info[2] + ", Resource Name - " + this.rsrcName;
    }

    @Override
    public String getInstrfindArgs() {
        return "('Type', '" + this.type + "', 'RsrcName', '" + this.rsrcName + "', 'Tag', '" + this.tag + "');";
    }

    @Override
    public boolean supportsAsynchronousOperations() {
        return this.objectPolls;
    }

    public char spoll(int n) throws TMException {
        return this.visa.spoll(this.handle, n, this.getHardwareTimeout());
    }

    @Override
    protected void hardwareStopAsync() throws TMException {
        this.oldTransferStatus = this.transferStatus;
        switch (this.transferStatus) {
            case 1: {
                this.visa.StopAsync(this.handle, this.readId);
                break;
            }
            case 2: {
                this.visa.StopAsync(this.handle, this.writeId);
            }
        }
    }

    @Override
    protected void hardwareFlushOutput() throws TMException {
        this.oldTransferStatus = this.transferStatus;
        switch (this.transferStatus) {
            case 2: {
                this.visa.StopAsync(this.handle, this.writeId);
            }
        }
    }

    @Override
    protected void verifyWriteOperation(int n) throws TMException {
        this.visa.verifyWriteOperation(n, (String)this.info[2], this.type, this.transferStatus);
    }

    @Override
    protected void verifyReadOperation() throws TMException {
        this.visa.verifyReadOperation((String)this.info[2], this.type, this.transferStatus);
        this.transferStatus = 1;
    }

    @Override
    public int getAsyncActionType(int n, int n2) {
        if (n == 0) {
            n = this.transferStatus == 2 ? 2 : (this.transferStatus == 1 ? 0 : (this.oldTransferStatus == 2 ? 2 : (this.oldTransferStatus == 1 ? 0 : -1)));
        }
        return n;
    }

    @Override
    protected int writeAsciiToHardware(String string) {
        return this.visa.Write(this.handle, string, string.length());
    }

    @Override
    protected int writeBytes(Object object, int n, int n2) {
        return this.visa.writeBytes(this.handle, object, n, n2);
    }

    @Override
    public int writeBinaryToHardwareAsync(byte[] byArray) {
        int n = this.visa.WriteBinaryByteAsync(this.handle, byArray, byArray.length);
        if (n >= 0) {
            this.writeId = n;
        }
        return n;
    }

    @Override
    protected Object[] readAsciiFromHardware(int n, double d) {
        return this.visa.Read(this.handle, n);
    }

    @Override
    protected Object[] readBinaryFromHardware(int n, double d) {
        return this.visa.ReadBinary(this.handle, n, 0);
    }

    @Override
    public byte[] readAsynchronousDataFromHardware(int n) {
        return this.visa.GetAsyncReadData(this.handle, n);
    }

    @Override
    public int readBinaryFromHardwareAsync(int n) {
        int n2 = this.visa.ReadBinaryByteAsync(this.handle, n);
        if (n2 >= 0) {
            this.readId = n2;
        }
        return n2;
    }

    @Override
    protected String getErrorMessageFromHardware(int n) {
        return "VISA: " + this.visa.TranslateErrorCode(this.handle, n);
    }

    @Override
    protected int getSuccessValue() {
        return 0;
    }

    @Override
    public void clrdevice() throws TMException {
        this.verifyObjectState();
        int n = this.visa.Clear(this.handle);
        if (n < 0) {
            GpibVisa.displayError("VISA: " + this.visa.TranslateErrorCode(this.handle, n));
        }
    }

    @Override
    protected void hardwareGPIBTrigger() throws TMException {
        int n = this.visa.Trigger(this.handle);
        if (n < 0) {
            GpibVisa.displayError(this.getErrorMessageFromHardware(n));
        }
    }

    @Override
    protected void hardwareGPIBClear() throws TMException {
        int n = this.visa.Clear(this.handle);
        if (n < 0) {
            GpibVisa.displayError(this.getErrorMessageFromHardware(n));
        }
    }

    public Object ObjectHardwareInfo() {
        return this.visa.ObjectHardwareInfo(this.info, this.handle);
    }

    @Override
    protected Object[] getHwInfoStruct() {
        this.ObjectHardwareInfo();
        return this.info;
    }

    @Override
    protected String[] getHwInfoFields() {
        return HWINFO_FIELDS;
    }

    @Override
    protected void updateObjectSpecificProperties(ICProp[] iCPropArray) {
        for (int i = 0; i < iCPropArray.length; ++i) {
            String string = iCPropArray[i].name;
            if (string.equals("Name")) {
                if (this.secondaryAddress == 0) {
                    iCPropArray[i].setDefaultValue("VISA-GPIB" + this.boardIndex + "-" + this.primaryAddress);
                    continue;
                }
                iCPropArray[i].setDefaultValue("VISA-GPIB" + this.boardIndex + "-" + this.primaryAddress + "-" + this.secondaryAddress);
                continue;
            }
            if (string.equals("BoardIndex")) {
                iCPropArray[i].setDefaultValue(new Integer(this.boardIndex));
                continue;
            }
            if (string.equals("PrimaryAddress")) {
                iCPropArray[i].setDefaultValue(new Integer(this.primaryAddress));
                continue;
            }
            if (string.equals("Alias")) {
                iCPropArray[i].setDefaultValue(this.alias);
                continue;
            }
            if (!string.equals("RsrcName")) continue;
            iCPropArray[i].setDefaultValue(this.rsrcName);
        }
    }

    public static ICProp[] getProperties() {
        return DefaultICProp.addObjectProps(objectICProps);
    }

    @Override
    public String display() {
        if (!this.isvalid()) {
            return Displays.invalidDisplay();
        }
        return LINESEP + "   VISA-GPIB Object Using " + this.info[2] + " Adaptor : " + this.name + LINESEP + LINESEP + this.gpibDisplay();
    }

    @Override
    public String setDisplay() {
        return Displays.getSetDisplay() + "    " + LINESEP + "    VISA-GPIB specific properties:" + LINESEP + "    BoardIndex" + LINESEP + "    EOIMode: [ {on} | off ]" + LINESEP + "    EOSCharCode" + LINESEP + "    EOSMode: [ {none} | read | write | read&write ]" + LINESEP + "    PrimaryAddress" + LINESEP + "    SecondaryAddress" + LINESEP + " " + LINESEP;
    }
}

