/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.driver;

import com.mathworks.toolbox.instrument.browser.driver.IVITab;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IVIListSelector
extends JPanel
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 1L;
    protected static final String ACTION = "ACTION";
    protected static final int ADD = 0;
    protected static final int REMOVE = 1;
    private JButton addButton;
    private JButton removeButton;
    private JList list;
    private DefaultListModel listModel;
    private IVITab tab;

    public IVIListSelector(IVITab iVITab) {
        this.tab = iVITab;
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        this.layoutPanel();
        this.addButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.list.addListSelectionListener(this);
    }

    private void layoutPanel() {
        this.addButton = new JButton("Add");
        this.removeButton = new JButton("Remove");
        this.removeButton.setEnabled(false);
        this.addButton.putClientProperty(ACTION, new Integer(0));
        this.removeButton.putClientProperty(ACTION, new Integer(1));
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 4, 0));
        jPanel.add(this.addButton);
        jPanel.add(this.removeButton);
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 0, 0));
        jPanel2.add(jPanel);
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setPreferredSize(new Dimension(180, 75));
        this.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel2, "South");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = (Integer)((JComponent)actionEvent.getSource()).getClientProperty(ACTION);
        switch (n) {
            case 0: {
                this.listModel.addElement(this.getUniqueName());
                this.list.setSelectedIndex(this.listModel.size() - 1);
                this.tab.addItem((String)this.listModel.getElementAt(this.listModel.size() - 1));
                break;
            }
            case 1: {
                int n2 = this.list.getSelectedIndex();
                if (n2 < 0) break;
                this.tab.removeItem((String)this.listModel.getElementAt(n2));
                this.listModel.removeElementAt(n2);
                this.list.setSelectedIndex(this.listModel.size() - 1);
            }
        }
        this.removeButton.setEnabled(this.listModel.size() > 0);
        this.tab.setEnabled(this.listModel.size() > 0);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.list.getSelectedIndex();
        if (n == -1) {
            this.tab.itemChangedEvent("");
            return;
        }
        if (n < this.listModel.size()) {
            String string = (String)this.listModel.elementAt(n);
            this.tab.itemChangedEvent(string);
        } else {
            this.tab.itemChangedEvent("");
        }
    }

    public String getSelectedItem() {
        int n = this.list.getSelectedIndex();
        if (n == -1 || this.listModel.size() == 0) {
            return "";
        }
        return (String)this.listModel.elementAt(n);
    }

    public int getItemCount() {
        return this.listModel.getSize();
    }

    public void addElement(String string) {
        this.listModel.addElement(string);
        this.removeButton.setEnabled(this.listModel.size() > 0);
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public void setSelectedIndex(int n) {
        this.list.setSelectedIndex(n);
    }

    public String[] getAllItems() {
        String[] stringArray = new String[this.listModel.getSize()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)this.listModel.getElementAt(i);
        }
        return stringArray;
    }

    public boolean containsDuplicate(String string) {
        String[] stringArray = this.getAllItems();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            ++n;
        }
        return n >= 2;
    }

    public void removeAllElements() {
        this.listModel.removeAllElements();
        this.list.getSelectionModel().clearSelection();
    }

    public void enableButtons(boolean bl) {
        this.addButton.setEnabled(bl);
        this.removeButton.setEnabled(!bl ? false : this.listModel.size() > 0);
    }

    private String getUniqueName() {
        String string = "Unnamed";
        int n = 0;
        for (int i = 0; i < this.listModel.size(); ++i) {
            int n2;
            String string2 = (String)this.listModel.elementAt(i);
            if (string2.equals("Unnamed")) {
                n = 1;
                continue;
            }
            if (!string2.startsWith("Unnamed") || (n2 = TMStringUtil.str2int((String)string2.substring(8, string2.length() - 1))) < n) continue;
            n = n2 + 1;
        }
        if (n != 0) {
            string = string + "(" + n + ")";
        }
        return string;
    }

    public void updateSelectedItemText(String string) {
        int n = this.list.getSelectedIndex();
        this.listModel.setElementAt(string, n);
        this.list.removeListSelectionListener(this);
        this.list.setSelectedIndex(n);
        this.list.addListSelectionListener(this);
    }
}

