/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.objects;

import com.mathworks.toolbox.instrument.AdaptorInfo;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.browser.interfaceobj.CommunicationPage;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.util.Hashtable;

public abstract class BrowserObject {
    protected static Hashtable<String, String> vendors;
    private static final String[] BYTEORDER;
    public static final String[] EOSMODE;
    public String byteOrder = "littleEndian";
    public int inputBufferSize = 512;
    public int outputBufferSize = 512;
    public double timeout = 10.0;
    public boolean useVISA = false;
    public String identification;
    public String scanDate;
    protected Instrument instrumentObject;
    protected CommunicationPage panel;

    public abstract String[] getHeadingInfoColumnOne();

    public abstract String getType();

    public abstract String getDescriptiveText();

    public BrowserObject(String string, String string2) {
        this.identification = string;
        this.scanDate = string2;
    }

    public void dispose() {
        this.instrumentObject = null;
        this.panel = null;
    }

    public void setIdentification(String string) {
        this.identification = string;
        this.panel.setIdentification(this.identification);
        if (this.instrumentObject != null) {
            this.instrumentObject.setIdentificationLabel(this.identification);
        }
    }

    public String getIdentification() {
        return this.identification;
    }

    public void setScanDate(String string) {
        this.scanDate = string;
    }

    public String getScanDate() {
        return this.scanDate;
    }

    public boolean createVISAObject() {
        return this.useVISA;
    }

    public void setUseVISA(boolean bl) {
        this.useVISA = bl;
    }

    public void setInstrumentObject(Instrument instrument) {
        this.instrumentObject = instrument;
        if (this.instrumentObject != null) {
            this.instrumentObject.setIdentificationLabel(this.identification);
        }
    }

    public Instrument getInstrumentObject() {
        return this.instrumentObject;
    }

    public void setPanel(CommunicationPage communicationPage) {
        this.panel = communicationPage;
    }

    public CommunicationPage getPanel() {
        return this.panel;
    }

    public boolean str2bool(String string) {
        return string.equals("on");
    }

    public int getIndex(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return i;
        }
        return -1;
    }

    public void setByteOrder(String string) {
        if (this.instrumentObject == null) {
            this.byteOrder = string;
            return;
        }
        try {
            this.instrumentObject.setByteOrder(this.getIndex(BYTEORDER, string));
            this.byteOrder = string;
        }
        catch (Exception exception) {
            TMStringUtil.error((String)"Error Setting ByteOrder", (String)exception.getMessage());
        }
    }

    public String getByteOrder() {
        return this.byteOrder;
    }

    public void setInputBufferSize(int n) throws TMException {
        if (n <= 0) {
            return;
        }
        if (this.instrumentObject == null) {
            this.inputBufferSize = n;
            return;
        }
        try {
            this.instrumentObject.setInputBufferSize(n);
            this.inputBufferSize = n;
        }
        catch (TMException tMException) {
            TMStringUtil.error((String)"Error Setting InputBufferSize", (String)tMException.getMessage());
        }
        this.instrumentObject.postPropertyChangedEvent("InputBufferSize", new Integer(n));
    }

    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    public void setOutputBufferSize(int n) {
        if (n <= 0) {
            return;
        }
        if (this.instrumentObject == null) {
            this.outputBufferSize = n;
            return;
        }
        try {
            this.instrumentObject.setOutputBufferSize(n);
            this.outputBufferSize = n;
        }
        catch (TMException tMException) {
            TMStringUtil.error((String)"Error Setting OutputBufferSize", (String)tMException.getMessage());
        }
        this.instrumentObject.postPropertyChangedEvent("OutputBufferSize", new Integer(n));
    }

    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public void setTimeout(double d) {
        if (d < 0.0) {
            return;
        }
        if (this.instrumentObject == null) {
            this.timeout = d;
            return;
        }
        try {
            this.instrumentObject.setTimeout(d);
            this.timeout = d;
        }
        catch (TMException tMException) {
            TMStringUtil.error((String)"Error Setting Timeout", (String)tMException.getMessage());
        }
    }

    public double getTimeout() {
        if (this.instrumentObject == null) {
            return this.timeout;
        }
        return this.instrumentObject.getTimeout();
    }

    protected String getVendor(String string) {
        return vendors.get(string.toLowerCase());
    }

    static {
        int n;
        vendors = new Hashtable();
        for (n = 0; n < AdaptorInfo.GPIB_VENDORS.length; ++n) {
            vendors.put(AdaptorInfo.GPIB_VENDORS[n], AdaptorInfo.GPIB_NAMES[n]);
        }
        for (n = 0; n < AdaptorInfo.VISA_VENDORS.length; ++n) {
            vendors.put(AdaptorInfo.VISA_VENDORS[n], AdaptorInfo.VISA_NAMES[n]);
        }
        BYTEORDER = new String[]{"littleEndian", "bigEndian"};
        EOSMODE = new String[]{"none", "read", "write", "read&write"};
    }
}

