/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.drivers.xml;

import com.mathworks.toolbox.instrument.device.Device;
import com.mathworks.toolbox.instrument.device.PropertyInfo;
import com.mathworks.toolbox.instrument.device.drivers.xml.MethodDefinition;
import com.mathworks.toolbox.instrument.device.drivers.xml.ParserErrorHandler;
import com.mathworks.toolbox.instrument.device.drivers.xml.PropertyGroupDefinition;
import com.mathworks.toolbox.instrument.device.drivers.xml.property.PropertyConstraint;
import com.mathworks.toolbox.instrument.device.drivers.xml.property.PropertyDefinition;
import com.mathworks.toolbox.instrument.device.icdevice.ICDevice;
import com.mathworks.toolbox.instrument.device.icdevice.ICDeviceChild;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Parser {
    public static final int MCODE = 0;
    public static final int INSTRUMENT_COMMANDS = 1;
    public static final String OLD_MID = "MATLAB interface driver";
    protected boolean warnState = true;
    protected String logicalName;
    private Node root = null;
    private String fileVersion;
    private String instrumentType;
    private String instrumentModel;
    private String instrumentManufacturer;
    private String instrumentVersion;
    private String driverType;
    private int driverTypeId;
    private String driverName;
    private Vector<String> initConnectCodeVector = new Vector();
    private String initConnectCodeToEvaluate;
    private String initCreateCodeToEvaluate;
    private int connectInitCodeType = 0;
    private Vector<String> cleanupCodeVector = new Vector();
    private String cleanupCodeToEvaluate;
    private int cleanupCodeType = 0;
    private String identify = "";
    private String reset = "";
    private String selftest = "";
    private String error = "";
    private Vector<Object> capabilityGroups = new Vector();
    private Hashtable<String, Vector<String>> propertyNames = new Hashtable();
    private Hashtable<String, Vector<String>> capabilityGroupsAndProperties = new Hashtable();
    private Hashtable<Object, PropertyDefinition> propertyInfo = new Hashtable();
    private Hashtable<String, Vector<String>> methodNames = new Hashtable();
    private Hashtable<String, Vector<String>> capabilityGroupsAndMethods = new Hashtable();
    private Hashtable<Object, MethodDefinition> methodInfo = new Hashtable();
    private Vector<String> propertyGroups = null;
    private Hashtable<String, PropertyGroupDefinition> groups = new Hashtable();

    public Parser(String string) {
        this.logicalName = string;
    }

    public Parser(Document document) {
        this.root = document.getFirstChild();
    }

    public void dispose() {
        this.root = null;
        this.propertyNames = null;
        this.propertyInfo = null;
        this.methodNames = null;
        this.methodInfo = null;
        this.groups = null;
        this.capabilityGroupsAndProperties = null;
        this.capabilityGroupsAndMethods = null;
    }

    public void setWarnState(boolean bl) {
        this.warnState = bl;
    }

    protected void findRootNode() throws TMException {
        if (this.root == null) {
            this.getRoot();
        }
        if (this.root == null) {
            TMStringUtil.error((String)("The MATLAB instrument driver file: " + this.logicalName + " could not be parsed."));
            return;
        }
    }

    public String parseForDriverTypeDisplayName() throws TMException {
        if (this.root != null) {
            return this.getDriverDisplayType();
        }
        this.findRootNode();
        NodeList nodeList = this.root.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string = nodeList.item(i).getNodeName();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            if (!string.equals("DriverType")) continue;
            this.setDriverType(nodeList2.item(0).getNodeValue());
        }
        this.root = null;
        return Device.DRIVER_TYPE_NAMES[this.driverTypeId];
    }

    public void parse() throws TMException {
        this.findRootNode();
        NodeList nodeList = this.root.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string = nodeList.item(i).getNodeName();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            if (nodeList2.getLength() == 0) continue;
            if (string.equals("CreateInitCode")) {
                this.parseCreateInitCode(nodeList.item(i));
                continue;
            }
            if (string.equals("ConnectInitCode")) {
                this.parseConnectInitCode(nodeList.item(i));
                continue;
            }
            if (string.equals("CleanupCode")) {
                this.parseCleanupCode(nodeList.item(i));
                continue;
            }
            if (string.equals("FileVersion")) {
                this.fileVersion = nodeList2.item(0).getNodeValue();
                continue;
            }
            if (string.equals("InstrumentType")) {
                this.instrumentType = nodeList2.item(0).getNodeValue();
                continue;
            }
            if (string.equals("InstrumentModel")) {
                this.instrumentModel = nodeList2.item(0).getNodeValue();
                continue;
            }
            if (string.equals("InstrumentManufacturer")) {
                this.instrumentManufacturer = nodeList2.item(0).getNodeValue();
                continue;
            }
            if (string.equals("InstrumentVersion")) {
                this.instrumentVersion = nodeList2.item(0).getNodeValue();
                continue;
            }
            if (string.equals("DriverType")) {
                this.setDriverType(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (string.equals("DriverName")) {
                this.driverName = nodeList2.item(0).getNodeValue();
                continue;
            }
            if (string.equals("Identify")) {
                this.identify = nodeList2.item(0).getNodeValue();
                continue;
            }
            if (string.equals("Reset")) {
                this.reset = nodeList2.item(0).getNodeValue();
                continue;
            }
            if (string.equals("Selftest")) {
                this.selftest = nodeList2.item(0).getNodeValue();
                continue;
            }
            if (string.equals("Error")) {
                this.error = nodeList2.item(0).getNodeValue();
                continue;
            }
            if (!string.equals("GroupInfo")) continue;
            this.parseGroupInformation(nodeList.item(i));
        }
        this.verifyGroupNames();
        this.verifyGroupObjectProperties();
        this.verifyDeviceObjectProperties();
    }

    private void verifyGroupNames() {
        int n;
        Vector<String> vector = this.getProperties("parent");
        if (vector == null) {
            return;
        }
        Vector<String> vector2 = this.getPropertyGroups();
        if (vector2 == null || vector2.size() == 0) {
            return;
        }
        Vector<String> vector3 = new Vector<String>();
        for (int i = 0; i < vector.size(); ++i) {
            if (!vector2.contains(vector.elementAt(i))) continue;
            vector3.addElement(vector.elementAt(i));
        }
        String[] stringArray = ICDevice.BASE_PROPS;
        for (n = 0; n < stringArray.length; ++n) {
            if (!vector2.contains(stringArray[n])) continue;
            vector3.addElement(stringArray[n]);
        }
        for (n = 0; n < vector3.size(); ++n) {
            if (this.warnState) {
                TMStringUtil.warning((String)("Duplicate property name: " + (String)vector3.elementAt(n) + ". Only one of the properties will be added to the object."));
            }
            vector.remove(vector3.elementAt(n));
        }
        this.propertyNames.put("parent", vector);
    }

    private void verifyGroupObjectProperties() {
        Vector<String> vector = this.getPropertyGroups();
        if (vector == null || vector.size() == 0) {
            return;
        }
        String[] stringArray = ICDeviceChild.BASE_PROPS;
        for (int i = 0; i < vector.size(); ++i) {
            int n;
            Vector<String> vector2 = this.getProperties(vector.elementAt(i));
            if (vector2 == null || vector2.size() <= 0) continue;
            Vector<String> vector3 = new Vector<String>();
            for (n = 0; n < stringArray.length; ++n) {
                if (!vector2.contains(stringArray[n])) continue;
                vector3.addElement(stringArray[n]);
            }
            for (n = 0; n < vector3.size(); ++n) {
                if (((String)vector3.elementAt(n)).equalsIgnoreCase("type")) continue;
                if (this.warnState) {
                    TMStringUtil.warning((String)("The " + vector.elementAt(i) + " group object contains a duplicate property: " + (String)vector3.elementAt(n) + "." + TMStringUtil.LINESEP + "Only one of the properties will be added to the object."));
                }
                vector2.remove(vector3.elementAt(n));
            }
            this.propertyNames.put(vector.elementAt(i), vector2);
        }
    }

    private void verifyDeviceObjectProperties() {
        int n;
        Vector<String> vector = this.getProperties("parent");
        if (vector == null) {
            return;
        }
        String[] stringArray = ICDevice.BASE_PROPS;
        Vector<String> vector2 = new Vector<String>();
        for (n = 0; n < stringArray.length; ++n) {
            if (!vector.contains(stringArray[n])) continue;
            vector2.addElement(stringArray[n]);
        }
        for (n = 0; n < vector2.size(); ++n) {
            if (this.warnState) {
                TMStringUtil.warning((String)("Duplicate property name: " + (String)vector2.elementAt(n) + ". Only one of the properties will be added to the object."));
            }
            vector.remove(vector2.elementAt(n));
        }
        this.propertyNames.put("parent", vector);
    }

    private void parseCreateInitCode(Node node) {
        NodeList nodeList = node.getChildNodes();
        this.initCreateCodeToEvaluate = this.findNodeValue(nodeList, "Code");
    }

    private void parseConnectInitCode(Node node) {
        NodeList nodeList = node.getChildNodes();
        String string = this.findNodeValue(nodeList, "Type");
        if (string.equals("MCode")) {
            this.initConnectCodeToEvaluate = this.findNodeValue(nodeList, "Code");
            this.connectInitCodeType = 0;
            return;
        }
        this.connectInitCodeType = 1;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string2 = nodeList.item(i).getNodeName();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            if (nodeList2.getLength() == 0 || !string2.equals("Code")) continue;
            this.initConnectCodeVector.addElement(nodeList2.item(0).getNodeValue());
        }
    }

    private void parseCleanupCode(Node node) {
        NodeList nodeList = node.getChildNodes();
        String string = this.findNodeValue(nodeList, "Type");
        if (string.equals("MCode")) {
            this.cleanupCodeToEvaluate = this.findNodeValue(nodeList, "Code");
            this.cleanupCodeType = 0;
            return;
        }
        this.cleanupCodeType = 1;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string2 = nodeList.item(i).getNodeName();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            if (nodeList2.getLength() == 0 || !string2.equals("Code")) continue;
            this.cleanupCodeVector.addElement(nodeList2.item(0).getNodeValue());
        }
    }

    private void parseGroupInformation(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string = nodeList.item(i).getNodeName();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            if (nodeList2.getLength() == 0 || !string.equals("Group")) continue;
            this.parseGroup(nodeList.item(i));
        }
    }

    private void parseGroup(Node node) {
        NodeList nodeList = node.getChildNodes();
        String string = this.findNodeValue(nodeList, "Name");
        String string2 = this.findNodeValue(nodeList, "Size");
        if (!TMStringUtil.ispropertyname((String)string)) {
            if (this.warnState) {
                TMStringUtil.warning((String)("Invalid group name: " + string + ". This property will not be added to the object."));
            }
            return;
        }
        int n = 1;
        try {
            n = Integer.valueOf(string2);
            if (n <= 0) {
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        PropertyGroupDefinition propertyGroupDefinition = new PropertyGroupDefinition(string);
        propertyGroupDefinition.setSize(n);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string3 = nodeList.item(i).getNodeName();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            if (nodeList2.getLength() == 0) continue;
            if (string3.equals("Description")) {
                propertyGroupDefinition.setDescription(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (string3.equals("Command")) {
                propertyGroupDefinition.setCommand(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (string3.equals("Mappings")) {
                this.parseGroupMappings(propertyGroupDefinition, nodeList.item(i));
                continue;
            }
            if (string3.equals("PropertyInfo")) {
                this.parsePropertyInformation(nodeList.item(i));
                continue;
            }
            if (!string3.equals("MethodInfo")) continue;
            this.parseMethodInformation(nodeList.item(i));
        }
        if (!string.toLowerCase().equals("parent")) {
            this.groups.put(string.toLowerCase(), propertyGroupDefinition);
        }
    }

    private void parseGroupMappings(PropertyGroupDefinition propertyGroupDefinition, Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string = nodeList.item(i).getNodeName();
            if (!string.equals("ChannelMap")) continue;
            String string2 = ((Element)nodeList.item(i)).getAttribute("Index");
            String string3 = ((Element)nodeList.item(i)).getAttribute("Command");
            propertyGroupDefinition.addMapping(string2, string3);
        }
    }

    private void parsePropertyInformation(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string = nodeList.item(i).getNodeName();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            if (nodeList2.getLength() == 0 || !string.equals("Property")) continue;
            this.parseProperty(nodeList.item(i));
        }
    }

    private void parseProperty(Node node) {
        NodeList nodeList = node.getChildNodes();
        String string = this.findNodeValue(nodeList, "Name");
        if (!TMStringUtil.ispropertyname((String)string)) {
            if (this.warnState) {
                TMStringUtil.warning((String)("Invalid property name: " + string + ". This property will not be added to the object."));
            }
            return;
        }
        String string2 = this.findNodeValue(nodeList, "Location").toLowerCase();
        Vector<String> vector = this.getProperties(string2);
        if (vector != null && vector.contains(string)) {
            if (this.warnState) {
                TMStringUtil.warning((String)("Duplicate property name: " + string + ". The duplicate property will not be " + TMStringUtil.LINESEP + "added to the object."));
            }
            return;
        }
        String string3 = this.findNodeValue(nodeList, "CapabilityGroup");
        this.add(this.capabilityGroups, string3);
        this.add(this.capabilityGroupsAndProperties, string3, string);
        this.add(this.propertyNames, string2, string);
        PropertyDefinition propertyDefinition = new PropertyDefinition(string, string3);
        propertyDefinition.setLocation(string2);
        String string4 = this.findNodeValue(nodeList, "Type");
        propertyDefinition.setTypeOfProperty(string4);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string5 = nodeList.item(i).getNodeName();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            if (nodeList2.getLength() == 0) continue;
            if (string5.equals("Code")) {
                if (propertyDefinition.getTypeOfProperty().toLowerCase().equals("mcode")) {
                    this.parseMCodeProperty(propertyDefinition, nodeList.item(i));
                    continue;
                }
                this.parseInstrumentCommandProperty(propertyDefinition, nodeList.item(i));
                continue;
            }
            if (string5.equals("ReadOnly")) {
                propertyDefinition.setReadOnly(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (string5.equals("DefaultValue")) {
                propertyDefinition.setDefaultValue(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (string5.equals("Description")) {
                propertyDefinition.setDescription(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (!string5.equals("PermissibleType")) continue;
            this.parseType(propertyDefinition, nodeList.item(i));
        }
        propertyDefinition.setCurrentValue(propertyDefinition.getOutputValue((String)propertyDefinition.getDefaultValue()));
        propertyDefinition.definePropInfoFields();
        this.propertyInfo.put(string + "-" + string2, propertyDefinition);
    }

    private void parseMCodeProperty(PropertyDefinition propertyDefinition, Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string = nodeList.item(i).getNodeName();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            if (nodeList2.getLength() == 0) continue;
            if (string.equals("SetMCode")) {
                propertyDefinition.setSetMCodeToEvaluate(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (!string.equals("GetMCode")) continue;
            propertyDefinition.setGetMCodeToEvaluate(nodeList2.item(0).getNodeValue());
        }
    }

    private void parseInstrumentCommandProperty(PropertyDefinition propertyDefinition, Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string = nodeList.item(i).getNodeName();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            if (nodeList2.getLength() == 0 || !string.equals("Commands")) continue;
            this.parsePropertyCode(propertyDefinition, nodeList.item(i));
        }
    }

    private void parsePropertyCode(PropertyDefinition propertyDefinition, Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string = nodeList.item(i).getNodeName();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            if (nodeList2.getLength() == 0) continue;
            if (string.equals("ConfigureCommand")) {
                propertyDefinition.setConfigureCommand(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (!string.equals("QueryCommand")) continue;
            propertyDefinition.setQueryCommand(nodeList2.item(0).getNodeValue());
        }
    }

    private void parseType(PropertyDefinition propertyDefinition, Node node) {
        NodeList nodeList = node.getChildNodes();
        String string = this.findNodeValue(nodeList, "Type");
        String string2 = this.findNodeValue(nodeList, "Constraint");
        PropertyConstraint propertyConstraint = propertyDefinition.createConstraint(string, string2);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string3 = nodeList.item(i).getNodeName();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            if (nodeList2.getLength() == 0) continue;
            if (string3.equals("DependentProperty")) {
                propertyConstraint.setDependentPropertyName(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (string3.equals("DependentPropertyValue")) {
                propertyConstraint.setDependentPropertyValue(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (string3.equals("DependentPropertyLocation")) {
                propertyConstraint.setDependentPropertyLocation(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (!string3.equals("ConstraintValue")) continue;
            this.parseConstraintValue(propertyConstraint, nodeList.item(i));
        }
    }

    private void parseConstraintValue(PropertyConstraint propertyConstraint, Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            String string2;
            String string3 = nodeList.item(i).getNodeName();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            if (string3.equals("Range")) {
                string2 = ((Element)nodeList.item(i)).getAttribute("Min");
                string = ((Element)nodeList.item(i)).getAttribute("Max");
                propertyConstraint.setRange(string2, string);
                continue;
            }
            if (string3.equals("Enum")) {
                string2 = ((Element)nodeList.item(i)).getAttribute("Name");
                string = ((Element)nodeList.item(i)).getAttribute("Value");
                propertyConstraint.addEnumPair(string2, string);
                continue;
            }
            if (!string3.equals("Value")) continue;
            propertyConstraint.addValue(nodeList2.item(0).getNodeValue());
        }
    }

    private void parseMethodInformation(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string = nodeList.item(i).getNodeName();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            if (nodeList2.getLength() == 0 || !string.equals("Method")) continue;
            this.parseMethod(nodeList.item(i));
        }
    }

    private void parseMethod(Node node) {
        NodeList nodeList = node.getChildNodes();
        String string = this.findNodeValue(nodeList, "Name");
        if (!TMStringUtil.ismethodname((String)(string = this.genMethodname(string)))) {
            if (this.warnState) {
                TMStringUtil.warning((String)("Invalid method name: " + string + ". This method will not be added to the object."));
            }
            return;
        }
        String string2 = this.findNodeValue(nodeList, "Location").toLowerCase();
        Vector<String> vector = this.getMethods(string2);
        if (vector != null && vector.contains(string)) {
            if (this.warnState) {
                TMStringUtil.warning((String)("Duplicate method name: " + string + ". The duplicate method will not be " + TMStringUtil.LINESEP + "added to the object."));
            }
            return;
        }
        String string3 = this.findNodeValue(nodeList, "CapabilityGroup");
        this.add(this.capabilityGroups, string3);
        this.add(this.capabilityGroupsAndMethods, string3, string);
        this.add(this.methodNames, string2, string);
        String string4 = this.findNodeValue(nodeList, "Type");
        if (string4.equals("")) {
            string4 = "InstrumentCommand";
        }
        MethodDefinition methodDefinition = new MethodDefinition(string, string3);
        methodDefinition.setType(string4);
        methodDefinition.setLocation(string2);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string5 = nodeList.item(i).getNodeName();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            if (nodeList2.getLength() == 0) continue;
            if (string5.equals("Code")) {
                if (string4.equals("MCode")) {
                    this.parseMCodeMethod(methodDefinition, nodeList.item(i));
                    continue;
                }
                this.parseInstrumentCommandMethod(methodDefinition, nodeList.item(i));
                continue;
            }
            if (!string5.equals("Description")) continue;
            methodDefinition.setDescription(nodeList2.item(0).getNodeValue());
        }
        this.methodInfo.put(string.toLowerCase() + "-" + string2, methodDefinition);
    }

    public String genMethodname(String string) {
        String string2;
        if (string == null) {
            return "x";
        }
        String string3 = string.trim().replaceAll("\\W+", "");
        if (string3.length() > 0) {
            char c = string3.charAt(0);
            if (Character.isDigit(c)) {
                string3 = "x" + string3;
            }
            string2 = string3;
        } else {
            string2 = "x";
        }
        if (!TMStringUtil.ismethodname((String)string2)) {
            string2 = string2 + "_x";
        }
        return string2;
    }

    private void parseMCodeMethod(MethodDefinition methodDefinition, Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string = nodeList.item(i).getNodeName();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            if (nodeList2.getLength() == 0 || !string.equals("MCode")) continue;
            methodDefinition.setMCodeToEvaluate(nodeList2.item(0).getNodeValue());
        }
    }

    private void parseInstrumentCommandMethod(MethodDefinition methodDefinition, Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string = nodeList.item(i).getNodeName();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            if (nodeList2.getLength() == 0 || !string.equals("Commands")) continue;
            this.parseMethodCode(methodDefinition, nodeList.item(i));
        }
    }

    private void parseMethodCode(MethodDefinition methodDefinition, Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string = nodeList.item(i).getNodeName();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            if (string.equals("Line")) {
                String string2 = ((Element)nodeList.item(i)).getAttribute("Command");
                String string3 = ((Element)nodeList.item(i)).getAttribute("Output");
                String string4 = ((Element)nodeList.item(i)).getAttribute("ReadOutputAs");
                String string5 = ((Element)nodeList.item(i)).getAttribute("Format");
                if (string4.equals("") && string5.equals("")) {
                    string4 = "ascii";
                    string5 = "text";
                }
                methodDefinition.addLineOfCode(string2, string3, string4, string5);
                continue;
            }
            if (!string.equals("Input")) continue;
            methodDefinition.addInput(nodeList2.item(0).getNodeValue());
        }
    }

    private String findNodeValue(NodeList nodeList, String string) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string2 = nodeList.item(i).getNodeName();
            if (!string2.equals(string)) continue;
            return nodeList.item(i).getChildNodes().item(0).getNodeValue();
        }
        return "";
    }

    private void add(Hashtable<String, Vector<String>> hashtable, String string, String string2) {
        if (!hashtable.containsKey(string)) {
            Vector<String> vector = new Vector<String>();
            vector.addElement(string2);
            hashtable.put(string, vector);
            return;
        }
        Vector<String> vector = hashtable.get(string);
        vector.addElement(string2);
    }

    public Vector<String> getPropertyGroups() {
        if (this.propertyGroups != null) {
            return this.propertyGroups;
        }
        this.propertyGroups = new Vector();
        Enumeration<String> enumeration = this.groups.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            this.propertyGroups.addElement(this.formatPropertyGroupName(string));
        }
        return this.propertyGroups;
    }

    public boolean isPropertyGroup(String string) {
        if (this.propertyGroups == null) {
            this.getPropertyGroups();
        }
        return this.propertyGroups.contains(this.formatPropertyGroupName(string));
    }

    private String formatPropertyGroupName(String string) {
        string = string.toLowerCase();
        string = string.substring(0, 1).toUpperCase() + string.substring(1);
        return string;
    }

    public static Document getDocument(String string) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setIgnoringElementContentWhitespace(false);
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println("Could not create document builder: " + parserConfigurationException.getMessage());
            return null;
        }
        Document document = null;
        try {
            document = documentBuilder.parse(new File(string));
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            return null;
        }
        return document;
    }

    private void getRoot() {
        try {
            File file = new File(this.logicalName);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new ParserErrorHandler());
            Document document = documentBuilder.parse(file);
            this.root = document.getFirstChild();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void add(Vector<Object> vector, Object object) {
        if (!vector.contains(object)) {
            vector.addElement(object);
        }
    }

    public Vector<Object> getCapabilityGroups() {
        return this.capabilityGroups;
    }

    public Vector<String> getCapabilityGroupProperties(String string) {
        return this.capabilityGroupsAndProperties.get(string);
    }

    public Vector<String> getCapabilityGroupMethods(String string) {
        return this.capabilityGroupsAndMethods.get(string);
    }

    public Vector<String> getProperties(String string) {
        return this.propertyNames.get(string.toLowerCase());
    }

    public PropertyInfo getPropertyInformation(String string, String string2) {
        return this.propertyInfo.get(string + "-" + string2.toLowerCase());
    }

    public int getPropertyType(String string, String string2) {
        PropertyDefinition propertyDefinition = (PropertyDefinition)this.getPropertyInformation(string, string2);
        if (propertyDefinition.getTypeOfProperty().toLowerCase().equals("mcode")) {
            return 0;
        }
        return 1;
    }

    public MethodDefinition getMethodDefinition(String string, String string2) {
        return this.methodInfo.get(string.toLowerCase() + "-" + string2.toLowerCase());
    }

    public MethodDefinition getMethodDefinition(String string) {
        return this.methodInfo.get(string.toLowerCase() + "-parent");
    }

    public int getMethodType(String string, String string2) {
        MethodDefinition methodDefinition = this.getMethodDefinition(string, string2);
        if (methodDefinition.getType().toLowerCase().equals("mcode")) {
            return 0;
        }
        return 1;
    }

    public Vector<String> getMethods(String string) {
        return this.methodNames.get(string.toLowerCase());
    }

    public String getGroupConfigureCommand(String string) {
        return this.groups.get(string.toLowerCase()).getCommand();
    }

    public String getGroupDescription(String string) {
        PropertyGroupDefinition propertyGroupDefinition = this.groups.get(string.toLowerCase());
        if (propertyGroupDefinition == null) {
            return "";
        }
        return propertyGroupDefinition.getDescription();
    }

    public void setGroupDescription(String string, String string2) {
        PropertyGroupDefinition propertyGroupDefinition = this.groups.get(string.toLowerCase());
        if (propertyGroupDefinition == null) {
            return;
        }
        propertyGroupDefinition.setDescription(string2);
    }

    public String getGroupConfigureCommand(String string, int n) {
        PropertyGroupDefinition propertyGroupDefinition = this.groups.get(string.toLowerCase());
        if (propertyGroupDefinition == null) {
            return "";
        }
        String string2 = propertyGroupDefinition.getCommand();
        if (string2.equals("")) {
            return string2;
        }
        Hashtable<Integer, String> hashtable = propertyGroupDefinition.getMappings();
        if (hashtable.size() == 0) {
            return string2;
        }
        String string3 = hashtable.get(new Integer(n));
        if (string3 == null) {
            return string2;
        }
        return TMStringUtil.strrep((String)string2, (String)"<ID>", (String)string3);
    }

    public String substituteMappingInCommand(String string, String string2, int n) {
        PropertyGroupDefinition propertyGroupDefinition = this.groups.get(string.toLowerCase());
        if (propertyGroupDefinition == null) {
            return string2;
        }
        Hashtable<Integer, String> hashtable = propertyGroupDefinition.getMappings();
        if (hashtable.size() == 0) {
            return string2;
        }
        String string3 = hashtable.get(new Integer(n));
        if (string3 == null) {
            return string2;
        }
        return TMStringUtil.strrep((String)string2, (String)"<ID>", (String)string3);
    }

    public String getGroupCommandNameAt(String string, int n) {
        PropertyGroupDefinition propertyGroupDefinition = this.groups.get(string.toLowerCase());
        if (propertyGroupDefinition == null) {
            return "";
        }
        Hashtable<Integer, String> hashtable = propertyGroupDefinition.getMappings();
        if (hashtable == null || hashtable.size() == 0) {
            return "";
        }
        return hashtable.get(new Integer(n));
    }

    public Hashtable<Integer, String> getGroupMappings(String string) {
        PropertyGroupDefinition propertyGroupDefinition = this.groups.get(string.toLowerCase());
        if (propertyGroupDefinition == null) {
            return null;
        }
        return propertyGroupDefinition.getMappings();
    }

    public int getGroupSize(String string) {
        PropertyGroupDefinition propertyGroupDefinition = this.groups.get(string.toLowerCase());
        if (propertyGroupDefinition == null) {
            return 0;
        }
        return propertyGroupDefinition.getSize();
    }

    public void setGroupSize(String string, int n) {
        PropertyGroupDefinition propertyGroupDefinition = this.groups.get(string.toLowerCase());
        if (propertyGroupDefinition == null) {
            return;
        }
        propertyGroupDefinition.setSize(n);
    }

    public void setGroupObjectName(String string, int n, String string2) {
        PropertyGroupDefinition propertyGroupDefinition = this.groups.get(string.toLowerCase());
        propertyGroupDefinition.addMapping(String.valueOf(n), string2);
    }

    public String findLocationOfProperty(String string) {
        Vector<String> vector = this.getProperties("parent");
        if (vector != null && vector.contains(string)) {
            return "parent";
        }
        Vector<String> vector2 = this.getPropertyGroups();
        for (int i = 0; i < vector2.size(); ++i) {
            String string2 = vector2.elementAt(i);
            vector = this.getProperties(string2);
            if (vector == null || !vector.contains(string)) continue;
            return string2;
        }
        return "";
    }

    public String getFileVersion() {
        return this.fileVersion;
    }

    public String getDriverType() {
        return this.driverType;
    }

    public String getDriverDisplayType() {
        return Device.DRIVER_TYPE_DISPLAY_NAMES[this.driverTypeId];
    }

    protected void setDriverType(String string) {
        this.driverType = string;
        if (this.driverType.equals(OLD_MID)) {
            this.driverType = Device.DRIVER_TYPE_NAMES[0];
        }
        if (this.driverType.equals(Device.DRIVER_TYPE_NAMES[0])) {
            this.driverTypeId = 0;
        } else if (this.driverType.equals(Device.DRIVER_TYPE_NAMES[1])) {
            this.driverTypeId = 1;
        } else if (this.driverType.equals(Device.DRIVER_TYPE_NAMES[2])) {
            this.driverTypeId = 2;
        } else if (this.driverType.equals(Device.DRIVER_TYPE_NAMES[3])) {
            this.driverTypeId = 3;
        } else if (this.driverType.equals(Device.DRIVER_TYPE_NAMES[4])) {
            this.driverTypeId = 4;
        } else if (this.driverType.equals(Device.DRIVER_TYPE_NAMES[7])) {
            this.driverTypeId = 7;
        }
    }

    public int getDriverTypeId() {
        return this.driverTypeId;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getErrorCommand() {
        return this.error;
    }

    public String getIdentifyCommand() {
        return this.identify;
    }

    public String getResetCommand() {
        return this.reset;
    }

    public String getSelfTestCommand() {
        return this.selftest;
    }

    public int getConnectInitCodeType() {
        return this.connectInitCodeType;
    }

    public Vector<String> getConnectInitVector() {
        return this.initConnectCodeVector;
    }

    public String getConnectInitializationCode() {
        return this.initConnectCodeToEvaluate;
    }

    public String getCreateInitializationCode() {
        return this.initCreateCodeToEvaluate;
    }

    public int getCleanupCodeType() {
        return this.cleanupCodeType;
    }

    public Vector<String> getCleanupVector() {
        return this.cleanupCodeVector;
    }

    public String getCleanupCode() {
        return this.cleanupCodeToEvaluate;
    }

    public String getInstrumentManufacturer() {
        return this.instrumentManufacturer;
    }

    public String getInstrumentModel() {
        return this.instrumentModel;
    }

    public String getInstrumentType() {
        return this.instrumentType;
    }

    public String getInstrumentVersion() {
        return this.instrumentVersion;
    }

    public String getLogicalName() {
        return this.logicalName;
    }
}

