/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtest.panel;

import com.mathworks.toolbox.instrument.device.drivers.xml.property.PropertyConstraint;
import com.mathworks.toolbox.instrument.device.drivers.xml.property.PropertyDefinition;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.MIDStepPanel;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.PropertyInfo;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.StepInfo;
import com.mathworks.toolbox.instrument.device.util.PropertyHelp;
import com.mathworks.toolbox.testmeas.guiutil.TMHelpViewer;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class PropertyPanel
extends MIDStepPanel
implements ListSelectionListener {
    protected static final int SET = 0;
    protected static final int GET = 1;
    protected static final String NO_HELP = "No help is defined for this property.";
    protected JList propertyToTest;
    protected JLabel objectToTestLabel;
    protected JComboBox objectToTest;
    protected ButtonGroup failActionButtonGroup;
    protected Vector<String> properties;
    protected int[] propertyLabelLocations;
    protected String[] propertyLabelNames;
    protected int numOfPropertyGroups = 0;
    protected int stepType = 0;
    protected long driverLastModified = 0L;
    protected boolean isEnabled = true;

    public abstract void setComponentsEnabled(boolean var1);

    public void setStepType(int n) {
        this.stepType = n;
    }

    @Override
    public void update(StepInfo stepInfo) {
        PropertyInfo propertyInfo = (PropertyInfo)stepInfo;
        this.propertyToTest.setSelectedIndex(propertyInfo.getPropertyToTest());
        try {
            this.objectToTest.setSelectedIndex(propertyInfo.getObjectToTest());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void cleanup(StepInfo stepInfo) {
        PropertyInfo propertyInfo = (PropertyInfo)stepInfo;
        propertyInfo.setPropertyToTest(this.propertyToTest.getSelectedIndex());
        propertyInfo.setObjectToTest(this.objectToTest.getSelectedIndex());
    }

    protected JPanel createPropertyToTestPanel() {
        JLabel jLabel = new JLabel("Property to test:");
        jLabel.setVerticalAlignment(1);
        this.propertyToTest = new JList();
        this.propertyToTest.setSelectionMode(0);
        this.propertyToTest.setListData(this.getPropertyListData());
        JScrollPane jScrollPane = new JScrollPane(this.propertyToTest);
        jScrollPane.setPreferredSize(new Dimension(70, 300));
        this.propertyToTest.addListSelectionListener(this);
        this.propertyToTest.setName("Property to test Listbox");
        if (this.propertyToTest.getModel().getSize() > 1) {
            this.propertyToTest.setSelectedIndex(1);
        }
        JPanel jPanel = new JPanel(new BorderLayout(0, 4));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    protected JPanel createObjectToTestPanel() {
        this.objectToTestLabel = new JLabel("Object(s) to test:");
        this.objectToTestLabel.setVerticalAlignment(1);
        this.objectToTest = new JComboBox();
        this.objectToTest.setName("Object to test Combobox");
        JPanel jPanel = new JPanel(new BorderLayout(0, 4));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        jPanel.add((Component)this.objectToTestLabel, "North");
        jPanel.add((Component)this.objectToTest, "Center");
        return jPanel;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting() || this.objectToTest == null) {
            return;
        }
        int n = this.propertyToTest.getSelectedIndex();
        if (this.isHeader(this.propertyLabelLocations, n)) {
            this.setComponentsEnabled(false);
            return;
        }
        this.setComponentsEnabled(true);
        String string = this.getProperty(n);
        String string2 = this.getSelectedPropertyGroup(n);
        this.updateObjectToTest(string2);
        this.updatePanel(string2, string);
    }

    public boolean isHeader(int n) {
        return this.isHeader(this.propertyLabelLocations, n);
    }

    public void updatePanel(String string, String string2) {
    }

    protected void updatePropertiesInListBox() {
        this.propertyToTest.removeListSelectionListener(this);
        this.propertyToTest.setListData(this.getPropertyListData());
        this.propertyToTest.addListSelectionListener(this);
    }

    private void updateObjectToTest(String string) {
        this.objectToTest.removeAllItems();
        if (string.equals("parent")) {
            this.objectToTest.addItem("Device object");
            return;
        }
        int n = this.getGroupSize(string);
        for (int i = 0; i < n; ++i) {
            this.objectToTest.addItem(this.getGroupCommandNameAt(string, i + 1));
        }
        this.objectToTest.addItem("All " + string + " group objects");
    }

    protected void showHelp() {
        int n = this.propertyToTest.getSelectedIndex();
        String string = this.getSelectedPropertyGroup(n);
        String string2 = this.getPropertyHelp(string, n);
        string2 = "<html>" + string2 + "</html>";
        TMHelpViewer tMHelpViewer = TMHelpViewer.getInstance();
        tMHelpViewer.update(string2, this.getProperty(n) + " Help");
        tMHelpViewer.addToFrame();
    }

    protected Vector<String> getPropertyListData() {
        if (this.getDriverDate() == this.driverLastModified) {
            return this.properties;
        }
        this.driverLastModified = this.getDriverDate();
        this.properties = new Vector();
        String[] stringArray = this.getGroupNames();
        this.propertyLabelLocations = new int[stringArray.length + 1];
        this.propertyLabelNames = new String[stringArray.length + 1];
        this.numOfPropertyGroups = 0;
        Vector<String> vector = this.getParser().getProperties("parent");
        Vector vector2 = vector == null ? new Vector() : (Vector)vector.clone();
        if (this.stepType == 1) {
            vector2.add("InstrumentModel");
        } else {
            vector2 = this.removeReadOnlyProperties(vector2, "parent");
        }
        vector2 = TMStringUtil.stringArray2Vector((String[])TMStringUtil.sort((String[])TMStringUtil.vector2StringArray(vector2)));
        this.addToVector(this.properties, vector2, "Device object properties:");
        this.propertyLabelNames[this.numOfPropertyGroups] = "parent";
        this.propertyLabelLocations[this.numOfPropertyGroups] = 0;
        ++this.numOfPropertyGroups;
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            int n2 = this.properties.size();
            String string = stringArray[i] + " group object properties:";
            Vector<String> vector3 = this.getParser().getProperties(stringArray[i]);
            if (vector3 == null) continue;
            vector3 = (Vector<String>)vector3.clone();
            if (this.stepType == 0) {
                vector3 = this.removeReadOnlyProperties(vector3, stringArray[i]);
            }
            if ((n = this.addToVector(this.properties, vector3, string)) == 0) continue;
            this.propertyLabelNames[this.numOfPropertyGroups] = stringArray[i];
            this.propertyLabelLocations[this.numOfPropertyGroups] = n2;
            ++this.numOfPropertyGroups;
        }
        return this.properties;
    }

    protected Vector<String> removeReadOnlyProperties(Vector<String> vector, String string) {
        Vector<String> vector2 = new Vector<String>();
        while (vector.size() > 0) {
            String string2 = vector.elementAt(0);
            PropertyDefinition propertyDefinition = (PropertyDefinition)this.getParser().getPropertyInformation(string2, string);
            if (!propertyDefinition.getReadOnly().equals("always")) {
                vector2.add(string2);
            }
            vector.removeElementAt(0);
        }
        return vector2;
    }

    protected int getPropertyIndex(String string, String string2) {
        for (int i = 0; i < this.numOfPropertyGroups; ++i) {
            String string3 = this.propertyLabelNames[i];
            if (!string2.equals(string3)) continue;
            ListModel listModel = this.propertyToTest.getModel();
            int n = this.propertyLabelLocations[i];
            int n2 = listModel.getSize();
            if (i != this.numOfPropertyGroups - 1) {
                n2 = this.propertyLabelLocations[i + 1];
            }
            string = "    " + string;
            for (int j = n; j < n2; ++j) {
                if (!string.equals(listModel.getElementAt(j))) continue;
                return j;
            }
            return -1;
        }
        return -1;
    }

    protected String getSelectedPropertyGroup(int n) {
        String string = this.propertyLabelNames[this.numOfPropertyGroups - 1];
        for (int i = 0; i < this.numOfPropertyGroups; ++i) {
            if (this.propertyLabelLocations[i] <= n) continue;
            string = this.propertyLabelNames[i - 1];
            break;
        }
        return string;
    }

    public String getProperty(int n) {
        String string = this.properties.elementAt(n);
        for (int i = 0; i < this.propertyLabelLocations.length; ++i) {
            if (n != this.propertyLabelLocations[i]) continue;
            return string;
        }
        return string.substring("    ".length());
    }

    public String getPropertyHelp(String string, int n) {
        String string2 = this.getProperty(n);
        if (string2.equals("InstrumentModel")) {
            return this.getInstrumentModelHelp();
        }
        String string3 = ((PropertyDefinition)this.getParser().getPropertyInformation(string2, string)).getDescription();
        string3 = string3 == null || string3.equals("") ? NO_HELP : this.updateHtml(string3);
        return string3;
    }

    public boolean isPropertyHelpDefined(String string, int n) {
        String string2 = this.getPropertyHelp(string, n);
        return !string2.equals(NO_HELP);
    }

    public PropertyConstraint[] getPropertyConstraints(String string, String string2) {
        PropertyDefinition propertyDefinition = (PropertyDefinition)this.getParser().getPropertyInformation(string2, string);
        return propertyDefinition.getValidConstraints(this.getParser());
    }

    public boolean isDefaultValueDefined(String string, int n) {
        String string2 = this.getProperty(n);
        if (string2.equals("InstrumentModel")) {
            return true;
        }
        Object object = ((PropertyDefinition)this.getParser().getPropertyInformation(string2, string)).getDriverDefinedDefalutValue();
        return object != null;
    }

    private String getInstrumentModelHelp() {
        try {
            return PropertyHelp.getHelp("InstrumentModel");
        }
        catch (TMException tMException) {
            return "";
        }
    }

    public String formatPropertyValue(String string) {
        if (TMStringUtil.isnumeric((String)string)) {
            return string;
        }
        if (TMStringUtil.isdouble((String)string)) {
            return string;
        }
        if (this.isScientificDouble(string)) {
            return string;
        }
        string = !string.startsWith("'") ? "'" + string : "''" + string;
        string = !string.endsWith("'") ? string + "'" : string + "''";
        return string;
    }

    public String formatPropertyValueForStringConcat(String string) {
        if (TMStringUtil.isnumeric((String)string)) {
            return string;
        }
        if (TMStringUtil.isdouble((String)string)) {
            return string;
        }
        if (this.isScientificDouble(string)) {
            return string;
        }
        string = string.replaceAll("'", "''");
        return string;
    }

    public boolean isScientificDouble(String string) {
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isLetter(string.charAt(i))) continue;
            if (string.charAt(i) == 'e' || string.charAt(i) == 'E') {
                if (!bl) continue;
                return false;
            }
            return false;
        }
        try {
            TMStringUtil.str2double((String)string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

