/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtest.panel;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.mlservices.MLInspectorServices;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.InstrumentObjectListener;
import com.mathworks.toolbox.instrument.PropertyChangedListener;
import com.mathworks.toolbox.instrument.device.Device;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.MIDTestToolClient;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.MIDTestToolFileReader;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.MIDTestToolFileWriter;
import com.mathworks.toolbox.instrument.guiutil.NewObjectDialog;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import com.mathworks.toolbox.testmeas.guiutil.TMFileDialog;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SetupPanel
extends JPanel
implements Runnable,
ActionListener,
FocusListener,
MouseListener,
InstrumentObjectListener,
PropertyChangedListener,
DocumentListener {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_NAME = "Unnamed test";
    public static final String ACTION = "ACTION";
    private static final int NAME = 0;
    private static final int BROWSE = 1;
    private static final int CREATE = 2;
    private static final int CONFIGURE = 3;
    private static final int DRIVER_NAME = 4;
    private MIDTestToolClient client;
    private BrowserTreeNode rootNode;
    private JPanel interfaceLowerPanel;
    private JTextField nameField;
    private JTextArea descriptionTextArea;
    private JTextField driverField;
    private JComboBox interfaceBox;
    private JTextField interfaceField;
    private JLabel interfaceLabel;
    private JPanel interfacePanel;
    private JLabel tempLabel = new JLabel("");
    private JButton browseButton;
    private JButton createButton;
    private JButton configureButton;
    private Hashtable<Instrument, String> instrumentObjects = new Hashtable();
    private String driverType = "";
    private String driverName = "";
    private String oldName = "Unnamed test";
    private String oldDescription = "";
    private String oldDriverName = "";
    private String oldInterface = "";
    private String oldVxiPnpInterface = "";
    private String oldIVIComInterface = "";
    private String oldIVICInterface = "";
    private NewObjectDialog newObjectDialog = null;
    private boolean needToCreateObject = false;
    private CreateObjectRunnable createObjectRunnable = null;

    public SetupPanel(MIDTestToolClient mIDTestToolClient, BrowserTreeNode browserTreeNode) {
        this.client = mIDTestToolClient;
        this.rootNode = browserTreeNode;
        this.layoutPanel();
        this.driverField.setMaximumSize(new Dimension(6, 21));
        this.driverField.setMinimumSize(new Dimension(6, 21));
    }

    public void cleanup() {
        Instrument.removeInstrumentObjectListener(this);
        Instrument.removePropertyChangedListener(this);
    }

    public void reset() {
        this.nameField.setText(DEFAULT_NAME);
        this.descriptionTextArea.setText("");
        this.driverField.setText("");
        this.driverName = "";
        this.interfaceBox.removeAllItems();
        this.interfaceBox.setEnabled(false);
        this.createButton.setEnabled(false);
        this.configureButton.setEnabled(false);
        this.instrumentObjects.clear();
        this.interfacePanel.setVisible(false);
        this.client.updateNodeName(this.rootNode, DEFAULT_NAME);
        this.resetDirtyFlag();
    }

    public boolean isNodeDirty() {
        if (!this.oldName.equals(this.nameField.getText())) {
            return true;
        }
        if (!this.oldDescription.equals(this.descriptionTextArea.getText())) {
            return true;
        }
        if (!this.oldDriverName.equals(this.driverName)) {
            return true;
        }
        if (this.driverType.length() == 0) {
            return false;
        }
        if (this.driverType.equals(Device.DRIVER_TYPE_NAMES[0])) {
            String string;
            return this.interfaceBox.getItemCount() > 0 ? !this.oldInterface.equals(string = (String)this.interfaceBox.getSelectedItem()) : !this.oldInterface.equals("");
        }
        if (this.driverType.equals(Device.DRIVER_TYPE_NAMES[1])) {
            return !this.interfaceField.getText().equals(this.oldVxiPnpInterface);
        }
        if (this.driverType.equals(Device.DRIVER_TYPE_NAMES[2])) {
            return !this.interfaceField.getText().equals(this.oldIVICInterface);
        }
        if (this.driverType.equals(Device.DRIVER_TYPE_NAMES[3])) {
            return !this.interfaceField.getText().equals(this.oldIVIComInterface);
        }
        return false;
    }

    public void resetDirtyFlag() {
        this.oldName = this.nameField.getText();
        this.oldDescription = this.descriptionTextArea.getText();
        this.oldDriverName = this.driverName;
        if (this.driverType.length() == 0) {
            return;
        }
        if (this.driverType.equals(Device.DRIVER_TYPE_NAMES[0])) {
            this.oldInterface = this.interfaceBox.getItemCount() > 0 ? (String)this.interfaceBox.getSelectedItem() : "";
        }
        if (this.driverType.equals(Device.DRIVER_TYPE_NAMES[1])) {
            this.oldVxiPnpInterface = this.interfaceField.getText();
        }
        if (this.driverType.equals(Device.DRIVER_TYPE_NAMES[2])) {
            this.oldIVICInterface = this.interfaceField.getText();
        }
        if (this.driverType.equals(Device.DRIVER_TYPE_NAMES[3])) {
            this.oldIVIComInterface = this.interfaceField.getText();
        }
    }

    public boolean okToRunTest() {
        if (this.driverName.length() == 0 || this.driverType.length() == 0) {
            return false;
        }
        if (this.driverType.equals(Device.DRIVER_TYPE_NAMES[0])) {
            return this.interfaceBox.getItemCount() != 0;
        }
        if (this.driverType.equals(Device.DRIVER_TYPE_NAMES[1])) {
            return !this.interfaceField.getText().equals("");
        }
        if (this.driverType.equals(Device.DRIVER_TYPE_NAMES[3])) {
            return true;
        }
        if (this.driverType.equals(Device.DRIVER_TYPE_NAMES[2])) {
            return !this.interfaceField.getText().equals("");
        }
        return true;
    }

    private void layoutPanel() {
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(4, 6, 4, 6));
        JPanel jPanel = this.add(this.createNamePanel(), this.createDescriptionPanel(), 0);
        JPanel jPanel2 = this.add(jPanel, this.createDriverInterfacePanel(), 2);
        this.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 0, 0));
        this.configureButton = new JButton("Configure Interface...");
        this.configureButton.setEnabled(false);
        this.configureButton.putClientProperty(ACTION, new Integer(3));
        this.configureButton.addActionListener(this);
        this.configureButton.setName("Configure Interface Button");
        jPanel3.add(this.configureButton);
        this.add((Component)jPanel3, "South");
    }

    private JPanel createNamePanel() {
        JLabel jLabel = new JLabel("Name:");
        jLabel.setVerticalAlignment(1);
        this.nameField = new JTextField(DEFAULT_NAME);
        this.nameField.putClientProperty(ACTION, new Integer(0));
        this.nameField.addActionListener(this);
        this.nameField.addFocusListener(this);
        this.nameField.setName("Name Text Field");
        JPanel jPanel = new JPanel(new BorderLayout(0, 4));
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)this.nameField, "Center");
        return jPanel;
    }

    private JPanel createDescriptionPanel() {
        JLabel jLabel = new JLabel("Description:");
        jLabel.setVerticalAlignment(1);
        this.descriptionTextArea = new JTextArea();
        this.descriptionTextArea.setFont(this.nameField.getFont());
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setWrapStyleWord(true);
        this.descriptionTextArea.setName("Description Text Field");
        AWTKeyStroke aWTKeyStroke = AWTKeyStroke.getAWTKeyStroke(9, 0);
        AWTKeyStroke aWTKeyStroke2 = AWTKeyStroke.getAWTKeyStroke(9, 2);
        HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>();
        hashSet.add(aWTKeyStroke);
        hashSet.add(aWTKeyStroke2);
        this.descriptionTextArea.setFocusTraversalKeys(0, hashSet);
        AWTKeyStroke aWTKeyStroke3 = AWTKeyStroke.getAWTKeyStroke(9, 1);
        HashSet<AWTKeyStroke> hashSet2 = new HashSet<AWTKeyStroke>();
        hashSet2.add(aWTKeyStroke3);
        this.descriptionTextArea.setFocusTraversalKeys(1, hashSet2);
        JPanel jPanel = new JPanel(new BorderLayout(0, 4));
        jPanel.add((Component)jLabel, "North");
        JScrollPane jScrollPane = new JScrollPane(this.descriptionTextArea);
        jScrollPane.setPreferredSize(new Dimension(100, 75));
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JPanel createDriverInterfacePanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 4));
        JLabel jLabel = new JLabel("Driver:");
        jLabel.setVerticalAlignment(1);
        this.browseButton = new JButton("Browse...");
        this.driverField = new JTextField(20);
        this.driverField.getDocument().addDocumentListener(this);
        JPanel jPanel2 = new JPanel(new BorderLayout(4, 0));
        jPanel2.add((Component)this.browseButton, "East");
        jPanel2.add((Component)this.driverField, "Center");
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jPanel2, "Center");
        this.interfacePanel = new JPanel(new BorderLayout(0, 4));
        this.interfaceLabel = new JLabel("Interface:");
        this.interfaceLabel.setVerticalAlignment(1);
        this.interfaceBox = new JComboBox();
        this.interfaceField = new JTextField();
        this.createButton = new JButton("Create...");
        this.interfaceLowerPanel = new JPanel(new BorderLayout(4, 0));
        this.interfaceLowerPanel.add((Component)this.createButton, "East");
        this.interfaceLowerPanel.add((Component)this.interfaceBox, "Center");
        this.interfacePanel.add((Component)this.interfaceLabel, "North");
        this.interfacePanel.add((Component)this.interfaceLowerPanel, "Center");
        this.interfacePanel.setVisible(false);
        Dimension dimension = this.browseButton.getPreferredSize();
        Dimension dimension2 = this.createButton.getPreferredSize();
        dimension = new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, this.driverField.getPreferredSize().height));
        dimension2 = new Dimension(dimension.width, Math.max(dimension2.height, this.interfaceBox.getPreferredSize().height));
        this.browseButton.setPreferredSize(dimension);
        this.createButton.setPreferredSize(dimension2);
        this.browseButton.setHorizontalAlignment(0);
        this.createButton.setHorizontalAlignment(0);
        this.browseButton.setVerticalAlignment(0);
        this.createButton.setVerticalAlignment(0);
        this.driverField.setName("Driver Text Field");
        this.interfaceBox.setName("Interface Combobox");
        this.interfaceField.setName("Interface Text Field");
        this.driverField.addMouseListener(this);
        this.browseButton.setName("Browse Button");
        this.createButton.setName("Create Button");
        this.browseButton.putClientProperty(ACTION, new Integer(1));
        this.browseButton.addActionListener(this);
        this.createButton.putClientProperty(ACTION, new Integer(2));
        this.createButton.addActionListener(this);
        this.driverField.putClientProperty(ACTION, new Integer(4));
        this.driverField.addActionListener(this);
        JPanel jPanel3 = new JPanel(new BorderLayout(0, 4));
        jPanel3.add((Component)jPanel, "North");
        jPanel3.add((Component)this.interfacePanel, "Center");
        this.interfaceBox.setEnabled(false);
        this.createButton.setEnabled(false);
        return jPanel3;
    }

    private JPanel add(JPanel jPanel, JPanel jPanel2, int n) {
        JPanel jPanel3 = new JPanel(new BorderLayout(0, n));
        jPanel3.add((Component)jPanel, "North");
        jPanel3.add((Component)jPanel2, "Center");
        return jPanel3;
    }

    public void save(MIDTestToolFileWriter mIDTestToolFileWriter, Element element) {
        mIDTestToolFileWriter.addNode(element, "Name", this.nameField.getText());
        mIDTestToolFileWriter.addNode(element, "Description", this.descriptionTextArea.getText());
        mIDTestToolFileWriter.addNode(element, "Driver", this.driverName);
        if (this.driverType.equals(Device.DRIVER_TYPE_NAMES[0])) {
            if (this.getInstrument() == null) {
                return;
            }
            mIDTestToolFileWriter.addNode(element, "Constructor", this.getInstrument().getConstructor());
            mIDTestToolFileWriter.addNode(element, "Properties", this.getInterfaceConfigureCommand());
            mIDTestToolFileWriter.addNode(element, "InstrfindArgs", this.getInstrument().getInstrfindArgs());
            return;
        }
        if (this.driverType.equals(Device.DRIVER_TYPE_NAMES[1]) || this.driverType.equals(Device.DRIVER_TYPE_NAMES[3]) || this.driverType.equals(Device.DRIVER_TYPE_NAMES[2])) {
            mIDTestToolFileWriter.addNode(element, "Interface", this.interfaceField.getText());
        }
    }

    public void load(MIDTestToolFileReader mIDTestToolFileReader, Node node) {
        String string = "";
        String string2 = "";
        String string3 = "";
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string4 = nodeList.item(i).getNodeName();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            if (nodeList2.getLength() == 0) continue;
            if (string4.equals("Name")) {
                this.nameField.setText(nodeList2.item(0).getNodeValue());
                this.updateClientRootNodeName();
                continue;
            }
            if (string4.equals("Description")) {
                this.descriptionTextArea.setText(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (string4.equals("Driver")) {
                this.driverName = nodeList2.item(0).getNodeValue();
                this.driverField.setText(this.driverName);
                this.driverField.setCaretPosition(0);
                if (this.driverName.equals("")) continue;
                this.updateGUIWithDriverInfo();
                continue;
            }
            if (string4.equals("Constructor")) {
                string = nodeList2.item(0).getNodeValue();
                continue;
            }
            if (string4.equals("Properties")) {
                string2 = nodeList2.item(0).getNodeValue();
                continue;
            }
            if (string4.equals("InstrfindArgs")) {
                string3 = nodeList2.item(0).getNodeValue();
                continue;
            }
            if (!string4.equals("Interface")) continue;
            this.interfaceField.setText(nodeList2.item(0).getNodeValue());
        }
        this.resetDirtyFlag();
        if (string.equals("")) {
            return;
        }
        if (this.createObjectRunnable == null) {
            this.createObjectRunnable = new CreateObjectRunnable();
        }
        this.createObjectRunnable.configure(string, string2, string3);
        this.needToCreateObject = true;
        Matlab.whenMatlabReady((Runnable)this.createObjectRunnable);
    }

    public boolean needToCreateObject() {
        return this.needToCreateObject;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        int n = (Integer)jComponent.getClientProperty(ACTION);
        switch (n) {
            case 0: {
                this.updateClientRootNodeName();
                break;
            }
            case 1: {
                String string = this.driverName;
                this.client.postStatusBarUpdateEvent("Select a MATLAB instrument driver");
                int n2 = this.createLoadDialog();
                if (n2 == 0) {
                    if (this.driverName.equals(string)) {
                        this.client.postStatusBarUpdateEvent(" ");
                        return;
                    }
                    if (string.equals("")) {
                        this.updateGUIWithDriverInfo();
                        this.client.postStatusBarUpdateEvent(" ");
                        return;
                    }
                    EventQueue.invokeLater(this);
                }
                this.client.postStatusBarUpdateEvent(" ");
                break;
            }
            case 2: {
                if (this.newObjectDialog == null) {
                    this.newObjectDialog = new NewObjectDialog(1);
                }
                this.newObjectDialog.showAsDialog((MJFrame)SwingUtilities.windowForComponent(this));
                break;
            }
            case 3: {
                MLInspectorServices.inspectObject((Object)this.getInstrument());
                break;
            }
            case 4: {
                this.updateDriverBeingUsed();
            }
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        JComponent jComponent = (JComponent)focusEvent.getSource();
        int n = (Integer)jComponent.getClientProperty(ACTION);
        switch (n) {
            case 0: {
                this.updateClientRootNodeName();
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.driverName = this.driverField.getText();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.driverName = this.driverField.getText();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.driverName = this.driverField.getText();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.tempLabel.setText(this.driverName);
        if (this.driverField.getWidth() < this.tempLabel.getPreferredSize().width) {
            this.driverField.setToolTipText(this.driverName);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.driverField.setToolTipText("");
    }

    private void updateDriverBeingUsed() {
        String string = this.driverField.getText();
        if (this.driverName.equals(string)) {
            return;
        }
        if (this.driverName.equals("")) {
            this.driverName = string;
            if (!string.equals("")) {
                this.updateGUIWithDriverInfo();
            }
            return;
        }
        EventQueue.invokeLater(this);
    }

    @Override
    public void run() {
        String string = this.driverField.getText();
        int n = this.client.newTest();
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.driverField.setText(this.driverName);
                return;
            }
        }
        this.driverName = string;
        if (!this.driverName.equals("")) {
            this.driverField.setText(this.driverName);
            this.updateGUIWithDriverInfo();
        }
    }

    private void updateClientRootNodeName() {
        if (!this.rootNode.getName().equals(this.nameField.getText())) {
            this.client.updateNodeName(this.rootNode, this.nameField.getText());
        }
    }

    private void updateGUIWithDriverInfo() {
        this.driverType = this.client.setDriverName(this.driverName);
        if (this.driverType == null) {
            this.driverName = "";
            this.driverType = "";
            return;
        }
        if (this.driverType.equals(Device.DRIVER_TYPE_NAMES[0])) {
            this.interfaceBox.setEnabled(true);
            this.createButton.setEnabled(true);
            this.interfaceBox.setEditable(false);
            this.updateInterfaceComboBox();
            if (this.interfaceBox.getItemCount() > 0) {
                this.configureButton.setEnabled(true);
            }
            Instrument.addInstrumentObjectListener(this);
            Instrument.addPropertyChangedListener(this);
            this.updateInterfacePanel(this.interfaceField, this.interfaceBox);
            this.interfaceLabel.setText("Interface:");
            this.interfacePanel.setVisible(true);
            this.createButton.setVisible(true);
        } else if (this.driverType.equals(Device.DRIVER_TYPE_NAMES[1]) || this.driverType.equals(Device.DRIVER_TYPE_NAMES[2]) || this.driverType.equals(Device.DRIVER_TYPE_NAMES[3])) {
            Instrument.removeInstrumentObjectListener(this);
            Instrument.removePropertyChangedListener(this);
            this.createButton.setEnabled(false);
            this.configureButton.setEnabled(false);
            this.updateInterfacePanel(this.interfaceBox, this.interfaceField);
            this.interfaceLabel.setText("Resource String:");
            this.interfacePanel.setVisible(true);
            this.createButton.setVisible(false);
        } else if (this.driverType.equals(Device.DRIVER_TYPE_NAMES[4])) {
            Instrument.removeInstrumentObjectListener(this);
            Instrument.removePropertyChangedListener(this);
            this.createButton.setEnabled(false);
            this.configureButton.setEnabled(false);
            this.updateInterfacePanel(this.interfaceBox, this.interfaceField);
            this.interfaceLabel.setText("Optional Input:");
            this.interfacePanel.setVisible(true);
            this.createButton.setVisible(false);
        }
    }

    private void updateInterfaceComboBox() {
        Instrument instrument = this.getInstrument();
        this.instrumentObjects.clear();
        this.interfaceBox.removeAllItems();
        Vector<Instrument> vector = Instrument.getNonLockedObjects();
        String string = "";
        Instrument instrument2 = null;
        int n = -1;
        for (int i = 0; i < vector.size(); ++i) {
            instrument2 = vector.elementAt(i);
            string = this.getInstrumentNameForComboBox(instrument2.getName());
            this.interfaceBox.addItem(string);
            this.instrumentObjects.put(instrument2, string);
            if (!instrument2.equals(instrument)) continue;
            n = i;
        }
        if (n != -1) {
            this.interfaceBox.setSelectedIndex(n);
        } else if (this.interfaceBox.getItemCount() > 0) {
            this.interfaceBox.setSelectedIndex(0);
        }
    }

    private String getInstrumentNameForComboBox(String string) {
        int n = 0;
        for (int i = 0; i < this.interfaceBox.getItemCount(); ++i) {
            String string2 = (String)this.interfaceBox.getItemAt(i);
            if (!string2.equals(string) && !string2.startsWith(string + " (")) continue;
            ++n;
        }
        if (n == 0) {
            return string;
        }
        return string + " (" + n + ")";
    }

    private void updateInterfacePanel(JComponent jComponent, JComponent jComponent2) {
        Component[] componentArray = this.interfaceLowerPanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!componentArray[i].equals(jComponent2)) continue;
            return;
        }
        this.interfaceLowerPanel.remove(jComponent);
        this.interfaceLowerPanel.add((Component)jComponent2, "Center");
        this.repaint();
    }

    public void updateNameField(String string) {
        this.nameField.setText(string);
    }

    private Instrument getInstrument() {
        String string = (String)this.interfaceBox.getSelectedItem();
        if (string == null) {
            return null;
        }
        Enumeration<Instrument> enumeration = this.instrumentObjects.keys();
        while (enumeration.hasMoreElements()) {
            Instrument instrument = enumeration.nextElement();
            String string2 = this.instrumentObjects.get(instrument);
            if (!string2.equals(string)) continue;
            return instrument;
        }
        return null;
    }

    private int createLoadDialog() {
        try {
            TMFileDialog tMFileDialog = new TMFileDialog("Load MATLAB Instrument Driver", "mdd", "MATLAB Instrument Driver (*.mdd)");
            tMFileDialog.setCurrentDirectory(new File(Instrument.getPreferenceFile().read("SaveDirectory")));
            int n = tMFileDialog.showDialog(1, this.client.getBrowserFrame());
            if (n == 0) {
                this.driverName = tMFileDialog.getSelectedFile().getAbsolutePath();
                this.driverField.setText(this.driverName);
                this.driverField.setCaretPosition(0);
                Instrument.getPreferenceFile().update("SaveDirectory", tMFileDialog.getSelectedFile().getParentFile().getPath());
            }
            return n;
        }
        catch (Exception exception) {
            return 1;
        }
    }

    @Override
    public void instrumentObjectAdded(final Instrument instrument, final String string, final String string2) {
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SetupPanel.this.instrumentObjectAdded(instrument, string, string2);
                }
            });
            return;
        }
        String string3 = this.getInstrumentNameForComboBox(instrument.getName());
        this.interfaceBox.addItem(string3);
        this.instrumentObjects.put(instrument, string3);
        if (this.interfaceBox.getItemCount() == 1) {
            this.configureButton.setEnabled(true);
        }
    }

    @Override
    public void instrumentObjectDeleted(final Instrument instrument, final String string, final String string2) {
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SetupPanel.this.instrumentObjectDeleted(instrument, string, string2);
                }
            });
            return;
        }
        String string3 = this.instrumentObjects.get(instrument);
        this.interfaceBox.removeItem(string3);
        this.updateInterfaceComboBox();
        if (this.interfaceBox.getItemCount() == 0) {
            this.configureButton.setEnabled(false);
        }
    }

    @Override
    public void propertyChanged(Instrument instrument, String string, Object object) {
        if (!string.equals("Name")) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SetupPanel.this.updateInterfaceComboBox();
                }
            });
            return;
        }
    }

    public String generateCode() {
        String string = "";
        if (this.driverType.equals(Device.DRIVER_TYPE_NAMES[0])) {
            string = this.addLine(string, "% Construct the interface object.");
            string = this.addLine(string, "interfaceObj = instrfind" + this.getInstrument().getInstrfindArgs());
            string = this.addLine(string, "if isempty(interfaceObj)");
            string = this.addLine(string, "    interfaceObj = " + this.getInstrument().getConstructor());
            string = this.addLine(string, "else");
            string = this.addLine(string, "    okToDeleteInterfaceObj = false;");
            string = this.addLine(string, "    fclose(interfaceObj);");
            string = this.addLine(string, "    interfaceObj = interfaceObj(1);");
            string = this.addLine(string, "end");
            string = this.addLine(string, "");
            string = this.addLine(string, "% Construct the device object.");
            string = this.addLine(string, "deviceObj = icdevice('" + this.driverName + "', interfaceObj);");
            String string2 = this.getInterfaceConfigureCommand();
            if (!string2.equals("")) {
                string = this.addLine(string, "");
                string = this.addLine(string, "% Configure the interface object.");
                string = this.addLine(string, "set(interfaceObj, " + string2 + ");");
            }
        } else if (this.driverType.equals(Device.DRIVER_TYPE_NAMES[1]) || this.driverType.equals(Device.DRIVER_TYPE_NAMES[2])) {
            string = this.addLine(string, "% Construct the device object.");
            string = this.addLine(string, "deviceObj = icdevice('" + this.driverName + "', '" + this.interfaceField.getText() + "');");
        } else if (this.driverType.equals(Device.DRIVER_TYPE_NAMES[3])) {
            string = this.addLine(string, "% Construct the device object.");
            string = this.interfaceField.getText().equals("") ? this.addLine(string, "deviceObj = icdevice('" + this.driverName + "');") : this.addLine(string, "deviceObj = icdevice('" + this.driverName + "', '" + this.interfaceField.getText() + "');");
        }
        return string;
    }

    private String getInterfaceConfigureCommand() {
        String string = "";
        Object[] objectArray = this.getInstrument().getNonDefaultPVPairs();
        if (objectArray.length == 0) {
            return string;
        }
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object = objectArray[i];
            Object object2 = objectArray[i + 1];
            string = string + "'" + object + "', ";
            string = object2 instanceof String ? string + "'" + object2 + "', " : string + object2 + ", ";
        }
        return string.substring(0, string.length() - 2);
    }

    public String getDriverName() {
        return this.driverName;
    }

    private String addLine(String string, String string2) {
        return string + string2 + "\n";
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public class CreateObjectRunnable
    implements Runnable,
    MatlabListener {
        private Object[] args = new Object[]{"privateMIDTestToolHelper", "createObject", "", "", ""};
        private Matlab matlab = new Matlab();

        @Override
        public void run() {
            try {
                this.matlab.feval("instrgate", this.args, 0, (MatlabListener)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void matlabEvent(MatlabEvent matlabEvent) {
            int n = SetupPanel.this.interfaceBox.getItemCount();
            if (n != 0) {
                SetupPanel.this.interfaceBox.setSelectedIndex(n - 1);
            }
            SetupPanel.this.resetDirtyFlag();
            SetupPanel.this.needToCreateObject = false;
            SetupPanel.this.client.showGlassPane(false);
        }

        public void configure(String string, String string2, String string3) {
            this.args[2] = string;
            this.args[3] = string2;
            this.args[4] = string3;
        }
    }
}

