/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtool.panel;

import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverClient;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverGroup;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverModel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.MIDNode;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.MIDTool;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.panel.BasePanel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.table.DriverTableModel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.table.MIDTable;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.table.MIDTablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.TableColumnModel;

public class GroupPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;
    private JTabbedPane fTab;
    private HelpPanel fHelpPanel;
    private MIDTablePanel fMappingTablePanel;
    private MIDTable fMappingTable;
    private JTextField fConfigureCommand;
    private JLabel fConfigureLabel;
    private DriverGroup fGroup = null;

    public GroupPanel(DriverClient driverClient) {
        super(driverClient);
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.fTab = new JTabbedPane();
        this.fTab.addTab("Definition", this.createGroupInfoPanel());
        this.fHelpPanel = new HelpPanel(driverClient);
        this.fTab.addTab("Help", (Component)((Object)this.fHelpPanel));
        this.add(this.fTab, "Center");
    }

    private JPanel createGroupInfoPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 8, 0, 0), 0, 0);
        this.fConfigureLabel = new JLabel("Selection command:");
        jPanel.add((Component)this.fConfigureLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 8);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.fConfigureCommand = new JTextField();
        jPanel.add((Component)this.fConfigureCommand, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0);
        this.fMappingTable = new MIDTable(new MappingTableModel());
        this.fMappingTable.setRowSelectionAllowed(true);
        this.fMappingTable.setColumnSelectionAllowed(false);
        TableColumnModel tableColumnModel = this.fMappingTable.getColumnModel();
        tableColumnModel.getColumn(0).setMinWidth(60);
        tableColumnModel.getColumn(0).setMaxWidth(1000);
        tableColumnModel.getColumn(0).setWidth(60);
        tableColumnModel.getColumn(0).setPreferredWidth(60);
        tableColumnModel.getColumn(0).sizeWidthToFit();
        tableColumnModel.getColumn(1).setPreferredWidth(100);
        this.fMappingTablePanel = new MIDTablePanel(this.fMappingTable, "Identifiers");
        this.fMappingTablePanel.setAllowsMoveEntry(false);
        this.fMappingTablePanel.setEntryLabelText("Identifier:");
        this.fMappingTablePanel.setPreferredSize(new Dimension(20, 20));
        this.fMappingTablePanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GroupPanel.this.channelMappingTableEvent(actionEvent);
            }
        });
        jPanel.add((Component)((Object)this.fMappingTablePanel), gridBagConstraints);
        return jPanel;
    }

    @Override
    public void driverDidLoad(DriverModel driverModel) {
        this.fTab.setSelectedIndex(0);
    }

    @Override
    public void updatePanel(MIDNode mIDNode) {
        this.fGroup = (DriverGroup)mIDNode.getUserData();
        String string = this.fGroup.getCommand();
        this.fConfigureCommand.setText(string);
        this.fHelpPanel.updatePanel(mIDNode);
    }

    @Override
    public void updateNode(MIDNode mIDNode) {
        String string = new String(this.fConfigureCommand.getText());
        this.fGroup.setCommand(string);
        this.fMappingTable.stopEditing();
        this.fHelpPanel.updateNode(mIDNode);
    }

    protected void channelMappingTableEvent(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        switch (Integer.decode(string)) {
            case 1: {
                String string2 = this.fMappingTablePanel.getEntryText();
                this.fGroup.addMapping(string2);
                ((MappingTableModel)this.fMappingTable.getModel()).fireTableDataChanged();
                break;
            }
            case 2: {
                if (!this.fMappingTable.willDeleteBasedOnSelection(true)) break;
                int[] nArray = this.fMappingTable.getMultipleRowSelctionIndices();
                for (int i = nArray.length - 1; i >= 0; --i) {
                    this.fGroup.removeMapping(nArray[i] + 1);
                }
                ((MappingTableModel)this.fMappingTable.getModel()).fireTableDataChanged();
                this.fMappingTable.setSelectionBasedOnIndex(nArray[0]);
            }
        }
    }

    public class HelpPanel
    extends BasePanel {
        private static final long serialVersionUID = 1L;
        private JTextArea fHelpText;

        public HelpPanel(DriverClient driverClient) {
            super(driverClient);
            this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.setLayout(new BorderLayout(0, 2));
            this.add(new JLabel("Help text:"), "North");
            this.fHelpText = new JTextArea();
            this.fHelpText.setColumns(20);
            this.fHelpText.setRows(1);
            this.fHelpText.setLineWrap(true);
            this.fHelpText.setWrapStyleWord(true);
            this.fHelpText.setMargin(new Insets(0, 2, 2, 2));
            this.fHelpText.setTabSize(4);
            this.fHelpText.setForeground(MIDTool.getMCommentColor());
            this.add(new JScrollPane(this.fHelpText), "Center");
        }

        @Override
        public void updatePanel(MIDNode mIDNode) {
            this.fHelpText.setText(GroupPanel.this.fGroup.getHelpText());
            this.fHelpText.setCaretPosition(0);
        }

        @Override
        public void updateNode(MIDNode mIDNode) {
            GroupPanel.this.fGroup.setHelpText(this.fHelpText.getText());
        }
    }

    public class MappingTableModel
    extends DriverTableModel {
        private static final long serialVersionUID = 1L;
        private final String[] kColumnHeaders = new String[]{"Index", "Identifier Name"};

        @Override
        public String getColumnName(int n) {
            return this.kColumnHeaders[n];
        }

        @Override
        public int getRowCount() {
            if (GroupPanel.this.fGroup == null) {
                return 0;
            }
            return GroupPanel.this.fGroup.getIdMappings().size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (GroupPanel.this.fGroup != null) {
                if (n2 == 0) {
                    return new Integer(n + 1);
                }
                return GroupPanel.this.fGroup.getMapping(n + 1);
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (GroupPanel.this.fGroup != null) {
                if (((String)object).length() == 0) {
                    MJOptionPane.showMessageDialog((Component)GroupPanel.this.fDriverClient.getBrowserFrame(), (Object)"The identifier cannot be empty", (String)"Identifier", (int)0);
                } else {
                    GroupPanel.this.fGroup.setMapping(n + 1, (String)object);
                }
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }
    }
}

