/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtool.panel;

import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTabbedPane;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverClient;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverModel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.MIDNode;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.event.DriverModelEvent;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.event.DriverModelListener;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.panel.BasePanel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.table.DriverTableModel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.table.MIDTable;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.table.MIDTablePanel;
import com.mathworks.widgets.SyntaxTextPane;
import com.mathworks.widgets.SyntaxTextPaneBase;
import com.mathworks.widgets.text.mcode.MLanguage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;

public class InitializationPanel
extends BasePanel
implements ItemListener {
    private static final long serialVersionUID = 1L;
    private MJTabbedPane fTabbedPane;
    private SyntaxTextPane fCreateMSyntaxPanel;
    private MJPanel fConnectPanel;
    private MJComboBox fConnectCodeType;
    private Component fConnectMCodeEdit;
    private SyntaxTextPane fConnectMSyntaxPanel;
    private MIDTablePanel fConnectTablePanel;
    private MIDTable fConnectTable;
    GridBagConstraints fConnectPanelConstraints;
    private MJPanel fDisconnectPanel;
    private MJComboBox fDisconnectCodeType;
    private Component fDisconnectMCodeEdit;
    private SyntaxTextPane fDisconnectMSyntaxPanel;
    private MIDTablePanel fDisconnectTablePanel;
    private MIDTable fDisconnectTable;
    GridBagConstraints fDisconnectPanelConstraints;
    private static String[] sCodeTypes = new String[]{"Instrument Commands", "M-Code"};
    private DriverModel fModel;

    public InitializationPanel(DriverClient driverClient) {
        super(driverClient);
        this.layoutPanel();
    }

    protected void layoutPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.fTabbedPane = new MJTabbedPane();
        this.fTabbedPane.setPreferredSize(new Dimension(20, 20));
        this.fTabbedPane.add((Component)this.createCreatePanel(), (Object)"Create");
        this.fTabbedPane.add((Component)this.createConnectPanel(), (Object)"Connect");
        this.fTabbedPane.add((Component)this.createDisconnectPanel(), (Object)"Disconnect");
        this.add((Component)this.fTabbedPane, "Center");
    }

    protected MJPanel createCreatePanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.fCreateMSyntaxPanel = new SyntaxTextPane();
        this.fCreateMSyntaxPanel.setContentType(MLanguage.M_MIME_TYPE);
        mJPanel.add((Component)SyntaxTextPane.getDisplayComponent((SyntaxTextPaneBase)this.fCreateMSyntaxPanel), (Object)"Center");
        return mJPanel;
    }

    protected MJPanel createConnectPanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 4, 2, 4), 0, 0);
        this.fConnectCodeType = new MJComboBox((Object[])sCodeTypes);
        mJPanel.add((Component)this.createStylePanel(this.fConnectCodeType), (Object)gridBagConstraints);
        this.fConnectPanelConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(2, 4, 4, 4), 0, 0);
        this.fConnectTable = new MIDTable(new VectorTableModel("Command", 0));
        this.fConnectTable.setRowSelectionAllowed(true);
        this.fConnectTablePanel = new MIDTablePanel(this.fConnectTable, "Connect commands");
        this.fConnectTablePanel.setEntryLabelText("Add command:");
        this.fConnectTablePanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InitializationPanel.this.connectTableEvent(actionEvent);
            }
        });
        this.fConnectMSyntaxPanel = new SyntaxTextPane();
        this.fConnectMSyntaxPanel.setContentType(MLanguage.M_MIME_TYPE);
        this.fConnectPanel = mJPanel;
        this.fConnectMCodeEdit = SyntaxTextPane.getDisplayComponent((SyntaxTextPaneBase)this.fConnectMSyntaxPanel);
        mJPanel.add((Component)((Object)this.fConnectTablePanel), (Object)this.fConnectPanelConstraints);
        return mJPanel;
    }

    protected MJPanel createDisconnectPanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 4, 2, 4), 0, 0);
        this.fDisconnectCodeType = new MJComboBox((Object[])sCodeTypes);
        mJPanel.add((Component)this.createStylePanel(this.fDisconnectCodeType), (Object)gridBagConstraints);
        this.fDisconnectPanelConstraints = new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, new Insets(2, 4, 4, 4), 0, 0);
        this.fDisconnectTable = new MIDTable(new VectorTableModel("Command", 1));
        this.fDisconnectTable.setRowSelectionAllowed(true);
        this.fDisconnectTablePanel = new MIDTablePanel(this.fDisconnectTable, "Disconnect commands");
        this.fDisconnectTablePanel.setEntryLabelText("Add command:");
        this.fDisconnectTablePanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InitializationPanel.this.disconnectTableEvent(actionEvent);
            }
        });
        this.fDisconnectMSyntaxPanel = new SyntaxTextPane();
        this.fDisconnectMSyntaxPanel.setContentType(MLanguage.M_MIME_TYPE);
        this.fDisconnectPanel = mJPanel;
        this.fDisconnectMCodeEdit = SyntaxTextPane.getDisplayComponent((SyntaxTextPaneBase)this.fDisconnectMSyntaxPanel);
        mJPanel.add((Component)((Object)this.fDisconnectTablePanel), (Object)this.fDisconnectPanelConstraints);
        return mJPanel;
    }

    protected MJPanel createStylePanel(MJComboBox mJComboBox) {
        MJPanel mJPanel = new MJPanel((LayoutManager)new FlowLayout(0, 2, 0));
        mJPanel.add((Component)new MJLabel("Function style:"));
        mJComboBox.addItemListener((ItemListener)this);
        mJPanel.add((Component)mJComboBox);
        return mJPanel;
    }

    @Override
    public void driverWillUnload(DriverModel driverModel) {
        driverModel.removeDriverModelListener((VectorTableModel)this.fConnectTable.getModel());
        driverModel.removeDriverModelListener((VectorTableModel)this.fDisconnectTable.getModel());
    }

    @Override
    public void driverDidLoad(DriverModel driverModel) {
        this.fTabbedPane.setSelectedIndex(0);
        ((VectorTableModel)this.fConnectTable.getModel()).setData(driverModel.getConnectInitCode());
        driverModel.addDriverModelListener((VectorTableModel)this.fConnectTable.getModel());
        ((VectorTableModel)this.fDisconnectTable.getModel()).setData(driverModel.getDisconnectCode());
        driverModel.addDriverModelListener((VectorTableModel)this.fDisconnectTable.getModel());
        if (driverModel.getDriverType() == 0) {
            this.fConnectCodeType.removeAllItems();
            this.fConnectCodeType.addItem((Object)sCodeTypes[0]);
            this.fConnectCodeType.addItem((Object)sCodeTypes[1]);
            this.fConnectCodeType.setEnabled(true);
            this.fDisconnectCodeType.removeAllItems();
            this.fDisconnectCodeType.addItem((Object)sCodeTypes[0]);
            this.fDisconnectCodeType.addItem((Object)sCodeTypes[1]);
            this.fDisconnectCodeType.setEnabled(true);
        } else {
            this.fConnectCodeType.removeAllItems();
            this.fConnectCodeType.addItem((Object)sCodeTypes[1]);
            this.fConnectCodeType.setEnabled(false);
            this.fDisconnectCodeType.removeAllItems();
            this.fDisconnectCodeType.addItem((Object)sCodeTypes[1]);
            this.fDisconnectCodeType.setEnabled(false);
        }
    }

    @Override
    public void updatePanel(MIDNode mIDNode) {
        this.fModel = this.fDriverClient.getDriverModel();
        this.setIsListening(false);
        int n = this.fTabbedPane.getSelectedIndex();
        this.fTabbedPane.setSelectedIndex(n == 2 ? 0 : 2);
        this.fTabbedPane.setSelectedIndex(n);
        this.fCreateMSyntaxPanel.setText(this.fModel.getCreateInitMCode());
        this.fCreateMSyntaxPanel.selectAll();
        this.fCreateMSyntaxPanel.setCaretPosition(0);
        this.fCreateMSyntaxPanel.discardAllUndoEdits();
        this.fConnectCodeType.setSelectedItem((Object)sCodeTypes[this.fModel.getConnectInitType()]);
        this.fConnectMSyntaxPanel.setText(this.fModel.getConnectInitMCode());
        this.fConnectMSyntaxPanel.selectAll();
        this.fConnectMSyntaxPanel.setCaretPosition(0);
        this.fConnectMSyntaxPanel.discardAllUndoEdits();
        this.fDisconnectCodeType.setSelectedItem((Object)sCodeTypes[this.fModel.getDisconnectType()]);
        this.fDisconnectMSyntaxPanel.setText(this.fModel.getDisconnectMCode());
        this.fDisconnectMSyntaxPanel.selectAll();
        this.fDisconnectMSyntaxPanel.setCaretPosition(0);
        this.fDisconnectMSyntaxPanel.discardAllUndoEdits();
        this.setIsListening(true);
    }

    @Override
    public void updateNode(MIDNode mIDNode) {
        this.fModel.setCreateInitMCode(this.fCreateMSyntaxPanel.getText());
        if (this.fConnectCodeType.getSelectedItem().equals(sCodeTypes[1])) {
            this.fModel.setConnectInitType(1);
        } else {
            this.fModel.setConnectInitType(0);
        }
        this.fModel.setConnectInitMCode(this.fConnectMSyntaxPanel.getText());
        if (this.fDisconnectCodeType.getSelectedItem().equals(sCodeTypes[1])) {
            this.fModel.setDisconnectType(1);
        } else {
            this.fModel.setDisconnectType(0);
        }
        this.fModel.setDisconnectMCode(this.fDisconnectMSyntaxPanel.getText());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 2) {
            return;
        }
        if (itemEvent.getSource() == this.fConnectCodeType) {
            if (this.fConnectCodeType.getSelectedItem() == sCodeTypes[0]) {
                this.fConnectPanel.remove(this.fConnectMCodeEdit);
                this.fConnectPanel.add((Component)((Object)this.fConnectTablePanel), (Object)this.fConnectPanelConstraints);
            } else {
                this.fConnectPanel.remove((Component)((Object)this.fConnectTablePanel));
                this.fConnectPanel.add(this.fConnectMCodeEdit, (Object)this.fConnectPanelConstraints);
            }
        } else if (itemEvent.getSource() == this.fDisconnectCodeType) {
            if (this.fDisconnectCodeType.getSelectedItem() == sCodeTypes[0]) {
                this.fDisconnectPanel.remove(this.fDisconnectMCodeEdit);
                this.fDisconnectPanel.add((Component)((Object)this.fDisconnectTablePanel), (Object)this.fDisconnectPanelConstraints);
            } else {
                this.fDisconnectPanel.remove((Component)((Object)this.fDisconnectTablePanel));
                this.fDisconnectPanel.add(this.fDisconnectMCodeEdit, (Object)this.fDisconnectPanelConstraints);
            }
        }
        this.revalidate();
        this.repaint();
    }

    protected void connectTableEvent(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        this.fConnectTable.stopEditing();
        switch (Integer.decode(string)) {
            case 1: {
                String string2 = this.fConnectTablePanel.getEntryText();
                this.fDriverClient.getDriverModel().appendConnectInitCode(string2);
                this.fConnectTable.ensureRowIsVisible(this.fConnectTable.getRowCount() - 1);
                break;
            }
            case 2: {
                if (!this.fConnectTable.willDeleteBasedOnSelection(true)) break;
                int[] nArray = this.fConnectTable.getMultipleRowSelctionIndices();
                for (int i = nArray.length - 1; i >= 0; --i) {
                    this.fDriverClient.getDriverModel().removeConnectInitCode(nArray[i]);
                }
                this.fConnectTable.setSelectionBasedOnIndex(nArray[0]);
                break;
            }
            case 4: {
                if (!this.fConnectTable.willMoveRowBasedOnSelection(false)) break;
                int n = this.fConnectTable.getSelectedRow();
                ((VectorTableModel)this.fConnectTable.getModel()).exchangeRows(n, n + 1);
                ((VectorTableModel)this.fConnectTable.getModel()).fireTableDataChanged();
                this.fConnectTable.setRowSelectionInterval(n + 1, n + 1);
                break;
            }
            case 3: {
                if (!this.fConnectTable.willMoveRowBasedOnSelection(true)) break;
                int n = this.fConnectTable.getSelectedRow();
                ((VectorTableModel)this.fConnectTable.getModel()).exchangeRows(n, n - 1);
                ((VectorTableModel)this.fConnectTable.getModel()).fireTableDataChanged();
                this.fConnectTable.setRowSelectionInterval(n - 1, n - 1);
            }
        }
    }

    protected void disconnectTableEvent(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        this.fDisconnectTable.stopEditing();
        switch (Integer.decode(string)) {
            case 1: {
                String string2 = this.fDisconnectTablePanel.getEntryText();
                this.fDriverClient.getDriverModel().appendDisconnectCode(string2);
                this.fDisconnectTable.ensureRowIsVisible(this.fDisconnectTable.getRowCount() - 1);
                break;
            }
            case 2: {
                if (!this.fDisconnectTable.willDeleteBasedOnSelection(true)) break;
                int[] nArray = this.fDisconnectTable.getMultipleRowSelctionIndices();
                for (int i = nArray.length - 1; i >= 0; --i) {
                    this.fDriverClient.getDriverModel().removeDisconnectCode(nArray[i]);
                }
                this.fDisconnectTable.setSelectionBasedOnIndex(nArray[0]);
                break;
            }
            case 4: {
                if (!this.fDisconnectTable.willMoveRowBasedOnSelection(false)) break;
                int n = this.fDisconnectTable.getSelectedRow();
                ((VectorTableModel)this.fDisconnectTable.getModel()).exchangeRows(n, n + 1);
                ((VectorTableModel)this.fDisconnectTable.getModel()).fireTableDataChanged();
                this.fDisconnectTable.setRowSelectionInterval(n + 1, n + 1);
                break;
            }
            case 3: {
                if (!this.fDisconnectTable.willMoveRowBasedOnSelection(true)) break;
                int n = this.fDisconnectTable.getSelectedRow();
                ((VectorTableModel)this.fDisconnectTable.getModel()).exchangeRows(n, n - 1);
                ((VectorTableModel)this.fDisconnectTable.getModel()).fireTableDataChanged();
                this.fDisconnectTable.setRowSelectionInterval(n - 1, n - 1);
            }
        }
    }

    public class VectorTableModel
    extends DriverTableModel
    implements DriverModelListener {
        private static final long serialVersionUID = 1L;
        public static final int CONNECT = 0;
        public static final int DISCONNECT = 1;
        private String header = "";
        private Vector<String> data = new Vector();
        private int codeSource;

        public VectorTableModel(String string, int n) {
            this.header = string;
            this.codeSource = n;
        }

        @Override
        public void driverStateChanged(DriverModelEvent driverModelEvent) {
            if (driverModelEvent.getType() == 2) {
                this.fireTableDataChanged();
            }
        }

        public void setData(Vector<String> vector) {
            this.data = vector == null ? new Vector() : vector;
        }

        @Override
        public String getColumnName(int n) {
            return this.header;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.data.get(n);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (((String)object).length() == 0) {
                MJOptionPane.showMessageDialog((Component)InitializationPanel.this.fDriverClient.getBrowserFrame(), (Object)("The " + this.header.toLowerCase() + " cannot be empty"), (String)"Empty Value", (int)0);
            } else if (this.codeSource == 0) {
                InitializationPanel.this.fDriverClient.getDriverModel().setConnectInitCode((String)object, n);
            } else {
                InitializationPanel.this.fDriverClient.getDriverModel().setDisconnectCode((String)object, n);
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }
    }
}

