/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtool.panel;

import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverClient;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverFunction;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverGroup;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverModel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverProperty;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.MIDNode;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.event.DriverModelEvent;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.event.DriverModelListener;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.panel.BasePanel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.table.DriverTableModel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.table.MIDTable;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.table.MIDTablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;

public class ListPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;
    public static final int sGroupList = 0;
    public static final int sPropertyList = 1;
    public static final int sFunctionList = 2;
    private MIDTablePanel fGroupTablePanel;
    private MIDTable fGroupTable;
    private MIDTablePanel fPropertyTablePanel;
    private MIDTable fPropertyTable;
    private MIDTablePanel fFunctionTablePanel;
    private MIDTable fFunctionTable;
    private DriverGroup fGroup = null;
    private boolean fShowGroups = false;
    private boolean fShowProperties = false;
    private boolean fShowFunctions = false;

    public ListPanel(DriverClient driverClient, int n) {
        super(driverClient);
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        switch (n) {
            case 0: {
                this.add((Component)this.createGroupListTable(), "Center");
                this.fShowGroups = true;
                break;
            }
            case 1: {
                this.add((Component)this.createPropertyListTable(), "Center");
                this.fShowProperties = true;
                break;
            }
            case 2: {
                this.add((Component)this.createFunctionListTable(), "Center");
                this.fShowFunctions = true;
            }
        }
    }

    private MJPanel createGroupListTable() {
        this.fGroupTable = new MIDTable(new GroupListTableModel());
        this.fGroupTable.setRowSelectionAllowed(true);
        this.fGroupTable.setTag("group");
        this.adjustTableColumns(this.fGroupTable);
        this.fGroupTablePanel = new MIDTablePanel(this.fGroupTable, null);
        this.fGroupTablePanel.setAllowsMoveEntry(false);
        this.fGroupTablePanel.setEntryLabelText("Add group:");
        this.fGroupTablePanel.setPreferredSize(new Dimension(20, 20));
        this.fGroupTablePanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ListPanel.this.groupTableEvent(actionEvent);
            }
        });
        this.fGroupTablePanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        return this.fGroupTablePanel;
    }

    private MJPanel createPropertyListTable() {
        this.fPropertyTable = new MIDTable(new PropertyListTableModel());
        this.fPropertyTable.setRowSelectionAllowed(true);
        this.fPropertyTable.setDragEnabled(true);
        this.fPropertyTable.setTag("property");
        this.adjustTableColumns(this.fPropertyTable);
        this.fPropertyTablePanel = new MIDTablePanel(this.fPropertyTable, null);
        this.fPropertyTablePanel.setAllowsMoveEntry(false);
        this.fPropertyTablePanel.setEntryLabelText("Add property:");
        this.fPropertyTablePanel.setPreferredSize(new Dimension(20, 20));
        this.fPropertyTablePanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ListPanel.this.propertyTableEvent(actionEvent);
            }
        });
        this.fPropertyTablePanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        return this.fPropertyTablePanel;
    }

    private MJPanel createFunctionListTable() {
        this.fFunctionTable = new MIDTable(new FunctionListTableModel());
        this.fFunctionTable.setDragEnabled(true);
        this.fFunctionTable.setRowSelectionAllowed(true);
        this.fFunctionTable.setTag("function");
        this.adjustTableColumns(this.fFunctionTable);
        this.fFunctionTablePanel = new MIDTablePanel(this.fFunctionTable, null);
        this.fFunctionTablePanel.setAllowsMoveEntry(false);
        this.fFunctionTablePanel.setEntryLabelText("Add function:");
        this.fFunctionTablePanel.setPreferredSize(new Dimension(20, 20));
        this.fFunctionTablePanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ListPanel.this.functionTableEvent(actionEvent);
            }
        });
        this.fFunctionTablePanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        return this.fFunctionTablePanel;
    }

    private void adjustTableColumns(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        tableColumnModel.getColumn(0).setMinWidth(50);
        tableColumnModel.getColumn(0).setMaxWidth(1000);
        tableColumnModel.getColumn(0).setWidth(50);
        tableColumnModel.getColumn(0).setPreferredWidth(60);
        tableColumnModel.getColumn(0).sizeWidthToFit();
        tableColumnModel.getColumn(1).setPreferredWidth(100);
    }

    @Override
    public void driverWillUnload(DriverModel driverModel) {
        DriverTableModel driverTableModel;
        if (this.fShowGroups) {
            driverTableModel = (GroupListTableModel)this.fGroupTable.getModel();
            this.fDriverClient.getDriverModel().removeDriverModelListener((DriverModelListener)((Object)driverTableModel));
        }
        if (this.fShowProperties) {
            driverTableModel = (PropertyListTableModel)this.fPropertyTable.getModel();
            this.fDriverClient.getDriverModel().removeDriverModelListener((DriverModelListener)((Object)driverTableModel));
        }
        if (this.fShowFunctions) {
            driverTableModel = (FunctionListTableModel)this.fFunctionTable.getModel();
            this.fDriverClient.getDriverModel().removeDriverModelListener((DriverModelListener)((Object)driverTableModel));
        }
    }

    @Override
    public void driverDidLoad(DriverModel driverModel) {
        DriverTableModel driverTableModel;
        if (this.fShowGroups) {
            driverTableModel = (GroupListTableModel)this.fGroupTable.getModel();
            this.fDriverClient.getDriverModel().addDriverModelListener((DriverModelListener)((Object)driverTableModel));
            this.fGroupTablePanel.setEntryText("");
        }
        if (this.fShowProperties) {
            driverTableModel = (PropertyListTableModel)this.fPropertyTable.getModel();
            this.fDriverClient.getDriverModel().addDriverModelListener((DriverModelListener)((Object)driverTableModel));
            this.fPropertyTablePanel.setEntryText("");
        }
        if (this.fShowFunctions) {
            driverTableModel = (FunctionListTableModel)this.fFunctionTable.getModel();
            this.fDriverClient.getDriverModel().addDriverModelListener((DriverModelListener)((Object)driverTableModel));
            this.fFunctionTablePanel.setEntryText("");
        }
    }

    @Override
    public void updatePanel(MIDNode mIDNode) {
        this.fGroup = (DriverGroup)mIDNode.getUserData();
        if (this.fShowGroups) {
            this.fGroupTable.clearSelection();
            this.fGroupTable.setUserData(this.fGroup);
        }
        if (this.fShowProperties) {
            this.fPropertyTable.clearSelection();
            this.fPropertyTable.setUserData(this.fGroup);
        }
        if (this.fShowFunctions) {
            this.fFunctionTable.clearSelection();
            this.fFunctionTable.setUserData(this.fGroup);
        }
    }

    @Override
    public void updateNode(MIDNode mIDNode) {
        if (this.fShowGroups) {
            this.fGroupTable.stopEditing();
        }
        if (this.fShowProperties) {
            this.fPropertyTable.stopEditing();
        }
        if (this.fShowFunctions) {
            this.fFunctionTable.stopEditing();
        }
    }

    protected void groupTableEvent(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        switch (Integer.decode(string)) {
            case 1: {
                String string2 = this.fGroupTablePanel.getEntryText();
                if (!this.fDriverClient.isValidGroupName(string2, true)) break;
                DriverGroup driverGroup = new DriverGroup(string2);
                this.fDriverClient.getDriverModel().add(driverGroup);
                break;
            }
            case 2: {
                if (!this.fGroupTable.willDeleteBasedOnSelection(true)) break;
                int[] nArray = this.fGroupTable.getMultipleRowSelctionIndices();
                for (int i = nArray.length - 1; i >= 0; --i) {
                    String string3;
                    DriverModel driverModel = this.fDriverClient.getDriverModel();
                    DriverGroup driverGroup = driverModel.getGroup(string3 = driverModel.getGroupNames().get(nArray[i] + 1));
                    if (driverGroup.getProperties().isEmpty() && driverGroup.getFunctions().isEmpty()) {
                        driverModel.remove(driverGroup);
                        continue;
                    }
                    int n = MJOptionPane.showConfirmDialog((Component)this.fDriverClient.getBrowserFrame(), (Object)("The " + driverGroup.getName() + " group contains properties and/or functions\n that will also be deleted." + "  Continue with group deletion?"), (String)"Delete Group", (int)0, (int)3);
                    if (n != 0) break;
                    driverModel.remove(driverGroup);
                }
                this.fGroupTable.setSelectionBasedOnIndex(nArray[0]);
            }
        }
    }

    protected void propertyTableEvent(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        switch (Integer.decode(string)) {
            case 1: {
                String string2 = this.fPropertyTablePanel.getEntryText();
                if (!this.fDriverClient.isValidPropertyName(string2, this.fGroup, true)) break;
                DriverProperty driverProperty = this.fDriverClient.getDriverModel().createProperty(string2, this.fGroup);
                this.fDriverClient.getDriverModel().add(driverProperty);
                break;
            }
            case 2: {
                if (!this.fPropertyTable.willDeleteBasedOnSelection(true)) break;
                int[] nArray = this.fPropertyTable.getMultipleRowSelctionIndices();
                for (int i = nArray.length - 1; i >= 0; --i) {
                    String string3 = ((DriverProperty)this.fGroup.getProperties().get(nArray[i])).getName();
                    DriverModel driverModel = this.fDriverClient.getDriverModel();
                    driverModel.remove(driverModel.getProperty(string3, this.fGroup.getName()));
                }
                this.fPropertyTable.setSelectionBasedOnIndex(nArray[0]);
            }
        }
    }

    protected void functionTableEvent(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        switch (Integer.decode(string)) {
            case 1: {
                String string2 = this.fFunctionTablePanel.getEntryText();
                if (!this.fDriverClient.isValidFunctionName(string2, this.fGroup, true)) break;
                DriverFunction driverFunction = new DriverFunction(string2, this.fGroup);
                this.fDriverClient.getDriverModel().add(driverFunction);
                break;
            }
            case 2: {
                if (!this.fFunctionTable.willDeleteBasedOnSelection(true)) break;
                int[] nArray = this.fFunctionTable.getMultipleRowSelctionIndices();
                for (int i = nArray.length - 1; i >= 0; --i) {
                    String string3 = this.fGroup.getFunctions().get(nArray[i]).getName();
                    DriverModel driverModel = this.fDriverClient.getDriverModel();
                    driverModel.remove(driverModel.getFunction(string3, this.fGroup));
                }
                this.fFunctionTable.setSelectionBasedOnIndex(nArray[0]);
            }
        }
    }

    public class FunctionListTableModel
    extends DriverTableModel
    implements DriverModelListener {
        private static final long serialVersionUID = 1L;

        @Override
        public void driverStateChanged(DriverModelEvent driverModelEvent) {
            if (driverModelEvent.getType() == 11) {
                this.fireTableDataChanged();
            }
            if (driverModelEvent.getType() == 12) {
                this.fireTableDataChanged();
            }
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return "Index";
            }
            return "Function Name";
        }

        @Override
        public int getRowCount() {
            if (ListPanel.this.fGroup == null) {
                return 0;
            }
            return ListPanel.this.fGroup.getFunctions().size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return new Integer(n + 1);
            }
            if (ListPanel.this.fGroup != null) {
                return ListPanel.this.fGroup.getFunctions().get(n);
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 != 1) {
                return;
            }
            if (ListPanel.this.fGroup != null) {
                DriverFunction driverFunction = ListPanel.this.fGroup.getFunctions().get(n);
                if (driverFunction.getName().equalsIgnoreCase((String)object)) {
                    return;
                }
                if (ListPanel.this.fDriverClient.isValidFunctionName((String)object, driverFunction.getGroup(), true)) {
                    driverFunction.setName((String)object);
                    this.fireTableDataChanged();
                    for (int i = 0; i < this.getRowCount(); ++i) {
                        DriverFunction driverFunction2 = (DriverFunction)this.getValueAt(i, 1);
                        if (!((String)object).equalsIgnoreCase(driverFunction2.getName())) continue;
                        ListPanel.this.fFunctionTable.setRowSelectionInterval(i, i);
                        break;
                    }
                }
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 0;
        }
    }

    public class PropertyListTableModel
    extends DriverTableModel
    implements DriverModelListener {
        private static final long serialVersionUID = 1L;

        @Override
        public void driverStateChanged(DriverModelEvent driverModelEvent) {
            if (driverModelEvent.getType() == 7) {
                this.fireTableDataChanged();
            }
            if (driverModelEvent.getType() == 8) {
                this.fireTableDataChanged();
            }
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return "Index";
            }
            return "Property Name";
        }

        @Override
        public int getRowCount() {
            if (ListPanel.this.fGroup == null) {
                return 0;
            }
            return ListPanel.this.fGroup.getProperties().size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return new Integer(n + 1);
            }
            if (ListPanel.this.fGroup != null) {
                return ListPanel.this.fGroup.getProperties().get(n);
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 != 1) {
                return;
            }
            if (ListPanel.this.fGroup != null) {
                DriverProperty driverProperty = (DriverProperty)ListPanel.this.fGroup.getProperties().get(n);
                if (driverProperty.getName().equalsIgnoreCase((String)object)) {
                    return;
                }
                if (ListPanel.this.fDriverClient.isValidPropertyName((String)object, driverProperty.getGroup(), true)) {
                    driverProperty.setName((String)object);
                    this.fireTableDataChanged();
                    for (int i = 0; i < this.getRowCount(); ++i) {
                        DriverProperty driverProperty2 = (DriverProperty)this.getValueAt(i, 1);
                        if (!((String)object).equalsIgnoreCase(driverProperty2.getName())) continue;
                        ListPanel.this.fPropertyTable.setRowSelectionInterval(i, i);
                        break;
                    }
                }
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 0;
        }
    }

    public class GroupListTableModel
    extends DriverTableModel
    implements DriverModelListener {
        private static final long serialVersionUID = 1L;

        @Override
        public void driverStateChanged(DriverModelEvent driverModelEvent) {
            if (driverModelEvent.getType() == 3) {
                this.fireTableDataChanged();
            }
            if (driverModelEvent.getType() == 4) {
                this.fireTableDataChanged();
            }
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return "Index";
            }
            return "Group Name";
        }

        @Override
        public int getRowCount() {
            if (ListPanel.this.fDriverClient.getDriverModel() == null) {
                return 0;
            }
            return ListPanel.this.fDriverClient.getDriverModel().getGroups().length - 1;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return new Integer(n + 1);
            }
            String string = ListPanel.this.fDriverClient.getDriverModel().getGroupNames().get(n + 1);
            DriverGroup driverGroup = ListPanel.this.fDriverClient.getDriverModel().getGroup(string);
            return driverGroup;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 != 1) {
                return;
            }
            String string = ListPanel.this.fDriverClient.getDriverModel().getGroupNames().get(n + 1);
            DriverGroup driverGroup = ListPanel.this.fDriverClient.getDriverModel().getGroup(string);
            if (driverGroup.getName().equalsIgnoreCase((String)object)) {
                return;
            }
            if (ListPanel.this.fDriverClient.isValidGroupName((String)object, true)) {
                driverGroup.setName((String)object);
                this.fireTableDataChanged();
                for (int i = 0; i < this.getRowCount(); ++i) {
                    if (!((String)object).equalsIgnoreCase(((DriverGroup)this.getValueAt(i, 1)).getName())) continue;
                    ListPanel.this.fGroupTable.setRowSelectionInterval(i, i);
                    break;
                }
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 0;
        }
    }
}

