/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtool.panel;

import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTabbedPane;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverClient;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverDataType;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverGroup;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverModel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverProperty;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.MIDNode;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.MIDTextField;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.MIDTool;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.panel.BasePanel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.table.DriverTableModel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.table.MIDTable;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.table.MIDTablePanel;
import com.mathworks.widgets.SyntaxTextPane;
import com.mathworks.widgets.SyntaxTextPaneBase;
import com.mathworks.widgets.text.mcode.MLanguage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class PropertyPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;
    MJTabbedPane fTabbedPane;
    private PropertyGeneral fGeneralPanel;
    private PropertyCode fPropertyCodePanel;
    private PropertyType fPropertyTypesPanel;
    private static String[] sCodeTypes = new String[]{"Instrument Commands", "M-Code"};
    private DriverProperty fProperty;
    private static final String[] sReadOnlyValues = new String[]{"never", "while open", "always"};
    private static final String[] kStandardSupportedTypes = new String[]{"Boolean", "Double", "String"};
    private static final String[] kGenericSupportedTypes = new String[]{"Boolean", "Double", "String", "Any"};
    private static final String[] kAllSupportedTypes = kGenericSupportedTypes;

    public PropertyPanel(DriverClient driverClient) {
        super(driverClient);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.fTabbedPane = new MJTabbedPane();
        this.fTabbedPane.setPreferredSize(new Dimension(20, 20));
        this.fPropertyCodePanel = new PropertyCode(driverClient);
        this.fTabbedPane.add((Component)((Object)this.fPropertyCodePanel), (Object)"Code");
        this.fPropertyTypesPanel = new PropertyType(driverClient);
        this.fTabbedPane.add((Component)((Object)this.fPropertyTypesPanel), (Object)"Property Values");
        this.fGeneralPanel = new PropertyGeneral(driverClient);
        this.fTabbedPane.add((Component)((Object)this.fGeneralPanel), (Object)"General");
        this.add((Component)this.fTabbedPane, "Center");
    }

    @Override
    public void driverDidLoad(DriverModel driverModel) {
        this.fTabbedPane.setSelectedIndex(0);
        this.fGeneralPanel.driverDidLoad(driverModel);
        this.fPropertyTypesPanel.driverDidLoad(driverModel);
        this.fPropertyCodePanel.driverDidLoad(driverModel);
    }

    @Override
    public void updatePanel(MIDNode mIDNode) {
        this.fProperty = (DriverProperty)mIDNode.getUserData();
        this.fGeneralPanel.updatePanel(mIDNode);
        this.fPropertyCodePanel.updatePanel(mIDNode);
        this.fPropertyTypesPanel.updatePanel(mIDNode);
    }

    @Override
    public void updateNode(MIDNode mIDNode) {
        this.fGeneralPanel.updateNode(mIDNode);
        this.fPropertyCodePanel.updateNode(mIDNode);
        this.fPropertyTypesPanel.updateNode(mIDNode);
    }

    public class PropertyType
    extends BasePanel
    implements ItemListener {
        private static final long serialVersionUID = 1L;
        protected static final int NONE = 0;
        protected static final int BOUNDED = 1;
        protected static final int ENUM = 2;
        protected static final int DOUBLE_ENUM = 3;
        private static final int TYPE_COLUMN = 1;
        private static final int CONSTRAINT_COLUMN = 2;
        private MIDTable fTypeTable;
        private MIDTablePanel fTypePanel;
        private MJLabel fDependentValueLabel;
        private MJComboBox fDependentProperty;
        private MJComboBox fDependentValue;
        private BoundedPanel fBoundedPanel;
        private MIDTable fDoubleTable;
        private MIDTablePanel fDoublePanel;
        private MIDTable fStringTable;
        private MIDTablePanel fStringPanel;
        private MJPanel fConstraintPanel;
        private MJPanel[] constraintPanels;
        private MJPanel currentPanel;
        private PropertyTypeCellEditor fPropertyTypeCellEditor;
        private PropertyTypeCellRenderer fPropertyTypeCellRenderer;
        private DriverDataType fSelectedPropertyType;

        public PropertyType(DriverClient driverClient) {
            super(driverClient);
            this.setLayout(new BorderLayout());
            this.add((Component)this.createTypeListPanel(), "North");
            this.fConstraintPanel = this.createConstraintPanel();
            this.add((Component)this.fConstraintPanel, "Center");
            this.createDependentPropertyPanel();
            this.add((Component)this.createDependentPropertyPanel(), "South");
            this.constraintPanels = new MJPanel[4];
            this.constraintPanels[0] = this.createNonePanel();
            this.constraintPanels[1] = this.createBoundedPanel();
            this.constraintPanels[2] = this.createStringEnumPanel();
            this.constraintPanels[3] = this.createDoubleEnumPanel();
            this.currentPanel = null;
            this.setConstraintPanel(2);
        }

        private MJPanel createTypeListPanel() {
            this.fTypeTable = new MIDTable(new TypeTableModel());
            this.fTypeTable.setRowSelectionAllowed(true);
            this.fTypeTable.setSelectionMode(0);
            this.fTypeTable.setRowSelectionAllowed(true);
            this.setDefaultColumnSizes(this.fTypeTable);
            this.fTypePanel = new TypePanel(this.fTypeTable, "Allowed property values");
            this.fTypePanel.setAllowsMoveEntry(false);
            this.fTypePanel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PropertyType.this.typeTableEvent(actionEvent);
                }
            });
            this.fTypeTable.getSelectionModel().addListSelectionListener(this.fTypePanel);
            TableColumnModel tableColumnModel = this.fTypeTable.getColumnModel();
            this.fPropertyTypeCellEditor = new PropertyTypeCellEditor((JComboBox)new MJComboBox((Object[])kAllSupportedTypes));
            tableColumnModel.getColumn(1).setCellEditor(this.fPropertyTypeCellEditor);
            tableColumnModel.getColumn(2).setCellEditor(new ConstraintCellEditor(new MJComboBox()));
            this.fPropertyTypeCellRenderer = new PropertyTypeCellRenderer();
            tableColumnModel.getColumn(1).setCellRenderer(this.fPropertyTypeCellRenderer);
            tableColumnModel.getColumn(2).setCellRenderer(new ConstraintCellRenderer());
            return this.fTypePanel;
        }

        private void setDefaultColumnSizes(JTable jTable) {
            TableColumn tableColumn = this.initColumnSize(jTable, 0);
            tableColumn.setPreferredWidth(tableColumn.getPreferredWidth() * 3 / 2);
            tableColumn.setMaxWidth(tableColumn.getPreferredWidth() * 2);
            this.initColumnSize(jTable, 1);
            this.initColumnSize(jTable, 2);
        }

        private MJPanel createDependentPropertyPanel() {
            MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
            mJPanel.setBorder((Border)BorderFactory.createTitledBorder("Property value dependency"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0);
            MJLabel mJLabel = new MJLabel("Name:");
            mJPanel.add((Component)mJLabel, (Object)gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.insets = new Insets(0, 5, 5, 5);
            this.fDependentProperty = new MJComboBox();
            this.fDependentProperty.addItemListener((ItemListener)this);
            mJPanel.add((Component)this.fDependentProperty, (Object)gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.fDependentValueLabel = new MJLabel("Value:");
            mJPanel.add((Component)this.fDependentValueLabel, (Object)gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            this.fDependentValue = new MJComboBox();
            this.fDependentValue.addItemListener((ItemListener)this);
            mJPanel.add((Component)this.fDependentValue, (Object)gridBagConstraints);
            return mJPanel;
        }

        private MJPanel createConstraintPanel() {
            this.fConstraintPanel = new MJPanel((LayoutManager)new GridBagLayout());
            this.fConstraintPanel.setBorder((Border)BorderFactory.createTitledBorder("Constraints for selected property value"));
            return this.fConstraintPanel;
        }

        private MJPanel createNonePanel() {
            MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
            MJLabel mJLabel = new MJLabel("Not Applicable");
            mJLabel.setHorizontalAlignment(0);
            mJPanel.add((Component)mJLabel, (Object)"Center");
            return mJPanel;
        }

        private MJPanel createBoundedPanel() {
            this.fBoundedPanel = new BoundedPanel();
            return this.fBoundedPanel;
        }

        private MJPanel createDoubleEnumPanel() {
            this.fDoubleTable = new MIDTable(new DoubleEnumTableModel());
            this.fDoubleTable.setRowSelectionAllowed(true);
            this.fDoublePanel = new MIDTablePanel(this.fDoubleTable, null);
            this.fDoublePanel.setAllowsMoveEntry(false);
            this.fDoublePanel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PropertyType.this.doubleEnumTableEvent(actionEvent);
                }
            });
            MIDTextField mIDTextField = (MIDTextField)((Object)this.fDoublePanel.getEntryTextComponent());
            mIDTextField.setMode(1);
            mIDTextField.setMin(Double.NEGATIVE_INFINITY);
            mIDTextField.setMax(Double.POSITIVE_INFINITY);
            mIDTextField.setText("0");
            this.fDoublePanel.setEntryLabelText("Add enumeration:");
            this.fDoublePanel.setPreferredSize(new Dimension(20, 20));
            return this.fDoublePanel;
        }

        private MJPanel createStringEnumPanel() {
            this.fStringTable = new MIDTable(new StringEnumTableModel());
            this.fStringTable.setRowSelectionAllowed(true);
            this.fStringPanel = new MIDTablePanel(this.fStringTable, null);
            this.fStringPanel.setAllowsMoveEntry(false);
            this.fStringPanel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PropertyType.this.stringEnumTableEvent(actionEvent);
                }
            });
            this.fStringPanel.setEntryLabelText("Add property value:");
            this.fStringPanel.setPreferredSize(new Dimension(20, 20));
            return this.fStringPanel;
        }

        @Override
        public void updatePanel(MIDNode mIDNode) {
            this.fSelectedPropertyType = null;
            this.fDependentProperty.removeAllItems();
            this.fDependentProperty.addItem((Object)new DriverProperty("None", (DriverGroup)null));
            Vector<?> vector = this.fDriverClient.getDriverModel().getEnumeratedProperties(PropertyPanel.this.fProperty.getGroup().getName());
            for (int i = 0; i < vector.size(); ++i) {
                DriverProperty driverProperty = (DriverProperty)vector.get(i);
                if (driverProperty.getName().equalsIgnoreCase(PropertyPanel.this.fProperty.getName())) continue;
                this.fDependentProperty.addItem((Object)driverProperty);
            }
            Vector<DriverDataType> vector2 = PropertyPanel.this.fProperty.getPropertyTypes();
            this.fTypeTable.clearSelection();
            if (vector2.size() > 0) {
                this.fTypeTable.setRowSelectionInterval(0, 0);
            } else {
                this.constraintChanged(-1);
            }
            this.fTypePanel.updateButtonState();
        }

        @Override
        public void updateNode(MIDNode mIDNode) {
            this.fStringTable.stopEditing();
            this.fDoubleTable.stopEditing();
            this.fTypeTable.stopEditing();
            this.fTypeTable.clearSelection();
            if (this.fSelectedPropertyType != null) {
                this.saveDataType(this.fSelectedPropertyType);
            }
        }

        @Override
        public void driverDidLoad(DriverModel driverModel) {
            PropertyPanel.this.fTabbedPane.setSelectedIndex(0);
            if (driverModel.getDriverType() == 4) {
                this.fPropertyTypeCellEditor.setSupportedTypes(kGenericSupportedTypes);
                this.fPropertyTypeCellRenderer.setSupportedTypes(kGenericSupportedTypes);
            } else {
                this.fPropertyTypeCellEditor.setSupportedTypes(kStandardSupportedTypes);
                this.fPropertyTypeCellRenderer.setSupportedTypes(kStandardSupportedTypes);
            }
        }

        protected void typeTableEvent(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            this.fTypeTable.cancelEditing();
            switch (Integer.decode(string)) {
                case 1: {
                    DriverDataType driverDataType = new DriverDataType();
                    driverDataType.setParentProperty(PropertyPanel.this.fProperty);
                    PropertyPanel.this.fProperty.addPropertyType(driverDataType);
                    ((AbstractTableModel)this.fTypeTable.getModel()).fireTableDataChanged();
                    this.fTypeTable.ensureRowIsVisible(this.fTypeTable.getRowCount() - 1);
                    int n = this.fTypeTable.getRowCount();
                    this.fTypeTable.setSelectionBasedOnIndex(n);
                    break;
                }
                case 2: {
                    if (!this.fTypeTable.willDeleteBasedOnSelection(true)) break;
                    int[] nArray = this.fTypeTable.getMultipleRowSelctionIndices();
                    this.fTypeTable.clearSelection();
                    for (int i = nArray.length - 1; i >= 0; --i) {
                        PropertyPanel.this.fProperty.removePropertyType(nArray[i]);
                    }
                    ((AbstractTableModel)this.fTypeTable.getModel()).fireTableDataChanged();
                    this.fTypeTable.setSelectionBasedOnIndex(nArray[0]);
                }
            }
        }

        protected void doubleEnumTableEvent(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            this.fDoubleTable.stopEditing();
            switch (Integer.decode(string)) {
                case 1: {
                    if (this.fDoublePanel.getEntryText().length() == 0) {
                        this.showEmptyEnumerationError();
                        return;
                    }
                    try {
                        double d = Double.parseDouble(this.fDoublePanel.getEntryText());
                        this.fSelectedPropertyType.addDoubleEnum(new Double(d));
                        ((AbstractTableModel)this.fDoubleTable.getModel()).fireTableDataChanged();
                        this.fDoubleTable.ensureRowIsVisible(this.fDoubleTable.getRowCount() - 1);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                case 2: {
                    if (!this.fDoubleTable.willDeleteBasedOnSelection(true)) break;
                    int[] nArray = this.fDoubleTable.getMultipleRowSelctionIndices();
                    for (int i = nArray.length - 1; i >= 0; --i) {
                        this.fSelectedPropertyType.removeDoubleEnum(nArray[i]);
                    }
                    ((AbstractTableModel)this.fDoubleTable.getModel()).fireTableDataChanged();
                    this.fDoubleTable.setSelectionBasedOnIndex(nArray[0]);
                }
            }
        }

        protected void stringEnumTableEvent(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            this.fStringTable.stopEditing();
            switch (Integer.decode(string)) {
                case 1: {
                    String string2 = this.fStringPanel.getEntryText();
                    if (string2.length() == 0) {
                        this.showEmptyEnumerationError();
                        return;
                    }
                    this.fSelectedPropertyType.addStringEnumKey(string2);
                    this.fSelectedPropertyType.addStringEnumVal("");
                    ((AbstractTableModel)this.fStringTable.getModel()).fireTableDataChanged();
                    this.fStringTable.ensureRowIsVisible(this.fStringTable.getRowCount() - 1);
                    break;
                }
                case 2: {
                    if (!this.fStringTable.willDeleteBasedOnSelection(true)) break;
                    int[] nArray = this.fStringTable.getMultipleRowSelctionIndices();
                    for (int i = nArray.length - 1; i >= 0; --i) {
                        this.fSelectedPropertyType.removeStringEnumKey(nArray[i]);
                        this.fSelectedPropertyType.removeStringEnumVal(nArray[i]);
                    }
                    ((AbstractTableModel)this.fStringTable.getModel()).fireTableDataChanged();
                    this.fStringTable.setSelectionBasedOnIndex(nArray[0]);
                }
            }
        }

        protected void constraintChanged(int n) {
            int n2 = 0;
            if (n >= 0) {
                String string = (String)this.fTypeTable.getValueAt(n, 1);
                String string2 = (String)this.fTypeTable.getValueAt(n, 2);
                if (string2.equalsIgnoreCase("bounded")) {
                    n2 = 1;
                } else if (string2.equalsIgnoreCase("enumeration")) {
                    if (string.equalsIgnoreCase("double")) {
                        n2 = 3;
                    } else if (string.equalsIgnoreCase("string")) {
                        n2 = 2;
                    }
                }
                this.setConstraintPanel(n2);
                this.validate();
                this.repaint();
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1 && itemEvent.getSource() == this.fDependentProperty) {
                this.dependentPropertyChanged();
                return;
            }
        }

        private void dependentPropertyChanged() {
            DriverProperty driverProperty = (DriverProperty)this.fDependentProperty.getSelectedItem();
            if (driverProperty == null) {
                return;
            }
            this.fDependentValue.removeAllItems();
            if (driverProperty.getName().equalsIgnoreCase("none")) {
                this.fDependentValue.setEnabled(false);
                this.fDependentValueLabel.setEnabled(false);
            } else {
                Vector<String> vector = driverProperty.getEnumValues();
                if (vector != null) {
                    for (int i = 0; i < vector.size(); ++i) {
                        this.fDependentValue.addItem((Object)vector.get(i).toLowerCase());
                    }
                }
                this.fDependentValue.setEnabled(true);
                this.fDependentValueLabel.setEnabled(true);
            }
        }

        private void loadDataType(DriverDataType driverDataType) {
            this.fBoundedPanel.setRange(driverDataType.getRangeMin(), driverDataType.getRangeMax());
            String string = driverDataType.getDependentPropertyName();
            this.fDependentProperty.setSelectedIndex(0);
            if (string.length() > 0) {
                String string2 = PropertyPanel.this.fProperty.getGroup().getName();
                DriverProperty driverProperty = this.fDriverClient.getDriverModel().getProperty(string, PropertyPanel.this.fProperty.getGroup().getName());
                if (driverProperty == null && !string2.equals("parent")) {
                    driverProperty = this.fDriverClient.getDriverModel().getProperty(string, "parent");
                }
                if (driverProperty != null) {
                    this.fDependentProperty.setSelectedItem((Object)driverProperty);
                    this.fDependentValue.setSelectedItem((Object)driverDataType.getDependentPropertyValue().toLowerCase());
                }
            }
        }

        private void saveDataType(DriverDataType driverDataType) {
            driverDataType.setRangeMin(this.fBoundedPanel.getRangeMin());
            driverDataType.setRangeMax(this.fBoundedPanel.getRangeMax());
            if (this.fDependentProperty.getSelectedIndex() != 0) {
                DriverProperty driverProperty = (DriverProperty)this.fDependentProperty.getSelectedItem();
                driverDataType.setDependentPropertyName(driverProperty.getName());
                driverDataType.setDependentPropertyValue((String)this.fDependentValue.getSelectedItem());
            } else {
                driverDataType.setDependentPropertyName("");
                driverDataType.setDependentPropertyValue("");
            }
        }

        protected void setConstraintPanel(int n) {
            this.removeConstraintPanel();
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 2, 0, 1, 1.0, 1.0, 18, 1, new Insets(0, 5, 5, 5), 0, 0);
            this.fConstraintPanel.add((Component)this.constraintPanels[n], (Object)gridBagConstraints);
            this.currentPanel = this.constraintPanels[n];
        }

        private void removeConstraintPanel() {
            if (this.currentPanel != null) {
                this.fConstraintPanel.remove((Component)this.currentPanel);
            }
        }

        private void showEmptyEnumerationError() {
            MJOptionPane.showMessageDialog((Component)this.fDriverClient.getBrowserFrame(), (Object)"The enumeration value cannot be empty.", (String)"Invalid Enumeration", (int)0);
        }

        private void showNonDoubleEnumerationError() {
            MJOptionPane.showMessageDialog((Component)this.fDriverClient.getBrowserFrame(), (Object)"The enumeration value must be a double.", (String)"Invalid Enumeration", (int)0);
        }

        private class ConstraintCellRenderer
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = 1L;
            MJComboBox box;

            public ConstraintCellRenderer() {
                Object[] objectArray = new String[]{"None", "Bounded", "Enumeration"};
                this.box = new MJComboBox(objectArray);
                this.box.setBorder(null);
            }

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                String string = (String)jTable.getValueAt(n, 1);
                this.setEnabled(!string.equalsIgnoreCase("boolean") && !string.equalsIgnoreCase("any"));
                this.box.setEnabled(this.isEnabled());
                this.box.setSelectedItem(object);
                return this.box;
            }
        }

        private class PropertyTypeCellRenderer
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = 1L;
            MJComboBox box = new MJComboBox();

            public PropertyTypeCellRenderer() {
                this.setSupportedTypes(kStandardSupportedTypes);
                this.box.setBorder(null);
            }

            public void setSupportedTypes(String[] stringArray) {
                this.box.removeAllItems();
                for (int i = 0; i < stringArray.length; ++i) {
                    this.box.addItem((Object)stringArray[i]);
                }
            }

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                this.box.setSelectedItem(object);
                return this.box;
            }
        }

        private class ConstraintCellEditor
        extends DefaultCellEditor
        implements ItemListener {
            private static final long serialVersionUID = 1L;
            public String[] kConstraintFull;
            public String[] kConstraintPartial;
            public String[] kConstraintNone;
            MJComboBox box;
            MJComboBox fullBox;
            MJComboBox partialBox;
            MJComboBox noneBox;

            public ConstraintCellEditor(MJComboBox mJComboBox) {
                super((JComboBox<?>)mJComboBox);
                this.kConstraintFull = new String[]{"None", "Bounded", "Enumeration"};
                this.kConstraintPartial = new String[]{"None", "Enumeration"};
                this.kConstraintNone = new String[]{"None"};
                this.box = mJComboBox;
                this.box.addItem((Object)"None");
                this.box.addItem((Object)"Bounded");
                this.box.addItem((Object)"Enumeration");
                this.fullBox = new MJComboBox((Object[])this.kConstraintFull);
                this.fullBox.setBorder(null);
                this.fullBox.addItemListener((ItemListener)this);
                this.partialBox = new MJComboBox((Object[])this.kConstraintPartial);
                this.partialBox.setBorder(null);
                this.partialBox.addItemListener((ItemListener)this);
                this.noneBox = new MJComboBox((Object[])this.kConstraintNone);
                this.noneBox.setBorder(null);
                this.noneBox.setEnabled(false);
            }

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    int n = PropertyType.this.fTypeTable.getEditingRow();
                    String string = (String)((JComboBox)itemEvent.getSource()).getSelectedItem();
                    this.box.setSelectedItem((Object)string);
                    ListSelectionModel listSelectionModel = PropertyType.this.fTypeTable.getSelectionModel();
                    int n2 = listSelectionModel.getLeadSelectionIndex();
                    if (n >= 0) {
                        PropertyType.this.fTypeTable.setSelectionBasedOnIndex(n);
                    }
                    PropertyType.this.constraintChanged(n2);
                }
            }

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                String string = (String)jTable.getValueAt(n, 1);
                MJComboBox mJComboBox = string.equalsIgnoreCase("double") ? this.fullBox : (string.equalsIgnoreCase("string") ? this.partialBox : this.noneBox);
                mJComboBox.setSelectedItem(object);
                this.box.setSelectedItem(object);
                return mJComboBox;
            }
        }

        private class PropertyTypeCellEditor
        extends DefaultCellEditor
        implements ItemListener {
            private static final long serialVersionUID = 1L;
            JComboBox box;
            JComboBox fullBox;

            public PropertyTypeCellEditor(JComboBox jComboBox) {
                super(jComboBox);
                this.box = jComboBox;
                this.box.setBorder(null);
                this.fullBox = new JComboBox();
                this.setSupportedTypes(kStandardSupportedTypes);
                this.fullBox.setBorder(null);
                this.fullBox.addItemListener(this);
            }

            public void setSupportedTypes(String[] stringArray) {
                this.fullBox.removeAllItems();
                for (int i = 0; i < stringArray.length; ++i) {
                    this.fullBox.addItem(stringArray[i]);
                }
            }

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    int n = PropertyType.this.fTypeTable.getEditingRow();
                    String string = (String)((JComboBox)itemEvent.getSource()).getSelectedItem();
                    this.box.setSelectedItem(string);
                    if (n >= 0) {
                        PropertyType.this.fTypeTable.setSelectionBasedOnIndex(n);
                    }
                }
            }

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                this.box.setSelectedItem(object);
                this.fullBox.setSelectedItem(object);
                return this.fullBox;
            }
        }

        public class StringEnumTableModel
        extends DriverTableModel {
            private static final long serialVersionUID = 1L;
            private final String[] sHeaders = new String[]{"Property Value", "Instrument Value"};

            @Override
            public String getColumnName(int n) {
                return this.sHeaders[n];
            }

            @Override
            public int getRowCount() {
                if (PropertyType.this.fSelectedPropertyType == null) {
                    return 0;
                }
                return PropertyType.this.fSelectedPropertyType.getStringEnumKeyCount();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                if (PropertyType.this.fSelectedPropertyType != null) {
                    if (n2 == 0) {
                        return PropertyType.this.fSelectedPropertyType.getStringEnumKey(n);
                    }
                    return PropertyType.this.fSelectedPropertyType.getStringEnumVal(n);
                }
                return null;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (PropertyType.this.fSelectedPropertyType != null) {
                    if (n2 == 0) {
                        String string = (String)object;
                        if (string.length() == 0) {
                            PropertyType.this.showEmptyEnumerationError();
                            return;
                        }
                        PropertyType.this.fSelectedPropertyType.setStringEnumKey((String)object, n);
                    } else {
                        PropertyType.this.fSelectedPropertyType.setStringEnumVal((String)object, n);
                    }
                }
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return true;
            }
        }

        public class DoubleEnumTableModel
        extends DriverTableModel {
            private static final long serialVersionUID = 1L;

            @Override
            public String getColumnName(int n) {
                return "Enumeration";
            }

            @Override
            public int getRowCount() {
                if (PropertyType.this.fSelectedPropertyType == null) {
                    return 0;
                }
                return PropertyType.this.fSelectedPropertyType.getDoubleEnumCount();
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                if (PropertyType.this.fSelectedPropertyType != null) {
                    return PropertyType.this.fSelectedPropertyType.getDoubleEnum(n);
                }
                return null;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (PropertyType.this.fSelectedPropertyType != null) {
                    String string = (String)object;
                    if (string.length() == 0) {
                        PropertyType.this.showEmptyEnumerationError();
                        return;
                    }
                    try {
                        Double d = new Double(Double.parseDouble(string));
                        PropertyType.this.fSelectedPropertyType.setDoubleEnum(d, n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        PropertyType.this.showNonDoubleEnumerationError();
                    }
                }
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return true;
            }
        }

        public class TypeTableModel
        extends DriverTableModel {
            private static final long serialVersionUID = 1L;
            private final String[] sHeaders = new String[]{"Index", "Data Type", "Constraint"};

            @Override
            public void exchangeRows(int n, int n2) {
                DriverDataType driverDataType = PropertyPanel.this.fProperty.getPropertyTypes().get(n);
                PropertyPanel.this.fProperty.getPropertyTypes().setElementAt(PropertyPanel.this.fProperty.getPropertyTypes().get(n2), n);
                PropertyPanel.this.fProperty.getPropertyTypes().setElementAt(driverDataType, n2);
            }

            @Override
            public String getColumnName(int n) {
                return this.sHeaders[n];
            }

            @Override
            public int getRowCount() {
                if (PropertyPanel.this.fProperty == null) {
                    return 0;
                }
                return PropertyPanel.this.fProperty.getPropertyTypes().size();
            }

            @Override
            public int getColumnCount() {
                return 3;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                if (PropertyPanel.this.fProperty != null) {
                    if (n2 == 0) {
                        return new Integer(n + 1);
                    }
                    if (n2 == 1) {
                        return PropertyPanel.this.fProperty.getPropertyTypes().get(n).getDataTypeString();
                    }
                    return PropertyPanel.this.fProperty.getPropertyTypes().get(n).getConstraintString();
                }
                return null;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (PropertyPanel.this.fProperty != null) {
                    switch (n2) {
                        case 0: {
                            try {
                                int n3 = Integer.parseInt((String)object);
                                int n4 = this.moveRow(n, n3 - 1);
                                this.fireTableDataChanged();
                                PropertyType.this.fTypeTable.setRowSelectionInterval(n4, n4);
                            }
                            catch (NumberFormatException numberFormatException) {
                                MJOptionPane.showMessageDialog((Component)PropertyType.this.fDriverClient.getBrowserFrame(), (Object)("The index must be an integer between 1 and " + this.getRowCount() + " ."), (String)"Index Error", (int)0);
                            }
                            break;
                        }
                        case 1: {
                            PropertyPanel.this.fProperty.getPropertyTypes().get(n).setDataType((String)object);
                            ListSelectionModel listSelectionModel = PropertyType.this.fTypeTable.getSelectionModel();
                            if (listSelectionModel.getLeadSelectionIndex() != n) break;
                            PropertyType.this.constraintChanged(n);
                            break;
                        }
                        case 2: {
                            PropertyPanel.this.fProperty.getPropertyTypes().get(n).setConstraintType((String)object);
                            PropertyType.this.constraintChanged(n);
                        }
                    }
                    this.fireTableDataChanged();
                }
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return true;
            }
        }

        public class TypePanel
        extends MIDTablePanel {
            private static final long serialVersionUID = 1L;

            public TypePanel(MIDTable mIDTable, String string) {
                super(mIDTable, string);
                this.fEntryTextLabel.getParent().remove(this.fEntryTextLabel);
                this.fEntryText.getParent().remove(this.fEntryText);
                this.fAppendButton.setVisible(false);
                this.fAddButton.setEnabled(true);
                this.fEntryTextLabel.setVisible(false);
                this.fEntryText.setVisible(false);
            }

            public Dimension getPreferredSize() {
                return new Dimension(50, 150);
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int n;
                    ListSelectionModel listSelectionModel = PropertyType.this.fTypeTable.getSelectionModel();
                    if (PropertyType.this.fSelectedPropertyType != null) {
                        PropertyType.this.saveDataType(PropertyType.this.fSelectedPropertyType);
                    }
                    if ((n = listSelectionModel.getLeadSelectionIndex()) >= 0 || !listSelectionModel.isSelectionEmpty()) {
                        Vector<DriverDataType> vector = PropertyPanel.this.fProperty.getPropertyTypes();
                        PropertyType.this.fSelectedPropertyType = vector.get(n);
                        PropertyType.this.loadDataType(PropertyType.this.fSelectedPropertyType);
                        PropertyType.this.constraintChanged(n);
                    } else {
                        PropertyType.this.constraintChanged(-1);
                        PropertyType.this.fSelectedPropertyType = null;
                    }
                    super.valueChanged(listSelectionEvent);
                }
            }

            @Override
            public void updateButtonState() {
                super.updateButtonState();
                if (PropertyType.this.fTypeTable.getRowCount() < 2) {
                    this.fDeleteButton.setEnabled(false);
                }
            }
        }

        protected class BoundedPanel
        extends MJPanel {
            private static final long serialVersionUID = 1L;
            private MIDTextField fRangeMin;
            private MIDTextField fRangeMax;

            public BoundedPanel() {
                this.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0);
                this.add(new JLabel("Minimum:"), gridBagConstraints);
                ++gridBagConstraints.gridy;
                this.add(new JLabel("Maximum:"), gridBagConstraints);
                ++gridBagConstraints.gridy;
                ++gridBagConstraints.gridx;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets = new Insets(0, 5, 5, 5);
                this.fRangeMin = new MIDTextField("range minimum", 0.0);
                this.fRangeMin.setMode(1);
                this.fRangeMin.setOKToBeEmpty(false);
                this.fRangeMin.setColumns(12);
                this.add((Component)((Object)this.fRangeMin), gridBagConstraints);
                ++gridBagConstraints.gridy;
                this.fRangeMax = new MIDTextField("range maximum", 0.0);
                this.fRangeMax.setMode(1);
                this.fRangeMax.setOKToBeEmpty(false);
                this.fRangeMax.setColumns(12);
                this.add((Component)((Object)this.fRangeMax), gridBagConstraints);
                ++gridBagConstraints.gridy;
                gridBagConstraints.weighty = 1.0;
                this.add(new JPanel(), gridBagConstraints);
                this.setRangeMin(0.0);
                this.setRangeMax(0.0);
            }

            public void setRange(double d, double d2) {
                this.setRangeMin(d);
                this.setRangeMax(d2);
            }

            public void setRangeMin(double d) {
                this.fRangeMin.setText(String.valueOf(d));
            }

            public void setRangeMax(double d) {
                this.fRangeMax.setText(String.valueOf(d));
            }

            public void setRangeMin(Double d) {
                this.fRangeMin.setText(d.toString());
            }

            public void setRangeMax(Double d) {
                this.fRangeMax.setText(d.toString());
            }

            public Double getRangeMin() {
                try {
                    Double d = Double.valueOf(this.fRangeMin.getText());
                    return d;
                }
                catch (NumberFormatException numberFormatException) {
                    return new Double(0.0);
                }
            }

            public Double getRangeMax() {
                try {
                    Double d = Double.valueOf(this.fRangeMax.getText());
                    return d;
                }
                catch (NumberFormatException numberFormatException) {
                    return new Double(0.0);
                }
            }

            public String getRangeMinString() {
                return this.fRangeMin.getText();
            }

            public String getRangeMaxString() {
                return this.fRangeMax.getText();
            }
        }
    }

    public class PropertyCode
    extends BasePanel
    implements ItemListener {
        private static final long serialVersionUID = 1L;
        private MJComboBox fCodeSelection;
        private MJPanel fCommandPanel;
        private MJTextField fGetCommand;
        private MJTextField fSetCommand;
        private SyntaxTextPane fGetSyntaxPanel;
        private SyntaxTextPane fSetSyntaxPanel;
        private MJPanel fMCodePanel;

        public PropertyCode(DriverClient driverClient) {
            super(driverClient);
            this.layoutPanel();
        }

        private void layoutPanel() {
            this.setLayout(new BorderLayout(0, 0));
            this.add((Component)this.createCommandPanel(), "Center");
            this.add((Component)this.createCodeSelectionPanel(), "North");
            this.fMCodePanel = this.createMCodePanel();
        }

        private MJPanel createCodeSelectionPanel() {
            MJPanel mJPanel = new MJPanel((LayoutManager)new FlowLayout(0));
            mJPanel.add((Component)new MJLabel("Property style:"));
            this.fCodeSelection = new MJComboBox((Object[])sCodeTypes);
            this.fCodeSelection.addItemListener((ItemListener)this);
            mJPanel.add((Component)this.fCodeSelection);
            return mJPanel;
        }

        private MJPanel createCommandPanel() {
            MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0);
            mJPanel.add((Component)new JLabel("Get command:"), (Object)gridBagConstraints);
            ++gridBagConstraints.gridy;
            mJPanel.add((Component)new JLabel("Set command:"), (Object)gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(5, 6, 0, 5);
            this.fGetCommand = new MJTextField();
            mJPanel.add((Component)this.fGetCommand, (Object)gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.fSetCommand = new MJTextField();
            mJPanel.add((Component)this.fSetCommand, (Object)gridBagConstraints);
            gridBagConstraints = new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0);
            mJPanel.add((Component)new MJPanel(), (Object)gridBagConstraints);
            this.fCommandPanel = mJPanel;
            return mJPanel;
        }

        private MJPanel createMCodePanel() {
            MJPanel mJPanel = new MJPanel((LayoutManager)new GridLayout(2, 1));
            this.fGetSyntaxPanel = new SyntaxTextPane();
            this.fGetSyntaxPanel.setContentType(MLanguage.M_MIME_TYPE);
            MJPanel mJPanel2 = new MJPanel((LayoutManager)new BorderLayout());
            mJPanel2.setBorder((Border)BorderFactory.createTitledBorder("Get code"));
            mJPanel2.add((Component)SyntaxTextPane.getDisplayComponent((SyntaxTextPaneBase)this.fGetSyntaxPanel), (Object)"Center");
            mJPanel.add((Component)mJPanel2);
            this.fSetSyntaxPanel = new SyntaxTextPane();
            this.fSetSyntaxPanel.setContentType(MLanguage.M_MIME_TYPE);
            mJPanel2 = new MJPanel((LayoutManager)new BorderLayout());
            mJPanel2.setBorder((Border)BorderFactory.createTitledBorder("Set code"));
            mJPanel2.add((Component)SyntaxTextPane.getDisplayComponent((SyntaxTextPaneBase)this.fSetSyntaxPanel), (Object)"Center");
            mJPanel.add((Component)mJPanel2);
            return mJPanel;
        }

        @Override
        public void driverDidLoad(DriverModel driverModel) {
            PropertyPanel.this.fTabbedPane.setSelectedIndex(0);
            if (driverModel.getDriverType() == 0) {
                this.fCodeSelection.removeAllItems();
                this.fCodeSelection.addItem((Object)sCodeTypes[0]);
                this.fCodeSelection.addItem((Object)sCodeTypes[1]);
                this.fCodeSelection.setEnabled(true);
            } else {
                this.fCodeSelection.removeAllItems();
                this.fCodeSelection.addItem((Object)sCodeTypes[1]);
                this.fCodeSelection.setEnabled(false);
            }
        }

        @Override
        public void updatePanel(MIDNode mIDNode) {
            this.fCodeSelection.setSelectedItem((Object)sCodeTypes[PropertyPanel.this.fProperty.getCodeType()]);
            this.fSetCommand.setText(PropertyPanel.this.fProperty.getConfigureCommand());
            this.fGetCommand.setText(PropertyPanel.this.fProperty.getQueryCommand());
            this.fGetSyntaxPanel.setText(PropertyPanel.this.fProperty.getGetCodeToEvaluate());
            this.fGetSyntaxPanel.selectAll();
            this.fGetSyntaxPanel.setCaretPosition(0);
            this.fGetSyntaxPanel.discardAllUndoEdits();
            this.fSetSyntaxPanel.setText(PropertyPanel.this.fProperty.getSetCodeToEvaluate());
            this.fSetSyntaxPanel.selectAll();
            this.fSetSyntaxPanel.setCaretPosition(0);
            this.fSetSyntaxPanel.discardAllUndoEdits();
        }

        @Override
        public void updateNode(MIDNode mIDNode) {
            if (((String)this.fCodeSelection.getSelectedItem()).equalsIgnoreCase(sCodeTypes[1])) {
                PropertyPanel.this.fProperty.setCodeType(1);
            } else {
                PropertyPanel.this.fProperty.setCodeType(0);
            }
            PropertyPanel.this.fProperty.setConfigureCommand(this.fSetCommand.getText());
            PropertyPanel.this.fProperty.setQueryCommand(this.fGetCommand.getText());
            PropertyPanel.this.fProperty.setGetCodeToEvaluate(this.fGetSyntaxPanel.getText());
            PropertyPanel.this.fProperty.setSetCodeToEvaluate(this.fSetSyntaxPanel.getText());
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 2) {
                return;
            }
            if (this.fCodeSelection.getSelectedItem() == sCodeTypes[0]) {
                this.remove((Component)this.fMCodePanel);
                this.add((Component)this.fCommandPanel, "Center");
            } else {
                this.remove((Component)this.fCommandPanel);
                this.add((Component)this.fMCodePanel, "Center");
            }
            JFrame jFrame = (JFrame)this.getTopLevelAncestor();
            if (jFrame != null) {
                jFrame.invalidate();
                jFrame.repaint();
            }
        }
    }

    public class PropertyGeneral
    extends BasePanel
    implements FocusListener {
        private static final long serialVersionUID = 1L;
        private JTextField defaultValue;
        private JComboBox readOnly;
        private JTextArea descriptionArea;

        public PropertyGeneral(DriverClient driverClient) {
            super(driverClient);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0);
            this.add(new JLabel("Default value:"), gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.add(new JLabel("Read only:"), gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.anchor = 18;
            this.add(new JLabel("Help text:"), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0);
            this.defaultValue = new JTextField();
            this.defaultValue.addFocusListener(this);
            this.add(this.defaultValue, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
            this.readOnly = new JComboBox<String>(sReadOnlyValues);
            this.add(this.readOnly, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints(0, 3, 0, 1, 1.0, 1.0, 18, 1, new Insets(2, 5, 5, 5), 0, 0);
            this.descriptionArea = new JTextArea();
            this.descriptionArea.setColumns(20);
            this.descriptionArea.setRows(1);
            this.descriptionArea.setLineWrap(true);
            this.descriptionArea.setWrapStyleWord(true);
            this.descriptionArea.setTabSize(4);
            this.descriptionArea.setForeground(MIDTool.getMCommentColor());
            this.descriptionArea.setDragEnabled(true);
            this.add(new JScrollPane(this.descriptionArea), gridBagConstraints);
        }

        @Override
        public void driverDidLoad(DriverModel driverModel) {
            if (driverModel.getDriverType() == 0 || driverModel.getDriverType() == 4) {
                this.defaultValue.setEnabled(true);
                this.defaultValue.setBackground(new JTextField().getBackground());
                this.readOnly.setEnabled(true);
            } else {
                this.defaultValue.setEnabled(false);
                this.defaultValue.setBackground(new JPanel().getBackground());
                this.readOnly.setEnabled(false);
            }
        }

        @Override
        public void updatePanel(MIDNode mIDNode) {
            this.defaultValue.setText((String)PropertyPanel.this.fProperty.getDefaultValue());
            this.readOnly.setSelectedItem(PropertyPanel.this.fProperty.getReadOnly().toLowerCase());
            this.descriptionArea.setText(PropertyPanel.this.fProperty.getDescription());
        }

        @Override
        public void updateNode(MIDNode mIDNode) {
            PropertyPanel.this.fProperty.setDefaultValue(this.defaultValue.getText());
            PropertyPanel.this.fProperty.setReadOnly((String)this.readOnly.getSelectedItem());
            PropertyPanel.this.fProperty.setDescription(this.descriptionArea.getText());
            mIDNode.setUserObject(PropertyPanel.this.fProperty.getName());
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (this.defaultValue.getText().equalsIgnoreCase((String)PropertyPanel.this.fProperty.getDefaultValue())) {
                return;
            }
            if (!PropertyPanel.this.fProperty.isValidDefaultValue(this.defaultValue.getText())) {
                MJOptionPane.showMessageDialog((Component)this.fDriverClient.getBrowserFrame(), (Object)("The default value for " + PropertyPanel.this.fProperty.getName() + " does not appear to be valid for the defined property values"), (String)"Default Value Warning", (int)2);
            }
            PropertyPanel.this.fProperty.setDefaultValue(this.defaultValue.getText());
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }
    }
}

