/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.guiutil;

import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.device.icdevice.ICDevice;
import com.mathworks.toolbox.testmeas.guiutil.ObjectExporter;
import java.util.Vector;

public class InstrumentObjectExporter
extends ObjectExporter {
    private static final long serialVersionUID = 1L;
    private int fNumOfObjects = 0;
    private Vector<Object> fAllObjects = new Vector();
    private Vector<Instrument> fSerialObjects;
    private Vector<Instrument> fBluetoothObjects;
    private Vector<Instrument> fGpibObjects;
    private Vector<Instrument> fVisaObjects;
    private Vector<Object> fTcpipObjects;
    private Vector<Object> fUdpObjects;
    private Vector<Object> fDeviceObjects;

    public InstrumentObjectExporter(Vector<Object> vector) {
        this.fNumOfObjects = vector.size();
        this.fSerialObjects = new Vector();
        this.fBluetoothObjects = new Vector();
        this.fGpibObjects = new Vector();
        this.fVisaObjects = new Vector();
        this.fTcpipObjects = new Vector();
        this.fUdpObjects = new Vector();
        this.fDeviceObjects = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            Object object = vector.elementAt(i);
            if (object instanceof Instrument) {
                Instrument instrument = (Instrument)object;
                Vector<?> vector2 = this.getVector(instrument.getType());
                vector2.addElement(instrument);
                continue;
            }
            this.fDeviceObjects.add(object);
        }
        this.layoutPanel();
        directoryName = Instrument.getPreferenceFile().read("SaveDirectory");
    }

    private int findMinimumCount() {
        Vector<Instrument> vector = Instrument.jinstrfindall();
        if (vector.size() == 0) {
            return 0;
        }
        return new Double(vector.elementAt(0).getID()).intValue();
    }

    public InstrumentObjectExporter(Vector<Instrument> vector, Vector<Instrument> vector2, Vector<Instrument> vector3, Vector<Instrument> vector4, Vector<Object> vector5, Vector<Object> vector6, int n) {
        this.fSerialObjects = vector;
        this.fBluetoothObjects = vector2;
        this.fGpibObjects = vector3;
        this.fVisaObjects = vector4;
        this.fTcpipObjects = vector5;
        this.fUdpObjects = vector6;
        this.fDeviceObjects = new Vector();
        this.fNumOfObjects = n;
        this.layoutPanel();
    }

    public Object[][] defineTableData() {
        int n;
        if (this.fNumOfObjects == 0) {
            return null;
        }
        Object[][] objectArray = new Object[this.fNumOfObjects][this.getNumberOfColumns()];
        int n2 = 0;
        Instrument instrument = null;
        ICDevice iCDevice = null;
        for (n = 0; n < this.fSerialObjects.size(); ++n) {
            instrument = this.fSerialObjects.elementAt(n);
            objectArray[n2][0] = new Boolean(true);
            objectArray[n2][1] = "Serial";
            objectArray[n2][2] = instrument.getName();
            objectArray[n2++][3] = "obj" + n2;
            this.fAllObjects.addElement(instrument);
        }
        for (n = 0; n < this.fBluetoothObjects.size(); ++n) {
            instrument = this.fBluetoothObjects.elementAt(n);
            objectArray[n2][0] = new Boolean(true);
            objectArray[n2][1] = "Bluetooth";
            objectArray[n2][2] = instrument.getName();
            objectArray[n2++][3] = "obj" + n2;
            this.fAllObjects.addElement(instrument);
        }
        for (n = 0; n < this.fGpibObjects.size(); ++n) {
            instrument = this.fGpibObjects.elementAt(n);
            objectArray[n2][0] = new Boolean(true);
            objectArray[n2][1] = "GPIB";
            objectArray[n2][2] = instrument.getName();
            objectArray[n2++][3] = "obj" + n2;
            this.fAllObjects.addElement(instrument);
        }
        for (n = 0; n < this.fVisaObjects.size(); ++n) {
            instrument = this.fVisaObjects.elementAt(n);
            objectArray[n2][0] = new Boolean(true);
            objectArray[n2][1] = "VISA";
            objectArray[n2][2] = instrument.getName();
            objectArray[n2++][3] = "obj" + n2;
            this.fAllObjects.addElement(instrument);
        }
        for (n = 0; n < this.fTcpipObjects.size(); ++n) {
            instrument = (Instrument)this.fTcpipObjects.elementAt(n);
            objectArray[n2][0] = new Boolean(true);
            objectArray[n2][1] = "TCPIP";
            objectArray[n2][2] = instrument.getName();
            objectArray[n2++][3] = "obj" + n2;
            this.fAllObjects.addElement(instrument);
        }
        for (n = 0; n < this.fUdpObjects.size(); ++n) {
            instrument = (Instrument)this.fUdpObjects.elementAt(n);
            objectArray[n2][0] = new Boolean(true);
            objectArray[n2][1] = "UDP";
            objectArray[n2][2] = instrument.getName();
            objectArray[n2++][3] = "obj" + n2;
            this.fAllObjects.addElement(instrument);
        }
        for (n = 0; n < this.fDeviceObjects.size(); ++n) {
            iCDevice = (ICDevice)this.fDeviceObjects.elementAt(n);
            objectArray[n2][0] = new Boolean(true);
            objectArray[n2][1] = "device";
            objectArray[n2][2] = iCDevice.getName();
            objectArray[n2++][3] = "obj" + n2;
            this.fAllObjects.addElement(iCDevice);
        }
        if (this.fNumOfObjects == 1 && instrument != null) {
            Vector<Instrument> vector = Instrument.jinstrfind();
            for (int i = 0; i < vector.size(); ++i) {
                if (!instrument.equals(vector.elementAt(i))) continue;
                objectArray[0][3] = "obj" + (i + 1);
                return objectArray;
            }
            objectArray[0][3] = "obj" + (new Double(instrument.getID()).intValue() - this.findMinimumCount() + 1);
        }
        return objectArray;
    }

    public Vector<Object> defineObjects() {
        return this.fAllObjects;
    }

    public String getGatewayFunction() {
        return "instrgate";
    }

    public String getCallbackFunction() {
        return "privateObjectExporterHelper";
    }

    public String getHelpDirectory() {
        return "instrument";
    }

    public String getHelpFile() {
        return "tmtool_csh\\_object_exporter.html";
    }

    public String getHelpTitle() {
        return "Object Exporter Help";
    }

    private Vector<?> getVector(String string) {
        if (string.equals("serial")) {
            return this.fSerialObjects;
        }
        if (string.equals("bluetooth")) {
            return this.fBluetoothObjects;
        }
        if (string.equals("gpib")) {
            return this.fGpibObjects;
        }
        if (string.startsWith("visa")) {
            return this.fVisaObjects;
        }
        if (string.equals("tcpip")) {
            return this.fTcpipObjects;
        }
        if (string.equals("udp")) {
            return this.fTcpipObjects;
        }
        return null;
    }

    public void saveOptions() {
        if (!directoryName.equals("")) {
            Instrument.getPreferenceFile().update("SaveDirectory", directoryName);
        }
    }
}

