/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.instrcomm;

import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.toolbox.instrument.instrcomm.HistoryTable;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

public class TableContextMenu
extends JPopupMenu {
    private static final long serialVersionUID = 1L;
    protected static final String DELETE = "DELETE";
    protected static final String DELETE_ALL = "DELETE ALL";
    protected static final String EXPORT = "EXPORT";
    private HistoryTable historyTable;
    private JTable table;
    private boolean hasBeenAdded = false;
    private JMenuItem exportMenuItem;
    private JMenuItem deleteAllMenuItem;
    private JMenuItem deleteMenuItem;

    public TableContextMenu(ActionListener actionListener) {
        this.historyTable = (HistoryTable)actionListener;
        this.createMenu(actionListener);
    }

    private void createMenu(ActionListener actionListener) {
        this.deleteMenuItem = new JMenuItem("Delete Selected Row(s)");
        this.deleteMenuItem.putClientProperty("ACTION", DELETE);
        this.deleteMenuItem.addActionListener(actionListener);
        this.deleteAllMenuItem = new JMenuItem("Delete All Row(s)");
        this.deleteAllMenuItem.putClientProperty("ACTION", DELETE_ALL);
        this.deleteAllMenuItem.addActionListener(actionListener);
        this.exportMenuItem = new JMenuItem("EXPORT Selected Row(s)");
        this.exportMenuItem.putClientProperty("ACTION", EXPORT);
        this.exportMenuItem.addActionListener(actionListener);
        this.add(this.deleteMenuItem);
        this.add(this.deleteAllMenuItem);
        this.addSeparator();
        this.add(this.exportMenuItem);
    }

    public void cleanup(ActionListener actionListener) {
        this.deleteMenuItem.removeActionListener(actionListener);
        this.deleteAllMenuItem.removeActionListener(actionListener);
        this.exportMenuItem.removeActionListener(actionListener);
    }

    public void setup(ActionListener actionListener) {
        this.deleteMenuItem.addActionListener(actionListener);
        this.deleteAllMenuItem.addActionListener(actionListener);
        this.exportMenuItem.addActionListener(actionListener);
    }

    public void enableExportMenuItem(boolean bl) {
        this.exportMenuItem.setEnabled(bl);
    }

    public void addContextMenu(JTable jTable) {
        this.table = jTable;
        if (!this.hasBeenAdded) {
            jTable.addMouseListener(new PopupListener(this));
            this.hasBeenAdded = true;
        }
    }

    public boolean deleteMenuItem(String string) {
        Object[] objectArray = new Object[]{"Yes", "No"};
        int n = MJOptionPane.showOptionDialog((Component)new MJFrame(), (Object)("Are you sure you want to delete the " + string + "?"), (String)"Confirm Delete", (int)0, (int)3, null, (Object[])objectArray, (Object)objectArray[0]);
        return n == 0;
    }

    public class PopupListener
    extends MouseAdapter {
        protected TableContextMenu contextMenu;

        public PopupListener(TableContextMenu tableContextMenu2) {
            this.contextMenu = tableContextMenu2;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
            super.mousePressed(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
            super.mouseReleased(mouseEvent);
        }

        private void showPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                int n;
                int n2 = TableContextMenu.this.table.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                int[] nArray = TableContextMenu.this.table.getSelectedRows();
                if (nArray.length == 0) {
                    TableContextMenu.this.table.setRowSelectionInterval(n2, n2);
                }
                boolean bl = false;
                for (n = 0; n < nArray.length; ++n) {
                    if (nArray[n] != n2) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    TableContextMenu.this.table.setRowSelectionInterval(n2, n2);
                }
                nArray = TableContextMenu.this.table.getSelectedRows();
                for (n = 0; n < nArray.length; ++n) {
                    if (!TableContextMenu.this.historyTable.isReadRow(nArray[n])) {
                        TableContextMenu.this.enableExportMenuItem(false);
                        break;
                    }
                    TableContextMenu.this.enableExportMenuItem(true);
                }
                this.contextMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

