/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.desk;

import com.mathworks.mlservices.MLEditorServices;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.util.productinfo.InfoListener;
import com.mathworks.mlwidgets.util.productinfo.Product;
import com.mathworks.mlwidgets.util.productinfo.ProductInfoUtils;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTable;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.table.AccessibleTextProvider;
import com.mathworks.mwswing.table.ListColorUtils;
import com.mathworks.mwswing.table.UneditableTableModel;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.List;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class InfoXmlSourceViewer
extends MJFrame
implements InfoListener {
    private static ResourceBundle sRes;
    private static InfoXmlSourceViewer sSv;
    private MJTable fTable;
    private SortDecorator fSorter;
    private MJPopupMenu fPop;
    private MJButton fRefreshButton;
    private MJButton fHelpButton;
    private EditAction fEditAction;
    private RefreshAction fRefreshAction;
    private MJScrollPane fScrollpane;
    private Object[] fReselect;

    private InfoXmlSourceViewer() {
        sRes = ResourceBundle.getBundle("com.mathworks.mde.desk.resources.RES_InfoEditor");
        this.getContentPane().setLayout(new BorderLayout());
        this.setName("XmlSrcViewer");
        this.getAccessibleContext().setAccessibleName(sRes.getString("WindowTitle"));
        Object[] objectArray = new String[]{sRes.getString("header.product"), sRes.getString("header.filename")};
        Object[][] objectArray2 = this.getData();
        UneditableTableModel uneditableTableModel = new UneditableTableModel(objectArray2, objectArray);
        this.fTable = new MJTable((TableModel)uneditableTableModel);
        this.fSorter = new SortDecorator(uneditableTableModel);
        this.fTable.setModel((TableModel)this.fSorter);
        this.fTable.setName("XmlSourceTable");
        this.fTable.getAccessibleContext().setAccessibleName(sRes.getString("acc.Table"));
        JTableHeader jTableHeader = this.fTable.getTableHeader();
        jTableHeader.addMouseListener(new HeaderMouseAdapter());
        this.fTable.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.fTable.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.fTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        InfoXmlSourceViewer.this.updateEditButton();
                    }
                });
            }
        });
        this.fTable.addMouseListener((MouseListener)new ClickMouseListener());
        this.fTable.addKeyListener((KeyListener)new MyKeyListener());
        ListColorUtils.setupForList((JTable)this.fTable);
        ListColorUtils.installListRenderer((JTable)this.fTable);
        this.fTable.setAccessibleTextProvider(this.createAccessibleTextProvider());
        this.fPop = new MJPopupMenu();
        this.fPop.setName("popup menu");
        this.fPop.getAccessibleContext().setAccessibleName(sRes.getString("acc.Pop"));
        this.fEditAction = new EditAction();
        this.fRefreshAction = new RefreshAction();
        this.fPop.add((Action)this.fEditAction);
        this.fScrollpane = new MJScrollPane((Component)this.fTable);
        this.fScrollpane.getViewport().setBackground(Color.white);
        this.fScrollpane.setName("scrollpane");
        this.fScrollpane.getAccessibleContext().setAccessibleName(sRes.getString("acc.ScrollPane"));
        this.fScrollpane.setHorizontalScrollBarPolicy(30);
        this.getContentPane().add((Component)this.fScrollpane, "Center");
        this.fTable.setAutoResizeMode(0);
        this.setBackgroundColor();
        this.setTextColor();
        MJPanel mJPanel = new MJPanel();
        mJPanel.setName("button panel");
        MJButton mJButton = new MJButton((Action)new CloseAction());
        mJButton.getAccessibleContext().setAccessibleName(sRes.getString("button.Close"));
        mJButton.setName("close button");
        MJButton mJButton2 = new MJButton((Action)this.fEditAction);
        mJButton2.setName("edit button");
        mJButton2.getAccessibleContext().setAccessibleName(MJUtilities.exciseAmpersand((String)sRes.getString("button.Edit")));
        this.fRefreshButton = new MJButton((Action)this.fRefreshAction);
        this.fRefreshButton.setName("refresh button");
        this.fRefreshButton.getAccessibleContext().setAccessibleName(MJUtilities.exciseAmpersand((String)sRes.getString("button.Refresh")));
        this.fHelpButton = new MJButton((Action)((Object)new HelpAction()));
        this.fHelpButton.setName("help button");
        this.fHelpButton.getAccessibleContext().setAccessibleName(MJUtilities.exciseAmpersand((String)sRes.getString("button.Help")));
        mJPanel.add((Component)this.fRefreshButton);
        mJPanel.add((Component)mJButton2);
        mJPanel.add((Component)mJButton);
        mJPanel.add((Component)this.fHelpButton);
        this.getContentPane().add((Component)mJPanel, "South");
        this.fEditAction.setEnabled(false);
        MyColorListener myColorListener = new MyColorListener();
        ColorPrefs.addColorListener((String)"ColorsText", (PrefListener)myColorListener);
        ColorPrefs.addColorListener((String)"ColorsBackground", (PrefListener)myColorListener);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                InfoXmlSourceViewer.this.parentResized();
            }
        });
    }

    private AccessibleTextProvider createAccessibleTextProvider() {
        return new AccessibleTextProvider(){

            public String getAccessibleText(int n, int n2) {
                String string = (String)InfoXmlSourceViewer.this.fTable.getValueAt(n, 0);
                String string2 = (String)InfoXmlSourceViewer.this.fTable.getValueAt(n, 1);
                return string + " " + string2;
            }
        };
    }

    public static void invoke() {
        if (sSv == null) {
            sSv = new InfoXmlSourceViewer();
        }
        ProductInfoUtils.registerInfoListener((InfoListener)sSv);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                sSv.setTitle(sRes.getString("WindowTitle"));
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                sSv.setSize(500, 300);
                if (sSv.fTable.getRowCount() >= 1) {
                    sSv.fTable.setRowSelectionInterval(0, 0);
                }
                Rectangle rectangle = sSv.getBounds();
                sSv.setLocation((dimension.width - rectangle.width) / 2, (dimension.height - rectangle.height) / 2);
                sSv.setVisible(true);
            }
        };
        MJUtilities.runOnEventDispatchThread((Runnable)runnable);
    }

    private void parentResized() {
        TableColumnModel tableColumnModel = this.fTable.getColumnModel();
        int n = 0;
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            n += tableColumnModel.getColumn(i).getPreferredWidth();
        }
        if (this.fScrollpane.getWidth() > 0 && n < this.fScrollpane.getWidth()) {
            this.fTable.setAutoResizeMode(4);
        } else {
            this.fTable.setAutoResizeMode(0);
        }
    }

    private void closeWindow() {
        ProductInfoUtils.unregisterInfoListener((InfoListener)this);
        this.dispose();
        sSv = null;
    }

    public void infoChanged(Product[] productArray) {
        final String[][] stringArray = this.formatData(productArray);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InfoXmlSourceViewer.this.saveSelection();
                InfoXmlSourceViewer.this.fSorter.removeAllRows();
                for (int i = 0; i < stringArray.length; ++i) {
                    Object[] objectArray = new String[]{stringArray[i][0], stringArray[i][1]};
                    InfoXmlSourceViewer.this.fSorter.addRow(objectArray);
                }
                InfoXmlSourceViewer.this.fTable.requestFocus();
                InfoXmlSourceViewer.this.restoreSelection();
            }
        });
    }

    private String[][] getData() {
        Product[] productArray = ProductInfoUtils.getAllProductsInfo();
        return this.formatData(productArray);
    }

    private String[][] formatData(Product[] productArray) {
        List list = new List();
        List list2 = new List();
        for (int i = 0; i < productArray.length; ++i) {
            if (productArray[i].getFilename() == null) continue;
            String string = productArray[i].getFullName();
            list.add(string);
            list2.add(productArray[i].getFilename());
        }
        String[][] stringArray = new String[list.getItemCount()][2];
        for (int i = 0; i < list.getItemCount(); ++i) {
            stringArray[i][0] = list.getItem(i);
            stringArray[i][1] = list2.getItem(i);
        }
        return stringArray;
    }

    private void editSelectedFiles() {
        sSv.setCursor(Cursor.getPredefinedCursor(3));
        int[] nArray = this.fTable.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            MLEditorServices.getEditorApplication().openEditor(new File((String)this.fTable.getModel().getValueAt(nArray[i], 1)));
        }
        sSv.setCursor(Cursor.getDefaultCursor());
    }

    private void refreshMenu() {
        ProductInfoUtils.clearAndReparseProducts();
    }

    private void saveSelection() {
        int[] nArray = this.fTable.getSelectedRows();
        this.fReselect = new Object[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.fReselect[i] = this.fTable.getModel().getValueAt(nArray[i], 0);
        }
    }

    private void restoreSelection() {
        this.fTable.clearSelection();
        for (int i = 0; i < this.fReselect.length; ++i) {
            int n = ((SortDecorator)this.fTable.getModel()).getRowForValue(this.fReselect[i]);
            if (n < 0) continue;
            this.fTable.addRowSelectionInterval(n, n);
        }
    }

    private void setTextColor() {
        if (this.fTable != null) {
            this.fTable.setForeground(ColorPrefs.getTextColor());
        }
    }

    private void setBackgroundColor() {
        Color color = ColorPrefs.getBackgroundColor();
        if (this.fTable != null) {
            this.fTable.setBackground(color);
        }
        if (this.fScrollpane != null) {
            this.fScrollpane.getViewport().setBackground(color);
        }
    }

    private void tabFromResults(boolean bl) {
        if (bl) {
            this.fRefreshButton.requestFocus();
        } else {
            this.fHelpButton.requestFocus();
        }
    }

    private void updateEditButton() {
        boolean bl = this.fTable.getSelectedRows().length > 0;
        this.fEditAction.setEnabled(bl);
    }

    private class MyColorListener
    implements PrefListener {
        private MyColorListener() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            if (prefEvent.getPrefKey().equals("ColorsText")) {
                InfoXmlSourceViewer.this.setTextColor();
            } else if (prefEvent.getPrefKey().equals("ColorsBackground")) {
                InfoXmlSourceViewer.this.setBackgroundColor();
            }
        }
    }

    private class MyKeyListener
    implements KeyListener {
        private MyKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 10) {
                keyEvent.consume();
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 10) {
                keyEvent.consume();
            } else if (n == 9) {
                InfoXmlSourceViewer.this.tabFromResults(keyEvent.getModifiers() != 1);
                keyEvent.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 10) {
                InfoXmlSourceViewer.this.editSelectedFiles();
            }
            keyEvent.consume();
        }
    }

    class HelpAction
    extends MJAbstractAction {
        public HelpAction() {
            super(sRes.getString("button.Help"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MLHelpServices.displayTopic((String)MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env"), (String)"start_button_config");
        }
    }

    class RefreshAction
    extends AbstractAction {
        public RefreshAction() {
            super(sRes.getString("button.Refresh"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InfoXmlSourceViewer.this.refreshMenu();
        }
    }

    class EditAction
    extends AbstractAction {
        public EditAction() {
            super(sRes.getString("button.Edit"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InfoXmlSourceViewer.this.editSelectedFiles();
        }
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(sRes.getString("button.Close"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InfoXmlSourceViewer.this.closeWindow();
        }
    }

    class ClickMouseListener
    extends MouseAdapter {
        ClickMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Object object;
            InfoXmlSourceViewer.this.updateEditButton();
            if (mouseEvent.isPopupTrigger() && (object = mouseEvent.getSource()) instanceof Component) {
                InfoXmlSourceViewer.this.fPop.show((Component)object, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                Object object = mouseEvent.getSource();
                if (object instanceof Component) {
                    InfoXmlSourceViewer.this.fPop.show((Component)object, mouseEvent.getX(), mouseEvent.getY());
                }
            } else if (mouseEvent.getClickCount() == 2) {
                InfoXmlSourceViewer.this.editSelectedFiles();
            }
        }
    }

    class HeaderMouseAdapter
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TableColumnModel tableColumnModel = InfoXmlSourceViewer.this.fTable.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n2 = InfoXmlSourceViewer.this.fTable.convertColumnIndexToModel(n);
            InfoXmlSourceViewer.this.fSorter.sort(n2);
        }
    }

    class SortDecorator
    implements TableModel,
    TableModelListener {
        private UneditableTableModel realModel;
        private int[] indexes;
        private boolean fSortedInReverse = true;

        public SortDecorator(UneditableTableModel uneditableTableModel) {
            if (uneditableTableModel == null) {
                throw new IllegalArgumentException("null models are not allowed");
            }
            this.realModel = uneditableTableModel;
            this.realModel.addTableModelListener((TableModelListener)this);
            this.allocate();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.realModel.getRowCount() > this.indexes.length) {
                this.allocate();
            }
            return this.realModel.getValueAt(this.indexes[n], n2);
        }

        public int getRowForValue(Object object) {
            int n = InfoXmlSourceViewer.this.fSorter.getRowCount();
            for (int i = 0; i < n; ++i) {
                if (!this.getValueAt(i, 0).equals(object)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.realModel.setValueAt(object, this.indexes[n], n2);
            if (this.realModel.getRowCount() > this.indexes.length) {
                this.allocate();
            }
        }

        public void removeAllRows() {
            int n = InfoXmlSourceViewer.this.fSorter.getRowCount();
            for (int i = 0; i < n; ++i) {
                this.realModel.removeRow(0);
            }
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            this.allocate();
        }

        public void sort(int n) {
            int n2 = this.getRowCount();
            if (!this.fSortedInReverse) {
                for (int i = n2; i > 0; --i) {
                    for (int j = i - 1; j > 0; --j) {
                        if (this.compare(this.indexes[i - 1], this.indexes[j - 1], n) >= 0) continue;
                        this.swap(j - 1, i - 1);
                    }
                }
                this.fSortedInReverse = true;
            } else {
                for (int i = 0; i < n2; ++i) {
                    for (int j = i + 1; j < n2; ++j) {
                        if (this.compare(this.indexes[i], this.indexes[j], n) >= 0) continue;
                        this.swap(i, j);
                    }
                }
                this.fSortedInReverse = false;
            }
        }

        public void swap(int n, int n2) {
            int n3 = this.indexes[n];
            this.indexes[n] = this.indexes[n2];
            this.indexes[n2] = n3;
        }

        public int compare(int n, int n2, int n3) {
            Object object = this.realModel.getValueAt(n, n3);
            Object object2 = this.realModel.getValueAt(n2, n3);
            int n4 = object2.toString().compareTo(object.toString());
            return n4 < 0 ? -1 : (n4 > 0 ? 1 : 0);
        }

        private void allocate() {
            this.indexes = new int[this.getRowCount()];
            for (int i = 0; i < this.indexes.length; ++i) {
                this.indexes[i] = i;
            }
        }

        @Override
        public int getRowCount() {
            return this.realModel.getRowCount();
        }

        @Override
        public int getColumnCount() {
            return this.realModel.getColumnCount();
        }

        @Override
        public String getColumnName(int n) {
            return this.realModel.getColumnName(n);
        }

        public Class getColumnClass(int n) {
            return this.realModel.getColumnClass(n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return this.realModel.isCellEditable(n, n2);
        }

        @Override
        public void addTableModelListener(TableModelListener tableModelListener) {
            this.realModel.addTableModelListener(tableModelListener);
        }

        @Override
        public void removeTableModelListener(TableModelListener tableModelListener) {
            this.realModel.removeTableModelListener(tableModelListener);
        }

        public void addRow(Object[] objectArray) {
            this.realModel.addRow(objectArray);
        }
    }
}

