/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.desk;

import com.mathworks.common.icons.ProvisionalIcon;
import com.mathworks.comparisons.main.ComparisonUtilities;
import com.mathworks.jmi.AWTUtilities;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.MLFileIconUtils;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.NewFileTemplate;
import com.mathworks.mde.array.ArrayEditorToolstripTabFactory;
import com.mathworks.mde.cmdwin.CmdWinMLIF;
import com.mathworks.mde.cmdwin.CmdWinPrefs;
import com.mathworks.mde.desk.CommonToolRegistrar;
import com.mathworks.mde.desk.ContributedToolsLoader;
import com.mathworks.mde.desk.MLMacScreenMenuProxy;
import com.mathworks.mde.desk.MLMainFrame;
import com.mathworks.mde.desk.MLMainToolBarSupplier;
import com.mathworks.mde.desk.MLMenuBar;
import com.mathworks.mde.desk.MLMenuMergeTag;
import com.mathworks.mde.desk.MLMnemonicsProvider;
import com.mathworks.mde.desk.MLMultipleClientFrame;
import com.mathworks.mde.desk.MLSingleClientFrame;
import com.mathworks.mde.desk.MLToolBarPrefsPanel;
import com.mathworks.mde.desk.MLToolstripFactory;
import com.mathworks.mde.desk.PlotableClientBase;
import com.mathworks.mde.desk.StartupClassLoader;
import com.mathworks.mde.editor.EditorOptions;
import com.mathworks.mde.editor.EditorToolSetFactory;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mde.editor.EditorViewToolSetFactory;
import com.mathworks.mde.editor.codepad.CodepadToolSetFactory;
import com.mathworks.mde.explorer.Explorer;
import com.mathworks.mde.find.FindFiles;
import com.mathworks.mde.functionbrowser.FunctionBrowser;
import com.mathworks.mde.licensing.borrowing.BorrowUI;
import com.mathworks.mde.vrd.LicenseActionsFactory;
import com.mathworks.mde.vrd.LicenseToolSetFactory;
import com.mathworks.mde.webintegration.checkforupdates.CheckForUpdatesDialogFactory;
import com.mathworks.mde.webintegration.startpage.StartPageFactory;
import com.mathworks.mde.webintegration.supportrequest.SupportRequestFactory;
import com.mathworks.mlservices.MLCommandHistoryServices;
import com.mathworks.mlservices.MLEditorServices;
import com.mathworks.mlservices.MLExecuteServices;
import com.mathworks.mlservices.MLExecutionEvent;
import com.mathworks.mlservices.MLExecutionListener;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlservices.MLLicenseChecker;
import com.mathworks.mlservices.MLPrefsDialogServices;
import com.mathworks.mlservices.MatlabDesktop;
import com.mathworks.mlwidgets.cwd.CwdComponentSet;
import com.mathworks.mlwidgets.debug.DebugActions;
import com.mathworks.mlwidgets.dialog.filters.MatlabProductFileExtensionFilter;
import com.mathworks.mlwidgets.explorer.extensions.matlab.BlankMFileTemplate;
import com.mathworks.mlwidgets.explorer.extensions.matlab.ClassMFileTemplate;
import com.mathworks.mlwidgets.explorer.extensions.matlab.EnumerationMFileTemplate;
import com.mathworks.mlwidgets.explorer.extensions.matlab.ExampleMFileTemplate;
import com.mathworks.mlwidgets.explorer.extensions.matlab.FunctionMFileTemplate;
import com.mathworks.mlwidgets.explorer.extensions.matlab.SystemMFileTemplate;
import com.mathworks.mlwidgets.graphics.PlotToolSetFactory;
import com.mathworks.mlwidgets.prefs.ConfirmationDialogPrefsPanel;
import com.mathworks.mlwidgets.shortcuts.ShortcutsToolstripTabFactory;
import com.mathworks.mlwidgets.util.MatlabDropTargetListener;
import com.mathworks.mlwidgets.workspace.WorkspaceCommands;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.ExtendedInputMap;
import com.mathworks.mwswing.FileExtensionFilter;
import com.mathworks.mwswing.FileExtensionFilterUtils;
import com.mathworks.mwswing.GlobalCursor;
import com.mathworks.mwswing.IconSet;
import com.mathworks.mwswing.MInputMap;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.SimpleElement;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.toolstrip.factory.QuickAccessConfiguration;
import com.mathworks.toolstrip.factory.TSToolPath;
import com.mathworks.util.FactoryUtils;
import com.mathworks.util.Log;
import com.mathworks.util.Predicate;
import com.mathworks.util.StringUtils;
import com.mathworks.widgets.Dialogs;
import com.mathworks.widgets.action.AbstractOpenAction;
import com.mathworks.widgets.action.AbstractPasteAction;
import com.mathworks.widgets.debug.DebuggerManager;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTGroup;
import com.mathworks.widgets.desk.DTLayoutLibrary;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.DTMainToolBarSupplier;
import com.mathworks.widgets.desk.DTMenuBar;
import com.mathworks.widgets.desk.DTMnemonicsProvider;
import com.mathworks.widgets.desk.DTMultipleClientFrame;
import com.mathworks.widgets.desk.DTSingleClientFrame;
import com.mathworks.widgets.desk.DTToolstripFactory;
import com.mathworks.widgets.desk.DTUtilities;
import com.mathworks.widgets.desk.DTWindowCloser;
import com.mathworks.widgets.desk.Desktop;
import com.mathworks.widgets.desk.MacScreenMenuProxy;
import com.mathworks.widgets.desk.RecentFiles;
import com.mathworks.widgets.desk.ToolstripInfoRegistrar;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.zip.DataFormatException;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MLDesktop
extends Desktop
implements MLExecutionListener,
MatlabDesktop {
    private Matlab fMatlab = new Matlab();
    private MLExecutionEvent.InterpretedStatus fMatlabStatus;
    private boolean fIsCreatingMainFrame;
    private boolean fRetainEditorFocus;
    private static boolean fHasCompilerPlugin;
    private static boolean fHasCodeGenerationPlugin;
    private static boolean fHasSimulinkProjectPlugin;
    private static boolean fHasSystemToolbox;
    private boolean fHasDCTLicense;
    private boolean fLicenseBorrowingEnabled;
    private boolean fIsFirstInit = true;
    private boolean fIsPrefListenerRegistered = false;
    private boolean fIsCurrentFolderBarBelowToolstrip;
    private int fNumberOfBits = -1;
    private Boolean fUndockSingletonsOnTop;
    private Boolean fAsyncDesktopInit = null;
    private boolean fInitializationComplete;
    private boolean fNeedToUpdateIdle;
    DropTargetListener fDropListener;
    private Map<String, Action> fComponentHelpActionTable = new Hashtable<String, Action>();
    private Action fNewBlankMFileAction;
    private Action fNewFunctionMFileAction;
    private Action fNewExampleMFileAction;
    private Action fNewClassMFileAction;
    private Action fNewEnumerationMFileAction;
    private Action fNewSystemMFileAction;
    private Action fNewFigureAction;
    private Action fNewVariableAction;
    private Action fNewModelAction;
    private Action fNewGUIAction;
    private Action fOpenAction;
    private Action fInstallAppAction;
    private Action fCloseDesktopAction;
    private Action fImportAction;
    private Action fSaveWorkspaceAction;
    private Action fSetPathAction;
    private Action fPreferencesAction;
    private Action fQuitAction;
    private Action fPasteSpecialAction;
    private Action fFindFilesAction;
    private Action fClearCommandAction;
    private Action fClearHistoryAction;
    private Action fClearWorkspaceAction;
    private Action fClearAllAction;
    private Action fVisitWebSiteAction;
    private Action fVisitMatlabCentralAction;
    private Action fVisitFileExchangeAction;
    private Action fVisitNewsGroupsAction;
    private Action fVisitNewslettersAction;
    private Action fVisitNewProductsAction;
    private Action fVisitLoginAction;
    private Action fVisitTrialsAction;
    private Action fVisitStudentFAQAction;
    private Action fVisitStudentCenterAction;
    private Action fVisitStoreAction;
    private Action fVisitTechSupportAction;
    private Action fVisitTrainingAction;
    private Action fVisitAppsAction;
    private Action fProductHelpAction;
    private Action fDesktopHelpAction;
    private Action fFunctionBrowserAction;
    private Action fCheckForUpdatesAction;
    private Action fSupportRequestAction;
    private Action fStartPageAction;
    private Action fLicenseBorrowAction;
    private Action fDemosAction;
    private Action fStudentActivationAction;
    private Action fTermsOfUseAction;
    private Action fPatentsAction;
    private Action fAboutAction;
    private Action fVisitTutorialsAction;
    private Action fVisitMLTutorialsAction;
    private Action fVisitSLTutorialsAction;
    private Action fLaunchSimulinkAction;
    private Action fLaunchGuideAction;
    private Action fLaunchProfilerAction;
    private Action fLaunchComparisonToolAction;
    private MoveCurrentFolderBarAction fMoveCFBarToBrowserAction;
    private MoveCurrentFolderBarAction fMoveCFBarBelowToolstripAction;
    static ResourceBundle sMLRes;
    static MLDesktop sInstance;
    private static final String MATLAB = "MATLAB";
    private static final String EXIT_CONFIRM = "MatlabExitConfirm";
    private static final int BUSY_DELAY = 250;
    private static final String ASYNC_TIC_ID_DESKTOP_INITIALIZATION = "Init Desktop";
    private static final String UNDOCK_SINGLETONS_ON_TOP = "MATLABSingletonsOnTop";
    private static final Map<MLExecutionEvent.InterpretedStatus, String> sMatlabStatusText;
    private static ResourceBundle sPrefRes;
    private static final String COMMAND_WINDOW_NAME = "Command Window";
    private static final String COMMAND_HISTORY_NAME = "Command History";
    private static final String FILE_BROWSER_NAME = "Old Current Directory";
    private static final String WORKSPACE_BROWSER_NAME = "Workspace";
    private static final String HELP_BROWSER_NAME = "Help";
    private static final String PROFILER_NAME = "Profiler";
    private static final String EXPLORER_NAME = "Current Directory";
    public static final String FILE_EXCHANGE_NAME = "File Exchange";
    static final String EDITOR_NAME = "Editor";
    private static final String FIGURES_NAME = "Figures";
    private static final String WEB_BROWSER_NAME = "Web Browser";
    static final String VARIABLE_EDITOR_NAME = "Array Editor";
    private static final String FILE_COMPARISONS_NAME = "File Comparisons";
    private static final String CURRENT_FOLDER_TOOLBAR_NAME = "Current DirectoryToolBar";
    private static Map<String, ClientInfo> sClientInfoTable;
    private static final int DEFAULT_LAYOUT = 0;
    private static final int COMMAND_ONLY_LAYOUT = 1;
    private static final int COMMAND_AND_HISTORY_LAYOUT = 2;
    private static final int ALL_TABBED_LAYOUT = 3;
    private static final int ALL_BUT_COMMAND_MINIMIZED_LAYOUT = 4;
    static final String WEB_MATHWORKS;
    static final String WEB_LOGIN;
    static final String WEB_STORE;
    static final String WEB_TRIALS;
    static final String WEB_MATLAB_CENTRAL;
    static final String WEB_FILE_EXCHANGE;
    static final String WEB_NEWSREADER;
    static final String WEB_NEWSLETTERS;
    static final String WEB_STUDENT_PRODUCTS;
    static final String WEB_STUDENT_FAQ;
    static final String WEB_STUDENT_CENTER;
    static final String WEB_PRODUCTS;
    static final String WEB_SUPPORT;
    static final String WEB_TRAINING;
    static final String TUTORIALS_URL;
    static final String ML_TUTORIALS_URL;
    static final String SL_TUTORIALS_URL;
    static final String WEB_APPS;
    static final String WEB_EN_MATHWORKS = "http://www.mathworks.com/pl_homepage";
    static final String WEB_EN_LOGIN = "http://www.mathworks.com/pl_accesslogin";
    static final String WEB_EN_STUDENT_FAQ = "http://www.mathworks.com/pl_studentfaq";
    static final String WEB_EN_STUDENT_CENTER = "http://www.mathworks.com/pl_studentcenter";
    static final String WEB_EN_PRODUCTS = "http://www.mathworks.com/pl_products";
    static final String WEB_EN_SUPPORT = "http://www.mathworks.com/pl_support";
    static final String WEB_EN_TRAINING = "http://www.mathworks.com/pl_training";
    static final String WEB_EN_STORE = "http://www.mathworks.com/pl_store";
    static final String WEB_EN_TRIALS = "http://www.mathworks.com/pl_trials";
    static final String WEB_EN_MATLAB_CENTRAL = "http://www.mathworks.com/pl_mlc";
    static final String WEB_EN_FILE_EXCHANGE = "http://www.mathworks.com/pl_fileexchange";
    static final String WEB_EN_NEWSREADER = "http://www.mathworks.com/pl_newsreader";
    static final String WEB_EN_NEWSLETTERS = "http://www.mathworks.com/pl_newsletters";
    static final String WEB_EN_STUDENT_PRODUCTS = "http://www.mathworks.com/pl_studentversion";
    static final String WEB_EN_APPS = "http://www.mathworks.com/fileexchange_apps";
    static final String WEB_JP_MATHWORKS = "http://www.mathworks.co.jp/pl_homepage";
    static final String WEB_JP_LOGIN = "http://www.mathworks.co.jp/accesslogin/index_new.jsp?uri=http://www.mathworks.co.jp/accesslogin/myAccount.do";
    static final String WEB_JP_STUDENT_FAQ = "http://www.mathworks.co.jp/pl_studentfaq";
    static final String WEB_JP_STUDENT_CENTER = "http://www.mathworks.co.jp/pl_studentcenter";
    static final String WEB_JP_PRODUCTS = "http://www.mathworks.co.jp/pl_products";
    static final String WEB_JP_SUPPORT = "http://www.mathworks.co.jp/pl_support";
    static final String WEB_JP_TRAINING = "http://www.mathworks.co.jp/pl_training";
    static final String WEB_JP_STORE = "http://www.mathworks.co.jp/pl_store";
    static final String WEB_JP_TRIALS = "http://www.mathworks.co.jp/pl_trials";
    static final String WEB_JP_MATLAB_CENTRAL = "http://www.mathworks.co.jp/pl_mlc";
    static final String WEB_JP_FILE_EXCHANGE = "http://www.mathworks.co.jp/pl_fileexchange";
    static final String WEB_JP_NEWSREADER = "http://www.mathworks.co.jp/pl_newsreader";
    static final String WEB_JP_NEWSLETTERS = "http://www.mathworks.co.jp/pl_newsletters";
    static final String WEB_JP_STUDENT_PRODUCTS = "http://www.mathworks.co.jp/pl_studentversion";
    static final String WEB_JP_APPS = "http://www.mathworks.co.jp/fileexchange_apps";
    private static final String TUTORIALS_EN_URL = "http://www.mathworks.com/academia/student_center/tutorials";
    private static final String TUTORIALS_JP_URL = "http://www.mathworks.co.jp/academia/student_center/tutorials";
    private static final String ML_TUTORIALS_EN_URL = "http://www.mathworks.com/academia/student_center/tutorials/mltutorial_launchpad.html?s_cid=0310_ptow_sv_tutorial_matlab_";
    private static final String ML_TUTORIALS_JP_URL = "http://www.mathworks.co.jp/academia/student_center/tutorials/mltutorial_launchpad.html?s_cid=0310_ptow_jp_sv_tutorial_matlab_";
    private static final String SL_TUTORIALS_EN_URL = "http://www.mathworks.com/academia/student_center/tutorials/sltutorial_launchpad.html?s_cid=0310_ptow_sv_tutorial_simulink_";
    private static final String SL_TUTORIALS_JP_URL = "http://www.mathworks.co.jp/academia/student_center/tutorials/sltutorial_launchpad.html?s_cid=0310_ptow_jp_sv_tutorial_simulink_";
    private List<DTWindowCloser> fMatlabThreadClosers;
    private static final String CURRENT_FOLDER_BAR_ATTRIBUTE = "CurrentFolderBarBelow";
    private static final String SHOW_SHORTCUTS_TAB_ATTRIBUTE = "ShowShortcutsTab";
    private static final String YES_VALUE = "yes";
    private static final String NO_VALUE = "no";
    private doMatlabStatus fDoMatlabStatus = new doMatlabStatus();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean ifJavaIsNotShuttingDown(Runnable runnable) {
        final CyclicBarrier cyclicBarrier = new CyclicBarrier(2);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    cyclicBarrier.await();
                    cyclicBarrier.await();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (BrokenBarrierException brokenBarrierException) {
                    // empty catch block
                }
            }
        });
        thread.setDaemon(false);
        thread.start();
        try {
            cyclicBarrier.await();
            try {
                Thread thread2 = new Thread();
                Runtime runtime = Runtime.getRuntime();
                runtime.addShutdownHook(thread2);
                runtime.removeShutdownHook(thread2);
                runnable.run();
                boolean bl = true;
                return bl;
            }
            catch (IllegalStateException illegalStateException) {
                return false;
            }
            finally {
                cyclicBarrier.await();
            }
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (BrokenBarrierException brokenBarrierException) {
            // empty catch block
        }
        return false;
    }

    private MLDesktop() {
        super(MATLAB, false);
        InputStream inputStream;
        this.fMatlabThreadClosers = new Vector<DTWindowCloser>();
        this.fDocumentContainment = 2;
        URL uRL = MLDesktop.class.getResource("resources/InitialLayout.xml");
        try {
            inputStream = uRL.openStream();
            SimpleElement simpleElement = this.parseLayout(inputStream);
            inputStream.close();
            this.addGroups(simpleElement);
            this.addSingletons(simpleElement);
        }
        catch (Exception exception) {
            System.out.println(this.getString("error.ReadingConfigFile"));
        }
        Matlab.registerExitPredicate((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return MLDesktop.this.canClose();
            }
        });
        Matlab.registerQuitListener((Runnable)new Runnable(){

            @Override
            public void run() {
                MLDesktop.ifJavaIsNotShuttingDown(new Runnable(){

                    @Override
                    public void run() {
                        MLDesktop.this.close();
                    }
                });
            }
        });
        if (this.useToolstrip()) {
            inputStream = DebuggerManager.getInstance();
            this.addAction(inputStream.getStepAction());
            this.addAction(inputStream.getStepInAction());
            this.addAction(inputStream.getStepOutAction());
            this.addAction(inputStream.getContinueAction());
            this.addAction(DebugActions.getClearAllBkptsAction());
            this.addAction(DebugActions.getSetErrorBkptsAction());
            this.addAction(inputStream.getExitDebugAction());
        }
    }

    public static synchronized MLDesktop getInstance() {
        if (sInstance == null) {
            sInstance = new MLDesktop();
        }
        return sInstance;
    }

    public static synchronized MLDesktop getInstanceNoCreate() {
        return sInstance;
    }

    public void useAsynchronousStartup(boolean bl) {
        this.fAsyncDesktopInit = new Boolean(bl);
    }

    public boolean usingAsynchronousStartup() {
        boolean bl = true;
        bl = this.fAsyncDesktopInit != null ? this.fAsyncDesktopInit.booleanValue() : Boolean.valueOf(System.getProperty("mathworks.matlab.asyncDesktopInit", Boolean.valueOf(bl).toString())).booleanValue();
        return bl;
    }

    static boolean isDeployToolPluginAvailable(String string, String string2, String string3) {
        return MLLicenseChecker.hasLicense((String)string) && new File(Matlab.matlabRoot(), "toolbox/" + string2 + "/plugins/" + string3 + "/plugin.xml").exists();
    }

    private static boolean isSimulinkProjectAvailable() {
        return Matlab.isSimulinkAvailable() && MLLicenseChecker.hasLicense((String)"simulink");
    }

    private static boolean isSystemToolboxAvailable() {
        return MLLicenseChecker.hasLicense((String)"signal_blocks") && new File(Matlab.matlabRoot(), "toolbox/dsp/dsp/+dsp/Contents.m").exists() || MLLicenseChecker.hasLicense((String)"video_and_image_blockset") && new File(Matlab.matlabRoot(), "toolbox/vision/vision/+vision/CommonSets.m").exists();
    }

    public void initMainFrame(boolean bl, boolean bl2, boolean bl3) {
        assert (NativeMatlab.nativeIsMatlabThread());
        if (this.fMainFrame != null) {
            return;
        }
        this.fLicenseBorrowingEnabled = BorrowUI.getInstance().isBorrowingEnabled();
        this.fHasDCTLicense = MLLicenseChecker.hasLicense((String)"Distrib_Computing_Toolbox");
        fHasCompilerPlugin = MLDesktop.isDeployToolPluginAvailable("Compiler", "compiler", "desktop");
        fHasCodeGenerationPlugin = MLDesktop.isDeployToolPluginAvailable("MATLAB_Coder", "coder", "coder") || MLDesktop.isDeployToolPluginAvailable("RTW_Embedded_Coder", "coder", "coder") || MLDesktop.isDeployToolPluginAvailable("MATLAB_Coder", "hdlcoder", "hdlcoder");
        fHasSimulinkProjectPlugin = MLDesktop.isSimulinkProjectAvailable();
        fHasSystemToolbox = MLDesktop.isSystemToolboxAvailable();
        if (this.fIsFirstInit) {
            this.fIsFirstInit = false;
            ConfirmationDialogPrefsPanel.addDialogItem((String)sMLRes.getString("title.CommandWindow"), (String)sMLRes.getString("message.ClearCWPref"), (String)CmdWinPrefs.getShowClearConfirmationPrefKey(), (boolean)true);
            ConfirmationDialogPrefsPanel.addDialogItem((String)sMLRes.getString("message.General"), (String)sMLRes.getString("message.QuitPref"), (String)EXIT_CONFIRM, (boolean)false);
        }
        try {
            if (this.usingAsynchronousStartup()) {
                EventQueue.invokeLater(new Initializer(bl, bl2, bl3, this.usingAsynchronousStartup()));
            } else {
                AWTUtilities.invokeAndWaitWithDispatch((Runnable)new Initializer(bl, bl2, bl3, this.usingAsynchronousStartup()));
            }
        }
        catch (Error error) {
            this.reportStartupError(error);
        }
        catch (Throwable throwable) {
            Log.logThrowable((Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMainFrameFromThread(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        assert (SwingUtilities.isEventDispatchThread());
        if (bl4) {
            NativeMatlab.nativeTic();
        }
        try {
            DTGroup dTGroup = this.getGroup(FIGURES_NAME);
            if (dTGroup != null) {
                dTGroup.addEmptyKeyListener((KeyListener)new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent keyEvent) {
                        CmdWinMLIF.processKeyFromC(keyEvent);
                    }
                });
            }
            this.fAutoShowMain = false;
            super.initMainFrame(bl, bl2, bl3);
            if (this.fMainFrame == null) {
                throw new RuntimeException("Desktop frames where not created successfully.");
            }
            if (dTGroup != null && this.isGroupShowing(FIGURES_NAME) && dTGroup.getDocumentCount() == 0) {
                this.closeGroup(FIGURES_NAME);
            }
            this.fMainFrame.addDropTargetListener(this.getDropListener());
            this.showFrames();
            this.fInitializationComplete = false;
            this.fMatlabStatus = MLExecutionEvent.InterpretedStatus.INITIALIZING;
            sMatlabStatusText.put(MLExecutionEvent.InterpretedStatus.IDLE, sMLRes.getString("status.Ready"));
            this.fNeedToUpdateIdle = true;
            MLExecuteServices.addMLExecutionListener((MLExecutionListener)this);
            if (!this.fIsPrefListenerRegistered) {
                this.fIsPrefListenerRegistered = true;
                PrefListener prefListener = new PrefListener(){

                    public void prefChanged(PrefEvent prefEvent) {
                        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                MLDesktop.this.updateTitle();
                            }
                        });
                    }
                };
                Prefs.addListener((PrefListener)prefListener, (String)"GeneralShowVersionOnTitle");
                Prefs.addListener((PrefListener)prefListener, (String)"GeneralShowJavaVersionOnTitle");
                Prefs.addListener((PrefListener)prefListener, (String)"GeneralShowMLRootOnTitle");
                Prefs.addListener((PrefListener)prefListener, (String)"GeneralShowBitsOnTitle");
            }
            this.pingMatlab();
        }
        finally {
            if (bl4) {
                NativeMatlab.nativeToc((String)ASYNC_TIC_ID_DESKTOP_INITIALIZATION);
            }
        }
    }

    protected void showFrames() {
        try {
            NativeMatlab.nativeHideSplashScreen();
            super.showFrames();
            DTClient dTClient = this.getDTClient(COMMAND_WINDOW_NAME);
            if (dTClient == null) {
                String string = "Command Window creation failed, for details see\n " + DTUtilities.getTempDirectory() + "MATLABDesktopCreateError.log";
                String string2 = this.getString("error.ErrorStartingDesktop");
                MJOptionPane.showMessageDialog(null, (Object)string, (String)string2, (int)0);
                this.abortMainFrameInit();
            } else {
                this.showClientWithoutActivatingFrame(dTClient);
            }
        }
        catch (Exception exception) {
            this.reportStartupError(exception);
        }
    }

    protected File getInitFile(boolean bl) {
        File file = null;
        if (Matlab.isStudentVersion()) {
            String string = this.fDTName;
            this.fDTName = "StudentMATLAB";
            file = super.getInitFile(bl);
            this.fDTName = string;
        } else {
            file = super.getInitFile(bl);
        }
        return file;
    }

    protected Component createClientComponent(DTClient dTClient) {
        if ("com.mathworks.mde.editor.EditorViewContainer".equals(dTClient.getComponentClassName())) {
            dTClient.setComponentClassName("com.mathworks.mde.editor.EditorViewClient");
        } else if ("com.mathworks.mde.deploytool.DeployTool".equals(dTClient.getComponentClassName())) {
            dTClient.setComponentClassName("com.mathworks.project.impl.DeployTool");
        } else if ("com.mathworks.mde.help.HelpBrowser".equals(dTClient.getComponentClassName())) {
            return null;
        }
        return super.createClientComponent(dTClient);
    }

    private void reportStartupError(final Throwable throwable) {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        throwable.printStackTrace();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
                String string = MLDesktop.this.getString("error.ErrorStartingDesktop");
                Object[] objectArray = new Object[stackTraceElementArray.length + 1];
                objectArray[0] = throwable;
                for (int i = 0; i < stackTraceElementArray.length; ++i) {
                    objectArray[i + 1] = stackTraceElementArray[i];
                }
                MJOptionPane.showMessageDialog(null, (Object)objectArray, (String)string, (int)0);
                MLDesktop.this.abortMainFrameInit();
            }
        };
        EventQueue.invokeLater(runnable);
    }

    private void pingMatlab() {
        Object[] objectArray = new Object[]{"computer"};
        this.fMatlab.feval("builtin", objectArray, 0, new MatlabListener(){

            public void matlabEvent(MatlabEvent matlabEvent) {
                String string;
                MLDesktop.this.fInitializationComplete = true;
                if (MLDesktop.this.fPreferencesAction != null) {
                    MLDesktop.this.fPreferencesAction.setEnabled(true);
                }
                if (MLDesktop.this.fCheckForUpdatesAction != null) {
                    MLDesktop.this.fCheckForUpdatesAction.setEnabled(true);
                }
                if (MLDesktop.this.fStudentActivationAction != null) {
                    MLDesktop.this.fStudentActivationAction.setEnabled(true);
                }
                if (MLDesktop.this.fTermsOfUseAction != null) {
                    MLDesktop.this.fTermsOfUseAction.setEnabled(true);
                }
                if (MLDesktop.this.fPatentsAction != null) {
                    MLDesktop.this.fPatentsAction.setEnabled(true);
                }
                if (MLDesktop.this.fAboutAction != null) {
                    MLDesktop.this.fAboutAction.setEnabled(true);
                }
                if (MLDesktop.this.fProductHelpAction != null) {
                    MLDesktop.this.fProductHelpAction.setEnabled(true);
                }
                if (MLDesktop.this.fDesktopHelpAction != null) {
                    MLDesktop.this.fDesktopHelpAction.setEnabled(true);
                }
                if (MLDesktop.this.fFunctionBrowserAction != null) {
                    MLDesktop.this.fFunctionBrowserAction.setEnabled(true);
                }
                if (MLDesktop.this.fDemosAction != null) {
                    MLDesktop.this.fDemosAction.setEnabled(true);
                }
                if (MLDesktop.this.fStartPageAction != null) {
                    MLDesktop.this.fStartPageAction.setEnabled(true);
                }
                if (MLDesktop.this.fLicenseBorrowAction != null) {
                    MLDesktop.this.fLicenseBorrowAction.setEnabled(true);
                }
                if (MLDesktop.this.fSupportRequestAction != null) {
                    MLDesktop.this.fSupportRequestAction.setEnabled(true);
                }
                MLDesktop.this.fNumberOfBits = (string = (String)matlabEvent.getResult()) != null && string.indexOf("64") >= 0 ? 64 : 32;
                MLDesktop.this.updateTitle();
                StartupClassLoader.loadAllClasses();
                LicenseActionsFactory.getLicenseActions().startup((Frame)MLDesktop.this.fMainFrame);
                LicenseToolSetFactory.populateToolSet(sMLRes);
                if (MLDesktop.this.useToolstrip()) {
                    MLDesktop.this.getToolstripRegistry().addToolSetContents(LicenseToolSetFactory.getToolSet().getContents());
                    MLDesktop.this.getToolstripRegistry().addToolSet(LicenseToolSetFactory.getToolSet());
                    ContributedToolsLoader.load(MLDesktop.this);
                }
                StartPageFactory.getStartPage().startup((Frame)MLDesktop.this.fMainFrame);
            }
        });
    }

    private void updateTitle() {
        if (this.hasMainFrame()) {
            this.getMainFrame().setTitle(this.getTitle());
        }
    }

    protected void abortMainFrameInit() {
        if (this.startedWithMainFrame()) {
            System.exit(1);
        }
    }

    boolean startedWithMainFrame() {
        return NativeMatlab.desktopRequestedAtStartup();
    }

    protected boolean mustHaveMainFrame() {
        return false;
    }

    static boolean hasCompilerPlugin() {
        return fHasCompilerPlugin;
    }

    static boolean hasCodeGenerationPlugin() {
        return fHasCodeGenerationPlugin;
    }

    static boolean hasSimulinkProjectPlugin() {
        return fHasSimulinkProjectPlugin;
    }

    static boolean hasSystemToolbox() {
        return fHasSystemToolbox;
    }

    boolean hasDCTLicense() {
        return this.fHasDCTLicense;
    }

    boolean isLicenseBorrowingEnabled() {
        return this.fLicenseBorrowingEnabled;
    }

    public void setRetainEditorFocus(boolean bl) {
        this.fRetainEditorFocus = bl;
    }

    public boolean isDockedMinMaxEnabled() {
        return true;
    }

    public boolean isWindowNavigationMenuEnabled() {
        return true;
    }

    public boolean undockSingletonsOnTop() {
        if (this.fUndockSingletonsOnTop == null) {
            this.fUndockSingletonsOnTop = Prefs.getBooleanPref((String)UNDOCK_SINGLETONS_ON_TOP, (boolean)false);
        }
        return this.fUndockSingletonsOnTop;
    }

    public boolean supplyDefaultViewTabs() {
        return true;
    }

    public void addClient(Component component, String string, boolean bl, DTLocation dTLocation, boolean bl2, DTClientListener dTClientListener) {
        if (bl2) {
            DTClient dTClient = (DTClient)this.fComponentToClientMap.get(component);
            bl2 = this.selectionPermitted(dTClient, dTLocation);
        }
        super.addClient(component, string, bl, dTLocation, bl2, dTClientListener);
    }

    public void showClient(Component component, DTLocation dTLocation, boolean bl) {
        if (bl) {
            DTClient dTClient = (DTClient)this.fComponentToClientMap.get(component);
            bl = this.selectionPermitted(dTClient, dTLocation);
        }
        super.showClient(component, dTLocation, bl);
    }

    private boolean selectionPermitted(DTClient dTClient, DTLocation dTLocation) {
        if (dTClient != null && FIGURES_NAME.equals(dTClient.getGroupName())) {
            DTClient dTClient2 = this.getSelectedClient();
            if (dTClient2 == null) {
                dTClient2 = this.getPreviousSelectedClient();
            }
            if (dTClient2 != null && EDITOR_NAME.equals(dTClient2.getGroupName())) {
                if (this.fRetainEditorFocus) {
                    return false;
                }
                if (dTLocation != null) {
                    return !dTLocation.isDocked();
                }
                return !this.shouldDock(dTClient);
            }
        }
        return true;
    }

    protected boolean ownsWindowRegistry() {
        return true;
    }

    public void attemptClose() {
        if (this.startedWithMainFrame()) {
            this.attemptDesktopClose();
        } else {
            this.attemptMainFrameClose();
        }
    }

    private void attemptDesktopClose() {
        Matlab.whenMatlabReady((Runnable)new Runnable(){

            @Override
            public void run() {
                Object[] objectArray = new Object[]{"exit"};
                try {
                    Matlab.mtFevalConsoleOutput((String)"builtin", (Object[])objectArray, (int)0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DTWindowCloser> getMatlabThreadClosers() {
        List<DTWindowCloser> list = this.fMatlabThreadClosers;
        synchronized (list) {
            return new Vector<DTWindowCloser>(this.fMatlabThreadClosers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMatlabThreadCloser(DTWindowCloser dTWindowCloser) {
        List<DTWindowCloser> list = this.fMatlabThreadClosers;
        synchronized (list) {
            this.fMatlabThreadClosers.add(dTWindowCloser);
        }
    }

    public boolean canClose() {
        if (this.hasMainFrame()) {
            for (DTWindowCloser dTWindowCloser : this.getMatlabThreadClosers()) {
                if (dTWindowCloser.canClose()) continue;
                return false;
            }
            QueryClose queryClose = new QueryClose();
            if (SwingUtilities.isEventDispatchThread()) {
                queryClose.run();
            } else {
                SwingUtilities.invokeLater(queryClose);
                while (!queryClose.isDone()) {
                    if (FactoryUtils.processPendingEvents()) {
                        return false;
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (queryClose.getReply() == 0) {
                return super.canClose();
            }
            return false;
        }
        return super.canClose();
    }

    public void close() {
        super.close();
        for (DTWindowCloser dTWindowCloser : this.getMatlabThreadClosers()) {
            dTWindowCloser.close();
        }
        MLCommandHistoryServices.save();
        CwdComponentSet.saveHistory();
    }

    public void closeMainFrame(boolean bl) {
        super.closeMainFrame(bl);
        MLExecuteServices.removeMLExecutionListener((MLExecutionListener)this);
    }

    protected void addGroup(DTGroup dTGroup) {
        super.addGroup(dTGroup);
        dTGroup.addDropTargetListener(this.getDropListener());
    }

    public void setDefaultDesktop() {
        URL uRL = MLDesktop.class.getResource("resources/InitialLayout.xml");
        try {
            InputStream inputStream = uRL.openStream();
            this.restoreLayout(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            System.out.println(this.getString("error.ReadingConfigFile"));
        }
    }

    protected DTLocation getDefaultGroupDockLocation() {
        DTLocation dTLocation;
        DTClient dTClient = this.getDTClient(COMMAND_WINDOW_NAME);
        if (dTClient != null && this.isClientShowing(dTClient) && this.isClientDocked(dTClient) && !this.isClientMinimized(dTClient) && !this.isClientMaximized(dTClient) && (dTLocation = this.getClientLocation(dTClient.getComponent())) != null) {
            String string = dTLocation.getPath();
            if (string.length() > 0 && string.charAt(string.length() - 1) == 'T') {
                string = string.substring(0, string.length() - 1);
            }
            return DTLocation.create((String)(string + "N"));
        }
        return super.getDefaultGroupDockLocation();
    }

    public void setCurrentFolderBarBelowToolstrip(boolean bl) {
        if (!this.useToolstrip() || this.getMainFrame() == null) {
            return;
        }
        assert (EventQueue.isDispatchThread());
        if (bl != this.fIsCurrentFolderBarBelowToolstrip) {
            Explorer explorer = Explorer.getInstance();
            MLMainFrame mLMainFrame = (MLMainFrame)this.getMainFrame();
            String string = sMLRes.getString("title.Explorer");
            if (bl) {
                JToolBar jToolBar = explorer.borrowToolbar();
                mLMainFrame.addToolBar(jToolBar, CURRENT_FOLDER_TOOLBAR_NAME, string);
            } else {
                mLMainFrame.removeToolBar(CURRENT_FOLDER_TOOLBAR_NAME, string);
                explorer.returnToolbar();
            }
            this.fIsCurrentFolderBarBelowToolstrip = bl;
            if (this.fMoveCFBarToBrowserAction != null) {
                this.fMoveCFBarToBrowserAction.update();
            }
            if (this.fMoveCFBarBelowToolstripAction != null) {
                this.fMoveCFBarBelowToolstripAction.update();
            }
        }
    }

    public boolean isCurrentFolderBarBelowToolstrip() {
        return this.fIsCurrentFolderBarBelowToolstrip;
    }

    protected void saveLayout(Document document, Element element, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super.saveLayout(document, element, bl, bl2, bl3, bl4);
        if (this.useToolstrip()) {
            element.setAttribute(CURRENT_FOLDER_BAR_ATTRIBUTE, this.fIsCurrentFolderBarBelowToolstrip ? YES_VALUE : NO_VALUE);
            Boolean bl5 = this.getMLToolstripFactory().showShortcutsTab();
            if (bl5 != null) {
                element.setAttribute(SHOW_SHORTCUTS_TAB_ATTRIBUTE, bl5 != false ? YES_VALUE : NO_VALUE);
            }
        }
    }

    protected void restoreLayout(SimpleElement simpleElement) throws DataFormatException {
        if (this.useToolstrip()) {
            boolean bl;
            String string = simpleElement.getAttribute(CURRENT_FOLDER_BAR_ATTRIBUTE);
            boolean bl2 = bl = string == null || YES_VALUE.equalsIgnoreCase(string);
            if (bl) {
                this.setCurrentFolderBarBelowToolstrip(true);
            }
            if ((string = simpleElement.getAttribute(SHOW_SHORTCUTS_TAB_ATTRIBUTE)) != null) {
                this.getMLToolstripFactory().setShowShortcutsTab(YES_VALUE.equalsIgnoreCase(string));
            }
        }
        super.restoreLayout(simpleElement);
    }

    protected DTLayoutLibrary getLayoutLibrary() {
        boolean bl = this.fLayoutLibrary == null;
        DTLayoutLibrary dTLayoutLibrary = super.getLayoutLibrary();
        if (bl) {
            dTLayoutLibrary.addFactoryLayout(sMLRes.getString("menuitem.Default"), "Default", MLDesktop.class.getResource("resources/DefaultLayout.xml"), (Icon)new IconSet(new Icon[]{new ImageIcon(MLDesktop.class.getResource("resources/default_layout_24.png")), new ImageIcon(MLDesktop.class.getResource("resources/default_layout_16.png"))}));
            dTLayoutLibrary.addFactoryLayout(sMLRes.getString("menuitem.CommandWindowOnly"), "Command Window Only", MLDesktop.class.getResource("resources/CommandOnlyLayout.xml"), (Icon)new IconSet(new Icon[]{new ImageIcon(MLDesktop.class.getResource("resources/command_only_layout_24.png")), new ImageIcon(MLDesktop.class.getResource("resources/command_only_layout_16.png"))}));
            dTLayoutLibrary.addFactoryLayout(sMLRes.getString("menuitem.HistoryAndCommand"), "History and Command Window", MLDesktop.class.getResource("resources/HistoryAndCommandLayout.xml"), (Icon)new IconSet(new Icon[]{new ImageIcon(MLDesktop.class.getResource("resources/history_and_command_layout_24.png")), new ImageIcon(MLDesktop.class.getResource("resources/history_and_command_layout_16.png"))}));
            if (!this.useToolstrip()) {
                dTLayoutLibrary.addFactoryLayout(sMLRes.getString("menuitem.AllTabbed"), "All Tabbed", MLDesktop.class.getResource("resources/AllTabbedLayout.xml"));
            }
            dTLayoutLibrary.addFactoryLayout(sMLRes.getString("menuitem.AllButCommandMinimized"), "All but Command Window Minimized", MLDesktop.class.getResource("resources/AllButCommandMinimizedLayout.xml"), (Icon)new IconSet(new Icon[]{new ImageIcon(MLDesktop.class.getResource("resources/minimize_all_but_layout_24.png")), new ImageIcon(MLDesktop.class.getResource("resources/minimize_all_but_layout_16.png"))}));
        }
        return dTLayoutLibrary;
    }

    protected DTMultipleClientFrame createMainFrame() {
        this.fIsCreatingMainFrame = true;
        MLMainFrame mLMainFrame = new MLMainFrame(this, this.getTitle());
        this.fIsCreatingMainFrame = false;
        this.installKeyBindings((DTFrame)mLMainFrame);
        return mLMainFrame;
    }

    private String getTitle() {
        String string = Matlab.isStudentVersion() ? sMLRes.getString("StudentVersion") + " " + MATLAB : MATLAB;
        String string2 = NativeMatlab.GetMatlabVersion();
        int n = string2.indexOf(40);
        int n2 = string2.indexOf(41, n + 1);
        if (n != -1 && n2 != -1) {
            string = string + " " + string2.substring(n + 1, n2);
        }
        if (Prefs.getBooleanPref((String)"GeneralShowVersionOnTitle", (boolean)false)) {
            int n3;
            int n4;
            for (n4 = 0; n4 < string2.length() && !Character.isDigit((char)(n3 = string2.charAt(n4))); ++n4) {
            }
            if (n4 < string2.length()) {
                char c;
                for (n3 = n4 + 1; n3 < string2.length() && (Character.isDigit(c = string2.charAt(n3)) || c == '.'); ++n3) {
                }
                string = string + " (" + string2.substring(n4, n3) + ")";
            }
        }
        if (Prefs.getBooleanPref((String)"GeneralShowJavaVersionOnTitle", (boolean)false)) {
            string = string + "    Java " + System.getProperty("java.version");
        }
        if (Prefs.getBooleanPref((String)"GeneralShowMLRootOnTitle", (boolean)false)) {
            string = string + "    " + sMLRes.getString("titlebar.Root") + " " + Matlab.matlabRoot();
        }
        if (Prefs.getBooleanPref((String)"GeneralShowBitsOnTitle", (boolean)false) && this.fNumberOfBits > 0) {
            string = string + "    " + this.fNumberOfBits + "-" + sMLRes.getString("titlebar.Bit");
        }
        return StartPageFactory.getStartPage().wrapTitle(string);
    }

    protected DTMultipleClientFrame createUndockedFrame(DTGroup dTGroup) {
        MLMultipleClientFrame mLMultipleClientFrame = new MLMultipleClientFrame(this, dTGroup.getTitle(), dTGroup.getIcon(), dTGroup, false);
        this.installKeyBindings((DTFrame)mLMultipleClientFrame);
        return mLMultipleClientFrame;
    }

    protected DTSingleClientFrame createUndockedFrame(DTClient dTClient) {
        MLSingleClientFrame mLSingleClientFrame = dTClient.getComponent() instanceof PlotableClientBase ? new MLSingleClientFrame(this, dTClient.getTitle()) : super.createUndockedFrame(dTClient);
        this.installKeyBindings((DTFrame)mLSingleClientFrame);
        return mLSingleClientFrame;
    }

    private void installKeyBindings(DTFrame dTFrame) {
        MInputMap mInputMap;
        InputMap inputMap = dTFrame.getRootPane().getInputMap(1);
        if (inputMap instanceof MInputMap) {
            mInputMap = (MInputMap)inputMap;
        } else {
            mInputMap = new MInputMap();
            mInputMap.setParent(inputMap);
        }
        this.populateBindingMaps(mInputMap, dTFrame.getRootPane().getActionMap());
        if (mInputMap != inputMap) {
            dTFrame.getRootPane().setInputMap(1, (InputMap)mInputMap);
        }
    }

    private void populateBindingMaps(MInputMap mInputMap, ActionMap actionMap) {
        Action[] actionArray;
        for (Action action : actionArray = new Action[]{this.getLaunchGuideAction(), this.getLaunchProfilerAction(), this.getLaunchSimulinkAction()}) {
            MatlabKeyBindings.getManager().addKeyBindings((ExtendedAction)action, (ExtendedInputMap)mInputMap);
            MatlabKeyBindings.getManager().addToActionMap((ExtendedAction)action, actionMap);
        }
    }

    protected DTMenuBar createMenuBar(DTFrame dTFrame, DTClient dTClient, DTGroup dTGroup) {
        return new MLMenuBar(this, dTFrame, dTClient, dTGroup);
    }

    protected DTMainToolBarSupplier createMainToolBarSupplier() {
        return new MLMainToolBarSupplier(this);
    }

    protected ToolstripInfoRegistrar[] getToolstripRegistrars() {
        ToolstripInfoRegistrar[] toolstripInfoRegistrarArray;
        if (Matlab.isStandaloneMode()) {
            ToolstripInfoRegistrar[] toolstripInfoRegistrarArray2 = new ToolstripInfoRegistrar[2];
            toolstripInfoRegistrarArray2[0] = new CommonToolRegistrar(this);
            toolstripInfoRegistrarArray = toolstripInfoRegistrarArray2;
            toolstripInfoRegistrarArray2[1] = new MLToolstripFactory.Registrar();
        } else {
            ToolstripInfoRegistrar[] toolstripInfoRegistrarArray3 = new ToolstripInfoRegistrar[8];
            toolstripInfoRegistrarArray3[0] = new CommonToolRegistrar(this);
            toolstripInfoRegistrarArray3[1] = new MLToolstripFactory.Registrar();
            toolstripInfoRegistrarArray3[2] = new ShortcutsToolstripTabFactory.Registrar();
            toolstripInfoRegistrarArray3[3] = new ArrayEditorToolstripTabFactory.Registrar();
            toolstripInfoRegistrarArray3[4] = new EditorToolSetFactory.Registrar();
            toolstripInfoRegistrarArray3[5] = new CodepadToolSetFactory.Registrar();
            toolstripInfoRegistrarArray3[6] = new EditorViewToolSetFactory.Registrar();
            toolstripInfoRegistrarArray = toolstripInfoRegistrarArray3;
            toolstripInfoRegistrarArray3[7] = new PlotToolSetFactory.Registrar();
        }
        return toolstripInfoRegistrarArray;
    }

    public QuickAccessConfiguration getDefaultQuickAccessConfiguration() {
        QuickAccessConfiguration quickAccessConfiguration = new QuickAccessConfiguration();
        quickAccessConfiguration.addTool(new TSToolPath("shortcuts", "house_keeping").appendTool("new_shortcut", "matlab_shortcut_toolset"));
        quickAccessConfiguration.addTool(new TSToolPath("common_tab", "common_section").appendTool("save", "common_tools", true));
        quickAccessConfiguration.addTool(new TSToolPath("common_tab", "common_section").appendTool("cut", "common_tools", true));
        quickAccessConfiguration.addTool(new TSToolPath("common_tab", "common_section").appendTool("copy", "common_tools", true));
        quickAccessConfiguration.addTool(new TSToolPath("common_tab", "common_section").appendTool("paste", "common_tools", true));
        quickAccessConfiguration.addTool(new TSToolPath("common_tab", "common_section").appendTool("undo", "common_tools", true));
        quickAccessConfiguration.addTool(new TSToolPath("common_tab", "common_section").appendTool("redo", "common_tools", true));
        quickAccessConfiguration.addTool(new TSToolPath("common_tab", "common_section").appendTool("switch_windows", "common_tools", false));
        quickAccessConfiguration.addTool(new TSToolPath("common_tab", "common_section").appendTool("help", "common_tools", true));
        return quickAccessConfiguration;
    }

    protected Predicate<TSToolPath> getQuickAccessConfigurationFilter(final DTFrame dTFrame) {
        return new Predicate<TSToolPath>(){

            public boolean accept(TSToolPath tSToolPath) {
                String string = tSToolPath.getToolSetName();
                return (!"plot_toolset".equals(string) || dTFrame.getToolstrip() != null && dTFrame.getToolstrip().getModel().get("plot") != null) && (!"desktop_layout_toolset".equals(string) || dTFrame.isMainFrame());
            }
        };
    }

    public boolean useToolstrip() {
        return true;
    }

    protected DTToolstripFactory createToolstripFactory() {
        return new MLToolstripFactory(this);
    }

    protected DTMnemonicsProvider createMnemonicsProvider(DTFrame dTFrame) {
        return new MLMnemonicsProvider(dTFrame);
    }

    protected MacScreenMenuProxy createMacScreenMenuProxy(DTFrame dTFrame) {
        return new MLMacScreenMenuProxy(dTFrame);
    }

    MLToolstripFactory getMLToolstripFactory() {
        return (MLToolstripFactory)this.getToolstripFactory();
    }

    protected RecentFiles createRecentFiles() {
        final RecentFiles recentFiles = new RecentFiles();
        RecentFiles.IconSupplier iconSupplier = new RecentFiles.IconSupplier(){

            public Icon getFileIcon(String string) {
                File file = new File(string);
                return MLFileIconUtils.getFileIcon((File)file, (boolean)file.isDirectory());
            }
        };
        recentFiles.addTool(EDITOR_NAME, sMLRes.getString("RecentFiles.Editor.Label"), new RecentFiles.Opener(){

            public void open(String string) {
                if (EditorOptions.getBuiltinEditor()) {
                    MLEditorServices.getEditorApplication().openEditor(new File(string));
                } else {
                    String string2 = "edit ('" + StringUtils.quoteSingleQuotes((String)string) + "')";
                    EditorUtils.getMatlab().evalConsoleOutput(string2);
                }
            }
        }, iconSupplier, "EditorMRU", EditorOptions.getMRUSize());
        Prefs.addListener((PrefListener)new PrefListener(){

            public void prefChanged(PrefEvent prefEvent) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        recentFiles.setLimit(MLDesktop.EDITOR_NAME, EditorOptions.getMRUSize());
                    }
                });
            }
        }, (String)"EditorMRU");
        recentFiles.addTool("default", sMLRes.getString("RecentFiles.default.Label"), new RecentFiles.Opener(){

            public void open(String string) {
                MLDesktop.this.fMatlab.evalConsoleOutput("uiopen('" + StringUtils.quoteSingleQuotes((String)string) + "', true);");
            }
        }, iconSupplier, "GeneralRecentFiles", 10);
        return recentFiles;
    }

    public void showToolBarCustomizationPanel(String string) {
        if (!SwingUtilities.isEventDispatchThread()) {
            super.showToolBarCustomizationPanel(string);
        } else {
            MLToolBarPrefsPanel.setToolBar(string);
            MLPrefsDialogServices.showPrefsDialog((String)sPrefRes.getString("area.toolbars"));
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        MLExecutionEvent mLExecutionEvent = (MLExecutionEvent)changeEvent;
        MLExecutionEvent.InterpretedStatus interpretedStatus = mLExecutionEvent.getInterpretedStatus();
        if (interpretedStatus == MLExecutionEvent.InterpretedStatus.PROFILER_OFF) {
            if (this.fMatlabStatus == MLExecutionEvent.InterpretedStatus.IDLE_AND_PROFILING) {
                interpretedStatus = MLExecutionEvent.InterpretedStatus.IDLE;
            } else if (this.fMatlabStatus == MLExecutionEvent.InterpretedStatus.BUSY_AND_PROFILING) {
                interpretedStatus = MLExecutionEvent.InterpretedStatus.BUSY;
            }
        } else if (interpretedStatus == MLExecutionEvent.InterpretedStatus.PROFILER_ON) {
            if (this.fMatlabStatus == MLExecutionEvent.InterpretedStatus.IDLE) {
                interpretedStatus = MLExecutionEvent.InterpretedStatus.IDLE_AND_PROFILING;
            } else if (this.fMatlabStatus == MLExecutionEvent.InterpretedStatus.BUSY) {
                interpretedStatus = MLExecutionEvent.InterpretedStatus.BUSY_AND_PROFILING;
            }
        }
        if (interpretedStatus != this.fMatlabStatus) {
            this.fMatlabStatus = interpretedStatus;
            if (sMatlabStatusText.get(this.fMatlabStatus) != null) {
                EventQueue.invokeLater(this.fDoMatlabStatus);
            }
        }
        if (this.fNeedToUpdateIdle && interpretedStatus == MLExecutionEvent.InterpretedStatus.IDLE) {
            this.fNeedToUpdateIdle = false;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    sMatlabStatusText.put(MLExecutionEvent.InterpretedStatus.IDLE, " ");
                }
            });
        }
    }

    public void setMatlabMessage(String string) {
        if (this.fMainFrame != null) {
            ((MLMainFrame)this.fMainFrame).setMatlabStatusText(string);
        }
    }

    public void showCommandWindow() {
        this.showClient(COMMAND_WINDOW_NAME);
    }

    public void showCommandHistory() {
        this.showClient(COMMAND_HISTORY_NAME);
    }

    public void showFileBrowser() {
        this.showClient(FILE_BROWSER_NAME);
    }

    public void showWorkspaceBrowser() {
        this.showClient(WORKSPACE_BROWSER_NAME);
    }

    public void showHelpBrowser() {
        this.showClient(HELP_BROWSER_NAME);
    }

    public void showProfiler() {
        this.showClient(PROFILER_NAME);
    }

    public void showFileExchange() {
        this.showClient(FILE_EXCHANGE_NAME);
    }

    public void closeCommandWindow() {
        this.closeClient(COMMAND_WINDOW_NAME);
    }

    public void closeCommandHistory() {
        this.closeClient(COMMAND_HISTORY_NAME);
    }

    public void closeFileBrowser() {
        this.closeClient(FILE_BROWSER_NAME);
    }

    public void closeWorkspaceBrowser() {
        this.closeClient(WORKSPACE_BROWSER_NAME);
    }

    public void closeHelpBrowser() {
        this.closeClient(HELP_BROWSER_NAME);
    }

    public void closeProfiler() {
        this.closeClient(PROFILER_NAME);
    }

    public void closeFileExchange() {
        this.closeClient(FILE_EXCHANGE_NAME);
    }

    public DTClient getWorkspaceBrowserClient() {
        return this.getDTClient(WORKSPACE_BROWSER_NAME);
    }

    public DTGroup getVariableEditorGroup() {
        return this.getGroup(VARIABLE_EDITOR_NAME);
    }

    public void setDefaultLayout() {
        this.restoreLayout(0);
    }

    public void setCommandOnlyLayout() {
        this.restoreLayout(1);
    }

    public void setCommandAndHistoryLayout() {
        this.restoreLayout(2);
    }

    public void setAllTabbedLayout() {
        this.restoreLayout(3);
    }

    public void setAllButCommandMinimizedLayout() {
        this.restoreLayout(4);
    }

    public static long getCommandWindowHWND() {
        Component component = MLDesktop.getInstance().getClient(COMMAND_WINDOW_NAME);
        MJFrame mJFrame = MJFrame.getFrame((Component)component);
        return mJFrame != null ? mJFrame.getHWnd() : 0L;
    }

    private static String getClientOrGroupName(DTClient dTClient) {
        return dTClient.getGroupName() == null ? dTClient.getName() : dTClient.getGroupName();
    }

    public DropTargetListener getDropListener() {
        if (this.fDropListener == null) {
            this.fDropListener = new MatlabDropTargetListener();
        }
        return this.fDropListener;
    }

    boolean includeDebugMenuWhenUndocked(DTClient dTClient) {
        boolean bl = true;
        if (dTClient == this.getDTClient(FILE_EXCHANGE_NAME) || dTClient == this.getDTClient(HELP_BROWSER_NAME)) {
            bl = false;
        }
        return bl;
    }

    boolean includeEditMenuWhenUndocked(DTClient dTClient) {
        return dTClient == null || dTClient != this.getDTClient(FILE_EXCHANGE_NAME);
    }

    private boolean isMatlabReady() {
        return !this.hasMainFrame() && !this.fIsCreatingMainFrame || this.fInitializationComplete;
    }

    private static String appendRelease(String string) {
        String string2 = NativeMatlab.GetMatlabVersion();
        int n = string2.indexOf(40);
        int n2 = string2.indexOf(41);
        String string3 = string2.substring(n + 1, n2);
        String string4 = string.concat(string3);
        return string4;
    }

    public Action getDefaultNewAction() {
        NewMFileAction newMFileAction = new NewMFileAction("new-mfile", (NewFileTemplate)new BlankMFileTemplate());
        newMFileAction.putValue("buttonIcon", ProvisionalIcon.NEW_24.getIcon());
        newMFileAction.putValue("Name", MJUtilities.exciseMnemonic((String)sMLRes.getString("menu.New")));
        return newMFileAction;
    }

    public Action getNewMFileAction() {
        return this.getNewBlankMFileAction();
    }

    public Action getNewBlankMFileAction() {
        if (this.fNewBlankMFileAction == null) {
            this.fNewBlankMFileAction = new NewMFileAction("new-mfile", (NewFileTemplate)new BlankMFileTemplate());
        }
        return this.fNewBlankMFileAction;
    }

    public Action getNewFunctionMFileAction() {
        if (this.fNewFunctionMFileAction == null) {
            this.fNewFunctionMFileAction = new NewMFileAction("new-mfunction", (NewFileTemplate)new FunctionMFileTemplate());
        }
        return this.fNewFunctionMFileAction;
    }

    public Action getNewExampleMFileAction() {
        if (this.fNewExampleMFileAction == null) {
            this.fNewExampleMFileAction = new NewMFileAction("new-mexample", (NewFileTemplate)new ExampleMFileTemplate());
        }
        return this.fNewExampleMFileAction;
    }

    public Action getNewClassMFileAction() {
        if (this.fNewClassMFileAction == null) {
            this.fNewClassMFileAction = new NewMFileAction("new-mclass", (NewFileTemplate)new ClassMFileTemplate());
        }
        return this.fNewClassMFileAction;
    }

    public Action getNewEnumerationMFileAction() {
        if (this.fNewEnumerationMFileAction == null) {
            this.fNewEnumerationMFileAction = new NewMFileAction("new-menumeration", (NewFileTemplate)new EnumerationMFileTemplate());
        }
        return this.fNewEnumerationMFileAction;
    }

    public Action getNewSystemMFileAction() {
        if (this.fNewSystemMFileAction == null) {
            this.fNewSystemMFileAction = new NewMFileAction("new-msystem", (NewFileTemplate)new SystemMFileTemplate());
        }
        return this.fNewSystemMFileAction;
    }

    public Action getNewFigureAction() {
        if (this.fNewFigureAction == null) {
            this.fNewFigureAction = new NewFigureAction();
        }
        return this.fNewFigureAction;
    }

    public Action getNewVariableAction() {
        if (this.fNewVariableAction == null) {
            this.fNewVariableAction = new NewVariableAction();
        }
        return this.fNewVariableAction;
    }

    public Action getNewModelAction() {
        if (this.fNewModelAction == null) {
            this.fNewModelAction = new NewModelAction();
        }
        return this.fNewModelAction;
    }

    public Action getNewGUIAction() {
        if (this.fNewGUIAction == null) {
            this.fNewGUIAction = new NewGUIAction();
        }
        return this.fNewGUIAction;
    }

    public Action getOpenAction() {
        if (this.fOpenAction == null) {
            this.fOpenAction = new OpenAction();
        }
        return this.fOpenAction;
    }

    public Action getInstallAppAction() {
        if (this.fInstallAppAction == null) {
            this.fInstallAppAction = new InstallAppAction();
        }
        return this.fInstallAppAction;
    }

    public Action getCloseDesktopAction() {
        if (this.fCloseDesktopAction == null) {
            this.fCloseDesktopAction = new CloseDesktopAction();
        }
        return this.fCloseDesktopAction;
    }

    public Action getImportAction() {
        if (this.fImportAction == null) {
            this.fImportAction = new ImportAction();
        }
        return this.fImportAction;
    }

    public Action getSaveWorkspaceAction() {
        if (this.fSaveWorkspaceAction == null) {
            this.fSaveWorkspaceAction = new SaveWorkspaceAction();
        }
        return this.fSaveWorkspaceAction;
    }

    public Action getSetPathAction() {
        if (this.fSetPathAction == null) {
            this.fSetPathAction = new SetPathAction();
        }
        return this.fSetPathAction;
    }

    public Action getPreferencesAction() {
        if (this.fPreferencesAction == null) {
            this.fPreferencesAction = new PreferencesAction();
        }
        return this.fPreferencesAction;
    }

    public Action getQuitAction() {
        if (this.fQuitAction == null) {
            this.fQuitAction = new QuitAction();
        }
        return this.fQuitAction;
    }

    public Action getPasteSpecialAction() {
        if (this.fPasteSpecialAction == null) {
            this.fPasteSpecialAction = new PasteSpecialAction();
        }
        return this.fPasteSpecialAction;
    }

    public Action getFindFilesAction() {
        if (this.fFindFilesAction == null) {
            this.fFindFilesAction = new FindFilesAction();
        }
        return this.fFindFilesAction;
    }

    public Action getClearCommandAction() {
        if (this.fClearCommandAction == null) {
            this.fClearCommandAction = new ClearCommandAction();
        }
        return this.fClearCommandAction;
    }

    public Action getClearHistoryAction() {
        if (this.fClearHistoryAction == null) {
            this.fClearHistoryAction = new ClearHistoryAction();
        }
        return this.fClearHistoryAction;
    }

    public Action getClearWorkspaceAction() {
        if (this.fClearWorkspaceAction == null) {
            this.fClearWorkspaceAction = new ClearWorkspaceAction();
        }
        return this.fClearWorkspaceAction;
    }

    public Action getClearAllAction() {
        if (this.fClearAllAction == null) {
            this.fClearAllAction = new ClearAllAction();
        }
        return this.fClearAllAction;
    }

    Action getVisitWebSiteAction() {
        if (this.fVisitWebSiteAction == null) {
            this.fVisitWebSiteAction = new WebAction("TheMathWorksWebSite", WEB_MATHWORKS, MLMenuMergeTag.WEB_SITE);
        }
        return this.fVisitWebSiteAction;
    }

    Action getVisitMatlabCentralAction() {
        if (this.fVisitMatlabCentralAction == null) {
            this.fVisitMatlabCentralAction = new WebAction("MATLABCentral", WEB_MATLAB_CENTRAL, MLMenuMergeTag.MATLAB_CENTRAL);
        }
        return this.fVisitMatlabCentralAction;
    }

    Action getVisitFileExchangeAction() {
        if (this.fVisitFileExchangeAction == null) {
            this.fVisitFileExchangeAction = new WebAction("MATLABFileExchange", WEB_FILE_EXCHANGE, MLMenuMergeTag.FILE_EXCHANGE);
        }
        return this.fVisitFileExchangeAction;
    }

    Action getVisitAppsAction() {
        if (this.fVisitAppsAction == null) {
            this.fVisitAppsAction = new WebAction("MATLABFileExchange", WEB_APPS, MLMenuMergeTag.FILE_EXCHANGE);
        }
        return this.fVisitAppsAction;
    }

    Action getVisitNewsGroupsAction() {
        if (this.fVisitNewsGroupsAction == null) {
            this.fVisitNewsGroupsAction = new WebAction("MATLABNewsgroupAccess", WEB_NEWSREADER, MLMenuMergeTag.NEWS_GROUPS);
        }
        return this.fVisitNewsGroupsAction;
    }

    Action getVisitNewslettersAction() {
        if (this.fVisitNewslettersAction == null) {
            this.fVisitNewslettersAction = new WebAction("Newsletters", WEB_NEWSLETTERS, MLMenuMergeTag.NEWSLETTERS);
        }
        return this.fVisitNewslettersAction;
    }

    Action getVisitNewProductsAction() {
        if (this.fVisitNewProductsAction == null) {
            this.fVisitNewProductsAction = new WebAction("Products", Matlab.isStudentVersion() ? WEB_STUDENT_PRODUCTS : WEB_PRODUCTS, MLMenuMergeTag.PRODUCTS);
        }
        return this.fVisitNewProductsAction;
    }

    Action getVisitLoginAction() {
        if (this.fVisitLoginAction == null) {
            this.fVisitLoginAction = new WebAction(Matlab.isStudentVersion() ? "StudentLogin" : "Account", WEB_LOGIN, MLMenuMergeTag.ACCOUNT);
        }
        return this.fVisitLoginAction;
    }

    Action getVisitTrialsAction() {
        if (this.fVisitTrialsAction == null) {
            this.fVisitTrialsAction = new WebAction("Trials", WEB_TRIALS, MLMenuMergeTag.ACCOUNT);
        }
        return this.fVisitTrialsAction;
    }

    Action getVisitStudentFAQAction() {
        if (this.fVisitStudentFAQAction == null) {
            this.fVisitStudentFAQAction = new WebAction("StudentFAQ", WEB_STUDENT_FAQ, MLMenuMergeTag.STUDENT_FAQ);
        }
        return this.fVisitStudentFAQAction;
    }

    Action getVisitStudentCenterAction() {
        if (this.fVisitStudentCenterAction == null) {
            this.fVisitStudentCenterAction = new WebAction("StudentCenter", WEB_STUDENT_CENTER, MLMenuMergeTag.STUDENT_CENTER);
        }
        return this.fVisitStudentCenterAction;
    }

    Action getVisitStoreAction() {
        if (this.fVisitStoreAction == null) {
            this.fVisitStoreAction = new WebAction("WebStore", WEB_STORE, MLMenuMergeTag.WEB_STORE);
        }
        return this.fVisitStoreAction;
    }

    Action getVisitTechSupportAction() {
        if (this.fVisitTechSupportAction == null) {
            this.fVisitTechSupportAction = new WebAction("Support", WEB_SUPPORT, MLMenuMergeTag.SUPPORT);
        }
        return this.fVisitTechSupportAction;
    }

    Action getVisitTrainingAction() {
        if (this.fVisitTrainingAction == null) {
            this.fVisitTrainingAction = new WebAction("Training", WEB_TRAINING, MLMenuMergeTag.TRAINING);
        }
        return this.fVisitTrainingAction;
    }

    Action getVisitTutorialsAction() {
        if (this.fVisitTutorialsAction == null) {
            String string = MLDesktop.appendRelease(TUTORIALS_URL);
            this.fVisitTutorialsAction = new WebAction("Tutorials", TUTORIALS_URL, MLMenuMergeTag.TUTORIALS);
        }
        return this.fVisitTutorialsAction;
    }

    Action getVisitMLTutorialsAction() {
        if (this.fVisitMLTutorialsAction == null) {
            String string = MLDesktop.appendRelease(ML_TUTORIALS_URL);
            this.fVisitMLTutorialsAction = new WebAction("MATLABTutorials", string, MLMenuMergeTag.TUTORIALS);
        }
        return this.fVisitMLTutorialsAction;
    }

    Action getVisitSLTutorialsAction() {
        if (this.fVisitSLTutorialsAction == null) {
            String string = MLDesktop.appendRelease(SL_TUTORIALS_URL);
            this.fVisitSLTutorialsAction = new WebAction("SimulinkTutorials", string, MLMenuMergeTag.TUTORIALS);
        }
        return this.fVisitSLTutorialsAction;
    }

    public Action getProductHelpAction() {
        if (this.fProductHelpAction == null) {
            this.fProductHelpAction = new HelpProductPageAction(MLMenuMergeTag.PRODUCT_HELP);
        }
        return this.fProductHelpAction;
    }

    public Action getFunctionBrowserAction() {
        if (this.fFunctionBrowserAction == null) {
            this.fFunctionBrowserAction = new FunctionBrowserAction(MLMenuMergeTag.FUNCTION_BROWSER);
        }
        return this.fFunctionBrowserAction;
    }

    Action getDesktopHelpAction() {
        if (this.fDesktopHelpAction == null) {
            this.fDesktopHelpAction = new HelpTopicAction("UsingtheDesktop", "matlab_env", "matlabenvironment_desktop", MLMenuMergeTag.DESKTOP_HELP, true);
        }
        return this.fDesktopHelpAction;
    }

    Action getComponentHelpAction(DTClient dTClient, DTGroup dTGroup) {
        ClientInfo clientInfo;
        String string = null;
        if (dTClient != null) {
            string = MLDesktop.getClientOrGroupName(dTClient);
        } else if (dTGroup != null) {
            string = dTGroup.getName();
        }
        if (string == null) {
            return null;
        }
        Object object = this.fComponentHelpActionTable.get(string);
        if (object == null && (clientInfo = sClientInfoTable.get(string)) != null && clientInfo.iHelpCategory != null) {
            object = new HelpTopicAction(clientInfo.iHelpResource, clientInfo.iHelpCategory, clientInfo.iHelpTopic, MLMenuMergeTag.COMPONENT_HELP, false);
            this.fComponentHelpActionTable.put(string, (Action)object);
        }
        return object;
    }

    Action getCheckForUpdatesAction() {
        if (this.fCheckForUpdatesAction == null) {
            this.fCheckForUpdatesAction = new CheckForUpdatesAction();
        }
        return this.fCheckForUpdatesAction;
    }

    Action getSupportRequestAction() {
        if (this.fSupportRequestAction == null) {
            this.fSupportRequestAction = new SupportRequestAction();
        }
        return this.fSupportRequestAction;
    }

    public Action getDemosAction() {
        if (this.fDemosAction == null) {
            this.fDemosAction = new DemosAction(MLMenuMergeTag.DEMOS);
        }
        return this.fDemosAction;
    }

    Action getStudentActivationAction() {
        if (this.fStudentActivationAction == null) {
            this.fStudentActivationAction = new StudentActivationAction();
        }
        return this.fStudentActivationAction;
    }

    Action getTermsOfUseAction() {
        if (this.fTermsOfUseAction == null) {
            this.fTermsOfUseAction = new TermsOfUseAction();
        }
        return this.fTermsOfUseAction;
    }

    Action getPatentsAction() {
        if (this.fPatentsAction == null) {
            this.fPatentsAction = new PatentsAction();
        }
        return this.fPatentsAction;
    }

    Action getAboutAction() {
        if (this.fAboutAction == null) {
            this.fAboutAction = new AboutAction();
        }
        return this.fAboutAction;
    }

    Action getStartPageAction() {
        if (this.fStartPageAction == null) {
            this.fStartPageAction = new StartPageAction();
        }
        return this.fStartPageAction;
    }

    Action getLicenseBorrowAction() {
        if (this.fLicenseBorrowAction == null) {
            this.fLicenseBorrowAction = new LicenseBorrowAction();
        }
        return this.fLicenseBorrowAction;
    }

    public Action getLaunchSimulinkAction() {
        if (this.fLaunchSimulinkAction == null) {
            this.fLaunchSimulinkAction = new LaunchSimulinkAction();
        }
        return this.fLaunchSimulinkAction;
    }

    public Action getLaunchGuideAction() {
        if (this.fLaunchGuideAction == null) {
            this.fLaunchGuideAction = new LaunchGuideAction();
        }
        return this.fLaunchGuideAction;
    }

    public Action getLaunchProfilerAction() {
        if (this.fLaunchProfilerAction == null) {
            this.fLaunchProfilerAction = new LaunchProfilerAction();
        }
        return this.fLaunchProfilerAction;
    }

    public Action getLaunchComparisonToolAction() {
        if (this.fLaunchComparisonToolAction == null) {
            this.fLaunchComparisonToolAction = new LaunchComparisonToolAction();
        }
        return this.fLaunchComparisonToolAction;
    }

    Action getMoveCurrentFolderBarToBrowserAction() {
        if (this.fMoveCFBarToBrowserAction == null) {
            this.fMoveCFBarToBrowserAction = new MoveCurrentFolderBarAction(false);
        }
        return this.fMoveCFBarToBrowserAction;
    }

    Action getMoveCurrentFolderBarBelowToolstripAction() {
        if (this.fMoveCFBarBelowToolstripAction == null) {
            this.fMoveCFBarBelowToolstripAction = new MoveCurrentFolderBarAction(true);
        }
        return this.fMoveCFBarBelowToolstripAction;
    }

    public void showOpenDialog(File file, Component component) {
        this.showOpenDialog(file, component, null, FileExtensionFilterUtils.getFileExtensionFilters());
    }

    private void showOpenDialog(File file, Component component, String string, List<FileExtensionFilter> list) {
        MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform(file);
        mJFileChooserPerPlatform.setMultiSelectionEnabled(true);
        mJFileChooserPerPlatform.setFileMustExist(true);
        mJFileChooserPerPlatform.setAllowMacBundles(false);
        if (string != null) {
            mJFileChooserPerPlatform.setDialogTitle(string);
        }
        mJFileChooserPerPlatform.addChoosableFileFilters(list);
        mJFileChooserPerPlatform.showOpenDialog(component);
        if (mJFileChooserPerPlatform.getState() == 0) {
            File[] fileArray = mJFileChooserPerPlatform.getSelectedFiles();
            for (int i = 0; i != fileArray.length; ++i) {
                this.fMatlab.evalConsoleOutput("uiopen('" + StringUtils.quoteSingleQuotes((String)fileArray[i].toString()) + "', true);");
            }
        }
    }

    static {
        sMLRes = ResourceBundle.getBundle("com.mathworks.mde.desk.resources.RES_Desktop");
        sMatlabStatusText = Collections.synchronizedMap(new EnumMap(MLExecutionEvent.InterpretedStatus.class));
        sMatlabStatusText.put(MLExecutionEvent.InterpretedStatus.INITIALIZING, sMLRes.getString("status.WaitingForMATLAB"));
        sMatlabStatusText.put(MLExecutionEvent.InterpretedStatus.IDLE, sMLRes.getString("status.Ready"));
        sMatlabStatusText.put(MLExecutionEvent.InterpretedStatus.IDLE_AND_PROFILING, sMLRes.getString("status.IdleAndProfiling"));
        sMatlabStatusText.put(MLExecutionEvent.InterpretedStatus.BUSY, sMLRes.getString("status.Busy"));
        sMatlabStatusText.put(MLExecutionEvent.InterpretedStatus.BUSY_AND_PROFILING, sMLRes.getString("status.BusyAndProfiling"));
        sMatlabStatusText.put(MLExecutionEvent.InterpretedStatus.PAUSED, sMLRes.getString("status.Paused"));
        sMatlabStatusText.put(MLExecutionEvent.InterpretedStatus.AT_BREAKPOINT, sMLRes.getString("status.AtBreak"));
        sMatlabStatusText.put(MLExecutionEvent.InterpretedStatus.AWAITING_INPUT, sMLRes.getString("status.AwaitingInput"));
        sMatlabStatusText.put(MLExecutionEvent.InterpretedStatus.COMPLETING_BLOCK, sMLRes.getString("status.CompletingBlock"));
        sPrefRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.prefs.resources.RES_Prefs");
        sClientInfoTable = new HashMap<String, ClientInfo>();
        sClientInfoTable.put(COMMAND_WINDOW_NAME, new ClientInfo("area.commandwindow", "UsingCommandWindow", "matlab_env", "matlabenvironment_commands"));
        sClientInfoTable.put(COMMAND_HISTORY_NAME, new ClientInfo("area.commandhistory", "UsingCommandHistory", "matlab_env", "matlabenvironment_commandhistory"));
        sClientInfoTable.put(FILE_BROWSER_NAME, new ClientInfo("area.currentdirectory", "UsingCurrentDirectory", "matlab_env", "matlabenvironment_filebrowser"));
        sClientInfoTable.put(WORKSPACE_BROWSER_NAME, new ClientInfo("area.workspace", "UsingWorkspace", "matlab_env", "matlabenvironment_workspacebrowser"));
        sClientInfoTable.put(HELP_BROWSER_NAME, new ClientInfo("area.help", "UsingHelp", "matlab_env", "matlabenvironment_helpbrowser"));
        sClientInfoTable.put(PROFILER_NAME, new ClientInfo(null, "UsingProfiler", "matlab_env", "measuring_performance"));
        sClientInfoTable.put(EXPLORER_NAME, new ClientInfo("area.explorer", "UsingCurrentDirectory", "matlab_env", "matlabenvironment_filebrowser"));
        sClientInfoTable.put(FILE_EXCHANGE_NAME, new ClientInfo(null, "UsingFileExchange", "matlab_env", "desktop_using_file_exchange"));
        sClientInfoTable.put(EDITOR_NAME, new ClientInfo("area.editordebugger", "UsingEditor", "matlab_env", "matlabenvironment_editordebugger"));
        sClientInfoTable.put(FIGURES_NAME, new ClientInfo(null, "UsingFigures", "creating_plots", "creating_plots"));
        sClientInfoTable.put(WEB_BROWSER_NAME, new ClientInfo("area.web", "UsingWebBrowser", "matlab_env", "web_browser"));
        sClientInfoTable.put(VARIABLE_EDITOR_NAME, new ClientInfo("area.arrayeditor", "UsingArrayEditor", "matlab_env", "matlabenvironment_arrayeditor"));
        sClientInfoTable.put(FILE_COMPARISONS_NAME, new ClientInfo(null, "UsingFileComparisons", "matlab_env", "matlab_env_filecomparison"));
        if (Locale.getDefault().equals(Locale.JAPAN)) {
            WEB_MATHWORKS = WEB_JP_MATHWORKS;
            WEB_LOGIN = WEB_JP_LOGIN;
            WEB_STUDENT_FAQ = WEB_JP_STUDENT_FAQ;
            WEB_STUDENT_CENTER = WEB_JP_STUDENT_CENTER;
            WEB_PRODUCTS = WEB_JP_PRODUCTS;
            WEB_SUPPORT = WEB_JP_SUPPORT;
            WEB_TRAINING = WEB_JP_TRAINING;
            WEB_STORE = WEB_JP_STORE;
            WEB_TRIALS = WEB_JP_TRIALS;
            WEB_MATLAB_CENTRAL = WEB_JP_MATLAB_CENTRAL;
            WEB_FILE_EXCHANGE = WEB_JP_FILE_EXCHANGE;
            WEB_NEWSREADER = WEB_JP_NEWSREADER;
            WEB_NEWSLETTERS = WEB_JP_NEWSLETTERS;
            WEB_STUDENT_PRODUCTS = WEB_JP_STUDENT_PRODUCTS;
            TUTORIALS_URL = TUTORIALS_JP_URL;
            ML_TUTORIALS_URL = ML_TUTORIALS_JP_URL;
            SL_TUTORIALS_URL = SL_TUTORIALS_JP_URL;
            WEB_APPS = WEB_JP_APPS;
        } else {
            WEB_MATHWORKS = WEB_EN_MATHWORKS;
            WEB_LOGIN = WEB_EN_LOGIN;
            WEB_STUDENT_FAQ = WEB_EN_STUDENT_FAQ;
            WEB_STUDENT_CENTER = WEB_EN_STUDENT_CENTER;
            WEB_PRODUCTS = WEB_EN_PRODUCTS;
            WEB_SUPPORT = WEB_EN_SUPPORT;
            WEB_TRAINING = WEB_EN_TRAINING;
            WEB_STORE = WEB_EN_STORE;
            WEB_TRIALS = WEB_EN_TRIALS;
            WEB_MATLAB_CENTRAL = WEB_EN_MATLAB_CENTRAL;
            WEB_FILE_EXCHANGE = WEB_EN_FILE_EXCHANGE;
            WEB_NEWSREADER = WEB_EN_NEWSREADER;
            WEB_NEWSLETTERS = WEB_EN_NEWSLETTERS;
            WEB_STUDENT_PRODUCTS = WEB_EN_STUDENT_PRODUCTS;
            TUTORIALS_URL = TUTORIALS_EN_URL;
            ML_TUTORIALS_URL = ML_TUTORIALS_EN_URL;
            SL_TUTORIALS_URL = SL_TUTORIALS_EN_URL;
            WEB_APPS = WEB_EN_APPS;
        }
    }

    private class MoveCurrentFolderBarAction
    extends MJAbstractAction {
        private final boolean iMoveBelowToolstrip;

        private MoveCurrentFolderBarAction(boolean bl) {
            this.iMoveBelowToolstrip = bl;
            this.update();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MLDesktop.this.setCurrentFolderBarBelowToolstrip(this.iMoveBelowToolstrip);
        }

        private void update() {
            this.setSelected(this.iMoveBelowToolstrip == MLDesktop.this.fIsCurrentFolderBarBelowToolstrip);
        }
    }

    private static class LaunchObserver
    implements CompletionObserver,
    Runnable {
        Frame fFrame;

        LaunchObserver(Frame frame) {
            this.fFrame = frame;
        }

        public void completed(int n, Object object) {
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            GlobalCursor.clear((Window)this.fFrame);
        }
    }

    private class LaunchComparisonToolAction
    extends MJAbstractAction {
        LaunchComparisonToolAction() {
            super(sMLRes.getString("Tool.compare.Label"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ComparisonUtilities.startEmptyComparison();
        }
    }

    class LaunchProfilerAction
    extends MJAbstractAction {
        public LaunchProfilerAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABDesktop", "launch-profiler", (ExtendedAction)this);
            this.setComponentName(MLDesktop.PROFILER_NAME);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            Frame frame = LaunchProfilerAction.getFrame((ActionEvent)actionEvent);
            GlobalCursor.setWait((Window)frame);
            try {
                MLDesktop.this.showProfiler();
            }
            finally {
                GlobalCursor.clear((Window)frame);
            }
        }
    }

    class LaunchGuideAction
    extends MJAbstractAction {
        public LaunchGuideAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABDesktop", "launch-guide", (ExtendedAction)this);
            this.setComponentName("Guide");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Frame frame = LaunchGuideAction.getFrame((ActionEvent)actionEvent);
            GlobalCursor.setWait((Window)frame);
            MLDesktop.this.fMatlab.evalConsoleOutput("guide", (CompletionObserver)new LaunchObserver(frame));
        }
    }

    class LaunchSimulinkAction
    extends MJAbstractAction {
        public LaunchSimulinkAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABDesktop", "launch-simulink", (ExtendedAction)this);
            this.setComponentName("Simulink");
            this.setEnabled(Matlab.isSimulinkAvailable());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Frame frame = LaunchSimulinkAction.getFrame((ActionEvent)actionEvent);
            GlobalCursor.setWait((Window)frame);
            MLDesktop.this.fMatlab.evalConsoleOutput("simulink", (CompletionObserver)new LaunchObserver(frame));
        }
    }

    private class doMatlabStatus
    implements Runnable {
        private doMatlabStatus() {
        }

        @Override
        public void run() {
            MLDesktop.this.setMatlabMessage((String)sMatlabStatusText.get(MLDesktop.this.fMatlabStatus));
        }
    }

    static class doAboutBox
    implements Runnable {
        private long hWnd = 0L;

        public doAboutBox(long l) {
            this.hWnd = l;
        }

        @Override
        public void run() {
            NativeMatlab.nativeDisplayAboutBox((long)this.hWnd);
        }
    }

    class LicenseBorrowAction
    extends MJAbstractAction {
        LicenseBorrowAction() {
            super(sMLRes.getString("menuitem.LicenseBorrow"));
            this.setComponentName("LicenseBorrow");
            this.setEnabled(MLDesktop.this.isMatlabReady());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            Frame frame = LicenseBorrowAction.getFrame((ActionEvent)actionEvent);
            GlobalCursor.setWait((Window)frame);
            try {
                BorrowUI.getInstance().showGUI();
            }
            finally {
                GlobalCursor.clear((Window)frame);
            }
        }
    }

    class StartPageAction
    extends MJAbstractAction {
        StartPageAction() {
            super(sMLRes.getString("menuitem.StartPage"));
            this.setComponentName("StartPage");
            MLMenuMergeTag.START_PAGE.setTag((Action)((Object)this));
            this.setEnabled(MLDesktop.this.isMatlabReady());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StartPageFactory.getStartPage().showStartPage((Frame)MLDesktop.this.fMainFrame);
        }
    }

    class AboutAction
    extends MJAbstractAction {
        AboutAction() {
            super(sMLRes.getString("menuitem.AboutMATLAB"));
            this.setComponentName("AboutMATLAB");
            MLMenuMergeTag.ABOUT.setTag((Action)((Object)this));
            this.setEnabled(MLDesktop.this.isMatlabReady());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            long l = 0L;
            Frame frame = AboutAction.getFrame((ActionEvent)actionEvent);
            if (frame instanceof MJFrame) {
                l = ((MJFrame)frame).getHWnd();
            }
            Matlab.whenMatlabReady((Runnable)new doAboutBox(l));
        }
    }

    class PatentsAction
    extends MJAbstractAction {
        PatentsAction() {
            super(sMLRes.getString("menuitem.Patents"));
            this.setComponentName("Patents");
            MLMenuMergeTag.PATENTS.setTag((Action)((Object)this));
            this.setEnabled(MLDesktop.this.isMatlabReady());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = new Object[]{Matlab.matlabRoot() + System.getProperty("file.separator") + "patents.txt"};
            MLDesktop.this.fMatlab.fevalConsoleOutput("web", objectArray, 0, (CompletionObserver)null);
        }
    }

    class TermsOfUseAction
    extends MJAbstractAction {
        TermsOfUseAction() {
            super(sMLRes.getString("menuitem.TermsOfUse"));
            this.setComponentName("TermsOfUse");
            MLMenuMergeTag.TERMS_OF_USE.setTag((Action)((Object)this));
            this.setEnabled(MLDesktop.this.isMatlabReady());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = new Object[]{Matlab.matlabRoot() + System.getProperty("file.separator") + "license.txt"};
            MLDesktop.this.fMatlab.fevalConsoleOutput("web", objectArray, 0, (CompletionObserver)null);
        }
    }

    class StudentActivationAction
    extends MJAbstractAction {
        StudentActivationAction() {
            super(sMLRes.getString("menuitem.CheckActivationStatus"));
            this.setComponentName("StudentActivation");
            MLMenuMergeTag.CHECK_ACTIVATION.setTag((Action)((Object)this));
            this.setEnabled(MLDesktop.this.isMatlabReady());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MLDesktop.this.fMatlab.evalConsoleOutput("StudentActivationStatus");
        }
    }

    class DemosAction
    extends MJAbstractAction {
        DemosAction(MLMenuMergeTag mLMenuMergeTag) {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABDesktop", "show-demos", (ExtendedAction)this);
            this.setComponentName("Demos");
            mLMenuMergeTag.setTag((Action)((Object)this));
            this.setEnabled(MLDesktop.this.isMatlabReady());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            Frame frame = DemosAction.getFrame((ActionEvent)actionEvent);
            GlobalCursor.setWait((Window)frame);
            try {
                MLHelpServices.showDemos();
            }
            finally {
                GlobalCursor.clear((Window)frame);
            }
        }
    }

    class SupportRequestAction
    extends MJAbstractAction {
        SupportRequestAction() {
            super(sMLRes.getString("menuitem.SupportRequest"));
            this.setComponentName("SupportRequest");
            MLMenuMergeTag.SUPPORT_REQUEST.setTag((Action)((Object)this));
            this.setEnabled(MLDesktop.this.isMatlabReady());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            Frame frame = SupportRequestAction.getFrame((ActionEvent)actionEvent);
            GlobalCursor.setWait((Window)frame);
            try {
                SupportRequestFactory.launchSupportRequest(frame);
            }
            finally {
                GlobalCursor.clear((Window)frame);
            }
        }
    }

    class CheckForUpdatesAction
    extends MJAbstractAction {
        CheckForUpdatesAction() {
            super(sMLRes.getString("menuitem.CheckForUpdates"));
            this.setComponentName("CheckForUpdates");
            MLMenuMergeTag.CHECK_UPDATES.setTag((Action)((Object)this));
            this.setEnabled(MLDesktop.this.isMatlabReady());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            Frame frame = CheckForUpdatesAction.getFrame((ActionEvent)actionEvent);
            GlobalCursor.setWait((Window)frame);
            try {
                CheckForUpdatesDialogFactory.getCheckForUpdatesDialog(frame);
            }
            finally {
                GlobalCursor.clear((Window)frame);
            }
        }
    }

    class FunctionBrowserAction
    extends MJAbstractAction {
        FunctionBrowserAction(MLMenuMergeTag mLMenuMergeTag) {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABDesktop", "function-browser-key", (ExtendedAction)this);
            this.setComponentName("FunctionBrowser");
            mLMenuMergeTag.setTag((Action)((Object)this));
            this.setEnabled(MLDesktop.this.isMatlabReady());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            Frame frame = FunctionBrowserAction.getFrame((ActionEvent)actionEvent);
            GlobalCursor.setWait((Window)frame);
            try {
                Point point = MouseInfo.getPointerInfo().getLocation();
                FunctionBrowser.open(new Rectangle(point.x, point.y, 0, 0));
            }
            finally {
                GlobalCursor.clear((Window)frame);
            }
        }
    }

    class HelpProductPageAction
    extends MJAbstractAction {
        HelpProductPageAction(MLMenuMergeTag mLMenuMergeTag) {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABDesktop", "product-help", (ExtendedAction)this);
            this.setComponentName("ProductHelp");
            mLMenuMergeTag.setTag((Action)((Object)this));
            this.setEnabled(MLDesktop.this.isMatlabReady());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MLHelpServices.invoke();
        }
    }

    class HelpTopicAction
    extends MJAbstractAction {
        String fMapFilename;
        String fTopic;

        HelpTopicAction(String string, String string2, String string3, MLMenuMergeTag mLMenuMergeTag, boolean bl) {
            String string4 = sMLRes.getString("menuitem." + string);
            this.setName(string4);
            String string5 = string;
            if (!"UsingtheDesktop".equals(string5)) {
                string5 = "UsingThis";
            }
            this.setComponentName(string5);
            mLMenuMergeTag.setTag((Action)((Object)this));
            this.fMapFilename = string2;
            this.fTopic = string3;
            if (bl) {
                this.setEnabled(MLDesktop.this.isMatlabReady());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            Frame frame = HelpTopicAction.getFrame((ActionEvent)actionEvent);
            GlobalCursor.setWait((Window)frame);
            try {
                MLHelpServices.displayTopic((String)MLHelpServices.getMapfileName((String)"matlab", (String)this.fMapFilename), (String)this.fTopic);
            }
            finally {
                GlobalCursor.clear((Window)frame);
            }
        }
    }

    class WebAction
    extends MJAbstractAction {
        String fURL;

        WebAction(String string, String string2, MLMenuMergeTag mLMenuMergeTag) {
            super(sMLRes.getString("menuitem." + string));
            this.setComponentName(string);
            mLMenuMergeTag.setTag((Action)((Object)this));
            this.fURL = string2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = new Object[]{this.fURL, "-browser", "-display"};
            MLDesktop.this.fMatlab.fevalConsoleOutput("web", objectArray, 0, (CompletionObserver)null);
        }
    }

    static class ClearAllAction
    extends MJAbstractAction {
        ClearAllAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WorkspaceCommands.clearAll((boolean)true, (Frame)ClearAllAction.getFrame((ActionEvent)actionEvent));
        }
    }

    static class ClearWorkspaceAction
    extends MJAbstractAction {
        ClearWorkspaceAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABDesktop", "clear-workspace", (ExtendedAction)this);
            this.setComponentName("ClearWorkspace");
            MLMenuMergeTag.CLEAR_WORKSPACE.setTag((Action)((Object)this));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WorkspaceCommands.clearAllVariables((boolean)true, (Frame)ClearWorkspaceAction.getFrame((ActionEvent)actionEvent));
        }
    }

    static class ClearHistoryAction
    extends MJAbstractAction {
        ClearHistoryAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABDesktop", "clear-command-history", (ExtendedAction)this);
            this.setComponentName("ClearCommandHistory");
            MLMenuMergeTag.CLEAR_HISTORY.setTag((Action)((Object)this));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = MJOptionPane.showConfirmDialog((Component)ClearHistoryAction.getFrame((ActionEvent)actionEvent), (Object)sMLRes.getString("message.DeleteEntireHistory"), (String)MLDesktop.MATLAB, (int)0, (int)2);
            if (n == 0) {
                MLCommandHistoryServices.removeAll();
            }
        }
    }

    static class ClearCommandAction
    extends MJAbstractAction {
        ClearCommandAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABDesktop", "clear-command-window", (ExtendedAction)this);
            this.setComponentName("ClearCommandWindow");
            MLMenuMergeTag.CLEAR_COMMAND.setTag((Action)((Object)this));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = Dialogs.showOptionalConfirmDialog((Component)ClearCommandAction.getFrame((ActionEvent)actionEvent), (Object)sMLRes.getString("message.ClearCommandWindow"), (String)MLDesktop.MATLAB, (int)2, (int)2, (String)CmdWinPrefs.getShowClearConfirmationPrefKey(), (int)0, (boolean)true);
            if (n == 0) {
                CmdWinMLIF.clc();
            }
        }
    }

    class FindFilesAction
    extends MJAbstractAction {
        FindFilesAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABDesktop", "find-files", (ExtendedAction)this);
            this.setComponentName("FindFiles");
            MLMenuMergeTag.FIND_FILES.setTag((Action)((Object)this));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            Frame frame = FindFilesAction.getFrame((ActionEvent)actionEvent);
            GlobalCursor.setWait((Window)frame);
            try {
                FindFiles.invoke();
            }
            finally {
                GlobalCursor.clear((Window)frame);
            }
        }
    }

    class PasteSpecialAction
    extends AbstractPasteAction {
        PasteSpecialAction() {
            super(true);
            this.clearKeyBinding();
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABDesktop", "paste-to-workspace", (ExtendedAction)this);
            this.setComponentName("PasteSpecial");
            MLMenuMergeTag.PASTE_SPECIAL.setTag((Action)((Object)this));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MLDesktop.this.fMatlab.evalConsoleOutput("uiimport('-pastespecial')");
        }
    }

    class QuitAction
    extends MJAbstractAction {
        QuitAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABDesktop", "exit-matlab", (ExtendedAction)this);
            this.setComponentName("ExitMATLAB");
            MLMenuMergeTag.EXIT.setTag((Action)((Object)this));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MLDesktop.this.attemptDesktopClose();
        }
    }

    class PreferencesAction
    extends MJAbstractAction {
        PreferencesAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABDesktop", "show-preferences", (ExtendedAction)this);
            this.setComponentName("Preferences");
            MLMenuMergeTag.PREFERENCES.setTag((Action)((Object)this));
            this.setEnabled(MLDesktop.this.isMatlabReady());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ClientInfo clientInfo;
            String string;
            String string2 = null;
            DTClient dTClient = MLDesktop.this.getSelectedClient();
            String string3 = string = dTClient != null ? MLDesktop.getClientOrGroupName(dTClient) : MLDesktop.this.getSelectedGroup();
            if (string != null && (clientInfo = (ClientInfo)sClientInfoTable.get(string)) != null) {
                string2 = clientInfo.iPrefPanelTitle;
            }
            MLPrefsDialogServices.showLastPrefsDialog(string2);
        }
    }

    class SetPathAction
    extends MJAbstractAction {
        SetPathAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABDesktop", "set-path", (ExtendedAction)this);
            this.setComponentName("SetPath");
            MLMenuMergeTag.SET_PATH.setTag((Action)((Object)this));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MLDesktop.this.fMatlab.evalConsoleOutput("pathtool;");
        }
    }

    class SaveWorkspaceAction
    extends MJAbstractAction {
        SaveWorkspaceAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABDesktop", "save-workspace", (ExtendedAction)this);
            this.setComponentName("SaveWorkspaceAs");
            MLMenuMergeTag.SAVE_WORKSPACE.setTag((Action)((Object)this));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WorkspaceCommands.saveAllVariables((Frame)SaveWorkspaceAction.getFrame((ActionEvent)actionEvent));
        }
    }

    class ImportAction
    extends MJAbstractAction {
        ImportAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABDesktop", "import-data", (ExtendedAction)this);
            this.setComponentName("ImportData");
            MLMenuMergeTag.IMPORT.setTag((Action)((Object)this));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WorkspaceCommands.importDataWithDialog((Component)ImportAction.getFrame((ActionEvent)actionEvent));
        }
    }

    class CloseDesktopAction
    extends MJAbstractAction {
        CloseDesktopAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABDesktop", "close-desktop", (ExtendedAction)this);
            this.setComponentName("CloseDesktop");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MLDesktop.this.attemptMainFrameClose();
        }
    }

    class InstallAppAction
    extends AbstractOpenAction {
        InstallAppAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MLDesktop.this.showOpenDialog(new File(MatlabPath.getCWD()), InstallAppAction.getFrame((ActionEvent)actionEvent), sMLRes.getString("title.InstallApp"), Collections.singletonList(MatlabProductFileExtensionFilter.getAppInstallFilter()));
        }
    }

    class OpenAction
    extends AbstractOpenAction {
        OpenAction() {
            this.setTip(sMLRes.getString("toolbar.OpenFile"));
            MLMenuMergeTag.OPEN.setTag((Action)((Object)this));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MLDesktop.this.showOpenDialog(new File(MatlabPath.getCWD()), OpenAction.getFrame((ActionEvent)actionEvent));
        }
    }

    class NewGUIAction
    extends MJAbstractAction {
        NewGUIAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABDesktop", "new-gui", (ExtendedAction)this);
            this.setComponentName("GUI");
            MLMenuMergeTag.NEW_GUI.setTag((Action)((Object)this));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MLDesktop.this.fMatlab.evalConsoleOutput("guide");
        }
    }

    class NewModelAction
    extends MJAbstractAction {
        NewModelAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABDesktop", "new-model", (ExtendedAction)this);
            this.setComponentName("Model");
            MLMenuMergeTag.NEW_MODEL.setTag((Action)((Object)this));
            this.setEnabled(Matlab.isSimulinkAvailable());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MLDesktop.this.fMatlab.evalConsoleOutput("open_system(new_system);");
        }
    }

    class NewVariableAction
    extends MJAbstractAction {
        NewVariableAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABDesktop", "new-variable", (ExtendedAction)this);
            this.setComponentName("Variable");
            MLMenuMergeTag.NEW_VARIABLE.setTag((Action)((Object)this));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WorkspaceCommands.createVariable();
            MLDesktop.this.showWorkspaceBrowser();
        }
    }

    class NewFigureAction
    extends MJAbstractAction {
        NewFigureAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABDesktop", "new-figure", (ExtendedAction)this);
            this.setComponentName("Figure");
            MLMenuMergeTag.NEW_FIGURE.setTag((Action)((Object)this));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MLDesktop.this.fMatlab.evalConsoleOutput("figure");
        }
    }

    class NewMFileAction
    extends MJAbstractAction {
        NewFileTemplate iFileTemplate;

        NewMFileAction(String string, NewFileTemplate newFileTemplate) {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABDesktop", string, (ExtendedAction)this);
            this.setComponentName("Mfile");
            MLMenuMergeTag.NEW_MFILE.setTag((Action)((Object)this));
            this.iFileTemplate = newFileTemplate;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StringWriter stringWriter = new StringWriter();
            FileLocation fileLocation = new FileLocation(EditorUtils.previewUntitledFilename());
            this.iFileTemplate.writeDefaultContent((Writer)stringWriter, fileLocation);
            MLEditorServices.getEditorApplication().newEditor(stringWriter.toString());
        }
    }

    private class QueryClose
    implements Runnable {
        private int iReply = 0;
        private volatile boolean iDone = false;

        private QueryClose() {
        }

        @Override
        public void run() {
            this.iReply = Dialogs.showOptionalConfirmDialog((Component)MLDesktop.this.fMainFrame, (Object)sMLRes.getString("message.QuitMatlab"), (String)MLDesktop.MATLAB, (int)2, (int)2, (String)MLDesktop.EXIT_CONFIRM, (int)0, (boolean)false);
            this.iDone = true;
        }

        public boolean isDone() {
            return this.iDone;
        }

        public int getReply() {
            return this.iReply;
        }
    }

    class Initializer
    implements Runnable {
        boolean fSplash;
        boolean fRestoreLayout;
        boolean fMinimize;
        boolean fAsync;

        Initializer(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.fSplash = bl;
            this.fRestoreLayout = bl2;
            this.fMinimize = bl3;
            this.fAsync = bl4;
        }

        @Override
        public void run() {
            try {
                String string = System.getProperty("mathworks.ErrorUponStartup");
                if ("true".equals(string)) {
                    throw new Exception("Test Exception");
                }
                MLDesktop.this.initMainFrameFromThread(this.fSplash, this.fRestoreLayout, this.fMinimize, this.fAsync);
            }
            catch (Exception exception) {
                MLDesktop.this.reportStartupError(exception);
            }
        }
    }

    private static class ClientInfo {
        String iPrefPanelTitle;
        String iHelpResource;
        String iHelpCategory;
        String iHelpTopic;

        ClientInfo(String string, String string2, String string3, String string4) {
            if (string != null) {
                this.iPrefPanelTitle = sPrefRes.getString(string);
            }
            this.iHelpResource = string2;
            this.iHelpCategory = string3;
            this.iHelpTopic = string4;
        }
    }
}

