/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.MGridLayout;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTable;
import com.mathworks.mwswing.table.ListColorUtils;
import com.mathworks.services.Prefs;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.text.EditorPrefsAccessor;
import com.mathworks.widgets.text.mcode.MFoldType;
import com.mathworks.widgets.text.mcode.MLanguage;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class EditorPrefsCodeFoldPanel
extends MJPanel {
    private static final Border NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private static final Border FOCUS_BORDER = UIManager.getBorder("Table.focusCellHighlightBorder");
    private static EditorPrefsCodeFoldPanel sPrefsPanel = null;
    private static MJCheckBox sEnableMCodeFolding;
    private static final int VGAP = 4;
    private static final int HGAP = 5;
    public static final String PREF_FOLD_ENABLE = "Editorcode-folding-enable";
    private FoldConstructsTableModel fConstructsSelectionTableModel;
    private List<FoldConstruct> fFoldConstructs;
    private MJTable fConstructsSelectionTable;
    private final Dimension fPrefDisplaySize;
    private boolean fJustEdited = true;

    private EditorPrefsCodeFoldPanel(Dimension dimension) {
        this.fPrefDisplaySize = dimension;
        this.setPreferredSize(this.fPrefDisplaySize);
        this.setLayout((LayoutManager)new MGridLayout(1, 1, 0, 0, 131072));
        CardLayout cardLayout = new CardLayout();
        MJPanel mJPanel = new MJPanel((LayoutManager)cardLayout);
        mJPanel.add((Component)this.createMPanel(), (Object)MLanguage.INSTANCE.getMimeType());
        cardLayout.show((Container)mJPanel, MLanguage.INSTANCE.getMimeType());
        this.add((Component)mJPanel);
        this.registerListeners();
    }

    private void registerListeners() {
        sEnableMCodeFolding.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = false;
                if (sEnableMCodeFolding.isSelected()) {
                    bl = true;
                }
                ((BooleanColumnRenderer)EditorPrefsCodeFoldPanel.this.fConstructsSelectionTable.getColumnModel().getColumn(2).getCellRenderer()).setBooleanColumnEnabled(bl);
                ((BooleanColumnRenderer)EditorPrefsCodeFoldPanel.this.fConstructsSelectionTable.getColumnModel().getColumn(1).getCellRenderer()).setBooleanColumnEnabled(bl);
                EditorPrefsCodeFoldPanel.this.fConstructsSelectionTableModel.fireTableDataChanged();
            }
        });
    }

    private MJPanel createMPanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new MGridLayout(3, 1, 5, 4, 131072));
        sEnableMCodeFolding = new MJCheckBox();
        sEnableMCodeFolding.setName("MCodeFolding");
        MJPanel mJPanel2 = EditorPrefsCodeFoldPanel.createCodeFoldsEnablePanel(sEnableMCodeFolding, EditorPrefsAccessor.isCodeFoldingEnabled());
        mJPanel.add((Component)mJPanel2);
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new BorderLayout());
        MJMultilineLabel mJMultilineLabel = EditorPrefsCodeFoldPanel.createConstructsLabel();
        MJScrollPane mJScrollPane = this.createMFoldConstructsScrollPane();
        mJPanel3.add((Component)mJMultilineLabel, (Object)"North");
        mJPanel3.add((Component)mJScrollPane, (Object)"Center");
        mJPanel.add((Component)mJPanel3);
        return mJPanel;
    }

    private static MJMultilineLabel createConstructsLabel() {
        MJMultilineLabel mJMultilineLabel = new MJMultilineLabel(EditorUtils.lookup("pref.codefolds.ConstructSelectionHeaderInfo"), true);
        mJMultilineLabel.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
        mJMultilineLabel.setName("LangConstructDescriptionLabel");
        mJMultilineLabel.getAccessibleContext().setAccessibleName(EditorUtils.lookup("pref.codefolds.ConstructSelectionHeaderInfo"));
        return mJMultilineLabel;
    }

    private MJScrollPane createMFoldConstructsScrollPane() {
        this.fFoldConstructs = EditorPrefsCodeFoldPanel.createFoldConstructs();
        this.fConstructsSelectionTableModel = new FoldConstructsTableModel(this.fFoldConstructs, FoldConstructsTableColumn.values());
        this.fConstructsSelectionTable = new MJTable(this.fConstructsSelectionTableModel){

            public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
                Component component = super.prepareEditor(tableCellEditor, n, n2);
                EditorPrefsCodeFoldPanel.setRenderingColors(component, (JTable)((Object)this), n, true, true);
                return component;
            }

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                boolean bl = this.getSelectedRow() == n;
                boolean bl2 = this.hasFocus() || EditorPrefsCodeFoldPanel.this.fJustEdited;
                EditorPrefsCodeFoldPanel.setRenderingColors(component, (JTable)((Object)this), n, bl2, bl);
                return component;
            }
        };
        this.fConstructsSelectionTable.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                EditorPrefsCodeFoldPanel.this.fJustEdited = false;
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.fConstructsSelectionTable.setName("LanguageConstructsTable");
        this.fConstructsSelectionTable.setRowSelectionAllowed(false);
        this.fConstructsSelectionTable.setColumnSelectionAllowed(false);
        this.fConstructsSelectionTable.setCellSelectionEnabled(true);
        this.fConstructsSelectionTable.setSelectionMode(0);
        Dimension dimension = this.fConstructsSelectionTable.getIntercellSpacing();
        dimension.width = 0;
        this.fConstructsSelectionTable.setIntercellSpacing(dimension);
        this.fConstructsSelectionTable.setShowGrid(false);
        this.fConstructsSelectionTable.setCellViewerEnabled(true);
        this.fConstructsSelectionTable.setPreferredScrollableViewportSize(new Dimension(this.fPrefDisplaySize.width, this.fConstructsSelectionTable.getRowHeight() * this.fFoldConstructs.size()));
        this.fConstructsSelectionTable.getAccessibleContext().setAccessibleName(EditorUtils.lookup("pref.codefolds.ConstructSelectionTableAcessibleName"));
        ((JLabel)((Object)this.fConstructsSelectionTable.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(2);
        TableColumn tableColumn = this.fConstructsSelectionTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(200);
        tableColumn.setWidth(200);
        TableColumn tableColumn2 = this.fConstructsSelectionTable.getColumnModel().getColumn(1);
        tableColumn2.setCellRenderer(new BooleanColumnRenderer());
        tableColumn2.setCellEditor(new BooleanColumnRenderer());
        TableColumn tableColumn3 = this.fConstructsSelectionTable.getColumnModel().getColumn(2);
        tableColumn3.setCellRenderer(new BooleanColumnRenderer());
        tableColumn3.setCellEditor(new BooleanColumnRenderer());
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fConstructsSelectionTable);
        mJScrollPane.setVerticalScrollBarPolicy(20);
        mJScrollPane.setHorizontalScrollBarPolicy(30);
        mJScrollPane.getViewport().setBackground(this.fConstructsSelectionTable.getBackground());
        return mJScrollPane;
    }

    private static boolean isFoldEnabledCurrently() {
        return sEnableMCodeFolding.isSelected();
    }

    private static List<FoldConstruct> createFoldConstructs() {
        ArrayList<FoldConstruct> arrayList = new ArrayList<FoldConstruct>();
        MFoldType[] mFoldTypeArray = MFoldType.values();
        Comparator<MFoldType> comparator = new Comparator<MFoldType>(){

            @Override
            public int compare(MFoldType mFoldType, MFoldType mFoldType2) {
                return mFoldType.getPrefTableEntry().compareTo(mFoldType2.getPrefTableEntry());
            }
        };
        Arrays.sort(mFoldTypeArray, comparator);
        for (MFoldType mFoldType : mFoldTypeArray) {
            arrayList.add(new FoldConstruct(mFoldType));
        }
        return arrayList;
    }

    private static MJPanel createCodeFoldsEnablePanel(MJCheckBox mJCheckBox, boolean bl) {
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 5);
        mJCheckBox.setText(EditorUtils.lookup("pref.codefolds.EnableCodeFolds.MLanguage"));
        mJCheckBox.setSelected(bl);
        mJPanel.add((Component)mJCheckBox, (Object)gridBagConstraints);
        return mJPanel;
    }

    public static MJPanel createPrefsPanel(Dimension dimension) {
        if (sPrefsPanel != null) {
            sPrefsPanel = null;
        }
        sPrefsPanel = new EditorPrefsCodeFoldPanel(dimension);
        sPrefsPanel.setName("EditorPrefsCodeFoldPanel");
        return sPrefsPanel;
    }

    public static void commitPrefsChanges(boolean bl) {
        if (sPrefsPanel != null) {
            sPrefsPanel.commitChanges(bl);
        }
    }

    private void commitChanges(boolean bl) {
        if (bl) {
            Prefs.setBooleanPref((String)PREF_FOLD_ENABLE, (boolean)sEnableMCodeFolding.isSelected());
            for (FoldConstruct foldConstruct : this.fFoldConstructs) {
                foldConstruct.commitChanges();
            }
        }
    }

    public static String[] getHelpInfo() {
        return new String[]{MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env"), "matlab_editor_codefolding_prefs"};
    }

    private static void setRenderingColors(Component component, JTable jTable, int n, boolean bl, boolean bl2) {
        if (bl2) {
            if (bl) {
                component.setBackground(ColorUtils.getSelectionBackgroundColor());
                component.setForeground(ColorUtils.getSelectionForegroundColor());
            } else {
                component.setBackground(ColorUtils.getUnfocusedSelectionBackgroundColor((Component)component));
                component.setForeground(ColorUtils.getUnfocusedSelectionForegroundColor((Component)component));
            }
        } else {
            component.setBackground(ListColorUtils.getListAlternatingBackgroundColor((JTable)jTable, (int)n, (boolean)false, (boolean)bl));
            component.setForeground(ListColorUtils.getListForegroundColor((JTable)jTable, (boolean)false, (boolean)bl));
        }
    }

    private static class FoldConstructsTableModel
    extends AbstractTableModel {
        private final List<FoldConstruct> fRowModels;
        private final FoldConstructsTableColumn[] fTableColumns;

        FoldConstructsTableModel(List<FoldConstruct> list, FoldConstructsTableColumn[] foldConstructsTableColumnArray) {
            this.fRowModels = list;
            this.fTableColumns = foldConstructsTableColumnArray;
        }

        private FoldConstructsTableColumn getColumnAt(int n) {
            return this.fTableColumns[n];
        }

        @Override
        public int getRowCount() {
            return this.fRowModels != null ? this.fRowModels.size() : -1;
        }

        @Override
        public int getColumnCount() {
            return this.fTableColumns != null ? this.fTableColumns.length : -1;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.getColumnAt(n2).getValueOf(this.fRowModels.get(n));
        }

        @Override
        public String getColumnName(int n) {
            return this.getColumnAt(n).getColumnName();
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.getColumnAt(n).getColumnClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return this.getColumnAt(n2).isEditable(this.fRowModels.get(n));
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.getColumnAt(n2).setValue(this.fRowModels.get(n), object);
            this.fireTableRowsUpdated(n, n);
        }
    }

    private static class FoldConstruct {
        private boolean iEnableFold;
        private boolean iFoldedUponOpen;
        private final MFoldType iFold;

        FoldConstruct(MFoldType mFoldType) {
            this.iFold = mFoldType;
            this.iEnableFold = this.iFold.isFoldEnabled();
            this.iFoldedUponOpen = this.iFold.isFoldedUponOpen();
        }

        public String getConstructName() {
            return "  " + this.iFold.getPrefTableEntry();
        }

        public boolean isFoldEnabled() {
            return this.iEnableFold;
        }

        public void setFoldEnabled(boolean bl) {
            this.iEnableFold = bl;
            if (!bl) {
                this.setFoldInitially(false);
            }
        }

        public boolean isFoldedUponOpen() {
            return this.iFoldedUponOpen;
        }

        public void setFoldInitially(boolean bl) {
            this.iFoldedUponOpen = bl;
        }

        public void commitChanges() {
            this.iFold.setFoldEnabled(this.isFoldEnabled());
            this.iFold.setFoldedUponOpen(this.isFoldedUponOpen());
        }
    }

    private static enum FoldConstructsTableColumn {
        LANGUAGE_CONSTRUCT(EditorUtils.lookup("pref.codefolds.LanguageConstruct")){

            @Override
            public String getValueOf(FoldConstruct foldConstruct) {
                return foldConstruct.getConstructName();
            }

            @Override
            public Class<?> getColumnClass() {
                return String.class;
            }

            @Override
            public void setValue(FoldConstruct foldConstruct, Object object) {
            }

            @Override
            public boolean isEditable(FoldConstruct foldConstruct) {
                return false;
            }
        }
        ,
        INCLUDE(EditorUtils.lookup("pref.codefolds.IncludeForFolding")){

            @Override
            public Boolean getValueOf(FoldConstruct foldConstruct) {
                return foldConstruct.isFoldEnabled();
            }

            public Class<Boolean> getColumnClass() {
                return Boolean.class;
            }

            @Override
            public void setValue(FoldConstruct foldConstruct, Object object) {
                if (object != null) {
                    foldConstruct.setFoldEnabled((Boolean)object);
                }
            }

            @Override
            public boolean isEditable(FoldConstruct foldConstruct) {
                return EditorPrefsCodeFoldPanel.isFoldEnabledCurrently();
            }
        }
        ,
        FOLD_INITIALLY(EditorUtils.lookup("pref.codefolds.InitialFoldCollapse")){

            @Override
            public Boolean getValueOf(FoldConstruct foldConstruct) {
                return foldConstruct.isFoldedUponOpen();
            }

            public Class<Boolean> getColumnClass() {
                return Boolean.class;
            }

            @Override
            public void setValue(FoldConstruct foldConstruct, Object object) {
                if (object != null) {
                    foldConstruct.setFoldInitially((Boolean)object);
                }
            }

            @Override
            public boolean isEditable(FoldConstruct foldConstruct) {
                return EditorPrefsCodeFoldPanel.isFoldEnabledCurrently() && foldConstruct.isFoldEnabled();
            }
        };

        private String fColumnName;

        private FoldConstructsTableColumn(String string2) {
            this.fColumnName = string2;
        }

        public String getColumnName() {
            return this.fColumnName;
        }

        public abstract Object getValueOf(FoldConstruct var1);

        public abstract Class<?> getColumnClass();

        public abstract void setValue(FoldConstruct var1, Object var2);

        public abstract boolean isEditable(FoldConstruct var1);
    }

    private class BooleanColumnRenderer
    extends DefaultCellEditor
    implements TableCellRenderer {
        private BooleanColumnRenderer() {
            super((JCheckBox)new MJCheckBox());
            JCheckBox jCheckBox = (JCheckBox)this.getComponent();
            jCheckBox.setHorizontalAlignment(0);
            jCheckBox.setBorderPainted(!PlatformInfo.isMacintosh());
            jCheckBox.setOpaque(true);
            jCheckBox.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    EditorPrefsCodeFoldPanel.this.fJustEdited = true;
                    EditorPrefsCodeFoldPanel.this.fConstructsSelectionTable.repaint();
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return this.getTableCellRendererComponent(jTable, object, true, true, n, n2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JCheckBox jCheckBox = (JCheckBox)this.getComponent();
            jCheckBox.setSelected(object != null && (Boolean)object != false);
            jCheckBox.setBorder(bl2 ? FOCUS_BORDER : NO_FOCUS_BORDER);
            jCheckBox.setEnabled(jTable.isCellEditable(n, n2));
            return jCheckBox;
        }

        public void setBooleanColumnEnabled(boolean bl) {
            JCheckBox jCheckBox = (JCheckBox)this.getComponent();
            jCheckBox.setEnabled(bl);
        }
    }
}

